/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.util;

import com.cout970.magneticraft.api.util.MgDirection;

public enum Orientation {
    UP_NORTH(1, MgDirection.NORTH),
    UP_EAST(1, MgDirection.EAST),
    UP_SOUTH(1, MgDirection.SOUTH),
    UP_WEST(1, MgDirection.WEST),
    NORTH(0, MgDirection.NORTH),
    EAST(0, MgDirection.EAST),
    SOUTH(0, MgDirection.SOUTH),
    WEST(0, MgDirection.WEST),
    DOWN_NORTH(-1, MgDirection.NORTH),
    DOWN_EAST(-1, MgDirection.EAST),
    DOWN_SOUTH(-1, MgDirection.SOUTH),
    DOWN_WEST(-1, MgDirection.WEST);

    private int level;
    private MgDirection dir;

    private Orientation(int l, MgDirection dir) {
        this.level = l;
        this.dir = dir;
    }

    public MgDirection getDirection() {
        return this.dir;
    }

    public int getLevel() {
        return this.level;
    }

    public static Orientation find(int level, MgDirection dir) {
        for (Orientation o : Orientation.values()) {
            if (o.level != level || o.dir != dir) continue;
            return o;
        }
        return null;
    }

    public Orientation rotateY(boolean left) {
        return Orientation.find(this.level, this.dir.step(left ? MgDirection.DOWN : MgDirection.UP));
    }

    public int toMeta() {
        return this.ordinal();
    }

    public static Orientation fromMeta(int meta) {
        return Orientation.values()[meta % Orientation.values().length];
    }
}

