/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.util.fluid;

import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.update1_8.IFluidHandler1_8;
import com.cout970.magneticraft.util.fluid.FluidNetwork;
import com.cout970.magneticraft.util.fluid.IFluidTransport;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class FluidNetWorkManager
implements IFluidHandler1_8 {
    public FluidNetwork net;

    public FluidNetWorkManager(FluidNetwork fluidNetwork) {
        this.net = fluidNetwork;
    }

    public void computingFluids() {
        int amount = this.net.getFluidAmount();
        if (amount <= 0 || this.net.fluid == null) {
            return;
        }
        this.drainMg(MgDirection.DOWN, amount, true);
        this.fillMg(MgDirection.DOWN, new FluidStack(this.net.fluid, amount), true);
    }

    @Override
    public int fillMg(MgDirection from, FluidStack resource, boolean doFill) {
        FluidStack f;
        if (resource == null) {
            return 0;
        }
        if (!this.canFillMg(from, resource.getFluid())) {
            return 0;
        }
        int pipes = this.net.getPipes().size();
        if (pipes <= 0) {
            return 0;
        }
        int space = this.net.getCapacity() - this.net.getFluidAmount();
        int toFill = Math.min(resource.amount, space);
        int aceptPerPipe = toFill / pipes;
        int acepted = 0;
        if (aceptPerPipe > 0) {
            for (IFluidTransport t : this.net.getPipes()) {
                f = new FluidStack(resource, aceptPerPipe);
                int lSpace = t.getTank().getFluidAmount();
                int filled = t.getTank().fill(f, doFill);
                acepted += filled;
            }
        }
        if (aceptPerPipe * pipes != toFill) {
            for (IFluidTransport t : this.net.getPipes()) {
                if (toFill - acepted <= 0) continue;
                f = new FluidStack(resource, 1);
                int filled = t.getTank().fill(f, doFill);
                acepted += filled;
            }
        }
        return acepted;
    }

    @Override
    public FluidStack drainMg_F(MgDirection from, FluidStack resource, boolean doDrain) {
        if (!this.canDrainMg(from, resource.getFluid())) {
            return null;
        }
        return this.drainMg(from, resource.amount, doDrain);
    }

    @Override
    public FluidStack drainMg(MgDirection from, int maxDrain, boolean doDrain) {
        FluidStack d;
        if (this.net.fluid == null) {
            return null;
        }
        int pipes = this.net.getPipes().size();
        if (pipes <= 0) {
            return null;
        }
        int output = Math.min(maxDrain, this.net.getFluidAmount());
        if (output <= 0) {
            return null;
        }
        int outPerPipe = output / pipes;
        int drained = 0;
        if (outPerPipe > 0) {
            for (IFluidTransport t : this.net.getPipes()) {
                d = t.getTank().drain(outPerPipe, doDrain);
                if (d == null) continue;
                drained += d.amount;
            }
        }
        if (output - drained > 0) {
            for (IFluidTransport t : this.net.getPipes()) {
                if (output - drained <= 0 || (d = t.getTank().drain(1, doDrain)) == null) continue;
                drained += d.amount;
            }
        }
        if (drained > 0) {
            FluidStack f = new FluidStack(this.net.fluid, drained);
            if (this.net.getFluidAmount() <= 0) {
                this.net.fluid = null;
            }
            return f;
        }
        return null;
    }

    @Override
    public boolean canFillMg(MgDirection from, Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        if (this.net.fluid == null) {
            return true;
        }
        return this.net.fluid.equals(fluid);
    }

    @Override
    public boolean canDrainMg(MgDirection from, Fluid fluid) {
        if (this.net.fluid == null) {
            return false;
        }
        return this.net.fluid.equals(fluid);
    }

    @Override
    public FluidTankInfo[] getTankInfoMg(MgDirection from) {
        return null;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this instanceof IFluidHandler1_8) {
            return this.fillMg(MgDirection.getDirection(from.ordinal()), resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this instanceof IFluidHandler1_8) {
            return this.drainMg_F(MgDirection.getDirection(from.ordinal()), resource, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this instanceof IFluidHandler1_8) {
            return this.drainMg(MgDirection.getDirection(from.ordinal()), maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (this instanceof IFluidHandler1_8) {
            return this.canFillMg(MgDirection.getDirection(from.ordinal()), fluid);
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (this instanceof IFluidHandler1_8) {
            return this.canDrainMg(MgDirection.getDirection(from.ordinal()), fluid);
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this instanceof IFluidHandler1_8) {
            return this.getTankInfoMg(MgDirection.getDirection(from.ordinal()));
        }
        return null;
    }
}

