/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.util.fluid;

import com.cout970.magneticraft.util.fluid.FluidNetWorkManager;
import com.cout970.magneticraft.util.fluid.FluidPathfinder;
import com.cout970.magneticraft.util.fluid.IFluidTransport;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;

public class FluidNetwork {
    public FluidNetWorkManager manager = new FluidNetWorkManager(this);
    private List<IFluidTransport> pipes = new ArrayList<IFluidTransport>();
    public TileEntity tile;
    public Fluid fluid;

    private FluidNetwork() {
    }

    public static FluidNetwork create(IFluidTransport base, TileEntity tile) {
        FluidNetwork net = new FluidNetwork();
        net.pipes.add(base);
        net.tile = tile;
        return net;
    }

    private TileEntity getTile() {
        return this.tile;
    }

    public List<IFluidTransport> getPipes() {
        return this.pipes;
    }

    public void addPipe(IFluidTransport p) {
        this.pipes.add(p);
    }

    public void refresh() {
        IFluidTransport base = null;
        for (IFluidTransport e : this.pipes) {
            TileEntity t;
            if (e == null || (t = e.getTileEntity()) == null || t.func_145831_w().func_147438_o(t.field_145851_c, t.field_145848_d, t.field_145849_e) == null) continue;
            base = e;
        }
        if (base != null) {
            ArrayList<IFluidTransport> things = new ArrayList<IFluidTransport>();
            FluidPathfinder found = new FluidPathfinder(base, null);
            things.addAll(found.getPipes());
            for (IFluidTransport ft : this.pipes) {
                if (things.contains(ft)) continue;
                ft.setNetwork(null);
            }
            this.pipes = things;
        }
        for (IFluidTransport e : this.pipes) {
            e.setNetwork(this);
            e.onNetworkUpdate();
        }
    }

    public void mergeWith(FluidNetwork net) {
        for (IFluidTransport te : this.pipes) {
            te.setNetwork(net);
        }
        for (IFluidTransport e : this.pipes) {
            e.onNetworkUpdate();
        }
    }

    public void exclude(IFluidTransport te) {
        List<IFluidTransport> members = te.getNetwork().getPipes();
        for (IFluidTransport i : members) {
            i.setNetwork(null);
        }
    }

    public void excludeAndRecalculate(IFluidTransport te) {
        this.exclude(te);
        this.refresh();
    }

    public int getFluidAmount() {
        int amount = 0;
        for (IFluidTransport t : this.pipes) {
            amount += t.getTank().getFluidAmount();
        }
        return amount;
    }

    public Fluid getFluid() {
        if (this.fluid == null) {
            if (this.getFluidAmount() == 0) {
                return null;
            }
            for (IFluidTransport t : this.pipes) {
                if (t.getTank().getFluidAmount() <= 0) continue;
                this.fluid = t.getTank().getFluid().getFluid();
                break;
            }
        }
        return this.fluid;
    }

    public int getCapacity() {
        int cap = 0;
        for (IFluidTransport t : this.pipes) {
            cap += t.getTank().getCapacity();
        }
        return cap;
    }
}

