/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.world;

import com.cout970.magneticraft.ManagerBlocks;
import com.cout970.magneticraft.api.util.BlockInfo;
import com.cout970.magneticraft.world.OreGenConfig;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fluids.FluidRegistry;

public class WorldGenManagerMg
implements IWorldGenerator {
    public static OreGenConfig GenCopper;
    public static OreGenConfig GenTungsten;
    public static OreGenConfig GenUranium;
    public static OreGenConfig GenSulfur;
    public static OreGenConfig GenThorium;
    public static OreGenConfig GenSalt;
    public static OreGenConfig GenZinc;
    public static boolean GenOil;
    public static int GenOilProbability;
    public static int GenOilMaxHeight;
    public static int GenOilMinHeight;
    public static int GenOilMaxAmount;
    public WorldGenMinable Copper;
    public WorldGenMinable Tungsten;
    public WorldGenMinable Uranium;
    public WorldGenMinable Sulfur;
    public WorldGenMinable Thorium;
    public WorldGenMinable Salt;
    public WorldGenMinable Zinc;

    public WorldGenManagerMg() {
        this.Copper = new WorldGenMinable(ManagerBlocks.oreCopper, 0, WorldGenManagerMg.GenCopper.amount_per_vein, Blocks.field_150348_b);
        this.Tungsten = new WorldGenMinable(ManagerBlocks.oreTungsten, 0, WorldGenManagerMg.GenTungsten.amount_per_vein, Blocks.field_150348_b);
        this.Uranium = new WorldGenMinable(ManagerBlocks.oreUranium, 0, WorldGenManagerMg.GenUranium.amount_per_vein, Blocks.field_150348_b);
        this.Sulfur = new WorldGenMinable(ManagerBlocks.oreSulfur, 0, WorldGenManagerMg.GenSulfur.amount_per_vein, Blocks.field_150348_b);
        this.Thorium = new WorldGenMinable(ManagerBlocks.oreThorium, 0, WorldGenManagerMg.GenThorium.amount_per_vein, Blocks.field_150348_b);
        this.Salt = new WorldGenMinable(ManagerBlocks.oreSalt, 0, WorldGenManagerMg.GenSalt.amount_per_vein, Blocks.field_150348_b);
        this.Zinc = new WorldGenMinable(ManagerBlocks.oreZinc, 0, WorldGenManagerMg.GenZinc.amount_per_vein, Blocks.field_150348_b);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g != 1 && world.field_73011_w.field_76574_g != -1) {
            this.useOreGenConfig(random, world, chunkX, chunkZ, GenCopper, this.Copper);
            this.useOreGenConfig(random, world, chunkX, chunkZ, GenTungsten, this.Tungsten);
            this.useOreGenConfig(random, world, chunkX, chunkZ, GenSulfur, this.Sulfur);
            this.useOreGenConfig(random, world, chunkX, chunkZ, GenUranium, this.Uranium);
            this.useOreGenConfig(random, world, chunkX, chunkZ, GenSalt, this.Salt);
            this.useOreGenConfig(random, world, chunkX, chunkZ, GenThorium, this.Thorium);
            this.useOreGenConfig(random, world, chunkX, chunkZ, GenZinc, this.Zinc);
            if (GenOil) {
                int run = GenOilProbability;
                BiomeGenBase base = world.func_72807_a(chunkX << 4, chunkZ << 4);
                if (base != null) {
                    if (base.func_76744_g() < 327680 || base.func_150561_m() == BiomeGenBase.TempCategory.WARM) {
                        run = (int)((double)run * 0.75);
                    }
                    if (base.func_150561_m() == BiomeGenBase.TempCategory.OCEAN) {
                        run = (int)((double)run * 0.85);
                    }
                    if (base.func_150561_m() == BiomeGenBase.TempCategory.COLD) {
                        run = (int)((double)run * 0.75);
                    }
                }
                if (random.nextInt(run) == 0 && GenOilMaxHeight - GenOilMinHeight >= 0) {
                    for (int d = 0; d < GenOilMaxAmount; ++d) {
                        int height = GenOilMinHeight + random.nextInt(GenOilMaxHeight - GenOilMinHeight);
                        int cX = chunkX - 3 + random.nextInt(6);
                        int cZ = chunkZ - 3 + random.nextInt(6);
                        int y = world.func_72976_f(cX << 4, cZ << 4);
                        this.generateSpere(random, world, cX << 4, y + 10, cZ << 4, FluidRegistry.getFluid((String)"oil").getBlock(), 0, false, 2.5f + (float)random.nextInt(3));
                        this.generateSpere_ore(random, world, cX << 4, height, cZ << 4, ManagerBlocks.oilSource, 15, false, 2.5f + (float)random.nextInt(4));
                    }
                }
            }
        }
    }

    public void useOreGenConfig(Random random, World world, int chunkX, int chunkZ, OreGenConfig conf, WorldGenMinable mine) {
        if (conf.active) {
            this.genChunk(random, world, chunkX, chunkZ, conf.amount_per_chunk, conf.max_height, conf.min_height, mine);
        }
    }

    public void genChunk(Random r, World w, int cx, int cz, int a, int h, int hm, WorldGenMinable wgm) {
        for (int k = 0; k < a; ++k) {
            int x = cx * 16 + r.nextInt(16);
            int y = hm + r.nextInt(h - hm);
            int z = cz * 16 + r.nextInt(16);
            wgm.func_76484_a(w, r, x, y, z);
        }
    }

    private void generateSpere(Random random, World world, int x, int y, int z, Block b, int meta, boolean flag, float rad) {
        int max_it = (int)(Math.ceil(rad) + 1.0);
        float rad_square = rad * rad;
        float rad_square_2 = (rad + 1.0f) * (rad + 1.0f);
        boolean ore = true;
        int offX = 8;
        int offZ = 8;
        int level = max_it;
        int count = 0;
        int water = 0;
        int extension = 1;
        LinkedList<BlockInfo> list = new LinkedList<BlockInfo>();
        while (y > 0 && !this.canRemplace(world.func_147439_a(x, y, z))) {
            if (Block.func_149680_a((Block)Blocks.field_150355_j, (Block)world.func_147439_a(x, y, z))) {
                return;
            }
            --y;
        }
        if (y == 0) {
            return;
        }
        for (int j = -extension; j <= extension; ++j) {
            for (int i = -max_it; i <= max_it; ++i) {
                for (int k = -max_it; k <= max_it; ++k) {
                    Block bl;
                    if ((float)(i * i + j * j * 8 + k * k) < rad_square) {
                        bl = world.func_147439_a(x + i + offX, y + j, z + k + offZ);
                        if (!Block.func_149680_a((Block)bl, (Block)Blocks.field_150350_a) || flag) {
                            if (this.canRemplace(bl)) {
                                if (ore) {
                                    list.add(new BlockInfo(b, meta, i, j, k));
                                    ++count;
                                    continue;
                                }
                                if (Block.func_149680_a((Block)bl, (Block)Blocks.field_150355_j)) {
                                    ++water;
                                }
                                list.add(new BlockInfo(Blocks.field_150350_a, 0, i, j, k));
                                continue;
                            }
                            if (!this.shouldVoid(bl)) continue;
                            list.add(new BlockInfo(Blocks.field_150350_a, 0, i, j, k));
                            continue;
                        }
                        list.add(new BlockInfo(Blocks.field_150350_a, 0, i, j, k));
                        continue;
                    }
                    if (!((float)(i * i + j * j * 8 + k * k) < rad_square_2)) continue;
                    bl = world.func_147439_a(x + i + offX, y + j, z + k + offZ);
                    if (Block.func_149680_a((Block)bl, (Block)Blocks.field_150355_j)) {
                        ++water;
                    }
                    if (!Block.func_149680_a((Block)bl, (Block)Blocks.field_150350_a)) continue;
                    level = Math.min(j, level);
                    ore = false;
                }
            }
        }
        if (count < 3) {
            return;
        }
        if (level < 1) {
            return;
        }
        if (water >= count) {
            return;
        }
        for (BlockInfo pos : list) {
            if (pos.getBlock() == b) {
                if (level > pos.getY()) {
                    world.func_147465_d(x + pos.getX() + offX, y + pos.getY(), z + pos.getZ() + offZ, pos.getBlock(), pos.getMeta(), 2);
                    continue;
                }
                world.func_147465_d(x + pos.getX() + offX, y + pos.getY(), z + pos.getZ() + offZ, Blocks.field_150350_a, 0, 2);
                continue;
            }
            world.func_147465_d(x + pos.getX() + offX, y + pos.getY(), z + pos.getZ() + offZ, pos.getBlock(), pos.getMeta(), 2);
        }
    }

    private void generateSpere_ore(Random random, World world, int x, int y, int z, Block b, int meta, boolean flag, float rad) {
        int max_it = (int)(Math.ceil(rad) + 1.0);
        float rad_square = rad * rad;
        float rad_square_2 = (rad + 1.0f) * (rad + 1.0f);
        LinkedList<BlockInfo> list = new LinkedList<BlockInfo>();
        int count = 0;
        int water = 0;
        for (int j = -max_it; j <= max_it; ++j) {
            for (int i = -max_it; i <= max_it; ++i) {
                for (int k = -max_it; k <= max_it; ++k) {
                    if ((float)(i * i + j * j + k * k) < rad_square) {
                        Block bl = world.func_147439_a(x + i + 8, y + j, z + k + 8);
                        if (Block.func_149680_a((Block)bl, (Block)Blocks.field_150350_a) && !flag) continue;
                        if (this.canRemplace(bl)) {
                            list.add(new BlockInfo(b, meta, i, j, k));
                            ++count;
                            continue;
                        }
                        if (!Block.func_149680_a((Block)bl, (Block)Blocks.field_150355_j)) continue;
                        ++water;
                        continue;
                    }
                    if (!((float)(i * i + j * j + k * k) < rad_square_2)) continue;
                    list.add(new BlockInfo(Blocks.field_150348_b, 0, i, j, k));
                }
            }
        }
        if (water >= count) {
            return;
        }
        for (BlockInfo pos : list) {
            world.func_147465_d(x + pos.getX() + 8, y + pos.getY(), z + pos.getZ() + 8, pos.getBlock(), pos.getMeta(), 2);
        }
    }

    private boolean shouldVoid(Block bl) {
        if (Block.func_149680_a((Block)bl, (Block)Blocks.field_150330_I)) {
            return true;
        }
        if (Block.func_149680_a((Block)bl, (Block)Blocks.field_150434_aF)) {
            return true;
        }
        if (Block.func_149680_a((Block)bl, (Block)Blocks.field_150327_N)) {
            return true;
        }
        return Block.func_149680_a((Block)bl, (Block)Blocks.field_150329_H);
    }

    public boolean canRemplace(Block b) {
        if (Block.func_149680_a((Block)b, (Block)Blocks.field_150346_d)) {
            return true;
        }
        if (Block.func_149680_a((Block)b, (Block)Blocks.field_150348_b)) {
            return true;
        }
        if (Block.func_149680_a((Block)b, (Block)Blocks.field_150349_c)) {
            return true;
        }
        if (Block.func_149680_a((Block)b, (Block)Blocks.field_150354_m)) {
            return true;
        }
        if (Block.func_149680_a((Block)b, (Block)Blocks.field_150351_n)) {
            return true;
        }
        if (Block.func_149680_a((Block)b, (Block)Blocks.field_150322_A)) {
            return true;
        }
        return Block.func_149680_a((Block)b, (Block)Blocks.field_150435_aG);
    }
}

