/*
 * Decompiled with CFR 0.152.
 */
package person.mister.auw;

import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.ArrayUtils;
import person.mister.auw.BaseMod;
import person.mister.auw.GuiNamedTextField;

public class NBTGuiElement {
    private GuiButton button;
    private GuiTextField textField;
    private static int buttonID = 500;
    public Object initialValue;
    public String tagName;
    private String[] buttonNames;
    private int buttonIndex = 0;
    public int datatype;
    private Class entityClass;

    public NBTGuiElement(int x, int y, int w, int h, Object initialValue, String tagName, List tab, Class entity, String ... names) {
        this.buttonNames = names;
        this.initialValue = initialValue;
        this.tagName = tagName;
        this.entityClass = entity;
        if (initialValue instanceof Boolean) {
            this.datatype = 10;
        }
        if (initialValue instanceof Byte) {
            this.datatype = 11;
        }
        if (initialValue instanceof Short) {
            this.datatype = 12;
        }
        if (initialValue instanceof Integer) {
            this.datatype = 13;
        }
        if (initialValue instanceof Long) {
            this.datatype = 14;
        }
        if (initialValue instanceof String) {
            this.datatype = 15;
        }
        this.buttonIndex = this.getInt(initialValue);
        this.button = new GuiButton(buttonID, x, y - 10, w, h, names[this.buttonIndex]);
        ++buttonID;
        tab.add(this.button);
    }

    public NBTGuiElement(FontRenderer f, int x, int y, int w, int h, Object initialValue, String tagName, List tab, Class entity, String name) {
        this.textField = new GuiNamedTextField(f, x, y, w, h, name);
        this.textField.func_146180_a(initialValue.toString());
        this.initialValue = initialValue;
        this.tagName = tagName;
        this.entityClass = entity;
        if (initialValue instanceof Boolean) {
            this.datatype = 0;
        }
        if (initialValue instanceof Byte) {
            this.datatype = 1;
        }
        if (initialValue instanceof Short) {
            this.datatype = 2;
        }
        if (initialValue instanceof Integer) {
            this.datatype = 3;
        }
        if (initialValue instanceof Long) {
            this.datatype = 4;
        }
        if (initialValue instanceof String) {
            this.datatype = 5;
        }
        if (initialValue instanceof Float) {
            this.datatype = 6;
        }
        if (initialValue instanceof Double) {
            this.datatype = 7;
        }
        tab.add(this.textField);
    }

    public int getInt(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1 : 0;
        }
        if (o instanceof Byte) {
            return ((Byte)o).byteValue();
        }
        if (o instanceof Short) {
            return ((Short)o).shortValue();
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Long) {
            return (int)((Long)o).longValue();
        }
        if (o instanceof String) {
            return ArrayUtils.indexOf((Object[])this.buttonNames, (Object)o);
        }
        return 0;
    }

    public void reset() {
        if (this.datatype >= 10) {
            this.buttonIndex = this.getInt(this.initialValue);
            this.button.field_146126_j = this.buttonNames[this.buttonIndex];
        } else {
            this.textField.func_146180_a(this.initialValue.toString());
        }
    }

    public void setFromNBT(NBTTagCompound tags, Entity entity) {
        if (this.entityClass.isAssignableFrom(entity.getClass())) {
            switch (this.datatype) {
                case 0: {
                    this.textField.func_146180_a("" + tags.func_74767_n(this.tagName));
                    break;
                }
                case 1: {
                    this.textField.func_146180_a("" + tags.func_74771_c(this.tagName));
                    break;
                }
                case 2: {
                    this.textField.func_146180_a("" + tags.func_74765_d(this.tagName));
                    break;
                }
                case 3: {
                    this.textField.func_146180_a("" + tags.func_74762_e(this.tagName));
                    break;
                }
                case 4: {
                    this.textField.func_146180_a("" + tags.func_74763_f(this.tagName));
                    break;
                }
                case 5: {
                    this.textField.func_146180_a(tags.func_74779_i(this.tagName));
                    break;
                }
                case 6: {
                    this.textField.func_146180_a(BaseMod.round(tags.func_74760_g(this.tagName), 2));
                    break;
                }
                case 7: {
                    this.textField.func_146180_a(BaseMod.round(tags.func_74769_h(this.tagName), 2));
                    break;
                }
                case 10: {
                    this.buttonIndex = tags.func_74767_n(this.tagName) ? 1 : 0;
                    this.button.field_146126_j = this.buttonNames[this.buttonIndex];
                    break;
                }
                case 11: {
                    this.buttonIndex = tags.func_74771_c(this.tagName);
                    this.button.field_146126_j = this.buttonNames[this.buttonIndex];
                    break;
                }
                case 12: {
                    this.buttonIndex = tags.func_74765_d(this.tagName);
                    this.button.field_146126_j = this.buttonNames[this.buttonIndex];
                    break;
                }
                case 13: {
                    this.buttonIndex = tags.func_74762_e(this.tagName);
                    this.button.field_146126_j = this.buttonNames[this.buttonIndex];
                    break;
                }
                case 14: {
                    this.buttonIndex = (int)tags.func_74763_f(this.tagName);
                    this.button.field_146126_j = this.buttonNames[this.buttonIndex];
                    break;
                }
                case 15: {
                    this.buttonIndex = ArrayUtils.indexOf((Object[])this.buttonNames, (Object)tags.func_74779_i(this.tagName));
                    this.button.field_146126_j = this.buttonNames[this.buttonIndex];
                }
            }
        }
    }

    public void actionPerformed(GuiButton b) {
        if (this.datatype >= 10 && b.field_146127_k == this.button.field_146127_k) {
            ++this.buttonIndex;
            if (this.buttonIndex >= this.buttonNames.length) {
                this.buttonIndex = 0;
            }
            this.button.field_146126_j = this.buttonNames[this.buttonIndex];
        }
    }

    public void addToTags(NBTTagCompound tags, Entity entity) {
        if (this.entityClass.isAssignableFrom(entity.getClass())) {
            switch (this.datatype) {
                case 0: {
                    tags.func_74757_a(this.tagName, Boolean.parseBoolean(this.textField.func_146179_b()));
                    break;
                }
                case 1: {
                    tags.func_74774_a(this.tagName, Byte.parseByte(this.textField.func_146179_b()));
                    break;
                }
                case 2: {
                    tags.func_74777_a(this.tagName, Short.parseShort(this.textField.func_146179_b()));
                    break;
                }
                case 3: {
                    tags.func_74768_a(this.tagName, Integer.parseInt(this.textField.func_146179_b()));
                    break;
                }
                case 4: {
                    tags.func_74772_a(this.tagName, Long.parseLong(this.textField.func_146179_b()));
                    break;
                }
                case 5: {
                    tags.func_74778_a(this.tagName, this.textField.func_146179_b());
                    break;
                }
                case 6: {
                    tags.func_74776_a(this.tagName, Float.parseFloat(this.textField.func_146179_b()));
                    break;
                }
                case 7: {
                    tags.func_74780_a(this.tagName, Double.parseDouble(this.textField.func_146179_b()));
                    break;
                }
                case 10: {
                    tags.func_74757_a(this.tagName, this.buttonIndex != 0);
                    break;
                }
                case 11: {
                    tags.func_74774_a(this.tagName, (byte)this.buttonIndex);
                    break;
                }
                case 12: {
                    tags.func_74777_a(this.tagName, (short)this.buttonIndex);
                    break;
                }
                case 13: {
                    tags.func_74768_a(this.tagName, this.buttonIndex);
                    break;
                }
                case 14: {
                    tags.func_74772_a(this.tagName, (long)this.buttonIndex);
                    break;
                }
                case 15: {
                    tags.func_74778_a(this.tagName, this.buttonNames[this.buttonIndex]);
                }
            }
        }
    }
}

