/*
 * Decompiled with CFR 0.152.
 */
package person.mister.auw.tileEntity;

import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityCommandBlock;
import org.apache.commons.lang3.ArrayUtils;
import person.mister.auw.BaseMod;
import person.mister.auw.GuiNamedTextField;
import person.mister.auw.GuiScrollBox;
import person.mister.auw.GuiShortButton;
import person.mister.auw.tileEntity.GuiEditTileEntity;

public class GuiEditCommandNew
extends GuiEditTileEntity {
    private int addX;
    private int addY;
    private GuiScreen parent;
    private int formatError;
    private TileEntityCommandBlock block;
    private String name;
    private GuiNamedTextField nameField;
    private String command;
    private GuiNamedTextField commandField;
    private int successCount;
    private GuiNamedTextField successField;
    private boolean rPress;
    private boolean click;
    private String[] commands = new String[]{"gamemode", "give", "scoreboard", "tp", "kill", "sqreadplayers", "xp", "difficulty", "debug", "gamerule", "clear", "time", "help", "defaultgamemode", "weather", "me", "tell", "publish", "achievement", "tellraw", "testforblock", "seed", "playsound", "msg", "spawnpoint", "setblock", "w", "toggledownfall", "effect", "say", "setworldspawn", "summon", "testfor", "?", "enchant"};
    private ArrayList<ArrayList<Gui>> commandButtons = new ArrayList();
    private ArrayList<CommandGuiElement> guis = new ArrayList();
    private int commandIndex;

    public GuiEditCommandNew(GuiScreen parent, TileEntity block) {
        int i;
        this.block = (TileEntityCommandBlock)block;
        this.parent = parent;
        if (block == null) {
            block = new TileEntityCommandBlock();
        }
        NBTTagCompound tags = new NBTTagCompound();
        block.func_145841_b(tags);
        if (tags.func_74764_b("CustomName")) {
            this.name = tags.func_74779_i("CustomName");
        }
        for (i = 0; i < this.commands.length; ++i) {
            this.commandButtons.add(new ArrayList());
        }
        this.command = tags.func_74779_i("Command");
        this.successCount = tags.func_74762_e("SuccessCount");
        for (i = 0; i < this.guis.size(); ++i) {
            this.guis.get(i).getFromString(this.command.split(" "), this.commandIndex);
        }
    }

    @Override
    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.textFields.clear();
        super.func_73866_w_();
        this.guis.clear();
        this.addX = this.field_146294_l / 2 - 160;
        this.addY = this.field_146295_m / 2 - 120;
        this.rPress = false;
        this.click = false;
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 52, this.field_146295_m - this.addY - 22, 50, 20, "Save"));
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 2, this.field_146295_m - this.addY - 22, 50, 20, "Cancel"));
        this.nameField = new GuiNamedTextField(this.field_146289_q, this.field_146294_l / 2 - 105, this.addY + 30, 100, 10, "Custom Name");
        if (this.name != null) {
            this.nameField.func_146180_a(this.name);
        }
        this.textFields.add(this.nameField);
        this.successField = new GuiNamedTextField(this.field_146289_q, this.field_146294_l / 2 + 5, this.addY + 30, 100, 10, "Success Count");
        this.successField.func_146180_a("" + this.successCount);
        this.textFields.add(this.successField);
        this.commandField = new GuiNamedTextField(this.field_146289_q, this.field_146294_l / 2 - 150, this.addY + 55, 300, 10, "Command");
        if (this.command != null) {
            this.commandField.func_146180_a(this.command);
        }
        this.textFields.add(this.commandField);
        this.guis.add(new CommandGuiElement(this.field_146294_l / 2 - 100, this.addY + 90, 200, 20, "survival", ArrayUtils.indexOf((Object[])this.commands, (Object)"gamemode") + 1, 1, "survival", "creative", "adventure"));
        this.guis.add(new CommandGuiElement(this.field_146289_q, this.field_146294_l / 2 - 100, this.addY + 90, 200, 10, "default", ArrayUtils.indexOf((Object[])this.commands, (Object)"say") + 1, 1, "Text"));
        for (int i = 0; i < this.commands.length; ++i) {
            this.commandButtons.get(0).add((Gui)new GuiShortButton(i + 10, 0, 0, this.field_146289_q.func_78256_a(this.commands[i]) + 10, 15, this.commands[i]));
        }
        this.updateCommandButtons();
        for (ArrayList<Gui> screen : this.commandButtons) {
            for (Gui element : screen) {
                if (element instanceof GuiTextField) {
                    this.textFields.add((GuiTextField)element);
                }
                if (!(element instanceof GuiButton)) continue;
                this.field_146292_n.add((GuiButton)element);
            }
        }
        this.updateButtons();
        this.updateArgs(true);
        this.colorButton(this.addX + 270, this.addY + 25);
    }

    @Override
    public void func_146284_a(GuiButton button) {
        int i;
        super.func_146284_a(button);
        for (i = 0; i < this.guis.size(); ++i) {
            this.guis.get(i).actionPerformed(button);
        }
        if (button.field_146127_k == 0) {
            this.updateCommandBlock();
            this.save();
            this.field_146297_k.func_147108_a(this.parent);
        } else if (button.field_146127_k == 1) {
            this.field_146297_k.func_147108_a(this.parent);
        } else if (button.field_146127_k >= 10 && button.field_146127_k <= 50) {
            this.commandIndex = button.field_146127_k - 9;
            this.updateButtons();
            this.commandField.func_146180_a("" + this.commands[button.field_146127_k - 10]);
            for (i = 0; i < this.guis.size(); ++i) {
                try {
                    this.guis.get(i).getFromString(this.command.split(" "), this.commandIndex);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (button.field_146127_k != 9016) {
            this.updateArgs(false);
        } else {
            boolean anyFocus = false;
            for (GuiTextField field : this.textFields) {
                if (!field.func_146206_l()) continue;
                anyFocus = true;
            }
            if (this.commandField.func_146206_l()) {
                this.updateArgs(true);
            } else if (anyFocus) {
                this.updateArgs(false);
            }
        }
    }

    @Override
    public void func_73869_a(char key, int keyCode) {
        super.func_73869_a(key, keyCode);
        this.name = this.nameField.func_146179_b().isEmpty() ? null : this.nameField.func_146179_b();
        try {
            this.successCount = Integer.parseInt(this.successField.func_146179_b());
            this.formatError = 0;
        }
        catch (Exception e) {
            if (this.formatError == 0) {
                e.printStackTrace();
            }
            this.formatError = 1;
        }
        boolean anyFocus = false;
        for (GuiTextField field : this.textFields) {
            if (!field.func_146206_l()) continue;
            anyFocus = true;
        }
        this.command = this.commandField.func_146179_b();
        if (this.commandField.func_146206_l()) {
            this.updateArgs(true);
        } else if (anyFocus && !this.nameField.func_146206_l() && !this.successField.func_146206_l()) {
            this.updateArgs(false);
        }
        this.updateCommandButtons();
        this.command = this.commandField.func_146179_b();
        if (keyCode == BaseMod.proxy.keyCode) {
            this.rPress = true;
        }
    }

    @Override
    public void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        this.command = this.commandField.func_146179_b();
        if (this.command.split(" ").length != 0 && this.commandField.func_146206_l() && this.commandField.func_146198_h() <= this.command.split(" ")[0].length()) {
            this.commandIndex = 0;
            this.updateButtons();
        } else if (this.commandIndex == 0) {
            for (int i = 0; i < this.commands.length; ++i) {
                if (this.command.split(" ").length == 0 || !this.command.split(" ")[0].equals(this.commands[i])) continue;
                this.commandIndex = i + 1;
                this.updateButtons();
            }
        }
        if (button == 0) {
            this.click = true;
        }
    }

    @Override
    public void func_73863_a(int x, int y, float par) {
        this.func_146276_q_();
        if (BaseMod.debugMode) {
            GuiEditCommandNew.func_73734_a((int)this.addX, (int)this.addY, (int)(this.field_146294_l - this.addX), (int)(this.field_146295_m - this.addY), (int)-2005401788);
        }
        super.func_73863_a(x, y, par);
        if (this.formatError > 0) {
            this.func_73731_b(this.field_146289_q, "One of the numbers is formatted wrong", this.addX, this.addY, 0xFF0000);
        }
    }

    public void updateCommandBlock() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74778_a("id", "Control");
        tags.func_74768_a("x", this.block.field_145851_c);
        tags.func_74768_a("y", this.block.field_145848_d);
        tags.func_74768_a("z", this.block.field_145849_e);
        if (this.name != null && !this.name.isEmpty()) {
            tags.func_74778_a("CustomName", this.name);
        }
        tags.func_74768_a("SuccessCount", this.successCount);
        tags.func_74778_a("Command", this.command);
        this.block = new TileEntityCommandBlock();
        this.block.func_145839_a(tags);
    }

    public void updateButtons() {
        for (int i = 0; i < this.commandButtons.size(); ++i) {
            for (Gui gui : this.commandButtons.get(i)) {
                if (gui instanceof GuiButton) {
                    ((GuiButton)gui).field_146124_l = false;
                    ((GuiButton)gui).field_146125_m = false;
                    continue;
                }
                if (!(gui instanceof GuiNamedTextField)) continue;
                ((GuiNamedTextField)gui).func_146184_c(false);
                ((GuiNamedTextField)gui).func_146189_e(false);
                ((GuiNamedTextField)gui).func_146195_b(false);
                ((GuiNamedTextField)gui).func_146205_d(false);
            }
        }
        for (Gui gui : this.commandButtons.get(this.commandIndex)) {
            if (gui instanceof GuiButton) {
                ((GuiButton)gui).field_146124_l = true;
                ((GuiButton)gui).field_146125_m = true;
                continue;
            }
            if (!(gui instanceof GuiNamedTextField)) continue;
            ((GuiNamedTextField)gui).func_146184_c(true);
            ((GuiNamedTextField)gui).func_146189_e(true);
            ((GuiNamedTextField)gui).func_146205_d(true);
        }
    }

    public void updateArgs(boolean fromCommand) {
        block11: {
            String tempCommand;
            block10: {
                int i;
                tempCommand = this.commandField.func_146179_b();
                if (!fromCommand) break block10;
                if ((tempCommand = tempCommand + "                    ").split(" ").length != 0 && !tempCommand.split(" ")[0].equals(this.commands[this.commandIndex])) {
                    this.commandIndex = 0;
                    this.updateButtons();
                }
                for (i = 0; i < this.commands.length; ++i) {
                    if (tempCommand.split(" ").length == 0 || !tempCommand.split(" ")[0].equals(this.commands[i]) || this.commandField.func_146206_l() && this.commandField.func_146198_h() <= this.command.split(" ")[0].length()) continue;
                    this.commandIndex = i + 1;
                    this.updateButtons();
                }
                for (i = 0; i < this.guis.size(); ++i) {
                    try {
                        this.guis.get(i).getFromString(tempCommand.split(" ", 20), this.commandIndex);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                break block11;
            }
            if (fromCommand) break block11;
            for (int i = 0; i < this.guis.size(); ++i) {
                try {
                    int j;
                    String[] s = new String[20];
                    for (j = 0; j < 20; ++j) {
                        s[j] = tempCommand.split(" ").length > j ? tempCommand.split(" ")[j] : "";
                    }
                    this.guis.get(i).addToString(s, this.commandIndex);
                    tempCommand = s[0];
                    for (j = 1; j < s.length; ++j) {
                        if (s[j].equals("")) continue;
                        tempCommand = tempCommand + " " + s[j];
                    }
                    this.commandField.func_146180_a(tempCommand);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public void updateCommandButtons() {
        int i;
        int x = 0;
        int y = 0;
        for (i = 0; i < this.commands.length; ++i) {
            if (!this.commands[i].toLowerCase().contains(this.commandField.func_146179_b().toLowerCase())) continue;
            if (x + this.field_146289_q.func_78256_a(this.commands[i]) > 320) {
                x = 0;
                ++y;
            }
            ((GuiButton)this.commandButtons.get((int)0).get((int)i)).field_146128_h = x + this.addX;
            ((GuiButton)this.commandButtons.get((int)0).get((int)i)).field_146129_i = y * 17 + 70 + this.addY;
            x += this.field_146289_q.func_78256_a(this.commands[i]) + 12;
        }
        y += 2;
        x = 0;
        for (i = 0; i < this.commands.length; ++i) {
            if (this.commands[i].toLowerCase().contains(this.commandField.func_146179_b().toLowerCase())) continue;
            if (x + this.field_146289_q.func_78256_a(this.commands[i]) > 320) {
                x = 0;
                ++y;
            }
            ((GuiButton)this.commandButtons.get((int)0).get((int)i)).field_146128_h = x + this.addX;
            ((GuiButton)this.commandButtons.get((int)0).get((int)i)).field_146129_i = y * 17 + 70 + this.addY;
            x += this.field_146289_q.func_78256_a(this.commands[i]) + 12;
        }
    }

    @Override
    public TileEntity getTileEntity() {
        return this.block;
    }

    @Override
    public void save() {
    }

    @Override
    public int getBlockID() {
        return 137;
    }

    private class CommandGuiElement {
        private GuiButton button;
        private GuiTextField textField;
        private GuiScrollBox box;
        private int x;
        private int y;
        private int w;
        private int h;
        private Object initialValue;
        private int type;
        private int commandIndex;
        private int argIndex;
        private String[] buttonNames;
        private int buttonIndex;
        private FontRenderer f;

        public CommandGuiElement(int x, int y, int w, int h, Object initialValue, int commandIndex, int argIndex, String ... buttonNames) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.initialValue = initialValue;
            this.commandIndex = commandIndex;
            this.argIndex = argIndex;
            this.buttonNames = buttonNames;
            if (initialValue instanceof Boolean) {
                this.type = 10;
            }
            if (initialValue instanceof Byte) {
                this.type = 11;
            }
            if (initialValue instanceof Short) {
                this.type = 12;
            }
            if (initialValue instanceof Integer) {
                this.type = 13;
            }
            if (initialValue instanceof Long) {
                this.type = 14;
            }
            if (initialValue instanceof String) {
                this.type = 15;
            }
            this.buttonIndex = this.getInt(initialValue);
            this.button = new GuiButton(50 + commandIndex * 20 + argIndex, x, y - 10, w, h, buttonNames[this.buttonIndex]);
            ((ArrayList)GuiEditCommandNew.this.commandButtons.get(commandIndex)).add(this.button);
        }

        public CommandGuiElement(FontRenderer f, int x, int y, int w, int h, Object initialValue, int commandIndex, int argIndex, String name) {
            this.f = f;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.initialValue = initialValue;
            this.commandIndex = commandIndex;
            this.argIndex = argIndex;
            this.textField = new GuiNamedTextField(f, x, y, w, h, name);
            this.textField.func_146180_a(initialValue.toString());
            if (initialValue instanceof Boolean) {
                this.type = 0;
            }
            if (initialValue instanceof Byte) {
                this.type = 1;
            }
            if (initialValue instanceof Short) {
                this.type = 2;
            }
            if (initialValue instanceof Integer) {
                this.type = 3;
            }
            if (initialValue instanceof Long) {
                this.type = 4;
            }
            if (initialValue instanceof String) {
                this.type = 5;
            }
            if (initialValue instanceof Float) {
                this.type = 6;
            }
            if (initialValue instanceof Double) {
                this.type = 7;
            }
            ((ArrayList)GuiEditCommandNew.this.commandButtons.get(commandIndex)).add(this.textField);
        }

        public CommandGuiElement(GuiScrollBox box) {
        }

        public int getInt(Object o) {
            if (o instanceof Boolean) {
                return (Boolean)o != false ? 1 : 0;
            }
            if (o instanceof Byte) {
                return ((Byte)o).byteValue();
            }
            if (o instanceof Short) {
                return ((Short)o).shortValue();
            }
            if (o instanceof Integer) {
                return (Integer)o;
            }
            if (o instanceof Long) {
                return (int)((Long)o).longValue();
            }
            if (o instanceof String) {
                return ArrayUtils.indexOf((Object[])this.buttonNames, (Object)o);
            }
            return 0;
        }

        public void actionPerformed(GuiButton b) {
            if (this.type >= 10 && b.field_146127_k == this.button.field_146127_k) {
                ++this.buttonIndex;
                if (this.buttonIndex >= this.buttonNames.length) {
                    this.buttonIndex = 0;
                }
                this.button.field_146126_j = this.buttonNames[this.buttonIndex];
            }
        }

        public void getFromString(String[] s, int commandIndex) {
            if (commandIndex == this.commandIndex) {
                switch (this.type) {
                    case 0: {
                        this.textField.func_146180_a("" + Boolean.parseBoolean(s[this.argIndex]));
                        break;
                    }
                    case 1: {
                        this.textField.func_146180_a("" + Byte.parseByte(s[this.argIndex]));
                        break;
                    }
                    case 2: {
                        this.textField.func_146180_a("" + Short.parseShort(s[this.argIndex]));
                        break;
                    }
                    case 3: {
                        this.textField.func_146180_a("" + Integer.parseInt(s[this.argIndex]));
                        break;
                    }
                    case 4: {
                        this.textField.func_146180_a("" + Long.parseLong(s[this.argIndex]));
                        break;
                    }
                    case 5: {
                        this.textField.func_146180_a(s[this.argIndex]);
                        break;
                    }
                    case 6: {
                        this.textField.func_146180_a(BaseMod.round(Float.parseFloat(s[this.argIndex]), 2));
                        break;
                    }
                    case 7: {
                        this.textField.func_146180_a(BaseMod.round(Double.parseDouble(s[this.argIndex]), 2));
                        break;
                    }
                    case 10: {
                        this.buttonIndex = Boolean.parseBoolean(s[this.argIndex]) ? 1 : 0;
                        this.button.field_146126_j = this.buttonNames[this.buttonIndex];
                        break;
                    }
                    case 11: {
                        this.buttonIndex = Byte.parseByte(s[this.argIndex]);
                        this.button.field_146126_j = this.buttonNames[this.buttonIndex];
                        break;
                    }
                    case 12: {
                        this.buttonIndex = Short.parseShort(s[this.argIndex]);
                        this.button.field_146126_j = this.buttonNames[this.buttonIndex];
                        break;
                    }
                    case 13: {
                        this.buttonIndex = Integer.parseInt(s[this.argIndex]);
                        this.button.field_146126_j = this.buttonNames[this.buttonIndex];
                        break;
                    }
                    case 14: {
                        this.buttonIndex = (int)Long.parseLong(s[this.argIndex]);
                        this.button.field_146126_j = this.buttonNames[this.buttonIndex];
                        break;
                    }
                    case 15: {
                        this.buttonIndex = ArrayUtils.indexOf((Object[])this.buttonNames, (Object)s[this.argIndex]);
                        this.button.field_146126_j = this.buttonNames[this.buttonIndex];
                    }
                }
            }
        }

        public String[] addToString(String[] s, int commandIndex) {
            if (commandIndex == this.commandIndex) {
                switch (this.type) {
                    case 0: {
                        s[this.argIndex] = "" + Boolean.parseBoolean(this.textField.func_146179_b());
                        break;
                    }
                    case 1: {
                        s[this.argIndex] = "" + Byte.parseByte(this.textField.func_146179_b());
                        break;
                    }
                    case 2: {
                        s[this.argIndex] = "" + Short.parseShort(this.textField.func_146179_b());
                        break;
                    }
                    case 3: {
                        s[this.argIndex] = "" + Integer.parseInt(this.textField.func_146179_b());
                        break;
                    }
                    case 4: {
                        s[this.argIndex] = "" + Long.parseLong(this.textField.func_146179_b());
                        break;
                    }
                    case 5: {
                        s[this.argIndex] = "" + this.textField.func_146179_b();
                        break;
                    }
                    case 6: {
                        s[this.argIndex] = "" + Float.parseFloat(this.textField.func_146179_b());
                        break;
                    }
                    case 7: {
                        s[this.argIndex] = "" + Double.parseDouble(this.textField.func_146179_b());
                        break;
                    }
                    case 10: {
                        s[this.argIndex] = "" + (this.buttonIndex != 0);
                        break;
                    }
                    case 11: {
                        s[this.argIndex] = "" + (byte)this.buttonIndex;
                        break;
                    }
                    case 12: {
                        s[this.argIndex] = "" + (short)this.buttonIndex;
                        break;
                    }
                    case 13: {
                        s[this.argIndex] = "" + this.buttonIndex;
                        break;
                    }
                    case 14: {
                        s[this.argIndex] = "" + this.buttonIndex;
                        break;
                    }
                    case 15: {
                        s[this.argIndex] = "" + this.buttonNames[this.buttonIndex];
                    }
                }
            }
            return s;
        }
    }
}

