/*
 * Decompiled with CFR 0.152.
 */
package person.mister.auw.tileEntity;

import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import person.mister.auw.BaseMod;
import person.mister.auw.GuiNamedTextField;
import person.mister.auw.tileEntity.GuiEditTileEntity;

public class GuiEditFlowerPot
extends GuiEditTileEntity {
    private int addX;
    private int addY;
    private GuiScreen parent;
    private TileEntityFlowerPot flowerPot;
    private int item;
    private GuiNamedTextField itemField;
    private int data;
    private GuiNamedTextField dataField;
    private boolean rPress;
    private boolean click;
    private int formatError;
    private Tessellator tessellator = Tessellator.field_78398_a;
    private IBlockAccess blockAccess = new BlockAccess();
    private RenderBlocks renderBlocks;
    private float rotation = 0.0f;

    public GuiEditFlowerPot(GuiScreen parent, TileEntity table) {
        this.flowerPot = (TileEntityFlowerPot)table;
        this.parent = parent;
        if (table == null) {
            table = new TileEntityFlowerPot();
        }
        NBTTagCompound tags = new NBTTagCompound();
        table.func_145841_b(tags);
        this.item = tags.func_74762_e("Item");
        this.data = tags.func_74762_e("Data");
        GuiEditFlowerPot guiEditFlowerPot = this;
        this.renderBlocks = guiEditFlowerPot.renderBlocks.getInstance();
        this.renderBlocks.field_147845_a = this.blockAccess;
    }

    @Override
    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.textFields.clear();
        super.func_73866_w_();
        this.addX = this.field_146294_l / 2 - 160;
        this.addY = this.field_146295_m / 2 - 120;
        this.rPress = false;
        this.click = false;
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 52, this.field_146295_m - this.addY - 22, 50, 20, "Save"));
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 2, this.field_146295_m - this.addY - 22, 50, 20, "Cancel"));
        this.itemField = new GuiNamedTextField(this.field_146289_q, this.field_146294_l / 2 - 50, this.addY + 30, 100, 10, "Item");
        this.itemField.func_146180_a("" + this.item);
        this.textFields.add(this.itemField);
        this.dataField = new GuiNamedTextField(this.field_146289_q, this.field_146294_l / 2 - 50, this.addY + 55, 100, 10, "Metadata");
        this.dataField.func_146180_a("" + this.data);
        this.textFields.add(this.dataField);
    }

    @Override
    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146127_k == 0) {
            this.updateTable();
            this.save();
            this.field_146297_k.func_147108_a(this.parent);
        } else if (button.field_146127_k == 1) {
            this.field_146297_k.func_147108_a(this.parent);
        }
    }

    @Override
    public void func_73869_a(char key, int keyCode) {
        super.func_73869_a(key, keyCode);
        try {
            this.item = Short.parseShort(this.itemField.func_146179_b());
            this.data = Short.parseShort(this.dataField.func_146179_b());
            if (this.formatError == 1) {
                this.formatError = 0;
            }
        }
        catch (NumberFormatException e) {
            this.item = 1;
            this.data = 0;
            if (this.formatError == 0) {
                e.printStackTrace();
            }
            this.formatError = 1;
        }
        if (keyCode == BaseMod.proxy.keyCode) {
            this.rPress = true;
        }
        this.updateTable();
    }

    @Override
    public void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        if (button == 0) {
            this.click = true;
        }
    }

    @Override
    public void func_73863_a(int x, int y, float par) {
        this.func_146276_q_();
        if (BaseMod.debugMode) {
            GuiEditFlowerPot.func_73734_a((int)this.addX, (int)this.addY, (int)(this.field_146294_l - this.addX), (int)(this.field_146295_m - this.addY), (int)-2005401788);
        }
        super.func_73863_a(x, y, par);
        this.func_73732_a(this.field_146289_q, "In \"item\", try numbers 6, 30, 31, 32, 37, 38, 39, 40 and 81.", this.field_146294_l / 2, this.addY + 70, -1);
        this.rotation += 1.0f;
        this.rotation %= 360.0f;
        try {
            int id = 0;
            if (Block.func_149729_e((int)this.item).func_149645_b() == 1 || Block.func_149729_e((int)this.item).func_149645_b() == 13) {
                id = this.item;
            }
            this.flowerPot.func_145964_a(Item.func_150899_d((int)id), this.data);
            this.renderBlock(Blocks.field_150457_bL, this.field_146294_l / 2 - 37, this.field_146295_m / 2 + 50, 80.0f, this.rotation);
            this.flowerPot.func_145964_a(Item.func_150899_d((int)this.item), this.data);
        }
        catch (Exception e) {
            try {
                this.tessellator.func_78381_a();
            }
            catch (IllegalStateException f) {
                // empty catch block
            }
        }
    }

    public void renderBlock(Block block, int x, int y, float scale, float rotation) {
        if (block != null) {
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)11606);
            this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            GL11.glTranslatef((float)x, (float)y, (float)25.0f);
            GL11.glScalef((float)scale, (float)(-scale), (float)scale);
            GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
            GL11.glRotatef((float)25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(-rotation), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
            block.func_149683_g();
            this.tessellator.func_78382_b();
            this.tessellator.func_78373_b((double)(-x), (double)(-y), 0.0);
            if (block != null) {
                this.renderBlocks.func_147769_a(block, x, y, 0);
            }
            this.tessellator.func_78373_b(0.0, 0.0, 0.0);
            this.func_73731_b(this.field_146289_q, "" + this.tessellator.func_78381_a(), 300, 50, 0xFFFFFF);
            this.renderBlocks.func_147771_a();
            GL11.glDisable((int)32826);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
    }

    public void updateTable() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74778_a("id", "FlowerPot");
        tags.func_74768_a("x", this.flowerPot.field_145851_c);
        tags.func_74768_a("y", this.flowerPot.field_145848_d);
        tags.func_74768_a("z", this.flowerPot.field_145849_e);
        tags.func_74768_a("Item", this.item);
        tags.func_74768_a("Data", this.data);
        this.flowerPot = new TileEntityFlowerPot();
        this.flowerPot.func_145839_a(tags);
    }

    @Override
    public TileEntity getTileEntity() {
        return this.flowerPot;
    }

    @Override
    public void save() {
    }

    @Override
    public int getBlockID() {
        return 140;
    }

    private class BlockAccess
    implements IBlockAccess {
        private BlockAccess() {
        }

        public Block func_147439_a(int var1, int var2, int var3) {
            return Blocks.field_150457_bL;
        }

        public TileEntity func_147438_o(int var1, int var2, int var3) {
            return GuiEditFlowerPot.this.flowerPot;
        }

        public int func_72802_i(int var1, int var2, int var3, int var4) {
            return 15;
        }

        public int func_72805_g(int var1, int var2, int var3) {
            return 0;
        }

        public boolean func_147437_c(int var1, int var2, int var3) {
            return false;
        }

        public BiomeGenBase func_72807_a(int var1, int var2) {
            return null;
        }

        public int func_72800_K() {
            return 100;
        }

        public boolean func_72806_N() {
            return false;
        }

        public int func_72879_k(int var1, int var2, int var3, int var4) {
            return 0;
        }

        public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean _default) {
            return true;
        }
    }
}

