/*
 * Decompiled with CFR 0.152.
 */
package person.mister.auw;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.BaseAttributeMap;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.attributes.ServersideAttributeMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import person.mister.auw.BaseMod;
import person.mister.auw.GuiNamedTextField;
import person.mister.auw.GuiScrollBox;
import person.mister.auw.GuiWithTextBoxes;

public class GuiEditBaseAttributes
extends GuiWithTextBoxes {
    public GuiScreen parent;
    public NBTTagCompound tags;
    public String tagName;
    private int addX;
    private int addY;
    private int formatError = 0;
    private int entityId;
    private int selected = 0;
    private GuiNamedTextField base;
    private GuiNamedTextField modName;
    private GuiNamedTextField modValue;
    private int modOperation;
    private IAttributeInstance[] attributes;
    private GuiScrollBox attributeBox;
    private ArrayList<AttributeModifier> modifiers = new ArrayList();
    private GuiScrollBox modifierBox;

    public GuiEditBaseAttributes(NBTTagCompound tags, GuiScreen parent, String tagName, int entityId) {
        this.tags = tags;
        this.parent = parent;
        this.tagName = tagName;
        this.entityId = entityId;
        EntityLivingBase entity = (EntityLivingBase)EntityList.func_75616_a((int)entityId, (World)Minecraft.func_71410_x().field_71441_e);
        BaseAttributeMap attributeMap = entity.func_110140_aT();
        if (tags.func_74764_b(tagName)) {
            NBTTagList list = tags.func_150295_c(tagName, 10);
            SharedMonsterAttributes.func_151475_a((BaseAttributeMap)attributeMap, (NBTTagList)list);
        }
        this.attributes = new IAttributeInstance[attributeMap.func_111146_a().size()];
        Iterator iter = attributeMap.func_111146_a().iterator();
        int i = 0;
        while (iter.hasNext()) {
            this.attributes[i] = (ModifiableAttributeInstance)iter.next();
            ++i;
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.textFields.clear();
        this.addX = this.field_146294_l / 2 - 160;
        this.addY = this.field_146295_m / 2 - 120;
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 50, this.field_146295_m - this.addY - 20, 100, 20, "Done"));
        this.attributeBox = new GuiScrollBox(this.addX + 5, this.addY + 5, 140, 210, this.attributes.length, 115, 35){

            @Override
            public void drawElement(int index, int xOffset, int yOffset) {
                this.func_73731_b(GuiEditBaseAttributes.this.field_146289_q, StatCollector.func_74838_a((String)("attribute.name." + GuiEditBaseAttributes.this.attributes[index].func_111123_a().func_111108_a())), this.xPosition + xOffset + 2, this.yPosition + yOffset + 3, 0xFFFFFF);
                this.func_73731_b(GuiEditBaseAttributes.this.field_146289_q, "Base: " + BaseMod.round(GuiEditBaseAttributes.this.attributes[index].func_111125_b(), 3) + ", " + GuiEditBaseAttributes.this.attributes[index].func_111122_c().size() + " Modifiers", this.xPosition + xOffset + 2, this.yPosition + yOffset + 13, 0xFFFFFF);
                this.func_73731_b(GuiEditBaseAttributes.this.field_146289_q, "Total: " + BaseMod.round(GuiEditBaseAttributes.this.attributes[index].func_111126_e(), 3), this.xPosition + xOffset + 2, this.yPosition + yOffset + 23, 0xFFFFFF);
            }

            @Override
            public void moveElement(int from, int to) {
            }
        };
        this.attributeBox.selected = 0;
        this.modifierBox = new GuiScrollBox(this.addX + 150, this.addY + 5, 100, 210, this.modifiers.size(), 75, 25){

            @Override
            public void drawElement(int index, int xOffset, int yOffset) {
                AttributeModifier temp = (AttributeModifier)GuiEditBaseAttributes.this.modifiers.get(index);
                this.func_73731_b(GuiEditBaseAttributes.this.field_146289_q, temp.func_111166_b(), this.xPosition + xOffset + 2, this.yPosition + yOffset + 2, 0xFFFFFF);
                String str = "";
                double var10 = temp.func_111164_d();
                double var12 = temp.func_111169_c() != 1 && temp.func_111169_c() != 2 ? temp.func_111164_d() : temp.func_111164_d() * 100.0;
                if (var10 > 0.0) {
                    str = EnumChatFormatting.BLUE + "+" + BaseMod.round(var12, 3) + (temp.func_111169_c() == 0 ? "" : "%");
                } else if (var10 < 0.0) {
                    str = EnumChatFormatting.RED + "-" + BaseMod.round(var12 *= -1.0, 3) + (temp.func_111169_c() == 0 ? "" : "%");
                }
                this.func_73731_b(GuiEditBaseAttributes.this.field_146289_q, str, this.xPosition + 12, this.yPosition + yOffset + 12, 0xFFFFFF);
            }

            @Override
            public void moveElement(int from, int to) {
                AttributeModifier temp = (AttributeModifier)GuiEditBaseAttributes.this.modifiers.get(from);
                GuiEditBaseAttributes.this.modifiers.remove(from);
                GuiEditBaseAttributes.this.modifiers.add(to, temp);
            }
        };
        this.modifierBox.selected = 0;
        this.field_146292_n.add(new GuiButton(1, this.addX + 253, this.addY + 50, 23, 20, "Add"));
        this.field_146292_n.add(new GuiButton(2, this.addX + 278, this.addY + 50, 40, 20, "Remove"));
        this.field_146292_n.add(new GuiButton(3, this.addX + 253, this.addY + 72, 66, 20, "Edit"));
        if (this.modifiers.isEmpty()) {
            this.getButtonFromId((int)2).field_146124_l = false;
            this.getButtonFromId((int)3).field_146124_l = false;
        }
        this.modName = new GuiNamedTextField(this.field_146289_q, this.addX + 253, this.addY + 106, 66, 10, "Name");
        this.modValue = new GuiNamedTextField(this.field_146289_q, this.addX + 253, this.addY + 130, 66, 10, "Amount");
        this.modName.func_146180_a("My Modifier");
        this.modValue.func_146180_a("0");
        this.textFields.add(this.modName);
        this.textFields.add(this.modValue);
        this.modOperation = 0;
        this.field_146292_n.add(new GuiButton(4, this.addX + 253, this.addY + 142, 66, 20, "Operation: 0"));
        this.base = new GuiNamedTextField(this.field_146289_q, this.addX + 253, this.addY + 15, 66, 10, "Base:");
        this.base.func_146180_a(BaseMod.round(this.attributes[this.attributeBox.selected].func_111125_b(), 3));
        this.textFields.add(this.base);
        this.selected = -1;
        this.update();
    }

    private void update() {
        if (this.selected != this.attributeBox.selected) {
            this.selected = this.attributeBox.selected;
            this.modifiers = new ArrayList();
            this.modifiers.addAll(this.attributes[this.selected].func_111122_c());
            this.modifierBox.numElements = this.modifiers.size();
            if (this.modifiers.isEmpty()) {
                this.getButtonFromId((int)2).field_146124_l = false;
                this.getButtonFromId((int)3).field_146124_l = false;
            } else {
                this.getButtonFromId((int)2).field_146124_l = true;
                this.getButtonFromId((int)3).field_146124_l = true;
            }
            if (this.getButtonFromId((int)3).field_146126_j.equals("Done")) {
                this.getButtonFromId((int)3).field_146126_j = "Edit";
            }
            this.base.func_146180_a(BaseMod.round(this.attributes[this.attributeBox.selected].func_111125_b(), 3));
        } else {
            for (Object modifier : this.attributes[this.selected].func_111122_c()) {
                this.attributes[this.selected].func_111124_b((AttributeModifier)modifier);
            }
            for (AttributeModifier mod : this.modifiers) {
                this.attributes[this.selected].func_111121_a(mod);
            }
            try {
                this.attributes[this.selected].func_111128_a(Double.parseDouble(this.base.func_146179_b()));
                this.formatError = 0;
            }
            catch (Exception e) {
                if (this.formatError != 1) {
                    e.printStackTrace();
                }
                this.formatError = 1;
            }
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146127_k == 0) {
            this.save();
            this.field_146297_k.func_147108_a(this.parent);
        } else if (button.field_146127_k == 1) {
            try {
                double amount = this.modOperation == 1 || this.modOperation == 2 ? Double.parseDouble(this.modValue.func_146179_b()) / 100.0 : Double.parseDouble(this.modValue.func_146179_b());
                this.modifiers.add(new AttributeModifier(this.modName.func_146179_b(), amount, this.modOperation));
                this.modifierBox.add();
                this.getButtonFromId((int)2).field_146124_l = true;
                this.getButtonFromId((int)3).field_146124_l = true;
                this.formatError = 0;
            }
            catch (Exception e) {
                if (this.formatError != 1) {
                    e.printStackTrace();
                }
                this.formatError = 1;
            }
        } else if (button.field_146127_k == 2) {
            this.modifiers.remove(this.modifierBox.selected);
            this.modifierBox.remove();
            if (this.modifiers.isEmpty()) {
                this.getButtonFromId((int)2).field_146124_l = false;
                this.getButtonFromId((int)3).field_146124_l = false;
            }
        } else if (button.field_146127_k == 3) {
            if (button.field_146126_j.equals("Edit")) {
                String value = this.modifiers.get(this.modifierBox.selected).func_111169_c() == 1 || this.modifiers.get(this.modifierBox.selected).func_111169_c() == 2 ? "" + this.modifiers.get(this.modifierBox.selected).func_111164_d() * 100.0 : "" + this.modifiers.get(this.modifierBox.selected).func_111164_d();
                this.modName.func_146180_a(this.modifiers.get(this.modifierBox.selected).func_111166_b());
                this.modValue.func_146180_a(value);
                this.modOperation = this.modifiers.get(this.modifierBox.selected).func_111169_c();
                this.getButtonFromId((int)4).field_146126_j = "Operation: " + this.modOperation;
                button.field_146126_j = "Done";
            } else {
                try {
                    double amount = this.modOperation == 1 || this.modOperation == 2 ? Double.parseDouble(this.modValue.func_146179_b()) / 100.0 : Double.parseDouble(this.modValue.func_146179_b());
                    this.modifiers.remove(this.modifierBox.selected);
                    this.modifiers.add(this.modifierBox.selected, new AttributeModifier(this.modName.func_146179_b(), amount, this.modOperation));
                    this.formatError = 0;
                }
                catch (Exception e) {
                    if (this.formatError != 1) {
                        e.printStackTrace();
                    }
                    this.formatError = 1;
                }
                button.field_146126_j = "Edit";
            }
        } else if (button.field_146127_k == 4) {
            ++this.modOperation;
            if (this.modOperation > 2) {
                this.modOperation = 0;
            }
            button.field_146126_j = "Operation: " + this.modOperation;
        }
    }

    @Override
    public void func_73863_a(int x, int y, float par) {
        this.func_146276_q_();
        this.attributeBox.draw(x, y);
        this.attributeBox.update(x, y);
        this.modifierBox.draw(x, y);
        this.modifierBox.update(x, y);
        if (this.formatError > 0) {
            this.func_73732_a(this.field_146289_q, "One of the numbers formatted wrong", this.field_146294_l / 2, this.field_146295_m - 25, 0xFF0000);
        }
        this.func_73731_b(this.field_146289_q, "Modifiers:", this.addX + 263, this.addY + 40, 0xFFFFFF);
        super.func_73863_a(x, y, par);
    }

    @Override
    public void func_73864_a(int x, int y, int partial) {
        super.func_73864_a(x, y, partial);
        this.attributeBox.mouseClick(x, y);
        this.modifierBox.mouseClick(x, y);
        this.update();
    }

    @Override
    public void func_73869_a(char key, int keyCode) {
        super.func_73869_a(key, keyCode);
        this.update();
    }

    private void save() {
        ServersideAttributeMap map = new ServersideAttributeMap();
        for (int i = 0; i < this.attributes.length; ++i) {
            map.func_111150_b(this.attributes[i].func_111123_a());
            ModifiableAttributeInstance attrib = map.func_111152_a(this.attributes[i].func_111123_a().func_111108_a());
            attrib.func_111128_a(this.attributes[i].func_111125_b());
            Iterator iter = this.attributes[i].func_111122_c().iterator();
            while (iter.hasNext()) {
                attrib.func_111121_a((AttributeModifier)iter.next());
            }
        }
        NBTTagList attribs = new NBTTagList();
        attribs = SharedMonsterAttributes.func_111257_a((BaseAttributeMap)map);
        this.tags.func_74782_a(this.tagName, (NBTBase)attribs);
    }

    private String stringRound(double number) {
        String str = "" + number;
        if (str.indexOf(46) != -1 && str.length() > str.indexOf(46) + 4) {
            return str.substring(0, str.indexOf(46) + 4);
        }
        return str;
    }
}

