/*
 * Decompiled with CFR 0.152.
 */
package person.mister.auw.tileEntity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.World;
import person.mister.auw.BaseMod;
import person.mister.auw.GuiNamedTextField;
import person.mister.auw.GuiPickEntity;
import person.mister.auw.GuiScrollBox;
import person.mister.auw.tileEntity.GuiEditTileEntity;

public class GuiEditSpawner
extends GuiEditTileEntity {
    private int addX;
    private int addY;
    private int formatError = 0;
    private GuiScreen parent;
    protected MobSpawnerBaseLogic spawner;
    private GuiScrollBox entityBox;
    private List<MobSpawnerBaseLogic.WeightedRandomMinecart> entities;
    private GuiNamedTextField weight;
    private GuiButton posDataButton;
    private boolean posData;
    private GuiNamedTextField delay;
    private GuiNamedTextField minSpawnDelay;
    private GuiNamedTextField maxSpawnDelay;
    private GuiNamedTextField spawnCount;
    private GuiNamedTextField maxNearbyEntities;
    private GuiNamedTextField playerRange;
    private GuiNamedTextField spawnRange;
    public boolean packetRecieved = true;

    public GuiEditSpawner(GuiScreen parent, TileEntity spawner) {
        this(parent, ((TileEntityMobSpawner)spawner).func_145881_a());
    }

    public GuiEditSpawner(GuiScreen parent, MobSpawnerBaseLogic spawner) {
        this.parent = parent;
        this.spawner = spawner;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.textFields.clear();
        this.addX = this.field_146294_l / 2 - 160;
        this.addY = this.field_146295_m / 2 - 120;
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 52, this.field_146295_m - this.addY - 22, 50, 20, "Save"));
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 2, this.field_146295_m - this.addY - 22, 50, 20, "Cancel"));
        if (this.spawner != null && this.entities == null) {
            try {
                this.packetRecieved = false;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.entities == null) {
            this.entities = new ArrayList<MobSpawnerBaseLogic.WeightedRandomMinecart>();
        }
        if (this.entities.size() == 0 && this.spawner == null) {
            Entity pig = EntityList.func_75620_a((String)"Pig", (World)this.field_146297_k.field_71441_e);
            pig.func_70107_b((double)this.spawner.func_98275_b() + 0.5, (double)this.spawner.func_98274_c(), (double)this.spawner.func_98266_d() + 0.5);
            NBTTagCompound temp = new NBTTagCompound();
            temp.func_74782_a("Properties", (NBTBase)new NBTTagCompound());
            pig.func_70109_d(temp.func_74775_l("Properties"));
            temp.func_74778_a("Type", pig.func_70005_c_());
            temp.func_74768_a("Weight", 20);
            MobSpawnerBaseLogic mobSpawnerBaseLogic = this.spawner;
            mobSpawnerBaseLogic.getClass();
            this.entities.add(new MobSpawnerBaseLogic.WeightedRandomMinecart(mobSpawnerBaseLogic, temp));
        }
        this.entityBox = new GuiScrollBox(this.addX + 5, this.field_146295_m - this.addY - 155, 100, 150, this.entities.size(), 75, 30){

            @Override
            public void drawElement(int index, int xOffset, int yOffset) {
                this.func_73731_b(GuiEditSpawner.this.field_146289_q, ((MobSpawnerBaseLogic.WeightedRandomMinecart)((GuiEditSpawner)GuiEditSpawner.this).entities.get((int)index)).field_98223_c, this.xPosition + xOffset + 5, this.yPosition + yOffset + 3, -1);
                this.func_73731_b(GuiEditSpawner.this.field_146289_q, "Weight: " + ((MobSpawnerBaseLogic.WeightedRandomMinecart)((GuiEditSpawner)GuiEditSpawner.this).entities.get((int)index)).field_76292_a, this.xPosition + xOffset + 5, this.yPosition + yOffset + 15, -1);
            }

            @Override
            public void moveElement(int from, int to) {
                MobSpawnerBaseLogic.WeightedRandomMinecart temp = (MobSpawnerBaseLogic.WeightedRandomMinecart)GuiEditSpawner.this.entities.get(from);
                GuiEditSpawner.this.entities.remove(from);
                GuiEditSpawner.this.entities.add(to, temp);
                GuiEditSpawner.this.updateStuff();
            }
        };
        this.entityBox.selected = 0;
        this.delay = new GuiNamedTextField(this.field_146289_q, this.addX + 230, this.addY + 70, 75, 10, "Current Spawn Delay");
        this.minSpawnDelay = new GuiNamedTextField(this.field_146289_q, this.addX + 230, this.addY + 95, 75, 10, "Min Spawn Delay");
        this.maxSpawnDelay = new GuiNamedTextField(this.field_146289_q, this.addX + 230, this.addY + 120, 75, 10, "Max Spawn Delay");
        this.spawnCount = new GuiNamedTextField(this.field_146289_q, this.addX + 230, this.addY + 145, 75, 10, "Spawn Count");
        this.maxNearbyEntities = new GuiNamedTextField(this.field_146289_q, this.addX + 230, this.addY + 170, 75, 10, "Max Nearby Entities");
        this.playerRange = new GuiNamedTextField(this.field_146289_q, this.addX + 230, this.addY + 195, 75, 10, "Max Player Distance");
        this.spawnRange = new GuiNamedTextField(this.field_146289_q, this.addX + 230, this.addY + 220, 75, 10, "Spawn Range");
        if (this.spawner == null) {
            this.delay.func_146180_a("500");
            this.minSpawnDelay.func_146180_a("200");
            this.maxSpawnDelay.func_146180_a("800");
            this.spawnCount.func_146180_a("4");
            this.maxNearbyEntities.func_146180_a("6");
            this.playerRange.func_146180_a("16");
            this.spawnRange.func_146180_a("4");
        } else {
            NBTTagCompound tags = new NBTTagCompound();
            this.spawner.func_98280_b(tags);
            this.delay.func_146180_a("" + tags.func_74765_d("Delay"));
            this.minSpawnDelay.func_146180_a("" + tags.func_74765_d("MinSpawnDelay"));
            this.maxSpawnDelay.func_146180_a("" + tags.func_74765_d("MaxSpawnDelay"));
            this.spawnCount.func_146180_a("" + tags.func_74765_d("SpawnCount"));
            this.maxNearbyEntities.func_146180_a("" + tags.func_74765_d("MaxNearbyEntities"));
            this.playerRange.func_146180_a("" + tags.func_74765_d("RequiredPlayerRange"));
            this.spawnRange.func_146180_a("" + tags.func_74765_d("SpawnRange"));
        }
        this.textFields.add(this.delay);
        this.textFields.add(this.minSpawnDelay);
        this.textFields.add(this.maxSpawnDelay);
        this.textFields.add(this.spawnCount);
        this.textFields.add(this.maxNearbyEntities);
        this.textFields.add(this.playerRange);
        this.textFields.add(this.spawnRange);
        this.field_146292_n.add(new GuiButton(2, this.addX + 2, this.field_146295_m - this.addY - 180, 55, 20, "Add Entity"));
        this.field_146292_n.add(new GuiButton(3, this.addX + 59, this.field_146295_m - this.addY - 180, 55, 20, "Remove"));
        this.field_146292_n.add(new GuiButton(4, this.addX + 2, this.field_146295_m - this.addY - 205, 30, 20, "Edit"));
        this.weight = new GuiNamedTextField(this.field_146289_q, this.addX + 34, this.field_146295_m - this.addY - 195, 70, 10, "Weight");
        this.textFields.add(this.weight);
        for (int i = 0; i < this.entities.size(); ++i) {
            if (this.entities.get((int)i).field_98222_b.func_74764_b("removePos")) continue;
            if (!this.entities.get((int)i).field_98222_b.func_74764_b("Pos")) {
                this.entities.get((int)i).field_98222_b.func_74757_a("removePos", true);
                NBTTagList pos = new NBTTagList();
                pos.func_74742_a((NBTBase)new NBTTagDouble((double)this.spawner.func_98275_b()));
                pos.func_74742_a((NBTBase)new NBTTagDouble((double)this.spawner.func_98274_c()));
                pos.func_74742_a((NBTBase)new NBTTagDouble((double)this.spawner.func_98266_d()));
                this.entities.get((int)i).field_98222_b.func_74782_a("Pos", (NBTBase)pos);
                continue;
            }
            this.entities.get((int)i).field_98222_b.func_74757_a("removePos", false);
        }
        this.posDataButton = new GuiButton(5, this.addX + 2, this.field_146295_m - this.addY - 230, 110, 20, "Include Position: no");
        this.field_146292_n.add(this.posDataButton);
        try {
            this.weight.func_146180_a("" + this.entities.get(this.entityBox.selected).func_98220_a().func_74762_e("Weight"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateStuff();
    }

    public void updateTileEntity(NBTTagCompound tags) {
        this.entities = new ArrayList<MobSpawnerBaseLogic.WeightedRandomMinecart>();
        if (tags.func_74764_b("SpawnPotentials") && tags.func_150295_c("SpawnPotentials", 10).func_74745_c() != 0) {
            NBTTagList potentials = tags.func_150295_c("SpawnPotentials", 10);
            for (int i = 0; i < potentials.func_74745_c(); ++i) {
                MobSpawnerBaseLogic mobSpawnerBaseLogic = this.spawner;
                mobSpawnerBaseLogic.getClass();
                this.entities.add(new MobSpawnerBaseLogic.WeightedRandomMinecart(mobSpawnerBaseLogic, tags.func_150295_c("SpawnPotentials", 10).func_150305_b(i)));
            }
        } else if (tags.func_74764_b("SpawnData")) {
            MobSpawnerBaseLogic mobSpawnerBaseLogic = this.spawner;
            mobSpawnerBaseLogic.getClass();
            this.entities.add(new MobSpawnerBaseLogic.WeightedRandomMinecart(mobSpawnerBaseLogic, tags.func_74775_l("SpawnData")));
        }
        this.entityBox.numElements = this.entities.size();
        for (int i = 0; i < this.entities.size(); ++i) {
            if (this.entities.get((int)i).field_98222_b.func_74764_b("removePos")) continue;
            if (!this.entities.get((int)i).field_98222_b.func_74764_b("Pos")) {
                this.entities.get((int)i).field_98222_b.func_74757_a("removePos", true);
                NBTTagList pos = new NBTTagList();
                pos.func_74742_a((NBTBase)new NBTTagDouble((double)this.spawner.func_98275_b()));
                pos.func_74742_a((NBTBase)new NBTTagDouble((double)this.spawner.func_98274_c()));
                pos.func_74742_a((NBTBase)new NBTTagDouble((double)this.spawner.func_98266_d()));
                this.entities.get((int)i).field_98222_b.func_74782_a("Pos", (NBTBase)pos);
                continue;
            }
            this.entities.get((int)i).field_98222_b.func_74757_a("removePos", false);
        }
        try {
            this.weight.func_146180_a("" + this.entities.get(this.entityBox.selected).func_98220_a().func_74762_e("Weight"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delay.func_146180_a("" + tags.func_74765_d("Delay"));
        this.minSpawnDelay.func_146180_a("" + tags.func_74765_d("MinSpawnDelay"));
        this.maxSpawnDelay.func_146180_a("" + tags.func_74765_d("MaxSpawnDelay"));
        this.spawnCount.func_146180_a("" + tags.func_74765_d("SpawnCount"));
        this.maxNearbyEntities.func_146180_a("" + tags.func_74765_d("MaxNearbyEntities"));
        this.playerRange.func_146180_a("" + tags.func_74765_d("RequiredPlayerRange"));
        this.spawnRange.func_146180_a("" + tags.func_74765_d("SpawnRange"));
        this.packetRecieved = true;
        this.updateStuff();
    }

    @Override
    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146127_k == 0) {
            if (this.formatError == 0) {
                this.save();
                this.exitGui();
            }
        } else if (button.field_146127_k == 1) {
            this.exitGui();
        } else if (button.field_146127_k == 2) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiPickEntity(this, null){

                @Override
                protected void save() {
                    NBTTagCompound temp = new NBTTagCompound();
                    temp.func_74782_a("Properties", (NBTBase)new NBTTagCompound());
                    this.entity.func_70109_d(temp.func_74775_l("Properties"));
                    temp.func_74778_a("Type", EntityList.func_75621_b((Entity)this.entity));
                    temp.func_74768_a("Weight", 20);
                    List list = GuiEditSpawner.this.entities;
                    MobSpawnerBaseLogic mobSpawnerBaseLogic = GuiEditSpawner.this.spawner;
                    mobSpawnerBaseLogic.getClass();
                    list.add(new MobSpawnerBaseLogic.WeightedRandomMinecart(mobSpawnerBaseLogic, temp));
                    GuiEditSpawner.this.entityBox.add();
                    ((MobSpawnerBaseLogic.WeightedRandomMinecart)((GuiEditSpawner)GuiEditSpawner.this).entities.get((int)(((GuiEditSpawner)GuiEditSpawner.this).entities.size() - 1))).field_98222_b.func_74757_a("removePos", true);
                }
            });
        } else if (button.field_146127_k == 3) {
            this.entities.remove(this.entityBox.selected);
            this.entityBox.remove();
        } else if (button.field_146127_k == 4) {
            NBTTagCompound temp = this.entities.get((int)this.entityBox.selected).field_98222_b;
            temp.func_74778_a("id", this.entities.get((int)this.entityBox.selected).field_98223_c);
            if (!temp.func_74764_b("Pos") || temp.func_150295_c("Pos", 6).func_74745_c() == 0) {
                NBTTagList pos = new NBTTagList();
                pos.func_74742_a((NBTBase)new NBTTagDouble(0.0 + (double)this.spawner.func_98275_b() + 0.5));
                pos.func_74742_a((NBTBase)new NBTTagDouble((double)this.spawner.func_98274_c()));
                pos.func_74742_a((NBTBase)new NBTTagDouble(0.0 + (double)this.spawner.func_98266_d() + 0.5));
                temp.func_74782_a("Pos", (NBTBase)pos);
            }
            Entity entity = GuiPickEntity.createEntityFromNBT(temp);
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiPickEntity(this, entity){

                @Override
                protected void save() {
                    NBTTagCompound temp = new NBTTagCompound();
                    temp.func_74782_a("Properties", (NBTBase)new NBTTagCompound());
                    this.entity.func_70109_d(temp.func_74775_l("Properties"));
                    temp.func_74778_a("Type", EntityList.func_75621_b((Entity)this.entity));
                    temp.func_74768_a("Weight", ((MobSpawnerBaseLogic.WeightedRandomMinecart)((GuiEditSpawner)GuiEditSpawner.this).entities.get((int)((GuiEditSpawner)GuiEditSpawner.this).entityBox.selected)).field_76292_a);
                    boolean tempPosData = ((MobSpawnerBaseLogic.WeightedRandomMinecart)((GuiEditSpawner)GuiEditSpawner.this).entities.get((int)((GuiEditSpawner)GuiEditSpawner.this).entityBox.selected)).field_98222_b.func_74767_n("removePos");
                    GuiEditSpawner.this.entities.remove(((GuiEditSpawner)GuiEditSpawner.this).entityBox.selected);
                    List list = GuiEditSpawner.this.entities;
                    int n = ((GuiEditSpawner)GuiEditSpawner.this).entityBox.selected;
                    MobSpawnerBaseLogic mobSpawnerBaseLogic = GuiEditSpawner.this.spawner;
                    mobSpawnerBaseLogic.getClass();
                    list.add(n, new MobSpawnerBaseLogic.WeightedRandomMinecart(mobSpawnerBaseLogic, temp));
                    ((MobSpawnerBaseLogic.WeightedRandomMinecart)((GuiEditSpawner)GuiEditSpawner.this).entities.get((int)((GuiEditSpawner)GuiEditSpawner.this).entityBox.selected)).field_98222_b.func_74757_a("removePos", tempPosData);
                }
            });
        } else if (button.field_146127_k == 5 && this.entities.size() > 0) {
            this.entities.get((int)this.entityBox.selected).field_98222_b.func_74757_a("removePos", this.posData);
            this.updatePosData();
        }
    }

    private void updatePosData() {
        this.posData = !this.entities.get((int)this.entityBox.selected).field_98222_b.func_74767_n("removePos");
        this.posDataButton.field_146126_j = "Include Position:" + (this.posData ? " yes" : " no");
    }

    private void updateWeight() {
        try {
            NBTTagCompound temp = this.entities.get(this.entityBox.selected).func_98220_a();
            temp.func_74768_a("Weight", Integer.parseInt(this.weight.func_146179_b()));
            int n = this.entityBox.selected;
            MobSpawnerBaseLogic mobSpawnerBaseLogic = this.spawner;
            mobSpawnerBaseLogic.getClass();
            this.entities.set(n, new MobSpawnerBaseLogic.WeightedRandomMinecart(mobSpawnerBaseLogic, temp));
            if (this.formatError == 2) {
                this.formatError = 0;
            }
        }
        catch (Exception e) {
            if (this.formatError == 0) {
                e.printStackTrace();
            }
            this.formatError = 2;
        }
    }

    private void updateSpawner() throws Exception {
        int i;
        ArrayList<MobSpawnerBaseLogic.WeightedRandomMinecart> tempEntities = new ArrayList<MobSpawnerBaseLogic.WeightedRandomMinecart>();
        for (i = 0; i < this.entities.size(); ++i) {
            MobSpawnerBaseLogic mobSpawnerBaseLogic = this.spawner;
            mobSpawnerBaseLogic.getClass();
            tempEntities.add(new MobSpawnerBaseLogic.WeightedRandomMinecart(mobSpawnerBaseLogic, (NBTTagCompound)this.entities.get(i).func_98220_a().func_74737_b()));
        }
        for (i = 0; i < tempEntities.size(); ++i) {
            if (((MobSpawnerBaseLogic.WeightedRandomMinecart)tempEntities.get((int)i)).field_98222_b.func_74767_n("removePos")) {
                ((MobSpawnerBaseLogic.WeightedRandomMinecart)tempEntities.get((int)i)).field_98222_b.func_82580_o("Pos");
            }
            ((MobSpawnerBaseLogic.WeightedRandomMinecart)tempEntities.get((int)i)).field_98222_b.func_82580_o("removePos");
        }
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74778_a("EntityId", ((MobSpawnerBaseLogic.WeightedRandomMinecart)tempEntities.get((int)0)).field_98223_c);
        tags.func_74777_a("Delay", (short)100);
        tags.func_74782_a("SpawnData", (NBTBase)((MobSpawnerBaseLogic.WeightedRandomMinecart)tempEntities.get((int)0)).field_98222_b);
        NBTTagList list = new NBTTagList();
        for (MobSpawnerBaseLogic.WeightedRandomMinecart item : tempEntities) {
            list.func_74742_a((NBTBase)item.func_98220_a());
        }
        tags.func_74782_a("SpawnPotentials", (NBTBase)list);
        if (Short.parseShort(this.minSpawnDelay.func_146179_b()) >= Short.parseShort(this.maxSpawnDelay.func_146179_b())) {
            throw new Exception("Min must be less than max.");
        }
        tags.func_74777_a("Delay", Short.parseShort(this.delay.func_146179_b()));
        tags.func_74777_a("MinSpawnDelay", Short.parseShort(this.minSpawnDelay.func_146179_b()));
        tags.func_74777_a("MaxSpawnDelay", Short.parseShort(this.maxSpawnDelay.func_146179_b()));
        tags.func_74777_a("SpawnCount", Short.parseShort(this.spawnCount.func_146179_b()));
        tags.func_74777_a("MaxNearbyEntities", Short.parseShort(this.maxNearbyEntities.func_146179_b()));
        tags.func_74777_a("RequiredPlayerRange", Short.parseShort(this.playerRange.func_146179_b()));
        tags.func_74777_a("SpawnRange", Short.parseShort(this.spawnRange.func_146179_b()));
        this.spawner.func_98270_a(tags);
    }

    private void updateStuff() {
        try {
            if (this.entities.get(this.entityBox.selected).func_98220_a().func_74762_e("Weight") != Integer.parseInt(this.weight.func_146179_b())) {
                this.weight.func_146180_a("" + this.entities.get(this.entityBox.selected).func_98220_a().func_74762_e("Weight"));
            }
            this.updateSpawner();
            this.updatePosData();
            if (this.formatError == 1) {
                this.formatError = 0;
            }
        }
        catch (Exception e) {
            if (this.formatError == 0) {
                e.printStackTrace();
            }
            this.formatError = 1;
        }
        if (this.entities.isEmpty()) {
            this.getButtonFromId((int)3).field_146124_l = false;
            this.getButtonFromId((int)4).field_146124_l = false;
        } else {
            this.getButtonFromId((int)3).field_146124_l = true;
            this.getButtonFromId((int)4).field_146124_l = true;
        }
    }

    @Override
    public void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        this.entityBox.mouseClick(x, y);
        this.updateStuff();
    }

    @Override
    public void func_73869_a(char key, int keyCode) {
        super.func_73869_a(key, keyCode);
        this.updateWeight();
        this.updateStuff();
    }

    @Override
    public void func_73863_a(int x, int y, float par) {
        this.func_146276_q_();
        if (BaseMod.debugMode) {
            GuiEditSpawner.func_73734_a((int)this.addX, (int)this.addY, (int)(this.field_146294_l - this.addX), (int)(this.field_146295_m - this.addY), (int)-2005401788);
        }
        super.func_73863_a(x, y, par);
        this.entityBox.draw(x, y);
        this.entityBox.update(x, y);
        if (this.formatError >= 1) {
            this.func_73731_b(this.field_146289_q, "One of the numbers is formatted wrong.", this.addX + 75, this.addY + 5, 0xFF0000);
        }
    }

    protected void exitGui() {
        Minecraft.func_71410_x().func_147108_a(this.parent);
    }

    public boolean func_73868_f() {
        return this.packetRecieved;
    }

    @Override
    public void save() {
    }

    @Override
    public TileEntity getTileEntity() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("x", this.spawner.func_98275_b());
        tags.func_74768_a("y", this.spawner.func_98274_c());
        tags.func_74768_a("z", this.spawner.func_98266_d());
        tags.func_74778_a("id", "MobSpawner");
        this.spawner.func_98280_b(tags);
        return TileEntity.func_145827_c((NBTTagCompound)tags);
    }

    @Override
    public int getBlockID() {
        return 52;
    }
}

