
local Assets =
{
	Asset("ANIM", "anim/hat_warfarinmask.zip"),
	Asset("ANIM", "anim/warfarin_mask.zip"),
	Asset("ANIM", "anim/hat_warfarinmask_swap.zip"),
}

local function breath(inst, target)
    local mindistance = 1
    local caster = inst.components.inventoryitem.owner
    local tar = target or caster
    SpawnPrefab("warfarin_gas").Transform:SetPosition(tar:GetPosition():Get())
	caster.components.sanity:DoDelta(-10)
    end

local function perish(inst)
        local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
        if owner then
	end
	inst:Remove()
end

    local function onequip(inst, owner)

        owner.AnimState:OverrideSymbol("swap_hat", "hat_warfarinmask", "swap_hat")
        owner.AnimState:Show("HAT")
        owner.AnimState:Hide("HAIR_NOHAT")
        owner.AnimState:Hide("HAIR")
        owner.AnimState:Hide("HAIR_PIGTAILS")
			owner.AnimState:Hide("HEAD_HAT")
			owner.AnimState:Hide("HEAD")
    end


    local function onunequip(inst, owner)

        owner.AnimState:Hide("HAT")
        owner.AnimState:Show("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")
        owner.AnimState:Show("HAIR_PIGTAILS")
		owner.AnimState:Show("HEAD_HAT")
	        owner.AnimState:Show("HEAD")

		if inst.components.fueled then
			inst.components.fueled:StopConsuming()        
		end
    end

local function fn(Sim)
        local inst = CreateEntity()

        inst.entity:AddTransform()
        inst.entity:AddAnimState()
        MakeInventoryPhysics(inst)

        inst.AnimState:SetBank("warfarinmask")
        inst.AnimState:SetBuild("warfarin_mask")
        inst.AnimState:PlayAnimation("idle")
    
    inst:AddTag("sanity")
    inst:AddTag("warfarinmask")

        inst:AddComponent("inspectable")

    inst:AddComponent("spellcaster")
    inst.components.spellcaster.canusefrominventory = true
    inst.components.spellcaster:SetSpellFn(breath)
    inst.components.spellcaster.castingstate = "castspell_breathe"
    inst.components.spellcaster.actiontype = "SCIENCE"

        inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/hat_warfarinmask.xml"

        inst:AddComponent("armor")
        inst:AddTag("metal")
        inst.components.armor:InitCondition(TUNING.ARMOR_RUINSHAT, TUNING.ARMOR_RUINSHAT_ABSORPTION)

        inst:AddComponent("equippable")
        inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
if IsDLCEnabled(REIGN_OF_GIANTS) then
    inst.components.equippable.dapperness = TUNING.CRAZINESS_SMALL*0.4
			else
    inst:AddComponent("dapperness")
    inst.components.dapperness.dapperness = TUNING.CRAZINESS_SMALL*0.4
		end

        inst.components.equippable:SetOnEquip( onequip )

        inst.components.equippable:SetOnUnequip( onunequip )

if IsDLCEnabled(CAPY_DLC) then
		MakeInventoryFloatable(inst, "idle_water", "idle")
		inst.components.equippable.poisongasblocker = true
		end

        return inst
end


return Prefab( "common/inventory/hat_warfarinmask", fn, Assets)


