local assets =
{
	Asset("ANIM", "anim/warfarin_heart.zip"),
	Asset("ANIM", "anim/warfarin_heart2.zip"),
	Asset("ANIM", "anim/warfarin_heart3.zip"),
	Asset("ANIM", "anim/warfarintree.zip"),
}

local function kill(inst)
    inst.AnimState:PlayAnimation("disappear")
    inst:DoTaskInTime(0.6, function() inst:Remove() end)    
end

local function nice()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    inst.Transform:SetFourFaced()
    anim:SetBank("star")
    anim:SetBuild("warfarin_heart")
    anim:PlayAnimation("appear")
    anim:PushAnimation("idle_loop", true)
    inst:AddTag("fx")
	inst:DoTaskInTime(1, function() kill(inst) end)
    return inst
end

local function scared()
	local inst = nice()
	local anim = inst.entity:AddAnimState()
    anim:SetBuild("warfarin_heart2")
    return inst
end

local function dots()
	local inst = nice()
	local anim = inst.entity:AddAnimState()
    anim:SetBuild("warfarin_heart3")
    return inst
end

local function tree()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    inst.Transform:SetFourFaced()
    anim:SetBank("berrybush")
    anim:SetBuild("warfarintree")
    anim:PlayAnimation("berriesmost")
	inst.persists = false
        inst.AnimState:SetMultColour(0, 0, 0, 0)
	inst:AddComponent("colourtweener")
	inst.components.colourtweener:StartTween({1,1,1,1}, 0.5)
   inst.AnimState:SetLightOverride(1)
    anim:SetBloomEffectHandle( "shaders/anim.ksh" )

    inst:AddTag("fx")
    return inst
end

return Prefab("common/fx/warfarinheart", nice, assets),
	Prefab("common/fx/warfarinheart2", scared, assets),
	Prefab("common/fx/warfarinheart3", dots, assets),
	Prefab("common/fx/warfarintree", tree, assets)    
