local assets=
{
	Asset("ANIM", "anim/warfarindagger.zip"),
	Asset("ANIM", "anim/warfarindaggergold.zip"),
	Asset("ANIM", "anim/warfarindaggermarble.zip"),
	Asset("ANIM", "anim/warfarindaggernight.zip"),
	Asset("ANIM", "anim/warfarindaggerliar.zip"),
	Asset("ANIM", "anim/swap_warfarindagger.zip"),
	Asset("ANIM", "anim/swap_warfarindaggergold.zip"),
	Asset("ANIM", "anim/swap_warfarindaggermarble.zip"),
	Asset("ANIM", "anim/swap_warfarindaggernight.zip"),
	Asset("ANIM", "anim/swap_warfarindaggerliar.zip"),
	Asset("ANIM", "anim/warfarin_liardagger.zip"),
}

local function onfinished(inst)
    inst:Remove()
end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_warfarindagger", "swap_spear")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal")
	owner.components.combat:SetDefaultDamage(TUNING.UNARMED_DAMAGE) 
end


local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("nightmaresword")
    anim:SetBuild("warfarindagger")
    anim:PlayAnimation("idle")
    
    inst:AddTag("sharp")
    inst:AddTag("lildagger")
    inst:AddTag("warwep")

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(27)
    
    -------
    
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(175)
    inst.components.finiteuses:SetUses(175)
    
    inst.components.finiteuses:SetOnFinished( onfinished )

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/warfarindagger.xml"    

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    
    return inst
end

local function onequipgold(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_warfarindaggergold", "swap_spear")
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")     
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function golden(Sim)
	local inst = fn(Sim)
	inst.AnimState:SetBuild("warfarindaggergold")
    inst.components.weapon:SetDamage(37)
        inst.components.inventoryitem.atlasname = "images/inventoryimages/warfarindagger_gold.xml"
    -------
    
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(250)
    inst.components.finiteuses:SetUses(250)
   inst.components.finiteuses:SetOnFinished( onfinished )
    inst.components.equippable:SetOnEquip( onequipgold )
    
	return inst
end

local function onequipmarble(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_warfarindaggermarble", "swap_cane")
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")     
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function marble(Sim)
	local inst = fn(Sim)
	inst.AnimState:SetBuild("warfarindaggermarble")
    inst.components.weapon:SetDamage(37)
        inst.components.inventoryitem.atlasname = "images/inventoryimages/warfarindagger_marble.xml"
    -------
    
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(250)
    inst.components.finiteuses:SetUses(250)
   inst.components.finiteuses:SetOnFinished( onfinished )
    inst.components.equippable:SetOnEquip( onequipmarble )
    
	return inst
end

local function onequipnight(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_warfarindaggernight", "swap_cane")
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")     
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function night(Sim)
	local inst = fn(Sim)
	inst.AnimState:SetBuild("warfarindaggernight")
    inst.components.weapon:SetDamage(57)
        inst.components.inventoryitem.atlasname = "images/inventoryimages/warfarindagger_night.xml"
    -------
    inst:AddTag("shadow")    

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(150)
    inst.components.finiteuses:SetUses(150)
   inst.components.finiteuses:SetOnFinished( onfinished )
    inst.components.equippable:SetOnEquip( onequipnight )
    
	return inst
end

local function takefuel(inst)
		SpawnPrefab("statue_transition").Transform:SetPosition(inst:GetPosition():Get())
		SpawnPrefab("statue_transition_2").Transform:SetPosition(inst:GetPosition():Get())
		inst.SoundEmitter:PlaySound("dontstarve/kingaura/hat_ready", "ready")
end


local function fuelupdate(inst)
if not inst.components.fueled:IsEmpty() then
	if inst.components.equippable.isequipped then
    local owner = inst.components.inventoryitem.owner
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 3 then 
	print("damage3")
	owner.components.combat:SetDefaultDamage(36)
        elseif sec == 2 then
	print("damage2")
	owner.components.combat:SetDefaultDamage(28)
        elseif sec == 1 then
	print("damage1")
	owner.components.combat:SetDefaultDamage(24)
        elseif sec == 0 then
	print("damage0")
	owner.components.combat:SetDefaultDamage(TUNING.UNARMED_DAMAGE)
		end
        end
		else
	inst:Remove()
	end
end

local function onequipliar(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_warfarindaggerliar", "swap_cane")
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")     
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal")
    fuelupdate(inst)
    inst:ListenForEvent("percentusedchange", fuelupdate, inst) 
end

local function onunequipliar(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal")
    inst:RemoveEventCallback("percentusedchange", fuelupdate, inst)
	owner.components.combat:SetDefaultDamage(TUNING.UNARMED_DAMAGE)
end

-- Go like a rabit Stabby-McHeartimuss! Kill 'em!

local function doport(staff, target, pos)
    local mindistance = 1
    local caster = staff.components.inventoryitem.owner
    local tar = target
		SpawnPrefab("statue_transition").Transform:SetPosition(caster:GetPosition():Get())
	caster:DoTaskInTime(0.10, function()
		    local comedown = SpawnPrefab("sanity_raise")
	    local follower = comedown.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
		end)
	caster:Hide()
		caster.components.health:SetInvincible(true)
	caster:DoTaskInTime(0.50, function() 
        staff.components.fueled:DoDelta(-50)
		caster.components.health:SetInvincible(false)
		caster.components.sanity:DoDelta(-10)
		caster:Show()
		caster.Transform:SetPosition(target:GetPosition():Get())
	caster:AddTag("shadow")
	caster.components.combat:SetTarget(target)
	caster.components.combat:ForceAttack()
		SpawnPrefab("statue_transition_2").Transform:SetPosition(caster:GetPosition():Get())
	end)
end

 --and caster.components.combat:CanTarget(target)

local function canport(staff, caster, target, pos)
    return target and target.components.health and target.components.combat and caster:HasTag("shadow")
		and not staff.components.fueled:IsEmpty()
end

local function liar(Sim)
	local inst = fn(Sim)
	local sound = inst.entity:AddSoundEmitter()
	inst.AnimState:SetBuild("warfarin_liardagger")
	inst.AnimState:SetBank("warfarinliardagger")
    inst:RemoveComponent("weapon")
 
        inst.components.inventoryitem.atlasname = "images/inventoryimages/warfarindagger_liar.xml"
    -------   
    inst:AddTag("liardagger") 

    inst:AddComponent("fueled")
    inst.components.fueled.fueltype = "PURPLEGEM"
    inst.components.fueled:InitializeFuelLevel(330)
    inst.components.fueled.maxfuel = 250
    inst.components.fueled:SetSections(3)
    inst.components.fueled.ontakefuelfn = takefuel
    inst.components.fueled.accepting = true

	if IsDLCEnabled(CAPY_DLC) then
		MakeInventoryFloatable(inst, "idle_water", "idle")
	end

    inst:RemoveComponent("finiteuses")

    inst:AddComponent("spellcaster")
    inst.components.spellcaster.canuseontargets = true
    inst.components.spellcaster.canuseonpoint = false
    inst.components.spellcaster.canusefrominventory = false
    inst.components.spellcaster:SetSpellTestFn(canport)
    inst.components.spellcaster:SetSpellFn(doport)
    inst.components.spellcaster.castingstate = "castspell_stabbyport"
    inst.components.spellcaster.actiontype = "SCIENCE"

    inst.components.equippable:SetOnEquip( onequipliar )
    inst.components.equippable:SetOnUnequip( onunequipliar )

	return inst
end

return Prefab( "common/inventory/warfarindagger", fn, assets),
	Prefab( "common/inventory/warfarindagger_marble", marble, assets),
	Prefab( "common/inventory/warfarindagger_night", night, assets),
	Prefab( "common/inventory/warfarindagger_gold", golden, assets),
	Prefab( "common/inventory/warfarindagger_liar", liar, assets) 