
local assets =
{
        Asset( "ANIM", "anim/warfarinsmokebomb.zip" ),
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("drumstick")
    inst.AnimState:SetBuild("warfarinsmokebomb")
    inst.AnimState:PlayAnimation("cooked")
    
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_MEDITEM
	
    inst:AddTag("Chem")
    inst:AddTag("warfarin")
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/warfarinsmokebomb.xml"	

	inst:AddComponent("edible") 
    inst.components.edible.healthvalue = 0
    inst.components.edible.hungervalue = 0
    inst.components.edible.sanityvalue = -5
    inst.components.edible.foodtype = "SMOKEBOMB"

    inst:AddComponent("characterspecific")
    inst.components.characterspecific:SetOwner("warfarin")

    return inst
end

return Prefab( "common/inventory/warfarinsmokebomb", fn, assets)

