/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.versionchecker.client.gui;

import com.dynious.versionchecker.api.Update;
import com.dynious.versionchecker.client.gui.GuiScroll;
import com.dynious.versionchecker.client.gui.GuiUpdates;
import com.dynious.versionchecker.handler.DownloadThread;
import com.dynious.versionchecker.handler.UpdateHandler;
import com.dynious.versionchecker.lib.Resources;
import com.dynious.versionchecker.lib.Strings;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class GuiUpdateList
extends GuiScroll {
    private GuiUpdates parent;
    private List<Update> updateList = new ArrayList<Update>();
    private int selectedIndex = -1;

    public GuiUpdateList(GuiUpdates parent, int width, int height, int top, int bottom, int left) {
        super(Minecraft.func_71410_x(), width, height, top, bottom, left, 45);
        this.parent = parent;
        this.setPadding(4, 4);
        this.makeList();
    }

    public void makeList() {
        this.updateList.clear();
        for (int index = 0; index < UpdateHandler.getListSize(); ++index) {
            Update update = UpdateHandler.getElement(index);
            if (update == null || !this.parent.getUpdateListProperties().shouldBeInList(update)) continue;
            this.updateList.add(update);
        }
    }

    @Override
    protected int getSize() {
        return this.updateList.size();
    }

    @Override
    protected void elementClicked(int index, boolean doubleClick) {
        this.selectedIndex = index;
        if (doubleClick && this.updateList.get(index) != null) {
            this.parent.openInfoScreen(this.updateList.get(index));
        }
    }

    @Override
    protected boolean isSelected(int index) {
        return index == this.selectedIndex;
    }

    @Override
    protected void drawBackground() {
        this.parent.func_146276_q_();
    }

    @Override
    protected void drawSlot(int slotIndex, int minX, int maxX, int minY, int maxY, Tessellator tesselator) {
        Update update = this.updateList.get(slotIndex);
        if (update != null && !update.oldVersion.matches(update.newVersion)) {
            String info;
            this.parent.getFontRenderer().func_78276_b(this.parent.getFontRenderer().func_78269_a(update.displayName, this.listWidth - 10), minX + 5, minY + 4, 0xFFFFFF);
            if (this.parent.getFontRenderer().func_78256_a(update.newVersion) >= this.listWidth - 125) {
                this.parent.getFontRenderer().func_78276_b(this.parent.getFontRenderer().func_78269_a(update.oldVersion + " -> ", this.listWidth - 10), minX + 5, minY + 15, 0xCCCCCC);
                this.parent.getFontRenderer().func_78276_b(this.parent.getFontRenderer().func_78269_a("  " + update.newVersion, this.listWidth - 10), minX + 5, minY + 25, 0xCCCCCC);
            } else {
                this.parent.getFontRenderer().func_78276_b(this.parent.getFontRenderer().func_78269_a(update.oldVersion + " -> " + update.newVersion, this.listWidth - 10), minX + 5, minY + 15, 0xCCCCCC);
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.GUI_ICONS);
            if (DownloadThread.isUpdating(update)) {
                Gui.func_146110_a((int)(maxX - 30), (int)(minY + 8), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)64.0f, (float)32.0f);
                info = StatCollector.func_74838_a((String)Strings.UPDATING);
            } else if (update.isDownloaded()) {
                Gui.func_146110_a((int)(maxX - 30), (int)(minY + 8), (float)16.0f, (float)0.0f, (int)16, (int)16, (float)64.0f, (float)32.0f);
                info = !update.MOD_ID.equalsIgnoreCase("VersionChecker") ? StatCollector.func_74838_a((String)Strings.IS_DOWNLOADED) : StatCollector.func_74838_a((String)Strings.UNABLE_TO_REMOVE_SELF);
            } else if (update.isErrored()) {
                Gui.func_146110_a((int)(maxX - 30), (int)(minY + 8), (float)32.0f, (float)0.0f, (int)16, (int)16, (float)64.0f, (float)32.0f);
                info = StatCollector.func_74838_a((String)Strings.ERRORED);
            } else if (update.isDirectLink) {
                Gui.func_146110_a((int)(maxX - 30), (int)(minY + 8), (float)16.0f, (float)16.0f, (int)16, (int)16, (float)64.0f, (float)32.0f);
                info = StatCollector.func_74838_a((String)Strings.DL_AVAILABLE);
            } else if (update.updateURL != null) {
                Gui.func_146110_a((int)(maxX - 30), (int)(minY + 8), (float)0.0f, (float)16.0f, (int)16, (int)16, (float)64.0f, (float)32.0f);
                info = StatCollector.func_74838_a((String)Strings.LINK_TO_DL);
            } else {
                info = StatCollector.func_74838_a((String)Strings.CANNOT_UPDATE);
            }
            if (update.updateType == Update.UpdateType.NOT_ENOUGH_MODS) {
                Gui.func_146110_a((int)(maxX - 30), (int)(minY + 8), (float)32.0f, (float)16.0f, (int)16, (int)16, (float)64.0f, (float)32.0f);
            } else if (update.updateType == Update.UpdateType.CURSE) {
                Gui.func_146110_a((int)(maxX - 30), (int)(minY + 8), (float)48.0f, (float)0.0f, (int)16, (int)16, (float)64.0f, (float)32.0f);
            }
            this.parent.getFontRenderer().func_78276_b(this.parent.getFontRenderer().func_78269_a(info, this.listWidth - 10), minX + 5, minY + 35, 0xCCCCCC);
        }
    }

    @Override
    public void overlayBackground() {
        this.client.field_71446_o.func_110577_a(Gui.field_110325_k);
        GL11.glColor4f((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
        Gui.func_146110_a((int)(this.left - 10), (int)(this.top - this.slotHeight), (float)0.0f, (float)0.0f, (int)(this.listWidth + 20), (int)this.slotHeight, (float)32.0f, (float)32.0f);
        Gui.func_146110_a((int)(this.left - 10), (int)(this.top + this.listHeight), (float)0.0f, (float)(this.listHeight + this.slotHeight), (int)(this.listWidth + 20), (int)this.slotHeight, (float)32.0f, (float)32.0f);
    }
}

