/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.versionchecker.api;

import com.dynious.versionchecker.helper.MatchHelper;
import java.util.List;

public class VersionContainer {
    public List<Version> versionList;

    public VersionContainer(List<Version> versionList) {
        this.versionList = versionList;
    }

    public Version getLatestFromMcVersion(String McVersion) {
        for (Version version : this.versionList) {
            if (!MatchHelper.doStringsMatch(McVersion, version.getMcVersion())) continue;
            return version;
        }
        return null;
    }

    public static class Version {
        private String mcVersion;
        private String modVersion;
        private List<String> changeLog;
        private String updateURL;
        private boolean isDirectLink;
        private String newFileName;

        private Version(String mcVersion, String modVersion, List<String> changeLog, String updateURL, boolean isDirectLink, String newFileName) {
            this.mcVersion = mcVersion;
            this.modVersion = modVersion;
            this.changeLog = changeLog;
            this.updateURL = updateURL;
            this.isDirectLink = isDirectLink;
            this.newFileName = newFileName;
        }

        public String getMcVersion() {
            return this.mcVersion;
        }

        public String getModVersion() {
            return this.modVersion;
        }

        public List<String> getChangeLog() {
            return this.changeLog;
        }

        public String getUpdateURL() {
            return this.updateURL;
        }

        public boolean isDirectLink() {
            return this.isDirectLink;
        }

        public String getNewFileName() {
            return this.newFileName;
        }
    }
}

