/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.versionchecker.checker;

import com.dynious.versionchecker.checker.NEMUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NEMModInfo {
    private String name;
    private String version;
    private String longurl;
    private String shorturl;
    private String[] aliases;
    private String comment;
    private String modid;
    private String dev;
    private String actualModVersion;

    public boolean isUpToDate(String modVersion, String displayVersion) {
        boolean modVersionValid;
        if (modVersion.equals("%VERSION%") || displayVersion.equals("%VERSION%")) {
            return false;
        }
        if (NEMUtils.isDevVersion(this.version)) {
            if (this.dev == null || this.dev.isEmpty()) {
                return true;
            }
            this.version = this.dev;
        }
        modVersion = NEMUtils.patchVersion(modVersion);
        displayVersion = NEMUtils.patchVersion(displayVersion);
        Pattern versionPattern = Pattern.compile("[a-zA-Z0-9]+([\\.\\-_][a-zA-Z0-9]+)*");
        if (modVersion.equals(displayVersion)) {
            this.actualModVersion = modVersion;
            Matcher matcher = versionPattern.matcher(this.actualModVersion);
            modVersionValid = matcher.matches();
        } else {
            Matcher matcher = versionPattern.matcher(modVersion);
            modVersionValid = matcher.matches();
            matcher = versionPattern.matcher(displayVersion);
            boolean displayModVersionValid = matcher.matches();
            if (modVersionValid && displayModVersionValid) {
                this.actualModVersion = NEMUtils.isNewer(modVersion, displayVersion) ? modVersion : displayVersion;
            } else if (modVersionValid) {
                this.actualModVersion = modVersion;
            } else if (displayModVersionValid) {
                this.actualModVersion = displayVersion;
                modVersionValid = true;
            } else {
                this.actualModVersion = modVersion + "/" + displayVersion;
            }
        }
        return modVersionValid && this.isUpToDate(this.actualModVersion);
    }

    private boolean isUpToDate(String modVersion) {
        Pattern versionPattern = Pattern.compile("[a-zA-Z0-9]+([\\.\\-_][a-zA-Z0-9]+)*");
        Matcher matcher = versionPattern.matcher(modVersion);
        boolean modVersionValid = matcher.matches();
        return modVersionValid && !NEMUtils.isNewer(this.version, modVersion);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getLongurl() {
        return this.longurl;
    }

    public String shorturl() {
        return this.shorturl;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public String getComment() {
        return this.comment;
    }

    public String getModid() {
        return this.modid;
    }

    public String getActualModVersion() {
        return this.actualModVersion;
    }
}

