/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.versionchecker.checker;

import com.dynious.versionchecker.checker.NEMChecker;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class NEMUtils {
    public static final String versionDelimiters = "[\\.\\-_]";
    public static final String allVersionRegex = "[a-zA-Z0-9]+([\\.\\-_][a-zA-Z0-9]+)*";
    public static final String numericalVersionRegex = "[0-9]+([\\.\\-_][0-9]+)*";

    public static boolean isNumericalVersion(String version) {
        Pattern numVersionPattern = Pattern.compile(numericalVersionRegex);
        Matcher matcher = numVersionPattern.matcher(version);
        return matcher.matches();
    }

    public static String[] versionSplitting(String version, String regexVersionDelimiters) {
        Pattern pattern = Pattern.compile(regexVersionDelimiters);
        return pattern.split(version);
    }

    public static boolean isNewer(String version, String compareVersion) {
        String[] compareVersionParts;
        if (version.equals(compareVersion)) {
            return false;
        }
        boolean numericalCompare = NEMUtils.isNumericalVersion(version) && NEMUtils.isNumericalVersion(compareVersion);
        String[] versionParts = NEMUtils.versionSplitting(version, versionDelimiters);
        if (versionParts.length != (compareVersionParts = NEMUtils.versionSplitting(compareVersion, versionDelimiters)).length) {
            return false;
        }
        if (numericalCompare) {
            for (int i = 0; i < Math.min(versionParts.length, compareVersionParts.length); ++i) {
                Integer currentVersionNumber = Integer.parseInt(versionParts[i]);
                Integer currentCompareNumber = Integer.parseInt(compareVersionParts[i]);
                if (currentVersionNumber > currentCompareNumber) {
                    return true;
                }
                if (currentVersionNumber >= currentCompareNumber) continue;
                return false;
            }
            return false;
        }
        for (int i = 0; i < Math.min(versionParts.length, compareVersionParts.length); ++i) {
            String currentVersionPart = versionParts[i];
            String currentComparePart = compareVersionParts[i];
            for (int c = 0; c < Math.min(currentVersionPart.length(), currentComparePart.length()); ++c) {
                if (currentVersionPart.charAt(c) > currentComparePart.charAt(c)) {
                    return true;
                }
                if (currentVersionPart.charAt(c) >= currentComparePart.charAt(c)) continue;
                return false;
            }
            if (currentVersionPart.length() > currentComparePart.length()) {
                return true;
            }
            if (currentVersionPart.length() >= currentComparePart.length()) continue;
            return false;
        }
        return false;
    }

    public static String patchVersion(String modVersion) {
        String lastPart;
        modVersion = modVersion.replaceAll(Pattern.quote("(" + NEMChecker.getMcVersion() + ")"), "");
        modVersion = modVersion.replaceAll(Pattern.quote("[" + NEMChecker.getMcVersion() + "]"), "");
        modVersion = modVersion.replaceAll("[\\)\\]]", "").replaceAll("[\\(\\[]", ".");
        modVersion = modVersion.replaceAll(Pattern.quote("_" + NEMChecker.getMcVersion()), "");
        modVersion = modVersion.replaceAll(Pattern.quote(NEMChecker.getMcVersion() + "_"), "");
        modVersion = modVersion.replaceAll(Pattern.quote(NEMChecker.getMcVersion() + "-"), "");
        modVersion = modVersion.replaceAll("^v", "").replaceAll("^V", "");
        int index = (modVersion = modVersion.replaceAll(" build ", ".").replaceAll("\\s", "")).lastIndexOf(45);
        if (index != -1 && StringUtils.isAlpha((CharSequence)(lastPart = modVersion.substring(index + 1)))) {
            modVersion = modVersion.substring(0, index);
        }
        return modVersion;
    }

    public static boolean isDevVersion(String version) {
        return version.equals("dev-only") || version.equals("alpha-only") || version.equals("beta-only");
    }
}

