/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.versionchecker.client.gui;

import com.dynious.versionchecker.client.gui.GuiScroll;
import com.dynious.versionchecker.client.gui.GuiUpdates;
import com.dynious.versionchecker.lib.Resources;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class GuiChangeLogList
extends GuiScroll {
    private GuiUpdates parent;
    private List<String> changeLogLines;
    protected int emptyLineHeight = 4;

    public GuiChangeLogList(GuiUpdates parent, int width, int height, int top, int bottom, int left) {
        super(Minecraft.func_71410_x(), width, height, top, bottom, left, parent.getFontRenderer().field_78288_b);
        this.parent = parent;
        this.emptyLineHeight = (int)((float)parent.getFontRenderer().field_78288_b / 2.0f);
        this.setPadding(1, 4);
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float p_22243_3_) {
        super.drawScreen(mouseX, mouseY, p_22243_3_);
    }

    public void setText(String lines) {
        this.changeLogLines = new ArrayList<String>();
        int MAX_LINE_LENGTH = this.listWidth - 10;
        for (String line : lines.split("\\n")) {
            if (line.isEmpty()) {
                this.changeLogLines.add(line);
            } else {
                String currentLine = "";
                for (String word : line.split(" ")) {
                    if (this.parent.getFontRenderer().func_78256_a(currentLine + word) < MAX_LINE_LENGTH) {
                        currentLine = currentLine + word + " ";
                        continue;
                    }
                    if (this.parent.getFontRenderer().func_78256_a(word) < MAX_LINE_LENGTH) {
                        this.changeLogLines.add(currentLine);
                        currentLine = word + " ";
                        continue;
                    }
                    while (this.parent.getFontRenderer().func_78256_a(word) >= MAX_LINE_LENGTH) {
                        String cutWord = this.parent.getFontRenderer().func_78269_a(word, MAX_LINE_LENGTH);
                        this.changeLogLines.add(cutWord);
                        word = word.substring(cutWord.length());
                    }
                    currentLine = word + " ";
                }
                if (!currentLine.isEmpty()) {
                    this.changeLogLines.add(currentLine);
                }
            }
            this.changeLogLines.add("");
        }
        if (!this.changeLogLines.isEmpty() && this.changeLogLines.get(this.changeLogLines.size() - 1).isEmpty()) {
            this.changeLogLines.remove(this.changeLogLines.size() - 1);
        }
    }

    @Override
    protected int getSize() {
        return this.changeLogLines != null ? this.changeLogLines.size() : 0;
    }

    @Override
    protected int getSlotHeight(int slotIndex) {
        if (slotIndex >= 0 && slotIndex < this.changeLogLines.size() && this.changeLogLines.get(slotIndex).isEmpty()) {
            return this.emptyLineHeight;
        }
        return super.getSlotHeight(slotIndex);
    }

    @Override
    protected void elementClicked(int index, boolean doubleClick) {
    }

    @Override
    protected boolean isSelected(int index) {
        return false;
    }

    @Override
    protected void drawBackground() {
        this.parent.drawWindow();
    }

    @Override
    protected void drawSlot(int slotIndex, int minX, int maxX, int minY, int maxY, Tessellator tesselator) {
        if (slotIndex < this.changeLogLines.size()) {
            this.parent.getFontRenderer().func_78276_b(this.changeLogLines.get(slotIndex), minX + 3, minY, 0xFFFFFF);
        }
    }

    @Override
    public void overlayBackground() {
        this.client.field_71446_o.func_110577_a(Resources.GUI_WINDOW);
        GL11.glColor4f((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
        Gui.func_146110_a((int)(this.left - 10), (int)(this.top - this.slotHeight), (float)0.0f, (float)30.0f, (int)(this.listWidth + 20), (int)this.slotHeight, (float)220.0f, (float)160.0f);
        Gui.func_146110_a((int)(this.left - 10), (int)(this.top + this.listHeight), (float)0.0f, (float)(this.listHeight + this.slotHeight), (int)(this.listWidth + 20), (int)this.slotHeight, (float)220.0f, (float)160.0f);
    }
}

