/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ndk.internal.discovery;

import com.android.ide.eclipse.ndk.internal.Activator;
import com.android.ide.eclipse.ndk.internal.build.NdkCommandLauncher;
import com.android.ide.eclipse.ndk.internal.discovery.NdkDiscoveredPathInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class NdkDiscoveryUpdater {
    private final NdkDiscoveredPathInfo mPathInfo;
    private final IProject mProject;
    private boolean mCPlusPlus = false;
    private String mCommand;
    private List<String> mArguments = new ArrayList<String>();

    public NdkDiscoveryUpdater(NdkDiscoveredPathInfo pathInfo) {
        this.mPathInfo = pathInfo;
        this.mProject = pathInfo.getProject();
    }

    public void runUpdate(IProgressMonitor monitor) throws CoreException {
        try {
            Path commandPath = new Path("ndk-build");
            String[] args = new String[]{"-nB"};
            String[] env = this.calcEnvironment();
            File projectDir = new File(this.mProject.getLocationURI());
            Path changeToDirectory = new Path(projectDir.getAbsolutePath());
            Process proc = new NdkCommandLauncher().execute((IPath)commandPath, args, env, (IPath)changeToDirectory, monitor);
            if (proc == null) {
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = reader.readLine();
            while (line != null) {
                this.checkBuildLine(line);
                line = reader.readLine();
            }
            if (this.mCommand == null) {
                return;
            }
            this.mArguments.add("-E");
            this.mArguments.add("-P");
            this.mArguments.add("-v");
            this.mArguments.add("-dD");
            URL url = Activator.findFile((IPath)new Path("discovery/" + (this.mCPlusPlus ? "test.cpp" : "test.c")));
            File testFile = new File(FileLocator.toFileURL((URL)url).toURI());
            String testFileName = testFile.getAbsolutePath().replace('\\', '/');
            this.mArguments.add(testFileName);
            args = this.mArguments.toArray(new String[this.mArguments.size()]);
            proc = new NdkCommandLauncher().execute((IPath)new Path(this.mCommand), args, env, (IPath)changeToDirectory, monitor);
            final InputStream errStream = proc.getErrorStream();
            new Thread(){

                @Override
                public void run() {
                    NdkDiscoveryUpdater.this.checkIncludes(errStream);
                }
            }.start();
            this.checkDefines(proc.getInputStream());
        }
        catch (IOException e) {
            throw new CoreException(Activator.newStatus(e));
        }
        catch (URISyntaxException e) {
            throw new CoreException(Activator.newStatus(e));
        }
    }

    private String[] calcEnvironment() throws CoreException {
        Map builderEnv;
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.mProject);
        IBuilder builder = info.getDefaultConfiguration().getBuilder();
        HashMap<String, String> envMap = new HashMap<String, String>();
        if (builder.appendEnvironment()) {
            IEnvironmentVariable[] vars;
            ICConfigurationDescription cfgDes = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)builder.getParent().getParent());
            IEnvironmentVariableManager mngr = CCorePlugin.getDefault().getBuildEnvironmentManager();
            IEnvironmentVariable[] iEnvironmentVariableArray = vars = mngr.getVariables(cfgDes, true);
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                IEnvironmentVariable var = iEnvironmentVariableArray[n2];
                envMap.put(var.getName(), var.getValue());
                ++n2;
            }
        }
        if ((builderEnv = builder.getExpandedEnvironment()) != null) {
            envMap.putAll(builderEnv);
        }
        ArrayList<String> strings = new ArrayList<String>(envMap.size());
        for (Map.Entry entry : envMap.entrySet()) {
            StringBuffer buffer = new StringBuffer((String)entry.getKey());
            buffer.append('=').append((String)entry.getValue());
            strings.add(buffer.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    private void checkBuildLine(String text) {
        Line line = new Line(text);
        String cmd = line.getToken();
        if (cmd == null) {
            return;
        }
        if (cmd.endsWith("g++")) {
            if (this.mCommand == null || !this.mCPlusPlus) {
                this.mCommand = cmd;
                this.mCPlusPlus = true;
            }
            this.gatherOptions(line);
        } else if (cmd.endsWith("gcc")) {
            if (this.mCommand == null) {
                this.mCommand = cmd;
            }
            this.gatherOptions(line);
        }
    }

    private void gatherOptions(Line line) {
        String option = line.getToken();
        while (option != null) {
            if (option.startsWith("-")) {
                if (option.equals("-I")) {
                    String dir = line.getToken();
                    if (dir != null) {
                        this.addArg(String.valueOf(option) + dir);
                    }
                } else if (option.startsWith("-I")) {
                    this.addArg(option);
                } else if (option.equals("-D")) {
                    String def = line.getToken();
                    if (def != null) {
                        this.addArg(String.valueOf(option) + def);
                    }
                } else if (option.startsWith("-D")) {
                    this.addArg(option);
                } else if (option.startsWith("-f")) {
                    this.addArg(option);
                } else if (option.startsWith("-m")) {
                    this.addArg(option);
                } else if (option.startsWith("--sysroot")) {
                    this.addArg(option);
                }
            }
            option = line.getToken();
        }
    }

    private void addArg(String arg) {
        if (!this.mArguments.contains(arg)) {
            this.mArguments.add(arg);
        }
    }

    private void checkIncludes(InputStream in) {
        try {
            ArrayList<String> includes = new ArrayList<String>();
            boolean inIncludes1 = false;
            boolean inIncludes2 = false;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String line = reader.readLine();
            while (line != null) {
                if (!inIncludes1) {
                    if (line.equals("#include \"...\" search starts here:")) {
                        inIncludes1 = true;
                    }
                } else if (!inIncludes2) {
                    if (line.equals("#include <...> search starts here:")) {
                        inIncludes2 = true;
                    } else {
                        includes.add(line.trim());
                    }
                } else if (line.equals("End of search list.")) {
                    this.mPathInfo.setIncludePaths(includes);
                } else {
                    includes.add(line.trim());
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            Activator.log(e);
        }
    }

    private void checkDefines(InputStream in) {
        try {
            HashMap<String, String> defines = new HashMap<String, String>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith("#define")) {
                    Line l = new Line(line, 7);
                    String var = l.getToken();
                    if (var == null) continue;
                    String value = l.getRemaining();
                    if (value == null) {
                        value = "";
                    }
                    defines.put(var, value);
                }
                line = reader.readLine();
            }
            this.mPathInfo.setSymbols(defines);
        }
        catch (IOException e) {
            Activator.log(e);
        }
    }

    private static class Line {
        private final String line;
        private int pos;

        public Line(String line) {
            this.line = line;
        }

        public Line(String line, int pos) {
            this(line);
            this.pos = pos;
        }

        public String getToken() {
            this.skipWhiteSpace();
            if (this.pos == this.line.length()) {
                return null;
            }
            int start = this.pos;
            boolean inQuote = false;
            do {
                char c;
                if ((c = this.line.charAt(this.pos)) == ' ') {
                    if (inQuote) continue;
                    return this.line.substring(start, this.pos);
                }
                if (c != '\"') continue;
                boolean bl = inQuote = !inQuote;
            } while (++this.pos != this.line.length());
            return null;
        }

        private String getRemaining() {
            if (this.pos == this.line.length()) {
                return null;
            }
            this.skipWhiteSpace();
            String rc = this.line.substring(this.pos);
            this.pos = this.line.length();
            return rc;
        }

        private void skipWhiteSpace() {
            while (true) {
                if (this.pos == this.line.length()) {
                    return;
                }
                char c = this.line.charAt(this.pos);
                if (c != ' ') break;
                ++this.pos;
            }
        }
    }
}

