/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.layout;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.api.DrawingStyle;
import com.android.ide.common.api.DropFeedback;
import com.android.ide.common.api.IAttributeInfo;
import com.android.ide.common.api.IClientRulesEngine;
import com.android.ide.common.api.IDragElement;
import com.android.ide.common.api.IFeedbackPainter;
import com.android.ide.common.api.IGraphics;
import com.android.ide.common.api.IMenuCallback;
import com.android.ide.common.api.INode;
import com.android.ide.common.api.INodeHandler;
import com.android.ide.common.api.MarginType;
import com.android.ide.common.api.Point;
import com.android.ide.common.api.Rect;
import com.android.ide.common.api.RuleAction;
import com.android.ide.common.api.Segment;
import com.android.ide.common.api.SegmentType;
import com.android.ide.common.layout.BaseViewRule;
import com.android.ide.common.layout.PropertyCallback;
import com.android.ide.common.layout.ResizeState;
import com.android.utils.Pair;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BaseLayoutRule
extends BaseViewRule {
    private static final String ACTION_FILL_WIDTH = "_fillW";
    private static final String ACTION_FILL_HEIGHT = "_fillH";
    private static final String ACTION_MARGIN = "_margin";
    private static final URL ICON_MARGINS = BaseLayoutRule.class.getResource("margins.png");
    private static final URL ICON_GRAVITY = BaseLayoutRule.class.getResource("gravity.png");
    private static final URL ICON_FILL_WIDTH = BaseLayoutRule.class.getResource("fillwidth.png");
    private static final URL ICON_FILL_HEIGHT = BaseLayoutRule.class.getResource("fillheight.png");
    private static final String[] EXCLUDED_ATTRIBUTES = new String[]{"layout_gravity", "layout_x", "layout_y", "layout_above", "layout_below", "layout_toLeftOf", "layout_toRightOf", "layout_alignBaseline", "layout_alignTop", "layout_alignBottom", "layout_alignLeft", "layout_alignRight", "layout_alignParentTop", "layout_alignParentBottom", "layout_alignParentLeft", "layout_alignParentRight", "layout_alignWithParentIfMissing", "layout_centerHorizontal", "layout_centerInParent", "layout_centerVertical", "layout_row", "layout_rowSpan", "layout_column", "layout_columnSpan"};
    public static final AttributeFilter DEFAULT_ATTR_FILTER = new AttributeFilter(){
        Set<String> mExcludes;

        @Override
        public String replace(String uri, String name, String value) {
            if (!"http://schemas.android.com/apk/res/android".equals(uri)) {
                return value;
            }
            if (this.mExcludes == null) {
                this.mExcludes = new HashSet<String>(EXCLUDED_ATTRIBUTES.length);
                this.mExcludes.addAll(Arrays.asList(EXCLUDED_ATTRIBUTES));
            }
            return this.mExcludes.contains(name) ? null : value;
        }
    };

    protected final RuleAction createMarginAction(final INode parentNode, List<? extends INode> children) {
        final List<INode> targets = children == null || children.size() == 0 ? Collections.singletonList(parentNode) : children;
        final INode first = targets.get(0);
        IMenuCallback actionCallback = new IMenuCallback(){

            public void action(@NonNull RuleAction action, @NonNull List<? extends INode> selectedNodes, @Nullable String valueId, @Nullable Boolean newValue) {
                parentNode.editXml("Change Margins", new INodeHandler(){

                    public void handle(@NonNull INode n) {
                        String bottom;
                        String top;
                        String right;
                        String left;
                        String uri = "http://schemas.android.com/apk/res/android";
                        String all = first.getStringAttr(uri, "layout_margin");
                        String[] margins = (this).BaseLayoutRule.this.mRulesEngine.displayMarginInput(all, left = first.getStringAttr(uri, "layout_marginLeft"), right = first.getStringAttr(uri, "layout_marginRight"), top = first.getStringAttr(uri, "layout_marginTop"), bottom = first.getStringAttr(uri, "layout_marginBottom"));
                        if (margins != null) {
                            if (!$assertionsDisabled && margins.length != 5) {
                                throw new AssertionError();
                            }
                            for (INode child : targets) {
                                child.setAttribute(uri, "layout_margin", margins[0]);
                                child.setAttribute(uri, "layout_marginLeft", margins[1]);
                                child.setAttribute(uri, "layout_marginRight", margins[2]);
                                child.setAttribute(uri, "layout_marginTop", margins[3]);
                                child.setAttribute(uri, "layout_marginBottom", margins[4]);
                            }
                        }
                    }
                });
            }
        };
        return RuleAction.createAction((String)ACTION_MARGIN, (String)"Change Margins...", (IMenuCallback)actionCallback, (URL)ICON_MARGINS, (int)40, (boolean)false);
    }

    protected final RuleAction createGravityAction(List<? extends INode> targets, final String attributeName) {
        if (targets != null && targets.size() > 0) {
            final INode first = targets.get(0);
            RuleAction.ChoiceProvider provider = new RuleAction.ChoiceProvider(){

                public void addChoices(@NonNull List<String> titles, @NonNull List<URL> iconUrls, @NonNull List<String> ids) {
                    IAttributeInfo info = first.getAttributeInfo("http://schemas.android.com/apk/res/android", attributeName);
                    if (info != null) {
                        if (!$assertionsDisabled && !info.getFormats().contains(IAttributeInfo.Format.FLAG)) {
                            throw new AssertionError();
                        }
                        String[] stringArray = info.getFlagValues();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String name = stringArray[n2];
                            titles.add(BaseLayoutRule.getAttributeDisplayName(name));
                            ids.add(name);
                            ++n2;
                        }
                    }
                }
            };
            return RuleAction.createChoices((String)"_gravity", (String)"Change Gravity", (IMenuCallback)new PropertyCallback(targets, "Change Gravity", "http://schemas.android.com/apk/res/android", attributeName), (RuleAction.ChoiceProvider)provider, (String)first.getStringAttr("http://schemas.android.com/apk/res/android", attributeName), (URL)ICON_GRAVITY, (int)43, (boolean)false);
        }
        return null;
    }

    public void addLayoutActions(@NonNull List<RuleAction> actions, final @NonNull INode parentNode, @NonNull List<? extends INode> children) {
        super.addLayoutActions(actions, parentNode, children);
        final List<INode> targets = children == null || children.size() == 0 ? Collections.singletonList(parentNode) : children;
        INode first = targets.get(0);
        IMenuCallback actionCallback = new IMenuCallback(){

            public void action(@NonNull RuleAction action, @NonNull List<? extends INode> selectedNodes, @Nullable String valueId, final @Nullable Boolean newValue) {
                String undoLabel;
                final String actionId = action.getId();
                if (actionId.equals(BaseLayoutRule.ACTION_FILL_WIDTH)) {
                    undoLabel = "Change Width Fill";
                } else if (actionId.equals(BaseLayoutRule.ACTION_FILL_HEIGHT)) {
                    undoLabel = "Change Height Fill";
                } else {
                    return;
                }
                parentNode.editXml(undoLabel, new INodeHandler(){

                    public void handle(@NonNull INode n) {
                        String attribute;
                        String string = attribute = actionId.equals(BaseLayoutRule.ACTION_FILL_WIDTH) ? "layout_width" : "layout_height";
                        String value = newValue.booleanValue() ? (BaseLayoutRule.this.supportsMatchParent() ? "match_parent" : "fill_parent") : "wrap_content";
                        for (INode child : targets) {
                            child.setAttribute("http://schemas.android.com/apk/res/android", attribute, value);
                        }
                    }
                });
            }
        };
        actions.add((RuleAction)RuleAction.createToggle((String)ACTION_FILL_WIDTH, (String)"Toggle Fill Width", (boolean)this.isFilled(first, "layout_width"), (IMenuCallback)actionCallback, (URL)ICON_FILL_WIDTH, (int)10, (boolean)false));
        actions.add((RuleAction)RuleAction.createToggle((String)ACTION_FILL_HEIGHT, (String)"Toggle Fill Height", (boolean)this.isFilled(first, "layout_height"), (IMenuCallback)actionCallback, (URL)ICON_FILL_HEIGHT, (int)20, (boolean)false));
    }

    @Override
    public void onPaste(@NonNull INode targetNode, @Nullable Object targetView, @NonNull IDragElement[] elements) {
        Point p;
        DropFeedback feedback = this.onDropEnter(targetNode, targetView, elements);
        if (feedback != null && (feedback = this.onDropMove(targetNode, elements, feedback, p = targetNode.getBounds().getTopLeft())) != null) {
            this.onDropLeave(targetNode, elements, feedback);
            this.onDropped(targetNode, elements, feedback, p);
        }
    }

    public void onPasteBeforeChild(INode parentNode, Object parentView, INode targetNode, IDragElement[] elements) {
        DropFeedback feedback = this.onDropEnter(parentNode, parentView, elements);
        if (feedback != null) {
            Point parentP = parentNode.getBounds().getTopLeft();
            Point targetP = targetNode.getBounds().getTopLeft();
            if (parentP.y < targetP.y) {
                --targetP.y;
            }
            if ((feedback = this.onDropMove(parentNode, elements, feedback, targetP)) != null) {
                this.onDropLeave(parentNode, elements, feedback);
                this.onDropped(parentNode, elements, feedback, targetP);
            }
        }
    }

    public void drawElement(IGraphics gc, IDragElement element, int offsetX, int offsetY) {
        Rect b = element.getBounds();
        if (b.isValid()) {
            gc.drawRect(b.x + offsetX, b.y + offsetY, b.x + offsetX + b.w, b.y + offsetY + b.h);
        }
        IDragElement[] iDragElementArray = element.getInnerElements();
        int n = iDragElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDragElement inner = iDragElementArray[n2];
            this.drawElement(gc, inner, offsetX, offsetY);
            ++n2;
        }
    }

    protected static Map<String, Pair<String, String>> getDropIdMap(INode targetNode, IDragElement[] elements, boolean createNewIds) {
        Map<String, Pair<String, String>> idMap = new HashMap<String, Pair<String, String>>();
        if (createNewIds) {
            BaseLayoutRule.collectIds(idMap, elements);
            idMap = BaseLayoutRule.remapIds(targetNode, idMap);
        }
        return idMap;
    }

    protected static Map<String, Pair<String, String>> collectIds(Map<String, Pair<String, String>> idMap, IDragElement[] elements) {
        IDragElement[] iDragElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            IDragElement element = iDragElementArray[n2];
            IDragElement.IDragAttribute attr = element.getAttribute("http://schemas.android.com/apk/res/android", "id");
            if (attr != null && (id = attr.getValue()) != null && id.length() > 0) {
                idMap.put(id, (Pair<String, String>)Pair.of((Object)id, (Object)element.getFqcn()));
            }
            BaseLayoutRule.collectIds(idMap, element.getInnerElements());
            ++n2;
        }
        return idMap;
    }

    protected static Map<String, Pair<String, String>> remapIds(INode node, Map<String, Pair<String, String>> idMap) {
        HashSet<String> existingIdSet = new HashSet<String>();
        BaseLayoutRule.collectExistingIds(node.getRoot(), existingIdSet);
        HashMap<String, Pair<String, String>> new_map = new HashMap<String, Pair<String, String>>();
        for (Map.Entry<String, Pair<String, String>> entry : idMap.entrySet()) {
            String key = entry.getKey();
            Pair value = entry.getValue();
            String id = BaseLayoutRule.normalizeId(key);
            if (!existingIdSet.contains(id)) {
                new_map.put(key, value);
                if (key.equals(id)) continue;
                new_map.put(id, (Pair<String, String>)value);
                continue;
            }
            String new_id = BaseLayoutRule.findNewId((String)value.getSecond(), existingIdSet);
            value = Pair.of((Object)new_id, (Object)((String)value.getSecond()));
            new_map.put(id, (Pair<String, String>)value);
            new_map.put(id.replaceFirst("@\\+", "@"), (Pair<String, String>)value);
        }
        return new_map;
    }

    protected static String findNewId(String fqcn, Set<String> existingIdSet) {
        String name = fqcn.substring(fqcn.lastIndexOf(46) + 1);
        int i = 1;
        while (i < 1000000) {
            String id = String.format("@+id/%s%02d", name, i);
            if (!existingIdSet.contains(id)) {
                existingIdSet.add(id);
                return id;
            }
            ++i;
        }
        return null;
    }

    protected static void collectExistingIds(INode root, Set<String> existingIdSet) {
        if (root == null) {
            return;
        }
        String id = root.getStringAttr("http://schemas.android.com/apk/res/android", "id");
        if (id != null && !existingIdSet.contains(id = BaseLayoutRule.normalizeId(id))) {
            existingIdSet.add(id);
        }
        INode[] iNodeArray = root.getChildren();
        int n = iNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            INode child = iNodeArray[n2];
            BaseLayoutRule.collectExistingIds(child, existingIdSet);
            ++n2;
        }
    }

    protected static String normalizeId(String id) {
        if (id.indexOf("@+") == -1) {
            id = id.replaceFirst("@", "@+");
        }
        return id;
    }

    protected static void addAttributes(INode newNode, IDragElement oldElement, Map<String, Pair<String, String>> idMap, AttributeFilter filter) {
        IDragElement.IDragAttribute[] iDragAttributeArray = oldElement.getAttributes();
        int n = iDragAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDragElement.IDragAttribute attr = iDragAttributeArray[n2];
            String uri = attr.getUri();
            String name = attr.getName();
            String value = attr.getValue();
            IAttributeInfo attrInfo = newNode.getAttributeInfo(uri, name);
            if (attrInfo != null && attrInfo.getFormats().contains(IAttributeInfo.Format.REFERENCE) && idMap.containsKey(value)) {
                value = (String)idMap.get(value).getFirst();
            }
            if (filter != null) {
                value = filter.replace(uri, name, value);
            }
            if (value != null && value.length() > 0) {
                newNode.setAttribute(uri, name, value);
            }
            ++n2;
        }
    }

    protected static void addInnerElements(INode newNode, IDragElement oldElement, Map<String, Pair<String, String>> idMap) {
        IDragElement[] iDragElementArray = oldElement.getInnerElements();
        int n = iDragElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDragElement element = iDragElementArray[n2];
            String fqcn = element.getFqcn();
            INode childNode = newNode.appendChild(fqcn);
            BaseLayoutRule.addAttributes(childNode, element, idMap, null);
            BaseLayoutRule.addInnerElements(childNode, element, idMap);
            ++n2;
        }
    }

    public static void insertAt(final INode targetNode, final IDragElement[] elements, boolean createNewIds, final int initialInsertPos) {
        final Map<String, Pair<String, String>> idMap = BaseLayoutRule.getDropIdMap(targetNode, elements, createNewIds);
        targetNode.editXml("Insert Elements", new INodeHandler(){

            public void handle(@NonNull INode node) {
                int insertPos = initialInsertPos;
                IDragElement[] iDragElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IDragElement element = iDragElementArray[n2];
                    String fqcn = element.getFqcn();
                    INode newChild = targetNode.insertChildAt(fqcn, insertPos);
                    if (insertPos >= 0) {
                        ++insertPos;
                    }
                    BaseLayoutRule.addAttributes(newChild, element, idMap, DEFAULT_ATTR_FILTER);
                    BaseLayoutRule.addInnerElements(newChild, element, idMap);
                    ++n2;
                }
            }
        });
    }

    protected ResizeState createResizeState(INode layout, Object layoutView, INode node) {
        return new ResizeState(this, layout, layoutView, node);
    }

    public DropFeedback onResizeBegin(@NonNull INode child, @NonNull INode parent, @Nullable SegmentType horizontalEdge, @Nullable SegmentType verticalEdge, @Nullable Object childView, @Nullable Object parentView) {
        ResizeState state = this.createResizeState(parent, parentView, child);
        state.horizontalEdgeType = horizontalEdge;
        state.verticalEdgeType = verticalEdge;
        Map sizes = this.mRulesEngine.measureChildren(parent, new IClientRulesEngine.AttributeFilter(){

            public String getAttribute(@NonNull INode node, @Nullable String namespace, @NonNull String localName) {
                if ("layout_width".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                    return "wrap_content";
                }
                if ("layout_height".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                    return "wrap_content";
                }
                return null;
            }
        });
        if (sizes != null) {
            state.wrapBounds = (Rect)sizes.get(child);
        }
        return new DropFeedback((Object)state, new IFeedbackPainter(){

            public void paint(@NonNull IGraphics gc, @NonNull INode node, @NonNull DropFeedback feedback) {
                ResizeState resizeState = (ResizeState)feedback.userData;
                if (resizeState != null && resizeState.bounds != null) {
                    BaseLayoutRule.this.paintResizeFeedback(gc, node, resizeState);
                }
            }
        });
    }

    protected void paintResizeFeedback(IGraphics gc, INode node, ResizeState resizeState) {
        block22: {
            int x;
            Rect b;
            block25: {
                int wrapHeight;
                int wrapWidth;
                block23: {
                    int y;
                    block24: {
                        Segment s;
                        gc.useStyle(DrawingStyle.RESIZE_PREVIEW);
                        b = resizeState.bounds;
                        gc.drawRect(b);
                        if (resizeState.horizontalFillSegment != null) {
                            gc.useStyle(DrawingStyle.GUIDELINE);
                            s = resizeState.horizontalFillSegment;
                            gc.drawLine(s.from, s.at, s.to, s.at);
                        }
                        if (resizeState.verticalFillSegment != null) {
                            gc.useStyle(DrawingStyle.GUIDELINE);
                            s = resizeState.verticalFillSegment;
                            gc.drawLine(s.at, s.from, s.at, s.to);
                        }
                        if (resizeState.wrapBounds == null) break block22;
                        gc.useStyle(DrawingStyle.GUIDELINE);
                        wrapWidth = resizeState.wrapBounds.w;
                        wrapHeight = resizeState.wrapBounds.h;
                        if (resizeState.horizontalEdgeType == null) break block23;
                        y = -1;
                        switch (resizeState.horizontalEdgeType) {
                            case TOP: {
                                y = b.y + b.h - wrapHeight;
                                break;
                            }
                            case BOTTOM: {
                                y = b.y + wrapHeight;
                                break;
                            }
                            default: {
                                assert (false) : resizeState.horizontalEdgeType;
                                break;
                            }
                        }
                        if (resizeState.verticalEdgeType == null) break block24;
                        switch (resizeState.verticalEdgeType) {
                            case LEFT: {
                                gc.drawLine(b.x + b.w - wrapWidth, y, b.x + b.w, y);
                                break block23;
                            }
                            case RIGHT: {
                                gc.drawLine(b.x, y, b.x + wrapWidth, y);
                                break block23;
                            }
                            default: {
                                assert (false) : resizeState.verticalEdgeType;
                                break block23;
                            }
                        }
                    }
                    gc.drawLine(b.x, y, b.x + b.w, y);
                }
                if (resizeState.verticalEdgeType == null) break block22;
                x = -1;
                switch (resizeState.verticalEdgeType) {
                    case LEFT: {
                        x = b.x + b.w - wrapWidth;
                        break;
                    }
                    case RIGHT: {
                        x = b.x + wrapWidth;
                        break;
                    }
                    default: {
                        assert (false) : resizeState.verticalEdgeType;
                        break;
                    }
                }
                if (resizeState.horizontalEdgeType == null) break block25;
                switch (resizeState.horizontalEdgeType) {
                    case TOP: {
                        gc.drawLine(x, b.y + b.h - wrapHeight, x, b.y + b.h);
                        break block22;
                    }
                    case BOTTOM: {
                        gc.drawLine(x, b.y, x, b.y + wrapHeight);
                        break block22;
                    }
                    default: {
                        assert (false) : resizeState.horizontalEdgeType;
                        break block22;
                    }
                }
            }
            gc.drawLine(x, b.y, x, b.y + b.h);
        }
    }

    public static final int getMaxMatchDistance() {
        return 20;
    }

    public void onResizeUpdate(@Nullable DropFeedback feedback, @NonNull INode child, @NonNull INode parent, @NonNull Rect newBounds, int modifierMask) {
        Rect parentBounds;
        ResizeState state = (ResizeState)feedback.userData;
        state.bounds = newBounds;
        state.modifierMask = modifierMask;
        state.wrapHeight = false;
        state.wrapWidth = false;
        if (state.wrapBounds != null) {
            Rect b = state.wrapBounds;
            int maxMatchDistance = BaseLayoutRule.getMaxMatchDistance();
            if (state.horizontalEdgeType != null && Math.abs(newBounds.h - b.h) < maxMatchDistance) {
                state.wrapHeight = true;
                if (state.horizontalEdgeType == SegmentType.TOP) {
                    newBounds.y += newBounds.h - b.h;
                }
                newBounds.h = b.h;
            }
            if (state.verticalEdgeType != null && Math.abs(newBounds.w - b.w) < maxMatchDistance) {
                state.wrapWidth = true;
                if (state.verticalEdgeType == SegmentType.LEFT) {
                    newBounds.x += newBounds.w - b.w;
                }
                newBounds.w = b.w;
            }
        }
        state.horizontalFillSegment = null;
        state.fillHeight = false;
        if (state.horizontalEdgeType == SegmentType.BOTTOM && !state.wrapHeight) {
            parentBounds = parent.getBounds();
            state.horizontalFillSegment = new Segment(parentBounds.y2(), newBounds.x, newBounds.x2(), null, null, SegmentType.BOTTOM, MarginType.NO_MARGIN);
            if (Math.abs(newBounds.y2() - parentBounds.y2()) < BaseLayoutRule.getMaxMatchDistance()) {
                state.fillHeight = true;
                newBounds.h = parentBounds.y2() - newBounds.y;
            }
        }
        state.verticalFillSegment = null;
        state.fillWidth = false;
        if (state.verticalEdgeType == SegmentType.RIGHT && !state.wrapWidth) {
            parentBounds = parent.getBounds();
            state.verticalFillSegment = new Segment(parentBounds.x2(), newBounds.y, newBounds.y2(), null, null, SegmentType.RIGHT, MarginType.NO_MARGIN);
            if (Math.abs(newBounds.x2() - parentBounds.x2()) < BaseLayoutRule.getMaxMatchDistance()) {
                state.fillWidth = true;
                newBounds.w = parentBounds.x2() - newBounds.x;
            }
        }
        feedback.tooltip = this.getResizeUpdateMessage(state, child, parent, newBounds, state.horizontalEdgeType, state.verticalEdgeType);
    }

    public void onResizeEnd(@Nullable DropFeedback feedback, @NonNull INode child, final @NonNull INode parent, final @NonNull Rect newBounds) {
        final Rect oldBounds = child.getBounds();
        if (oldBounds.w != newBounds.w || oldBounds.h != newBounds.h) {
            final ResizeState state = (ResizeState)feedback.userData;
            child.editXml("Resize", new INodeHandler(){

                public void handle(@NonNull INode n) {
                    BaseLayoutRule.this.setNewSizeBounds(state, n, parent, oldBounds, newBounds, state.horizontalEdgeType, state.verticalEdgeType);
                }
            });
        }
    }

    protected String getResizeUpdateMessage(ResizeState resizeState, INode child, INode parent, Rect newBounds, SegmentType horizontalEdge, SegmentType verticalEdge) {
        String width = resizeState.getWidthAttribute();
        String height = resizeState.getHeightAttribute();
        if (horizontalEdge == null) {
            return width;
        }
        if (verticalEdge == null) {
            return height;
        }
        return String.format("%s \u00d7 %s", width, height);
    }

    protected void setNewSizeBounds(ResizeState resizeState, INode node, INode layout, Rect oldBounds, Rect newBounds, SegmentType horizontalEdge, SegmentType verticalEdge) {
        if (verticalEdge != null && (newBounds.w != oldBounds.w || resizeState.wrapWidth || resizeState.fillWidth)) {
            node.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", resizeState.getWidthAttribute());
        }
        if (horizontalEdge != null && (newBounds.h != oldBounds.h || resizeState.wrapHeight || resizeState.fillHeight)) {
            node.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", resizeState.getHeightAttribute());
        }
    }

    protected static interface AttributeFilter {
        public String replace(String var1, String var2, String var3);
    }
}

