/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.layout.relative;

import com.android.ide.common.api.DropFeedback;
import com.android.ide.common.api.IClientRulesEngine;
import com.android.ide.common.api.IDragElement;
import com.android.ide.common.api.INode;
import com.android.ide.common.api.MarginType;
import com.android.ide.common.api.Rect;
import com.android.ide.common.api.Segment;
import com.android.ide.common.api.SegmentType;
import com.android.ide.common.layout.BaseLayoutRule;
import com.android.ide.common.layout.relative.DependencyGraph;
import com.android.ide.common.layout.relative.GuidelineHandler;
import com.android.ide.common.layout.relative.Match;
import java.util.ArrayList;
import java.util.List;

public class MoveHandler
extends GuidelineHandler {
    private int mDraggedBaseline;

    public MoveHandler(INode layout, IDragElement[] elements, IClientRulesEngine rulesEngine) {
        super(layout, rulesEngine);
        ArrayList<INode> nodes = new ArrayList<INode>();
        IDragElement[] iDragElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IDragElement element = iDragElementArray[n2];
            DependencyGraph.ViewData view = this.mDependencyGraph.getView(element);
            if (view != null) {
                nodes.add(view.node);
            }
            ++n2;
        }
        this.mDraggedNodes = nodes;
        this.mHorizontalDeps = this.mDependencyGraph.dependsOn(nodes, false);
        this.mVerticalDeps = this.mDependencyGraph.dependsOn(nodes, true);
        iDragElementArray = layout.getChildren();
        n = iDragElementArray.length;
        n2 = 0;
        while (n2 < n) {
            IDragElement child = iDragElementArray[n2];
            Rect bc = child.getBounds();
            if (bc.isValid()) {
                boolean isDragged = false;
                IDragElement[] iDragElementArray2 = elements;
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IDragElement element = iDragElementArray2[n4];
                    if (bc.equals((Object)element.getBounds())) {
                        isDragged = true;
                    }
                    ++n4;
                }
                if (!isDragged) {
                    String id = child.getStringAttr("http://schemas.android.com/apk/res/android", "id");
                    boolean addHorizontal = !this.mHorizontalDeps.contains(child);
                    boolean addVertical = !this.mVerticalDeps.contains(child);
                    this.addBounds((INode)child, id, addHorizontal, addVertical);
                    if (addHorizontal) {
                        this.addBaseLine((INode)child, id);
                    }
                }
            }
            ++n2;
        }
        String id = layout.getStringAttr("http://schemas.android.com/apk/res/android", "id");
        this.addBounds(layout, id, true, true);
        this.addCenter(layout, id, true, true);
    }

    @Override
    protected void snapVertical(Segment vEdge, int x, Rect newBounds) {
        int maxDistance = BaseLayoutRule.getMaxMatchDistance();
        if (vEdge.edgeType == SegmentType.LEFT) {
            int margin;
            int n = margin = !this.mSnap ? 0 : Math.abs(newBounds.x - x);
            if (margin > maxDistance) {
                this.mLeftMargin = margin;
            } else {
                newBounds.x = x;
            }
        } else if (vEdge.edgeType == SegmentType.RIGHT) {
            int margin;
            int n = margin = !this.mSnap ? 0 : Math.abs(newBounds.x - (x - newBounds.w));
            if (margin > maxDistance) {
                this.mRightMargin = margin;
            } else {
                newBounds.x = x - newBounds.w;
            }
        } else if (vEdge.edgeType == SegmentType.CENTER_VERTICAL) {
            newBounds.x = x - newBounds.w / 2;
        } else assert (false) : vEdge;
    }

    @Override
    protected void snapHorizontal(Segment hEdge, int y, Rect newBounds) {
        int maxDistance = BaseLayoutRule.getMaxMatchDistance();
        if (hEdge.edgeType == SegmentType.TOP) {
            int margin;
            int n = margin = !this.mSnap ? 0 : Math.abs(newBounds.y - y);
            if (margin > maxDistance) {
                this.mTopMargin = margin;
            } else {
                newBounds.y = y;
            }
        } else if (hEdge.edgeType == SegmentType.BOTTOM) {
            int margin;
            int n = margin = !this.mSnap ? 0 : Math.abs(newBounds.y - (y - newBounds.h));
            if (margin > maxDistance) {
                this.mBottomMargin = margin;
            } else {
                newBounds.y = y - newBounds.h;
            }
        } else if (hEdge.edgeType == SegmentType.CENTER_HORIZONTAL) {
            int margin;
            int n = margin = !this.mSnap ? 0 : Math.abs(newBounds.y - (y - newBounds.h / 2));
            if (margin > maxDistance) {
                this.mTopMargin = margin;
            } else {
                newBounds.y = y - newBounds.h / 2;
            }
        } else if (hEdge.edgeType == SegmentType.BASELINE) {
            newBounds.y = y - this.mDraggedBaseline;
        } else assert (false) : hEdge;
    }

    public void updateMove(DropFeedback feedback, IDragElement[] elements, int offsetX, int offsetY, int modifierMask) {
        int baseline;
        this.mSnap = (modifierMask & 2) == 0;
        Rect firstBounds = elements[0].getBounds();
        INode firstNode = null;
        if (this.mDraggedNodes != null && this.mDraggedNodes.size() > 0) {
            firstNode = (INode)this.mDraggedNodes.iterator().next();
            firstBounds = firstNode.getBounds();
        }
        this.mBounds = new Rect(offsetX, offsetY, firstBounds.w, firstBounds.h);
        Rect layoutBounds = this.layout.getBounds();
        if (this.mBounds.x2() > layoutBounds.x2()) {
            this.mBounds.x -= this.mBounds.x2() - layoutBounds.x2();
        }
        if (this.mBounds.y2() > layoutBounds.y2()) {
            this.mBounds.y -= this.mBounds.y2() - layoutBounds.y2();
        }
        if (this.mBounds.x < layoutBounds.x) {
            this.mBounds.x = layoutBounds.x;
        }
        if (this.mBounds.y < layoutBounds.y) {
            this.mBounds.y = layoutBounds.y;
        }
        this.clearSuggestions();
        Rect b = this.mBounds;
        Segment edge = new Segment(b.y, b.x, b.x2(), null, null, SegmentType.TOP, MarginType.NO_MARGIN);
        List<Match> horizontalMatches = this.findClosest(edge, this.mHorizontalEdges);
        edge = new Segment(b.y2(), b.x, b.x2(), null, null, SegmentType.BOTTOM, MarginType.NO_MARGIN);
        this.addClosest(edge, this.mHorizontalEdges, horizontalMatches);
        edge = new Segment(b.x, b.y, b.y2(), null, null, SegmentType.LEFT, MarginType.NO_MARGIN);
        List<Match> verticalMatches = this.findClosest(edge, this.mVerticalEdges);
        edge = new Segment(b.x2(), b.y, b.y2(), null, null, SegmentType.RIGHT, MarginType.NO_MARGIN);
        this.addClosest(edge, this.mVerticalEdges, verticalMatches);
        edge = new Segment(b.centerX(), b.y, b.y2(), null, null, SegmentType.CENTER_VERTICAL, MarginType.NO_MARGIN);
        this.addClosest(edge, this.mCenterVertEdges, verticalMatches);
        edge = new Segment(b.centerY(), b.x, b.x2(), null, null, SegmentType.CENTER_HORIZONTAL, MarginType.NO_MARGIN);
        this.addClosest(edge, this.mCenterHorizEdges, horizontalMatches);
        if (firstNode != null) {
            baseline = firstNode.getBaseline();
            if (baseline != -1) {
                this.mDraggedBaseline = baseline;
                edge = new Segment(b.y + baseline, b.x, b.x2(), firstNode, null, SegmentType.BASELINE, MarginType.NO_MARGIN);
                this.addClosest(edge, this.mHorizontalEdges, horizontalMatches);
            }
        } else {
            baseline = feedback.dragBaseline;
            if (baseline != -1) {
                this.mDraggedBaseline = baseline;
                edge = new Segment(offsetY + baseline, b.x, b.x2(), null, null, SegmentType.BASELINE, MarginType.NO_MARGIN);
                this.addClosest(edge, this.mHorizontalEdges, horizontalMatches);
            }
        }
        this.mHorizontalSuggestions = horizontalMatches;
        this.mVerticalSuggestions = verticalMatches;
        this.mRightMargin = 0;
        this.mLeftMargin = 0;
        this.mBottomMargin = 0;
        this.mTopMargin = 0;
        Match match = this.pickBestMatch(this.mHorizontalSuggestions);
        if (match != null) {
            if (this.mHorizontalDeps.contains(match.edge.node)) {
                match.cycle = true;
            }
            this.mMoveTop = true;
            this.mMoveBottom = true;
            this.snapHorizontal(match.with, match.edge.at, this.mBounds);
            if (match.with.edgeType == SegmentType.TOP) {
                this.mCurrentTopMatch = match;
            } else if (match.with.edgeType == SegmentType.BOTTOM) {
                this.mCurrentBottomMatch = match;
            } else {
                assert (match.with.edgeType == SegmentType.CENTER_HORIZONTAL || match.with.edgeType == SegmentType.BASELINE) : match.with.edgeType;
                this.mCurrentTopMatch = match;
            }
        }
        if ((match = this.pickBestMatch(this.mVerticalSuggestions)) != null) {
            if (this.mVerticalDeps.contains(match.edge.node)) {
                match.cycle = true;
            }
            this.mMoveLeft = true;
            this.mMoveRight = true;
            this.snapVertical(match.with, match.edge.at, this.mBounds);
            if (match.with.edgeType == SegmentType.LEFT) {
                this.mCurrentLeftMatch = match;
            } else if (match.with.edgeType == SegmentType.RIGHT) {
                this.mCurrentRightMatch = match;
            } else {
                assert (match.with.edgeType == SegmentType.CENTER_VERTICAL);
                this.mCurrentLeftMatch = match;
            }
        }
        this.checkCycles(feedback);
    }
}

