/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt;

import com.android.ide.eclipse.adt.internal.launch.AndroidLaunchController;
import com.android.ide.eclipse.adt.internal.project.ProjectHelper;
import com.android.ide.eclipse.adt.internal.resources.manager.GlobalProjectMonitor;
import com.android.ide.eclipse.ddms.IDebuggerConnector;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class DebuggerConnector
implements IDebuggerConnector {
    private WorkspaceAppCache mWorkspaceAppCache = new WorkspaceAppCache();

    public DebuggerConnector() {
        GlobalProjectMonitor.getMonitor().addProjectListener(this.mWorkspaceAppCache);
    }

    public boolean connectDebugger(String appName, int appPort, int selectedPort) {
        IProject project = ProjectHelper.findAndroidProjectByAppName(appName);
        if (project != null) {
            AndroidLaunchController.debugRunningApp(project, appPort);
            return true;
        }
        return false;
    }

    public boolean isWorkspaceApp(String appName) {
        return this.mWorkspaceAppCache.isWorkspaceApp(appName);
    }

    static class WorkspaceAppCache
    implements GlobalProjectMonitor.IProjectListener {
        private Set<String> mAppsNotInWorkspace = new HashSet<String>();
        private Map<String, String> mAppsInWorkspace = new HashMap<String, String>();

        public boolean isWorkspaceApp(String appName) {
            if (this.mAppsNotInWorkspace.contains(appName)) {
                return false;
            }
            String projectName = this.mAppsInWorkspace.get(appName);
            if (projectName == null) {
                IProject p = ProjectHelper.findAndroidProjectByAppName(appName);
                if (p == null) {
                    this.mAppsNotInWorkspace.add(appName);
                } else {
                    projectName = p.getName();
                    this.mAppsInWorkspace.put(appName, projectName);
                }
            }
            return projectName != null;
        }

        @Override
        public void projectRenamed(IProject project, IPath from) {
        }

        @Override
        public void projectOpenedWithWorkspace(IProject project) {
        }

        @Override
        public void allProjectsOpenedWithWorkspace() {
        }

        @Override
        public void projectOpened(IProject project) {
            this.mAppsNotInWorkspace.clear();
        }

        @Override
        public void projectDeleted(IProject project) {
            this.projectClosed(project);
        }

        @Override
        public void projectClosed(IProject project) {
            HashMap<String, String> updatedCache = new HashMap<String, String>();
            String name = project.getName();
            for (Map.Entry<String, String> e : this.mAppsInWorkspace.entrySet()) {
                if (e.getValue().equals(name)) continue;
                updatedCache.put(e.getKey(), e.getValue());
            }
            this.mAppsInWorkspace = updatedCache;
        }
    }
}

