/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.build;

import com.android.annotations.NonNull;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.build.SourceChangeHandler;
import com.android.sdklib.build.RenderScriptChecker;
import java.io.IOException;
import java.util.Set;
import org.eclipse.core.resources.IFile;

public class RsSourceChangeHandler
implements SourceChangeHandler {
    private final RenderScriptChecker mChecker;
    private boolean mIsCheckerLoaded = false;
    private boolean mMustCompile = false;

    public RsSourceChangeHandler(@NonNull RenderScriptChecker checker) {
        this.mChecker = checker;
    }

    @Override
    public boolean handleGeneratedFile(IFile file, int kind) {
        if (this.mMustCompile) {
            return false;
        }
        if (!this.mIsCheckerLoaded) {
            try {
                this.mChecker.loadDependencies();
            }
            catch (IOException e) {
                AdtPlugin.log(e, "Failed to read dependency files", new Object[0]);
                this.mMustCompile = true;
                return false;
            }
        }
        Set oldOutputs = this.mChecker.getOldOutputs();
        this.mMustCompile = oldOutputs.contains(file.getLocation().toFile());
        return this.mMustCompile;
    }

    @Override
    public void handleSourceFile(IFile file, int kind) {
        if (this.mMustCompile) {
            return;
        }
        String ext = file.getFileExtension();
        if ("rs".equals(ext) || "fs".equals(ext) || "rsh".equals(ext)) {
            this.mMustCompile = true;
        }
    }

    public boolean mustCompile() {
        return this.mMustCompile;
    }

    @NonNull
    public RenderScriptChecker getChecker() {
        return this.mChecker;
    }

    public void prepareFullBuild() {
        this.mMustCompile = true;
    }
}

