/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.build;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;

public class SourceFileData {
    private final IFile mSourceFile;
    private final List<IFile> mOutputFiles = new ArrayList<IFile>();
    private final List<IFile> mDependencyFiles = new ArrayList<IFile>();

    public SourceFileData(IFile sourceFile) {
        this(sourceFile, null, null);
    }

    SourceFileData(IFile sourceFile, List<IFile> outputFiles, List<IFile> dependencyFiles) {
        this.mSourceFile = sourceFile;
        if (outputFiles != null) {
            this.mOutputFiles.addAll(outputFiles);
        }
        if (dependencyFiles != null) {
            this.mDependencyFiles.addAll(dependencyFiles);
        }
    }

    SourceFileData(IFile sourceFile, IFile outputFile) {
        this.mSourceFile = sourceFile;
        if (outputFile != null) {
            this.mOutputFiles.add(outputFile);
        }
    }

    public IFile getSourceFile() {
        return this.mSourceFile;
    }

    public boolean dependsOn(IFile file) {
        return this.mDependencyFiles.contains(file);
    }

    public boolean generated(IFile file) {
        return this.mOutputFiles.contains(file);
    }

    void setOutputFiles(List<IFile> outputFiles) {
        this.mOutputFiles.clear();
        if (outputFiles != null) {
            this.mOutputFiles.addAll(outputFiles);
        }
    }

    void setOutputFile(IFile outputFile) {
        this.mOutputFiles.clear();
        if (outputFile != null) {
            this.mOutputFiles.add(outputFile);
        }
    }

    void setDependencyFiles(List<IFile> depFiles) {
        this.mDependencyFiles.clear();
        if (depFiles != null) {
            this.mDependencyFiles.addAll(depFiles);
        }
    }

    public List<IFile> getDependencyFiles() {
        return this.mDependencyFiles;
    }

    public IFile getOutput() {
        if (this.mOutputFiles.size() > 0) {
            return this.mOutputFiles.get(0);
        }
        return null;
    }

    public List<IFile> getOutputFiles() {
        return Collections.unmodifiableList(this.mOutputFiles);
    }

    public String toString() {
        return "NonJavaFileBundle [mSourceFile=" + this.mSourceFile + ", mGeneratedFiles=" + this.mOutputFiles + ", mDependencies=" + this.mDependencyFiles + "]";
    }
}

