/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.build.builders;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AndroidPrintStream;
import com.android.ide.eclipse.adt.internal.build.AaptExecException;
import com.android.ide.eclipse.adt.internal.build.AaptParser;
import com.android.ide.eclipse.adt.internal.build.AaptResultException;
import com.android.ide.eclipse.adt.internal.build.BuildHelper;
import com.android.ide.eclipse.adt.internal.build.DexException;
import com.android.ide.eclipse.adt.internal.build.Messages;
import com.android.ide.eclipse.adt.internal.build.NativeLibInJarException;
import com.android.ide.eclipse.adt.internal.build.builders.BaseBuilder;
import com.android.ide.eclipse.adt.internal.build.builders.ChangedFileSet;
import com.android.ide.eclipse.adt.internal.build.builders.ChangedFileSetHelper;
import com.android.ide.eclipse.adt.internal.build.builders.PatternBasedDeltaVisitor;
import com.android.ide.eclipse.adt.internal.lint.LintDeltaProcessor;
import com.android.ide.eclipse.adt.internal.preferences.AdtPrefs;
import com.android.ide.eclipse.adt.internal.project.ApkInstallManager;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.project.LibraryClasspathContainerInitializer;
import com.android.ide.eclipse.adt.internal.project.ProjectHelper;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceManager;
import com.android.ide.eclipse.adt.internal.sdk.ProjectState;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.ide.eclipse.adt.io.IFileWrapper;
import com.android.io.IAbstractFile;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.build.ApkBuilder;
import com.android.sdklib.build.ApkCreationException;
import com.android.sdklib.build.DuplicateFileException;
import com.android.sdklib.build.IArchiveBuilder;
import com.android.sdklib.build.SealedApkException;
import com.android.sdklib.internal.build.DebugKeyProvider;
import com.android.xml.AndroidManifest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class PostCompilerBuilder
extends BaseBuilder {
    public static final String ID = "com.android.ide.eclipse.adt.ApkBuilder";
    private static final String PROPERTY_CONVERT_TO_DEX = "convertToDex";
    private static final String PROPERTY_PACKAGE_RESOURCES = "packageResources";
    private static final String PROPERTY_BUILD_APK = "buildApk";
    public static final String POST_C_REQUESTED = "RunPostCompiler";
    private boolean mConvertToDex = false;
    private boolean mPackageResources = false;
    private boolean mBuildFinalPackage = false;
    private AndroidPrintStream mOutStream = null;
    private AndroidPrintStream mErrStream = null;
    private BuildHelper.ResourceMarker mResourceMarker = new BuildHelper.ResourceMarker(){

        @Override
        public void setWarning(IResource resource, String message) {
            BaseProjectHelper.markResource(resource, "com.android.ide.eclipse.adt.packagingProblem", message, 1);
        }
    };

    protected void clean(IProgressMonitor monitor) throws CoreException {
        super.clean(monitor);
        IProject project = this.getProject();
        if (DEBUG_LOG) {
            AdtPlugin.log(1, "%s CLEAN(POST)", project.getName());
        }
        this.removeMarkersFromContainer((IContainer)project, "com.android.ide.eclipse.common.aapt2Problem");
        this.removeMarkersFromContainer((IContainer)project, "com.android.ide.eclipse.adt.packagingProblem");
        IFolder javaOutput = BaseProjectHelper.getJavaOutputFolder(project);
        IFolder androidOutput = BaseProjectHelper.getAndroidOutputFolder(project);
        if (!javaOutput.equals((Object)androidOutput)) {
            IResource[] members;
            IResource[] iResourceArray = members = androidOutput.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (!member.equals((Object)javaOutput)) {
                    member.delete(true, monitor);
                }
                ++n2;
            }
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject[] allRefProjects;
        block53: {
            ProjectState projectState;
            IProject project;
            block52: {
                project = this.getProject();
                if (DEBUG_LOG) {
                    AdtPlugin.log(1, "%s BUILD(POST)", project.getName());
                }
                long startBuildTime = 0L;
                allRefProjects = null;
                projectState = Sdk.getProjectState(project);
                if (projectState != null) break block52;
                return null;
            }
            try {
                IContainer ic;
                boolean isLibrary = projectState.isLibrary();
                List<IProject> libProjects = projectState.getFullLibraryProjects();
                IJavaProject javaProject = JavaCore.create((IProject)project);
                List<IProject> javaProjects = ProjectHelper.getReferencedProjects(project);
                List<IJavaProject> referencedJavaProjects = BuildHelper.getJavaProjects(javaProjects);
                int size = libProjects.size() + javaProjects.size();
                ArrayList<IProject> refList = new ArrayList<IProject>(size);
                refList.addAll(libProjects);
                refList.addAll(javaProjects);
                allRefProjects = refList.toArray(new IProject[size]);
                IFolder androidOutputFolder = BaseProjectHelper.getAndroidOutputFolder(project);
                IFolder resOutputFolder = androidOutputFolder.getFolder("res");
                if (!args.containsKey(POST_C_REQUESTED) || !AdtPrefs.getPrefs().getBuildSkipPostCompileOnFileSave()) {
                    if (kind == 6) {
                        AdtPlugin.printBuildToConsole(AdtPrefs.BuildVerbosity.VERBOSE, project, Messages.Start_Full_Apk_Build);
                        if (DEBUG_LOG) {
                            AdtPlugin.log(1, "%s full build!", project.getName());
                        }
                        this.mPackageResources = true;
                        this.mConvertToDex = true;
                        this.mBuildFinalPackage = true;
                    } else {
                        AdtPlugin.printBuildToConsole(AdtPrefs.BuildVerbosity.VERBOSE, project, Messages.Start_Inc_Apk_Build);
                        IResourceDelta delta = this.getDelta(project);
                        if (delta == null) {
                            this.mPackageResources = true;
                            this.mConvertToDex = true;
                            this.mBuildFinalPackage = true;
                        } else {
                            if (ResourceManager.isAutoBuilding() && AdtPrefs.getPrefs().isLintOnSave()) {
                                LintDeltaProcessor.create().process(delta);
                            }
                            PatternBasedDeltaVisitor dv = new PatternBasedDeltaVisitor(project, project, "POST:Main");
                            ChangedFileSet manifestCfs = ChangedFileSetHelper.getMergedManifestCfs(project);
                            dv.addSet(manifestCfs);
                            ChangedFileSet resCfs = ChangedFileSetHelper.getResCfs(project);
                            dv.addSet(resCfs);
                            ChangedFileSet androidCodeCfs = ChangedFileSetHelper.getCodeCfs(project);
                            dv.addSet(androidCodeCfs);
                            ChangedFileSet javaResCfs = ChangedFileSetHelper.getJavaResCfs(project);
                            dv.addSet(javaResCfs);
                            dv.addSet(ChangedFileSetHelper.NATIVE_LIBS);
                            delta.accept((IResourceDeltaVisitor)dv);
                            this.mPackageResources |= dv.checkSet(manifestCfs) || dv.checkSet(resCfs);
                            this.mConvertToDex |= dv.checkSet(androidCodeCfs);
                            this.mBuildFinalPackage |= dv.checkSet(javaResCfs) || dv.checkSet(ChangedFileSetHelper.NATIVE_LIBS);
                        }
                        if (libProjects.size() > 0) {
                            for (IProject libProject : libProjects) {
                                delta = this.getDelta(libProject);
                                if (delta == null) continue;
                                PatternBasedDeltaVisitor visitor = new PatternBasedDeltaVisitor(project, libProject, "POST:Lib");
                                ChangedFileSet libResCfs = ChangedFileSetHelper.getFullResCfs(libProject);
                                visitor.addSet(libResCfs);
                                visitor.addSet(ChangedFileSetHelper.NATIVE_LIBS);
                                delta.accept((IResourceDeltaVisitor)visitor);
                                this.mPackageResources |= visitor.checkSet(libResCfs);
                                this.mBuildFinalPackage |= visitor.checkSet(ChangedFileSetHelper.NATIVE_LIBS);
                            }
                        }
                        int referencedCount = referencedJavaProjects.size();
                        int i = 0;
                        while (i < referencedCount) {
                            IJavaProject referencedJavaProject = referencedJavaProjects.get(i);
                            delta = this.getDelta(referencedJavaProject.getProject());
                            if (delta != null) {
                                IProject referencedProject = referencedJavaProject.getProject();
                                PatternBasedDeltaVisitor visitor = new PatternBasedDeltaVisitor(project, referencedProject, "POST:RefedProject");
                                ChangedFileSet javaResCfs = ChangedFileSetHelper.getJavaResCfs(referencedProject);
                                visitor.addSet(javaResCfs);
                                ChangedFileSet bytecodeCfs = ChangedFileSetHelper.getByteCodeCfs(referencedProject);
                                visitor.addSet(bytecodeCfs);
                                delta.accept((IResourceDeltaVisitor)visitor);
                                this.mConvertToDex |= visitor.checkSet(bytecodeCfs);
                                this.mBuildFinalPackage |= visitor.checkSet(javaResCfs);
                            }
                            ++i;
                        }
                    }
                }
                this.saveProjectBooleanProperty(PROPERTY_CONVERT_TO_DEX, this.mConvertToDex);
                this.saveProjectBooleanProperty(PROPERTY_PACKAGE_RESOURCES, this.mPackageResources);
                this.saveProjectBooleanProperty(PROPERTY_BUILD_APK, this.mBuildFinalPackage);
                this.abortOnBadSetup(javaProject, projectState);
                if (this.mOutStream == null) {
                    this.mOutStream = new AndroidPrintStream(project, null, AdtPlugin.getOutStream());
                    this.mErrStream = new AndroidPrintStream(project, null, AdtPlugin.getOutStream());
                }
                this.removeMarkersFromContainer((IContainer)javaProject.getProject(), "com.android.ide.eclipse.adt.packagingProblem");
                if (isLibrary) {
                    IFile jarIFile = androidOutputFolder.getFile(String.valueOf(project.getName().toLowerCase()) + ".jar");
                    if (!this.mConvertToDex && !jarIFile.exists()) {
                        this.mConvertToDex = true;
                    }
                    if (DEBUG_LOG) {
                        AdtPlugin.log(1, "%s running crunch!", project.getName());
                    }
                    BuildHelper helper = new BuildHelper(projectState, this.mBuildToolInfo, this.mOutStream, this.mErrStream, false, false, true, AdtPrefs.getPrefs().getBuildVerbosity() == AdtPrefs.BuildVerbosity.VERBOSE, this.mResourceMarker);
                    this.updateCrunchCache(project, helper);
                    resOutputFolder.refreshLocal(2, monitor);
                    if (this.mConvertToDex) {
                        if (DEBUG_LOG) {
                            AdtPlugin.log(1, "%s updating jar!", project.getName());
                        }
                        IFile manifestFile = project.getFile("AndroidManifest.xml");
                        String appPackage = AndroidManifest.getPackage((IAbstractFile)new IFileWrapper(manifestFile));
                        IFolder javaOutputFolder = BaseProjectHelper.getJavaOutputFolder(project);
                        this.writeLibraryPackage(jarIFile, project, appPackage, javaOutputFolder);
                        this.mConvertToDex = false;
                        this.saveProjectBooleanProperty(PROPERTY_CONVERT_TO_DEX, false);
                        androidOutputFolder.refreshLocal(1, monitor);
                        List<ProjectState> parentProjects = projectState.getParentProjects();
                        LibraryClasspathContainerInitializer.updateProject(parentProjects);
                    }
                    return allRefProjects;
                }
                if (!args.containsKey(POST_C_REQUESTED) && AdtPrefs.getPrefs().getBuildSkipPostCompileOnFileSave()) {
                    AdtPlugin.printBuildToConsole(AdtPrefs.BuildVerbosity.VERBOSE, project, Messages.Skip_Post_Compiler);
                    return allRefProjects;
                }
                AdtPlugin.printBuildToConsole(AdtPrefs.BuildVerbosity.VERBOSE, project, Messages.Start_Full_Post_Compiler);
                String osSdkFolder = AdtPlugin.getOsSdkFolder();
                if (osSdkFolder.length() == 0) {
                    return allRefProjects;
                }
                IResource tmp = null;
                if (!(this.mPackageResources || (tmp = androidOutputFolder.findMember("resources.ap_")) != null && tmp.exists())) {
                    this.mPackageResources = true;
                }
                if (!(this.mConvertToDex || (tmp = androidOutputFolder.findMember("classes.dex")) != null && tmp.exists())) {
                    this.mConvertToDex = true;
                }
                String finalPackageName = ProjectHelper.getApkFilename(project, null);
                if (!this.mBuildFinalPackage && ((tmp = androidOutputFolder.findMember(finalPackageName)) == null || tmp instanceof IFile && !tmp.exists())) {
                    String msg = String.format(Messages.s_Missing_Repackaging, finalPackageName);
                    AdtPlugin.printBuildToConsole(AdtPrefs.BuildVerbosity.VERBOSE, project, msg);
                    this.mBuildFinalPackage = true;
                }
                if ((ic = androidOutputFolder.getParent()) != null) {
                    ic.refreshLocal(1, monitor);
                }
                if (!this.mPackageResources && !this.mConvertToDex && !this.mBuildFinalPackage) break block53;
                String forceJumboStr = projectState.getProperty("dex.force.jumbo");
                Boolean jumbo = Boolean.valueOf(forceJumboStr);
                String dexMergerStr = projectState.getProperty("dex.disable.merger");
                Boolean dexMerger = Boolean.valueOf(dexMergerStr);
                BuildHelper helper = new BuildHelper(projectState, this.mBuildToolInfo, this.mOutStream, this.mErrStream, jumbo, dexMerger, true, AdtPrefs.getPrefs().getBuildVerbosity() == AdtPrefs.BuildVerbosity.VERBOSE, this.mResourceMarker);
                IPath androidBinLocation = androidOutputFolder.getLocation();
                if (androidBinLocation == null) {
                    this.markProject("com.android.ide.eclipse.adt.packagingProblem", Messages.Output_Missing, 2);
                    return allRefProjects;
                }
                String osAndroidBinPath = androidBinLocation.toOSString();
                IFile manifestFile = androidOutputFolder.getFile("AndroidManifest.xml");
                if (manifestFile == null || !manifestFile.exists()) {
                    String msg = String.format(Messages.s_File_Missing, "AndroidManifest.xml");
                    this.markProject("com.android.ide.eclipse.adt.packagingProblem", msg, 2);
                    return allRefProjects;
                }
                String osFinalPackagePath = String.valueOf(osAndroidBinPath) + File.separator + finalPackageName;
                File finalPackage = new File(osFinalPackagePath);
                finalPackage.delete();
                if (this.mPackageResources) {
                    block54: {
                        if (DEBUG_LOG) {
                            AdtPlugin.log(1, "%s running crunch!", project.getName());
                        }
                        if (!this.updateCrunchCache(project, helper)) {
                            return allRefProjects;
                        }
                        resOutputFolder.refreshLocal(2, monitor);
                        if (DEBUG_LOG) {
                            AdtPlugin.log(1, "%s packaging resources!", project.getName());
                        }
                        this.removeMarkersFromContainer((IContainer)project, "com.android.ide.eclipse.common.aapt2Problem");
                        try {
                            helper.packageResources(manifestFile, libProjects, null, 0, osAndroidBinPath, "resources.ap_");
                        }
                        catch (AaptExecException e) {
                            BaseProjectHelper.markResource((IResource)project, "com.android.ide.eclipse.adt.packagingProblem", e.getMessage(), 2);
                            return allRefProjects;
                        }
                        catch (AaptResultException e) {
                            Object[] aaptOutput = e.getOutput();
                            boolean parsingError = AaptParser.parseOutput((String[])aaptOutput, project);
                            if (!parsingError) break block54;
                            AdtPlugin.printErrorToConsole(project, aaptOutput);
                            BaseProjectHelper.markResource((IResource)project, "com.android.ide.eclipse.adt.packagingProblem", Messages.Unparsed_AAPT_Errors, 2);
                        }
                    }
                    this.mPackageResources = false;
                    this.saveProjectBooleanProperty(PROPERTY_PACKAGE_RESOURCES, this.mPackageResources);
                }
                String classesDexPath = String.valueOf(osAndroidBinPath) + File.separator + "classes.dex";
                if (this.mConvertToDex) {
                    if (DEBUG_LOG) {
                        AdtPlugin.log(1, "%s running dex!", project.getName());
                    }
                    try {
                        Collection<String> dxInputPaths = helper.getCompiledCodePaths();
                        helper.executeDx(javaProject, dxInputPaths, classesDexPath);
                    }
                    catch (DexException e) {
                        String message = e.getMessage();
                        AdtPlugin.printErrorToConsole(project, new Object[]{message});
                        BaseProjectHelper.markResource((IResource)project, "com.android.ide.eclipse.adt.packagingProblem", message, 2);
                        Throwable cause = e.getCause();
                        if (cause instanceof NoClassDefFoundError || cause instanceof NoSuchMethodError) {
                            AdtPlugin.printErrorToConsole(project, new Object[]{Messages.Incompatible_VM_Warning, Messages.Requires_1_5_Error});
                        }
                        return allRefProjects;
                    }
                    this.mConvertToDex = false;
                    this.saveProjectBooleanProperty(PROPERTY_CONVERT_TO_DEX, this.mConvertToDex);
                }
                try {
                    if (DEBUG_LOG) {
                        AdtPlugin.log(1, "%s making final package!", project.getName());
                    }
                    helper.finalDebugPackage(String.valueOf(osAndroidBinPath) + File.separator + "resources.ap_", classesDexPath, osFinalPackagePath, libProjects, this.mResourceMarker);
                }
                catch (DebugKeyProvider.KeytoolException e) {
                    String eMessage = e.getMessage();
                    String msg = String.format(Messages.Final_Archive_Error_s, eMessage);
                    BaseProjectHelper.markResource((IResource)project, "com.android.ide.eclipse.adt.packagingProblem", msg, 2);
                    AdtPlugin.printErrorToConsole(project, new Object[]{msg, String.format(Messages.ApkBuilder_JAVA_HOME_is_s, e.getJavaHome()), Messages.ApkBuilder_Update_or_Execute_manually_s, e.getCommandLine()});
                    AdtPlugin.log(e, msg, new Object[0]);
                    return allRefProjects;
                }
                catch (ApkCreationException e) {
                    String eMessage = e.getMessage();
                    String msg = String.format(Messages.Final_Archive_Error_s, eMessage);
                    BaseProjectHelper.markResource((IResource)project, "com.android.ide.eclipse.adt.packagingProblem", msg, 2);
                    AdtPlugin.log(e, msg, new Object[0]);
                }
                catch (AndroidLocation.AndroidLocationException e) {
                    String eMessage = e.getMessage();
                    String msg = String.format(Messages.Final_Archive_Error_s, eMessage);
                    BaseProjectHelper.markResource((IResource)project, "com.android.ide.eclipse.adt.packagingProblem", msg, 2);
                    AdtPlugin.log(e, msg, new Object[0]);
                }
                catch (NativeLibInJarException e) {
                    String msg = e.getMessage();
                    BaseProjectHelper.markResource((IResource)project, "com.android.ide.eclipse.adt.packagingProblem", msg, 2);
                    AdtPlugin.printErrorToConsole(project, (Object[])e.getAdditionalInfo());
                }
                catch (CoreException e) {
                    String msg = String.format(Messages.Final_Archive_Error_s, e.getMessage());
                    AdtPlugin.printErrorToConsole(project, new Object[]{msg});
                    BaseProjectHelper.markResource((IResource)project, "com.android.ide.eclipse.adt.packagingProblem", msg, 2);
                    AdtPlugin.log(e, msg, new Object[0]);
                }
                catch (DuplicateFileException e) {
                    String msg1 = String.format("Found duplicate file for APK: %1$s\nOrigin 1: %2$s\nOrigin 2: %3$s", e.getArchivePath(), e.getFile1(), e.getFile2());
                    String msg2 = String.format(Messages.Final_Archive_Error_s, msg1);
                    AdtPlugin.printErrorToConsole(project, new Object[]{msg2});
                    BaseProjectHelper.markResource((IResource)project, "com.android.ide.eclipse.adt.packagingProblem", msg2, 2);
                }
                androidOutputFolder.refreshLocal(1, monitor);
                this.mBuildFinalPackage = false;
                this.saveProjectBooleanProperty(PROPERTY_BUILD_APK, this.mBuildFinalPackage);
                ApkInstallManager.getInstance().resetInstallationFor(project);
                AdtPlugin.printBuildToConsole(AdtPrefs.BuildVerbosity.VERBOSE, this.getProject(), "Build Success!");
            }
            catch (BaseBuilder.AbortBuildException abortBuildException) {
                return allRefProjects;
            }
            catch (Exception exception) {
                if (exception instanceof CoreException && ((CoreException)((Object)exception)).getStatus().getSeverity() == 8) {
                    return allRefProjects;
                }
                String msg = exception.getMessage();
                if (msg == null) {
                    msg = exception.getClass().getCanonicalName();
                }
                msg = String.format("Unknown error: %1$s", msg);
                AdtPlugin.logAndPrintError(exception, project.getName(), msg, new Object[0]);
                this.markProject("com.android.ide.eclipse.adt.packagingProblem", msg, 2);
            }
        }
        return allRefProjects;
    }

    private boolean updateCrunchCache(IProject project, BuildHelper helper) {
        block3: {
            try {
                helper.updateCrunchCache();
            }
            catch (AaptExecException e) {
                BaseProjectHelper.markResource((IResource)project, "com.android.ide.eclipse.adt.packagingProblem", e.getMessage(), 2);
                return false;
            }
            catch (AaptResultException e) {
                Object[] aaptOutput = e.getOutput();
                boolean parsingError = AaptParser.parseOutput((String[])aaptOutput, project);
                if (!parsingError) break block3;
                AdtPlugin.printErrorToConsole(project, aaptOutput);
            }
        }
        return true;
    }

    private void writeLibraryPackage(IFile jarIFile, IProject project, String appPackage, IFolder javaOutputFolder) {
        block14: {
            ZipOutputStream jos = null;
            try {
                try {
                    Manifest manifest = new Manifest();
                    Attributes mainAttributes = manifest.getMainAttributes();
                    mainAttributes.put(Attributes.Name.CLASS_PATH, "Android ADT");
                    mainAttributes.putValue("Created-By", "1.0 (Android)");
                    jos = new JarOutputStream((OutputStream)new FileOutputStream(jarIFile.getLocation().toFile()), manifest);
                    JarBuilder jarBuilder = new JarBuilder((JarOutputStream)jos, appPackage);
                    this.writeClassFilesIntoJar(jarBuilder, javaOutputFolder, javaOutputFolder);
                    ApkBuilder.addSourceFolder((IArchiveBuilder)jarBuilder, (File)javaOutputFolder.getLocation().toFile());
                    this.saveProjectBooleanProperty(PROPERTY_CONVERT_TO_DEX, this.mConvertToDex);
                }
                catch (Exception e) {
                    AdtPlugin.log(e, "Failed to write jar file %s", jarIFile.getLocation().toOSString());
                    if (jos != null) {
                        try {
                            jos.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (jos != null) {
                    try {
                        jos.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (jos != null) {
                try {
                    jos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeClassFilesIntoJar(JarBuilder builder, IFolder folder, IFolder rootFolder) throws CoreException, IOException, ApkCreationException {
        IResource[] members;
        IResource[] iResourceArray = members = folder.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (member.getType() == 2) {
                this.writeClassFilesIntoJar(builder, (IFolder)member, rootFolder);
            } else if (member.getType() == 1) {
                IFile file = (IFile)member;
                builder.addFile(file, rootFolder);
            }
            ++n2;
        }
    }

    protected void startupOnInitialize() {
        super.startupOnInitialize();
        this.mConvertToDex = this.loadProjectBooleanProperty(PROPERTY_CONVERT_TO_DEX, true);
        this.mPackageResources = this.loadProjectBooleanProperty(PROPERTY_PACKAGE_RESOURCES, true);
        this.mBuildFinalPackage = this.loadProjectBooleanProperty(PROPERTY_BUILD_APK, true);
    }

    @Override
    protected void abortOnBadSetup(@NonNull IJavaProject javaProject, @Nullable ProjectState projectState) throws BaseBuilder.AbortBuildException, CoreException {
        super.abortOnBadSetup(javaProject, projectState);
        IProject iProject = this.getProject();
        this.stopOnMarker(iProject, "com.android.ide.eclipse.common.aaptProblem", 2, false);
        this.stopOnMarker(iProject, "com.android.ide.eclipse.common.aidlProblem", 2, false);
        this.stopOnMarker(iProject, "com.android.ide.eclipse.common.rsProblem", 2, false);
        this.stopOnMarker(iProject, "com.android.ide.eclipse.common.androidProblem", 0, false);
        this.stopOnMarker(iProject, "org.eclipse.jdt.core.problem", 2, true);
        this.stopOnMarker(iProject, "org.eclipse.jdt.core.buildpath_problem", 2, true);
    }

    private static class JarBuilder
    implements IArchiveBuilder {
        private static Pattern R_PATTERN = Pattern.compile("R(\\$.*)?\\.class");
        private static String BUILD_CONFIG_CLASS = "BuildConfig.class";
        private final byte[] buffer = new byte[1024];
        private final JarOutputStream mOutputStream;
        private final String mAppPackage;

        JarBuilder(JarOutputStream outputStream, String appPackage) {
            this.mOutputStream = outputStream;
            this.mAppPackage = appPackage.replace('.', '/');
        }

        public void addFile(IFile file, IFolder rootFolder) throws ApkCreationException {
            if (!"class".equals(file.getFileExtension())) {
                return;
            }
            IPath packageApp = file.getParent().getFullPath().makeRelativeTo(rootFolder.getFullPath());
            String name = file.getName();
            if (this.mAppPackage.equals(packageApp.toString()) && (BUILD_CONFIG_CLASS.equals(name) || R_PATTERN.matcher(name).matches())) {
                return;
            }
            IPath path = file.getFullPath().makeRelativeTo(rootFolder.getFullPath());
            try {
                this.addFile(file.getContents(), file.getLocalTimeStamp(), path.toString());
            }
            catch (ApkCreationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ApkCreationException((Throwable)e, "Failed to add %s", new Object[]{file});
            }
        }

        public void addFile(File file, String archivePath) throws ApkCreationException, SealedApkException, DuplicateFileException {
            try {
                FileInputStream inputStream = new FileInputStream(file);
                long lastModified = file.lastModified();
                this.addFile(inputStream, lastModified, archivePath);
            }
            catch (ApkCreationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ApkCreationException((Throwable)e, "Failed to add %s", new Object[]{file});
            }
        }

        private void addFile(InputStream content, long lastModified, String archivePath) throws IOException, ApkCreationException {
            JarEntry entry = new JarEntry(archivePath);
            entry.setTime(lastModified);
            try {
                int count;
                this.mOutputStream.putNextEntry(entry);
                while ((count = content.read(this.buffer)) != -1) {
                    this.mOutputStream.write(this.buffer, 0, count);
                }
            }
            finally {
                try {
                    if (content != null) {
                        content.close();
                    }
                }
                catch (Exception e) {
                    throw new ApkCreationException((Throwable)e, "Failed to close stream", new Object[0]);
                }
            }
        }
    }
}

