/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.draw9patch.graphics;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.draw9patch.graphics.GraphicsUtilities;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;

public class NinePatchedImage {
    private static final boolean DEBUG = false;
    public static final int BLACK_TICK = -16777216;
    public static final int RED_TICK = -65536;
    public static final int TRANSPARENT_TICK = 0;
    private ImageData mBaseImageData;
    private Image mBaseImage = null;
    private boolean mHasNinePatchExtension = false;
    private boolean mDirtyFlag = false;
    private int[] mHorizontalPatchPixels = null;
    private int[] mVerticalPatchPixels = null;
    private int[] mHorizontalContentPixels = null;
    private int[] mVerticalContentPixels = null;
    private boolean mRedTickOnlyInHorizontalFlag = false;
    private boolean mRedTickOnlyInVerticalFlag = false;
    private final List<Tick> mHorizontalPatches = new ArrayList<Tick>();
    private final List<Tick> mVerticalPatches = new ArrayList<Tick>();
    private final List<Tick> mHorizontalContents = new ArrayList<Tick>();
    private final List<Tick> mVerticalContents = new ArrayList<Tick>();
    private static final int CHUNK_BIN_SIZE = 100;
    private final List<Chunk> mChunkBin = new ArrayList<Chunk>(100);
    private int mHorizontalFixedPatchSum = 0;
    private int mVerticalFixedPatchSum = 0;
    private static final int PROJECTION_BIN_SIZE = 100;
    private final List<Projection> mProjectionBin = new ArrayList<Projection>(100);
    private Chunk[][] mPatchChunks = null;

    public static String getNinePatchedFileName(String fileName) {
        if (fileName.endsWith(".9.png")) {
            return fileName;
        }
        return String.valueOf(fileName.substring(0, fileName.lastIndexOf(".png"))) + ".9.png";
    }

    public ImageData getImageData() {
        return this.mBaseImageData;
    }

    public int getWidth() {
        return this.mBaseImageData.width;
    }

    public int getHeight() {
        return this.mBaseImageData.height;
    }

    public Image getImage() {
        if (this.mBaseImage == null) {
            this.mBaseImage = new Image((Device)AdtPlugin.getDisplay(), this.mBaseImageData);
        }
        return this.mBaseImage;
    }

    public boolean hasNinePatchExtension() {
        return this.mHasNinePatchExtension;
    }

    public boolean isDirty() {
        return this.mDirtyFlag;
    }

    public void clearDirtyFlag() {
        this.mDirtyFlag = false;
    }

    public NinePatchedImage(String fileName) {
        boolean hasNinePatchExtension = fileName.endsWith(".9.png");
        ImageData data = new ImageData(fileName);
        this.initNinePatchedImage(data, hasNinePatchExtension);
    }

    public NinePatchedImage(InputStream inputStream, String fileName) {
        boolean hasNinePatchExtension = fileName.endsWith(".9.png");
        ImageData data = new ImageData(inputStream);
        this.initNinePatchedImage(data, hasNinePatchExtension);
    }

    private Chunk getChunk() {
        if (this.mChunkBin.size() > 0) {
            Chunk chunk = this.mChunkBin.remove(0);
            chunk.init();
            return chunk;
        }
        return new Chunk();
    }

    private static final void recycleChunks(Chunk[][] patchChunks, List<Chunk> bin) {
        int yLen = patchChunks.length;
        int xLen = patchChunks[0].length;
        int y = 0;
        while (y < yLen) {
            int x = 0;
            while (x < xLen) {
                if (bin.size() < 100) {
                    bin.add(patchChunks[y][x]);
                }
                patchChunks[y][x] = null;
                ++x;
            }
            ++y;
        }
    }

    private Projection getProjection() {
        if (this.mProjectionBin.size() > 0) {
            Projection projection = this.mProjectionBin.remove(0);
            return projection;
        }
        return new Projection();
    }

    private static final void recycleProjections(Projection[][] projections, List<Projection> bin) {
        int yLen = projections.length;
        int xLen = 0;
        if (yLen > 0) {
            xLen = projections[0].length;
        }
        int y = 0;
        while (y < yLen) {
            int x = 0;
            while (x < xLen) {
                if (bin.size() < 100) {
                    bin.add(projections[y][x]);
                }
                projections[y][x] = null;
                ++x;
            }
            ++y;
        }
    }

    private static final int[] initArray(int[] array) {
        int len = array.length;
        int i = 0;
        while (i < len) {
            array[i] = 0;
            ++i;
        }
        return array;
    }

    private static final int getPixel(ImageData image, int x, int y) {
        return (image.getAlpha(x, y) << 24) + image.getPixel(x, y);
    }

    private static final boolean isTransparentPixel(ImageData image, int x, int y) {
        return image.getAlpha(x, y) == 0;
    }

    private static final boolean isValidTickColor(int pixel) {
        return pixel == -16777216 || pixel == -65536;
    }

    private void initNinePatchedImage(ImageData imageData, boolean hasNinePatchExtension) {
        this.mBaseImageData = imageData;
        this.mHasNinePatchExtension = hasNinePatchExtension;
    }

    private boolean ensurePixel(int x, int y, int[] pixels, int index) {
        boolean isValid = true;
        int pixel = NinePatchedImage.getPixel(this.mBaseImageData, x, y);
        if (!NinePatchedImage.isTransparentPixel(this.mBaseImageData, x, y)) {
            if (index == 0 || index == pixels.length - 1) {
                isValid = false;
            }
            if (NinePatchedImage.isValidTickColor(pixel)) {
                pixels[index] = pixel;
            } else {
                isValid = false;
            }
            this.mBaseImageData.setAlpha(x, y, 0);
        }
        return isValid;
    }

    private boolean ensureHorizontalPixel(int x, int y, int[] pixels) {
        return this.ensurePixel(x, y, pixels, x);
    }

    private boolean ensureVerticalPixel(int x, int y, int[] pixels) {
        return this.ensurePixel(x, y, pixels, y);
    }

    public boolean ensure9Patch() {
        boolean isValid = true;
        int width = this.mBaseImageData.width;
        int height = this.mBaseImageData.height;
        this.createPatchArray();
        this.createContentArray();
        int x = 0;
        while (x < width) {
            if (!this.ensureHorizontalPixel(x, 0, this.mHorizontalPatchPixels)) {
                isValid = false;
            }
            if (!this.ensureHorizontalPixel(x, height - 1, this.mHorizontalContentPixels)) {
                isValid = false;
            }
            ++x;
        }
        int y = 0;
        while (y < height) {
            if (!this.ensureVerticalPixel(0, y, this.mVerticalPatchPixels)) {
                isValid = false;
            }
            if (!this.ensureVerticalPixel(width - 1, y, this.mVerticalContentPixels)) {
                isValid = false;
            }
            ++y;
        }
        this.findPatches();
        this.findContentsArea();
        return isValid;
    }

    private void createPatchArray() {
        this.mHorizontalPatchPixels = NinePatchedImage.initArray(new int[this.mBaseImageData.width]);
        this.mVerticalPatchPixels = NinePatchedImage.initArray(new int[this.mBaseImageData.height]);
    }

    private void createContentArray() {
        this.mHorizontalContentPixels = NinePatchedImage.initArray(new int[this.mBaseImageData.width]);
        this.mVerticalContentPixels = NinePatchedImage.initArray(new int[this.mBaseImageData.height]);
    }

    public void convertToNinePatch() {
        this.mBaseImageData = GraphicsUtilities.convertToNinePatch(this.mBaseImageData);
        this.mHasNinePatchExtension = true;
        this.createPatchArray();
        this.createContentArray();
        this.findPatches();
        this.findContentsArea();
    }

    public boolean isValid(int x, int y) {
        return x == 0 ^ y == 0 ^ x == this.mBaseImageData.width - 1 ^ y == this.mBaseImageData.height - 1;
    }

    public void setPatch(int x, int y, int color) {
        if (this.isValid(x, y)) {
            if (x == 0) {
                this.mVerticalPatchPixels[y] = color;
            } else if (y == 0) {
                this.mHorizontalPatchPixels[x] = color;
            } else if (x == this.mBaseImageData.width - 1) {
                this.mVerticalContentPixels[y] = color;
            } else if (y == this.mBaseImageData.height - 1) {
                this.mHorizontalContentPixels[x] = color;
            }
            this.mDirtyFlag = true;
        }
    }

    public void erase(int x, int y) {
        if (this.isValid(x, y)) {
            int color = 0;
            if (x == 0) {
                this.mVerticalPatchPixels[y] = color;
            } else if (y == 0) {
                this.mHorizontalPatchPixels[x] = color;
            } else if (x == this.mBaseImageData.width - 1) {
                this.mVerticalContentPixels[y] = color;
            } else if (y == this.mBaseImageData.height - 1) {
                this.mHorizontalContentPixels[x] = color;
            }
            this.mDirtyFlag = true;
        }
    }

    public List<Tick> getHorizontalPatches() {
        return this.mHorizontalPatches;
    }

    public List<Tick> getVerticalPatches() {
        return this.mVerticalPatches;
    }

    private static boolean findPatches(int[] pixels, List<Tick> out) {
        boolean redTickOnly = true;
        Tick patch = null;
        int len = 0;
        out.clear();
        len = pixels.length - 1;
        int i = 1;
        while (i < len) {
            int pixel = pixels[i];
            if (redTickOnly && pixel != 0 && pixel != -65536) {
                redTickOnly = false;
            }
            if (patch != null && patch.color != pixel) {
                patch.end = i;
                out.add(patch);
                patch = null;
            }
            if (patch == null) {
                patch = new Tick(pixel);
                patch.start = i;
            }
            ++i;
        }
        if (patch != null) {
            patch.end = len;
            out.add(patch);
        }
        return redTickOnly;
    }

    public void findPatches() {
        this.mRedTickOnlyInHorizontalFlag = NinePatchedImage.findPatches(this.mHorizontalPatchPixels, this.mHorizontalPatches);
        this.mRedTickOnlyInVerticalFlag = NinePatchedImage.findPatches(this.mVerticalPatchPixels, this.mVerticalPatches);
    }

    public Rectangle getContentArea() {
        Tick horizontal = this.getContentArea(this.mHorizontalContents);
        Tick vertical = this.getContentArea(this.mVerticalContents);
        Rectangle rect = new Rectangle(0, 0, 0, 0);
        rect.x = 1;
        rect.width = this.mBaseImageData.width - 1;
        rect.y = 1;
        rect.height = this.mBaseImageData.height - 1;
        if (horizontal != null) {
            rect.x = horizontal.start;
            rect.width = horizontal.getLength();
        }
        if (vertical != null) {
            rect.y = vertical.start;
            rect.height = vertical.getLength();
        }
        return rect;
    }

    private Tick getContentArea(List<Tick> list) {
        int size = list.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return list.get(0);
        }
        Tick start = null;
        Tick end = null;
        int i = 0;
        while (i < size) {
            Tick t = list.get(i);
            if (t.color == -16777216) {
                if (start == null) {
                    start = t;
                    end = t;
                } else {
                    end = t;
                }
            }
            ++i;
        }
        if (start == null) {
            return null;
        }
        Tick result = new Tick(start.color);
        result.start = start.start;
        result.end = end.end;
        return result;
    }

    public List<Tick> getHorizontalContents() {
        return this.mHorizontalContents;
    }

    public List<Tick> getVerticalContents() {
        return this.mVerticalContents;
    }

    private static void findContentArea(int[] pixels, List<Tick> out) {
        Tick contents = null;
        int len = 0;
        out.clear();
        len = pixels.length - 1;
        int x = 1;
        while (x < len) {
            if (contents != null && contents.color != pixels[x]) {
                contents.end = x;
                out.add(contents);
                contents = null;
            }
            if (contents == null) {
                contents = new Tick(pixels[x]);
                contents.start = x;
            }
            ++x;
        }
        if (contents != null) {
            contents.end = len;
            out.add(contents);
        }
    }

    public void findContentsArea() {
        NinePatchedImage.findContentArea(this.mHorizontalContentPixels, this.mHorizontalContents);
        NinePatchedImage.findContentArea(this.mVerticalContentPixels, this.mVerticalContents);
    }

    public ImageData getRawImageData() {
        int pixel;
        ImageData image = GraphicsUtilities.copy(this.mBaseImageData);
        int width = image.width;
        int height = image.height;
        int len = 0;
        len = this.mHorizontalPatchPixels.length;
        int x = 0;
        while (x < len) {
            pixel = this.mHorizontalPatchPixels[x];
            if (pixel != 0) {
                image.setAlpha(x, 0, 255);
                image.setPixel(x, 0, pixel);
            }
            ++x;
        }
        len = this.mVerticalPatchPixels.length;
        int y = 0;
        while (y < len) {
            pixel = this.mVerticalPatchPixels[y];
            if (pixel != 0) {
                image.setAlpha(0, y, 255);
                image.setPixel(0, y, pixel);
            }
            ++y;
        }
        len = this.mHorizontalContentPixels.length;
        x = 0;
        while (x < len) {
            pixel = this.mHorizontalContentPixels[x];
            if (pixel != 0) {
                image.setAlpha(x, height - 1, 255);
                image.setPixel(x, height - 1, pixel);
            }
            ++x;
        }
        len = this.mVerticalContentPixels.length;
        y = 0;
        while (y < len) {
            pixel = this.mVerticalContentPixels[y];
            if (pixel != 0) {
                image.setAlpha(width - 1, y, 255);
                image.setPixel(width - 1, y, pixel);
            }
            ++y;
        }
        return image;
    }

    public Chunk[][] getChunks(Chunk[][] chunks) {
        int lenY = this.mVerticalPatches.size();
        int lenX = this.mHorizontalPatches.size();
        if (lenY == 0 || lenX == 0) {
            return null;
        }
        if (chunks == null) {
            chunks = new Chunk[lenY][lenX];
        } else {
            int y = chunks.length;
            int x = chunks[0].length;
            if (lenY != y || lenX != x) {
                NinePatchedImage.recycleChunks(chunks, this.mChunkBin);
                chunks = new Chunk[lenY][lenX];
            }
        }
        float horizontalPatchSum = 0.0f;
        float verticalPatchSum = 0.0f;
        this.mVerticalFixedPatchSum = 0;
        this.mHorizontalFixedPatchSum = 0;
        int y = 0;
        while (y < lenY) {
            Tick yTick = this.mVerticalPatches.get(y);
            int x = 0;
            while (x < lenX) {
                Chunk t;
                Tick xTick = this.mHorizontalPatches.get(x);
                chunks[y][x] = t = this.getChunk();
                t.rect.x = xTick.start;
                t.rect.width = xTick.getLength();
                t.rect.y = yTick.start;
                t.rect.height = yTick.getLength();
                if (this.mRedTickOnlyInHorizontalFlag || xTick.color == -16777216 || lenX == 1) {
                    ++t.type;
                    if (y == 0) {
                        horizontalPatchSum += (float)t.rect.width;
                    }
                }
                if (this.mRedTickOnlyInVerticalFlag || yTick.color == -16777216 || lenY == 1) {
                    t.type += 2;
                    if (x == 0) {
                        verticalPatchSum += (float)t.rect.height;
                    }
                }
                if ((t.type & 1) == 0 && lenX > 1 && y == 0) {
                    this.mHorizontalFixedPatchSum += t.rect.width;
                }
                if ((t.type & 2) == 0 && lenY > 1 && x == 0) {
                    this.mVerticalFixedPatchSum += t.rect.height;
                }
                ++x;
            }
            ++y;
        }
        y = 0;
        while (y < lenY) {
            int x = 0;
            while (x < lenX) {
                Chunk chunk = chunks[y][x];
                if ((chunk.type & 1) != 0) {
                    chunk.horizontalWeight = (float)chunk.rect.width / horizontalPatchSum;
                }
                if ((chunk.type & 2) != 0) {
                    chunk.verticalWeight = (float)chunk.rect.height / verticalPatchSum;
                }
                ++x;
            }
            ++y;
        }
        return chunks;
    }

    public Chunk[][] getCorruptedChunks(Chunk[][] chunks) {
        if ((chunks = this.getChunks(chunks)) != null) {
            int yLen = chunks.length;
            int xLen = chunks[0].length;
            int yPos = 0;
            while (yPos < yLen) {
                int xPos = 0;
                while (xPos < xLen) {
                    Chunk c = chunks[yPos][xPos];
                    Rectangle r = c.rect;
                    if ((c.type & 1) != 0 && NinePatchedImage.isHorizontalCorrupted(this.mBaseImageData, r)) {
                        c.type |= Integer.MIN_VALUE;
                    }
                    if ((c.type & 2) != 0 && NinePatchedImage.isVerticalCorrupted(this.mBaseImageData, r)) {
                        c.type |= Integer.MIN_VALUE;
                    }
                    ++xPos;
                }
                ++yPos;
            }
        }
        return chunks;
    }

    private static boolean isVerticalCorrupted(ImageData data, Rectangle r) {
        int[] column = new int[r.width];
        int[] sample = new int[r.width];
        GraphicsUtilities.getHorizontalPixels(data, r.x, r.y, r.width, column);
        int lenY = r.y + r.height;
        int y = r.y;
        while (y < lenY) {
            GraphicsUtilities.getHorizontalPixels(data, r.x, y, r.width, sample);
            if (!Arrays.equals(column, sample)) {
                return true;
            }
            ++y;
        }
        return false;
    }

    private static boolean isHorizontalCorrupted(ImageData data, Rectangle r) {
        int[] column = new int[r.height];
        int[] sample = new int[r.height];
        GraphicsUtilities.getVerticalPixels(data, r.x, r.y, r.height, column);
        int lenX = r.x + r.width;
        int x = r.x;
        while (x < lenX) {
            GraphicsUtilities.getVerticalPixels(data, x, r.y, r.height, sample);
            if (!Arrays.equals(column, sample)) {
                return true;
            }
            ++x;
        }
        return false;
    }

    public Projection[][] getProjections(int width, int height, Projection[][] projections) {
        this.mPatchChunks = this.getChunks(this.mPatchChunks);
        if (this.mPatchChunks == null) {
            return null;
        }
        int lenY = this.mPatchChunks.length;
        int lenX = this.mPatchChunks[0].length;
        if (projections == null) {
            projections = new Projection[lenY][lenX];
        } else {
            int y = projections.length;
            int x = projections[0].length;
            if (lenY != y || lenX != x) {
                NinePatchedImage.recycleProjections(projections, this.mProjectionBin);
                projections = new Projection[lenY][lenX];
            }
        }
        float xZoom = (float)width / (float)this.mBaseImageData.width;
        float yZoom = (float)height / (float)this.mBaseImageData.height;
        int destX = 0;
        int destY = 0;
        int streatchableWidth = width - this.mHorizontalFixedPatchSum;
        streatchableWidth = streatchableWidth > 0 ? streatchableWidth : 1;
        int streatchableHeight = height - this.mVerticalFixedPatchSum;
        streatchableHeight = streatchableHeight > 0 ? streatchableHeight : 1;
        int yPos = 0;
        while (yPos < lenY) {
            destX = 0;
            Projection p = null;
            int xPos = 0;
            while (xPos < lenX) {
                Chunk chunk = this.mPatchChunks[yPos][xPos];
                projections[yPos][xPos] = p = this.getProjection();
                p.chunk = chunk;
                p.src = chunk.rect;
                p.dest.x = destX;
                p.dest.y = destY;
                p.dest.width = chunk.rect.width;
                p.dest.height = chunk.rect.height;
                if ((chunk.type & 1) != 0) {
                    p.dest.width = Math.round((float)streatchableWidth * chunk.horizontalWeight);
                }
                if ((chunk.type & 2) != 0) {
                    p.dest.height = Math.round((float)streatchableHeight * chunk.verticalWeight);
                }
                destX += p.dest.width;
                ++xPos;
            }
            destY += p.dest.height;
            ++yPos;
        }
        return projections;
    }

    public static class Chunk {
        public static final int TYPE_FIXED = 0;
        public static final int TYPE_HORIZONTAL = 1;
        public static final int TYPE_VERTICAL = 2;
        public static final int TYPE_CORRUPT = Integer.MIN_VALUE;
        public int type = 0;
        public Rectangle rect = new Rectangle(0, 0, 0, 0);
        public float horizontalWeight = 0.0f;
        public float verticalWeight = 0.0f;

        void init() {
            this.type = 0;
            this.horizontalWeight = 0.0f;
            this.verticalWeight = 0.0f;
            this.rect.x = 0;
            this.rect.y = 0;
            this.rect.width = 0;
            this.rect.height = 0;
        }

        private String typeToString() {
            switch (this.type) {
                case 0: {
                    return "FIXED";
                }
                case 1: {
                    return "HORIZONTAL";
                }
                case 2: {
                    return "VERTICAL";
                }
                case 3: {
                    return "BOTH";
                }
            }
            return "UNKNOWN";
        }

        public String toString() {
            return String.format("%s %f/%f %s", this.typeToString(), Float.valueOf(this.horizontalWeight), Float.valueOf(this.verticalWeight), this.rect.toString());
        }
    }

    public static class Projection {
        public Chunk chunk = null;
        public Rectangle src = null;
        public final Rectangle dest = new Rectangle(0, 0, 0, 0);

        public String toString() {
            return String.format("src[%d, %d, %d, %d] => dest[%d, %d, %d, %d]", this.src.x, this.src.y, this.src.width, this.src.height, this.dest.x, this.dest.y, this.dest.width, this.dest.height);
        }
    }

    public static class Tick {
        public int start;
        public int end;
        public int color;

        public int getLength() {
            return this.end - this.start;
        }

        public Tick(int tickColor) {
            this.color = tickColor;
        }

        public String toString() {
            return String.format("%d tick: %d to %d", this.color, this.start, this.end);
        }
    }
}

