/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.draw9patch.ui;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.draw9patch.graphics.NinePatchedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;

public class ImageViewer
extends Canvas
implements PaintListener,
KeyListener,
MouseListener,
MouseMoveListener {
    private static final boolean DEBUG = false;
    public static final String HELP_MESSAGE_KEY_TIPS = "Press Shift to erase pixels. Press Control to draw layout bounds.";
    public static final String HELP_MESSAGE_KEY_TIPS2 = "Release Shift to draw pixels.";
    private static final Color BLACK_COLOR = AdtPlugin.getDisplay().getSystemColor(2);
    private static final Color RED_COLOR = AdtPlugin.getDisplay().getSystemColor(3);
    private static final Color BACK_COLOR = new Color((Device)AdtPlugin.getDisplay(), new RGB(0, 255, 0));
    private static final Color LOCK_COLOR = new Color((Device)AdtPlugin.getDisplay(), new RGB(255, 0, 0));
    private static final Color PATCH_COLOR = new Color((Device)AdtPlugin.getDisplay(), new RGB(255, 255, 0));
    private static final Color PATCH_ONEWAY_COLOR = new Color((Device)AdtPlugin.getDisplay(), new RGB(0, 0, 255));
    private static final Color CORRUPTED_COLOR = new Color((Device)AdtPlugin.getDisplay(), new RGB(255, 0, 0));
    private static final int NONE_ALPHA = 255;
    private static final int LOCK_ALPHA = 50;
    private static final int PATCH_ALPHA = 50;
    private static final int GUIDE_ALPHA = 60;
    private static final int MODE_NONE = 0;
    private static final int MODE_BLACK_TICK = 1;
    private static final int MODE_RED_TICK = 2;
    private static final int MODE_ERASE = 255;
    private int mDrawMode = 0;
    private static final int MARGIN = 5;
    private static final String CHECKER_PNG_PATH = "/icons/checker.png";
    private Image mBackgroundLayer = null;
    private NinePatchedImage mNinePatchedImage = null;
    private NinePatchedImage.Chunk[][] mChunks = null;
    private NinePatchedImage.Chunk[][] mBadChunks = null;
    private boolean mIsLockShown = true;
    private boolean mIsPatchesShown = false;
    private boolean mIsBadPatchesShown = false;
    private ScrollBar mHorizontalBar;
    private ScrollBar mVerticalBar;
    private int mZoom = 500;
    private int mHorizontalScroll = 0;
    private int mVerticalScroll = 0;
    private final Rectangle mPadding = new Rectangle(0, 0, 0, 0);
    private int mZoomedPixelSize = 1;
    private Image mBufferImage = null;
    private boolean isCtrlPressed = false;
    private boolean isShiftPressed = false;
    private final List<UpdateListener> mUpdateListenerList = new ArrayList<UpdateListener>();
    private final Point mCursorPoint = new Point(0, 0);
    private static final int DEFAULT_UPDATE_QUEUE_SIZE = 10;
    private final ArrayBlockingQueue<NinePatchedImage> mUpdateQueue = new ArrayBlockingQueue(10);
    private final Runnable mUpdateRunnable = new Runnable(){

        @Override
        public void run() {
            if (ImageViewer.this.isDisposed()) {
                return;
            }
            ImageViewer.this.redraw();
            ImageViewer.this.fireUpdateEvent();
        }
    };
    private final Thread mUpdateThread = new Thread(){

        @Override
        public void run() {
            while (!ImageViewer.this.isDisposed()) {
                try {
                    ImageViewer.this.mUpdateQueue.take();
                    ImageViewer.this.mNinePatchedImage.findPatches();
                    ImageViewer.this.mNinePatchedImage.findContentsArea();
                    ImageViewer.this.mChunks = ImageViewer.this.mNinePatchedImage.getChunks(ImageViewer.this.mChunks);
                    ImageViewer.this.mBadChunks = ImageViewer.this.mNinePatchedImage.getCorruptedChunks(ImageViewer.this.mBadChunks);
                    AdtPlugin.getDisplay().asyncExec(ImageViewer.this.mUpdateRunnable);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    };
    private StatusChangedListener mStatusChangedListener = null;

    public void addUpdateListener(UpdateListener l) {
        this.mUpdateListenerList.add(l);
    }

    public void removeUpdateListener(UpdateListener l) {
        this.mUpdateListenerList.remove(l);
    }

    private void fireUpdateEvent() {
        int len = this.mUpdateListenerList.size();
        int i = 0;
        while (i < len) {
            this.mUpdateListenerList.get(i).update(this.mNinePatchedImage);
            ++i;
        }
    }

    public void setStatusChangedListener(StatusChangedListener l) {
        this.mStatusChangedListener = l;
        if (this.mStatusChangedListener != null) {
            this.mStatusChangedListener.helpTextChanged(HELP_MESSAGE_KEY_TIPS);
        }
    }

    void setShowLock(boolean show) {
        this.mIsLockShown = show;
        this.redraw();
    }

    void setShowPatchesArea(boolean show) {
        this.mIsPatchesShown = show;
        this.redraw();
    }

    void setShowBadPatchesArea(boolean show) {
        this.mIsBadPatchesShown = show;
        this.redraw();
    }

    void setZoom(int zoom) {
        this.mZoom = zoom;
        this.mZoomedPixelSize = this.getZoomedPixelSize(1);
        this.redraw();
    }

    public ImageViewer(Composite parent, int style) {
        super(parent, style);
        this.mUpdateThread.start();
        this.mBackgroundLayer = AdtPlugin.getImageDescriptor(CHECKER_PNG_PATH).createImage();
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        this.addPaintListener(this);
        this.mHorizontalBar = this.getHorizontalBar();
        this.mHorizontalBar.setThumb(1);
        this.mHorizontalBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                super.widgetSelected(event);
                ScrollBar bar = (ScrollBar)event.widget;
                if (ImageViewer.this.mHorizontalBar.isVisible() && ImageViewer.this.mHorizontalScroll != bar.getSelection()) {
                    ImageViewer.this.mHorizontalScroll = bar.getSelection();
                    ImageViewer.this.redraw();
                }
            }
        });
        this.mVerticalBar = this.getVerticalBar();
        this.mVerticalBar.setThumb(1);
        this.mVerticalBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                super.widgetSelected(event);
                ScrollBar bar = (ScrollBar)event.widget;
                if (ImageViewer.this.mVerticalBar.isVisible() && ImageViewer.this.mVerticalScroll != bar.getSelection()) {
                    ImageViewer.this.mVerticalScroll = bar.getSelection();
                    ImageViewer.this.redraw();
                }
            }
        });
    }

    public NinePatchedImage loadFile(String fileName) {
        this.mNinePatchedImage = new NinePatchedImage(fileName);
        return this.mNinePatchedImage;
    }

    public void startDisplay() {
        this.mZoomedPixelSize = this.getZoomedPixelSize(1);
        this.scheduleUpdate();
    }

    private void draw(int x, int y, int drawMode) {
        if (drawMode == 255) {
            this.erase(x, y);
        } else {
            int color = drawMode == 2 ? -65536 : -16777216;
            this.mNinePatchedImage.setPatch(x, y, color);
            this.redraw();
            this.scheduleUpdate();
        }
    }

    private void erase(int x, int y) {
        this.mNinePatchedImage.erase(x, y);
        this.redraw();
        this.scheduleUpdate();
    }

    private void scheduleUpdate() {
        try {
            this.mUpdateQueue.put(this.mNinePatchedImage);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void mouseDown(MouseEvent event) {
        if (event.button == 1 && !this.isShiftPressed) {
            this.mDrawMode = !this.isCtrlPressed ? 1 : 2;
            this.draw(this.mCursorPoint.x, this.mCursorPoint.y, this.mDrawMode);
        } else if (event.button == 3 || this.isShiftPressed) {
            this.mDrawMode = 255;
            this.erase(this.mCursorPoint.x, this.mCursorPoint.y);
        }
    }

    public void mouseUp(MouseEvent event) {
        this.mDrawMode = 0;
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    private int getLogicalPositionX(int x) {
        return Math.round((float)(x - this.mPadding.x + this.mHorizontalScroll) / ((float)this.mZoom / 100.0f));
    }

    private int getLogicalPositionY(int y) {
        return Math.round((float)(y - this.mPadding.y + this.mVerticalScroll) / ((float)this.mZoom / 100.0f));
    }

    public void mouseMove(MouseEvent event) {
        int posX = this.getLogicalPositionX(event.x);
        int posY = this.getLogicalPositionY(event.y);
        int width = this.mNinePatchedImage.getWidth();
        int height = this.mNinePatchedImage.getHeight();
        if (posX < 0) {
            posX = 0;
        }
        if (posX >= width) {
            posX = width - 1;
        }
        if (posY < 0) {
            posY = 0;
        }
        if (posY >= height) {
            posY = height - 1;
        }
        if (this.mDrawMode != 0) {
            int drawMode = this.mDrawMode;
            if (this.isShiftPressed) {
                drawMode = 255;
            } else if (this.mDrawMode != 255) {
                drawMode = !this.isCtrlPressed ? 1 : 2;
            }
            int x = this.mCursorPoint.x;
            int y = this.mCursorPoint.y;
            while (y != posY) {
                this.draw(x, y, drawMode);
                y += y > posY ? -1 : 1;
            }
            x = this.mCursorPoint.x;
            y = this.mCursorPoint.y;
            while (x != posX) {
                this.draw(x, y, drawMode);
                x += x > posX ? -1 : 1;
            }
        }
        this.mCursorPoint.x = posX;
        this.mCursorPoint.y = posY;
        this.redraw();
        if (this.mStatusChangedListener != null && posX >= 0 && posY >= 0 && posX <= this.mNinePatchedImage.getWidth() && posY <= this.mNinePatchedImage.getHeight()) {
            this.mStatusChangedListener.cursorPositionChanged(posX + 1, posY + 1);
        }
    }

    private synchronized void calcPaddings(int width, int height) {
        Point canvasSize = this.getSize();
        this.mPadding.width = this.getZoomedPixelSize(width);
        this.mPadding.height = this.getZoomedPixelSize(height);
        int margin = this.getZoomedPixelSize(5);
        this.mPadding.x = this.mPadding.width < canvasSize.x ? (canvasSize.x - this.mPadding.width) / 2 : margin;
        this.mPadding.y = this.mPadding.height < canvasSize.y ? (canvasSize.y - this.mPadding.height) / 2 : margin;
    }

    private void calcScrollBarSettings() {
        int value;
        int max;
        Point size = this.getSize();
        int screenWidth = size.x;
        int screenHeight = size.y;
        int imageWidth = this.getZoomedPixelSize(this.mNinePatchedImage.getWidth() + 1);
        int imageHeight = this.getZoomedPixelSize(this.mNinePatchedImage.getHeight() + 1);
        int verticalBarSize = this.mVerticalBar.getSize().x;
        int horizontalBarSize = this.mHorizontalBar.getSize().y;
        int horizontalScroll = imageWidth - (screenWidth - verticalBarSize);
        int verticalScroll = imageHeight - (screenHeight - horizontalBarSize);
        int margin = this.getZoomedPixelSize(5) * 2;
        if (horizontalScroll > 0) {
            this.mHorizontalBar.setVisible(true);
            max = horizontalScroll + verticalBarSize + margin;
            this.mHorizontalBar.setMaximum(max);
            value = this.mHorizontalBar.getSelection();
            value = max < value ? max : value;
            this.mHorizontalBar.setSelection(value);
            this.mHorizontalScroll = value;
        } else {
            this.mHorizontalBar.setSelection(0);
            this.mHorizontalBar.setMaximum(0);
            this.mHorizontalBar.setVisible(false);
        }
        if (verticalScroll > 0) {
            this.mVerticalBar.setVisible(true);
            max = verticalScroll + horizontalBarSize + margin;
            this.mVerticalBar.setMaximum(max);
            value = this.mVerticalBar.getSelection();
            value = max < value ? max : value;
            this.mVerticalBar.setSelection(value);
            this.mVerticalScroll = value;
        } else {
            this.mVerticalBar.setSelection(0);
            this.mVerticalBar.setMaximum(0);
            this.mVerticalBar.setVisible(false);
        }
    }

    private int getZoomedPixelSize(int val) {
        return Math.round((float)val * (float)this.mZoom / 100.0f);
    }

    public void paintControl(PaintEvent pe) {
        int height;
        int width;
        if (this.mNinePatchedImage == null) {
            return;
        }
        GC bufferGc = null;
        if (this.mBufferImage == null) {
            this.mBufferImage = new Image((Device)AdtPlugin.getDisplay(), pe.width, pe.height);
        } else {
            width = this.mBufferImage.getBounds().width;
            height = this.mBufferImage.getBounds().height;
            if (width != pe.width || height != pe.height) {
                this.mBufferImage = new Image((Device)AdtPlugin.getDisplay(), pe.width, pe.height);
            }
        }
        pe.gc.drawImage(this.mBufferImage, 0, 0);
        bufferGc = new GC((Drawable)this.mBufferImage);
        bufferGc.setAdvanced(true);
        bufferGc.setInterpolation(0);
        bufferGc.fillRectangle(0, 0, pe.width, pe.height);
        this.calcScrollBarSettings();
        width = this.mNinePatchedImage.getWidth();
        height = this.mNinePatchedImage.getHeight();
        this.calcPaddings(width, height);
        int baseX = this.mPadding.x - this.mHorizontalScroll;
        int baseY = this.mPadding.y - this.mVerticalScroll;
        bufferGc.drawImage(this.mBackgroundLayer, 0, 0, this.mBackgroundLayer.getImageData().width, this.mBackgroundLayer.getImageData().height, baseX, baseY, this.mPadding.width, this.mPadding.height);
        bufferGc.drawImage(this.mNinePatchedImage.getImage(), 0, 0, width, height, baseX, baseY, this.mPadding.width, this.mPadding.height);
        bufferGc.setBackground(BLACK_COLOR);
        this.drawHorizontalPatches(bufferGc, baseX, baseY);
        this.drawVerticalPatches(bufferGc, baseX, baseY);
        this.drawHorizontalContentArea(bufferGc, baseX, baseY);
        this.drawVerticalContentArea(bufferGc, baseX, baseY);
        if (this.mNinePatchedImage.isValid(this.mCursorPoint.x, this.mCursorPoint.y)) {
            bufferGc.setForeground(BLACK_COLOR);
        } else if (this.mIsLockShown) {
            this.drawLockArea(bufferGc, baseX, baseY);
        }
        if (this.mIsPatchesShown) {
            this.drawPatchAreas(bufferGc, baseX, baseY);
        }
        if (this.mIsBadPatchesShown) {
            this.drawBadPatchAreas(bufferGc, baseX, baseY);
        }
        if (this.mNinePatchedImage.isValid(this.mCursorPoint.x, this.mCursorPoint.y)) {
            bufferGc.setForeground(BLACK_COLOR);
        } else {
            bufferGc.setForeground(RED_COLOR);
        }
        this.drawGuideLine(bufferGc, baseX, baseY);
        bufferGc.dispose();
        pe.gc.drawImage(this.mBufferImage, 0, 0);
    }

    private static final Color getColor(int color) {
        switch (color) {
            case -65536: {
                return RED_COLOR;
            }
        }
        return BLACK_COLOR;
    }

    private void drawVerticalPatches(GC gc, int baseX, int baseY) {
        List<NinePatchedImage.Tick> verticalPatches = this.mNinePatchedImage.getVerticalPatches();
        for (NinePatchedImage.Tick t : verticalPatches) {
            if (t.color == 0) continue;
            gc.setBackground(ImageViewer.getColor(t.color));
            gc.fillRectangle(baseX, baseY + this.getZoomedPixelSize(t.start), this.mZoomedPixelSize, this.getZoomedPixelSize(t.getLength()));
        }
    }

    private void drawHorizontalPatches(GC gc, int baseX, int baseY) {
        List<NinePatchedImage.Tick> horizontalPatches = this.mNinePatchedImage.getHorizontalPatches();
        for (NinePatchedImage.Tick t : horizontalPatches) {
            if (t.color == 0) continue;
            gc.setBackground(ImageViewer.getColor(t.color));
            gc.fillRectangle(baseX + this.getZoomedPixelSize(t.start), baseY, this.getZoomedPixelSize(t.getLength()), this.mZoomedPixelSize);
        }
    }

    private void drawHorizontalContentArea(GC gc, int baseX, int baseY) {
        List<NinePatchedImage.Tick> horizontalContentArea = this.mNinePatchedImage.getHorizontalContents();
        for (NinePatchedImage.Tick t : horizontalContentArea) {
            if (t.color == 0) continue;
            gc.setBackground(ImageViewer.getColor(t.color));
            gc.fillRectangle(baseX + this.getZoomedPixelSize(t.start), baseY + this.getZoomedPixelSize(this.mNinePatchedImage.getHeight() - 1), this.getZoomedPixelSize(t.getLength()), this.mZoomedPixelSize);
        }
    }

    private void drawVerticalContentArea(GC gc, int baseX, int baseY) {
        List<NinePatchedImage.Tick> verticalContentArea = this.mNinePatchedImage.getVerticalContents();
        for (NinePatchedImage.Tick t : verticalContentArea) {
            if (t.color == 0) continue;
            gc.setBackground(ImageViewer.getColor(t.color));
            gc.fillRectangle(baseX + this.getZoomedPixelSize(this.mNinePatchedImage.getWidth() - 1), baseY + this.getZoomedPixelSize(t.start), this.mZoomedPixelSize, this.getZoomedPixelSize(t.getLength()));
        }
    }

    private void drawLockArea(GC gc, int baseX, int baseY) {
        gc.setAlpha(50);
        gc.setForeground(LOCK_COLOR);
        gc.setBackground(LOCK_COLOR);
        gc.fillRectangle(baseX + this.mZoomedPixelSize, baseY + this.mZoomedPixelSize, this.getZoomedPixelSize(this.mNinePatchedImage.getWidth() - 2), this.getZoomedPixelSize(this.mNinePatchedImage.getHeight() - 2));
        gc.setAlpha(255);
    }

    private void drawPatchAreas(GC gc, int baseX, int baseY) {
        if (this.mChunks != null) {
            int yLen = this.mChunks.length;
            int xLen = this.mChunks[0].length;
            gc.setAlpha(50);
            int yPos = 0;
            while (yPos < yLen) {
                int xPos = 0;
                while (xPos < xLen) {
                    NinePatchedImage.Chunk c = this.mChunks[yPos][xPos];
                    if (c.type == 0) {
                        gc.setBackground(BACK_COLOR);
                    } else if (c.type == 1) {
                        gc.setBackground(PATCH_ONEWAY_COLOR);
                    } else if (c.type == 2) {
                        gc.setBackground(PATCH_ONEWAY_COLOR);
                    } else if (c.type == 3) {
                        gc.setBackground(PATCH_COLOR);
                    }
                    Rectangle r = c.rect;
                    gc.fillRectangle(baseX + this.getZoomedPixelSize(r.x), baseY + this.getZoomedPixelSize(r.y), this.getZoomedPixelSize(r.width), this.getZoomedPixelSize(r.height));
                    ++xPos;
                }
                ++yPos;
            }
        }
        gc.setAlpha(255);
    }

    private void drawBadPatchAreas(GC gc, int baseX, int baseY) {
        if (this.mBadChunks != null) {
            int yLen = this.mBadChunks.length;
            int xLen = this.mBadChunks[0].length;
            gc.setAlpha(255);
            gc.setForeground(CORRUPTED_COLOR);
            gc.setBackground(CORRUPTED_COLOR);
            int yPos = 0;
            while (yPos < yLen) {
                int xPos = 0;
                while (xPos < xLen) {
                    NinePatchedImage.Chunk c = this.mBadChunks[yPos][xPos];
                    if ((c.type & Integer.MIN_VALUE) != 0) {
                        Rectangle r = c.rect;
                        gc.drawRectangle(baseX + this.getZoomedPixelSize(r.x), baseY + this.getZoomedPixelSize(r.y), this.getZoomedPixelSize(r.width), this.getZoomedPixelSize(r.height));
                    }
                    ++xPos;
                }
                ++yPos;
            }
        }
    }

    private void drawGuideLine(GC gc, int baseX, int baseY) {
        gc.setAntialias(1);
        gc.setInterpolation(2);
        int x = Math.round((float)this.mCursorPoint.x * ((float)this.mZoom / 100.0f) + (float)baseX + (float)this.mZoom / 100.0f / 2.0f);
        int y = Math.round((float)this.mCursorPoint.y * ((float)this.mZoom / 100.0f) + (float)baseY + (float)this.mZoom / 100.0f / 2.0f);
        gc.setAlpha(60);
        Point size = this.getSize();
        gc.drawLine(x, 0, x, size.y);
        gc.drawLine(0, y, size.x, y);
        gc.setAlpha(255);
    }

    public void keyPressed(KeyEvent event) {
        int keycode = event.keyCode;
        if (keycode == 262144) {
            this.isCtrlPressed = true;
        }
        if (keycode == 131072) {
            this.isShiftPressed = true;
            if (this.mStatusChangedListener != null) {
                this.mStatusChangedListener.helpTextChanged(HELP_MESSAGE_KEY_TIPS2);
            }
        }
    }

    public void keyReleased(KeyEvent event) {
        int keycode = event.keyCode;
        if (keycode == 262144) {
            this.isCtrlPressed = false;
        }
        if (keycode == 131072) {
            this.isShiftPressed = false;
            if (this.mStatusChangedListener != null) {
                this.mStatusChangedListener.helpTextChanged(HELP_MESSAGE_KEY_TIPS);
            }
        }
    }

    public void dispose() {
        this.mBackgroundLayer.dispose();
        super.dispose();
    }

    public static interface StatusChangedListener {
        public void cursorPositionChanged(int var1, int var2);

        public void helpTextChanged(String var1);
    }

    public static interface UpdateListener {
        public void update(NinePatchedImage var1);
    }
}

