/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.draw9patch.ui;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.draw9patch.graphics.GraphicsUtilities;
import com.android.ide.eclipse.adt.internal.editors.draw9patch.graphics.NinePatchedImage;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class StretchesViewer
extends Composite {
    private static final boolean DEBUG = false;
    private static final int PADDING_COLOR = 204;
    private static final int PADDING_COLOR_ALPHA = 100;
    private static final PaletteData PADDING_PALLET = new PaletteData(new RGB[]{new RGB(0, 0, 204)});
    private static final String CHECKER_PNG_PATH = "/icons/checker.png";
    private Image mBackgroundLayer = AdtPlugin.getImageDescriptor("/icons/checker.png").createImage();
    private final StretchView mHorizontal;
    private final StretchView mVertical;
    private final StretchView mBoth;
    private NinePatchedImage mNinePatchedImage = null;
    private ImageData mContentAreaImageData = null;
    private boolean mIsContentAreaShown = false;
    private Image mContentAreaImage = null;
    private int mScale = 2;

    public StretchesViewer(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout(512));
        this.mHorizontal = new StretchView(this, 0);
        this.mVertical = new StretchView(this, 0);
        this.mBoth = new StretchView(this, 0);
    }

    public void setShowContentArea(boolean show) {
        this.mIsContentAreaShown = show;
        this.redraw();
    }

    private static final boolean equalSize(ImageData image1, ImageData image2) {
        return image1.width == image2.width && image1.height == image2.height;
    }

    public void updatePreview(NinePatchedImage image) {
        this.mNinePatchedImage = image;
        ImageData base = this.mNinePatchedImage.getImageData();
        if (this.mContentAreaImageData == null || this.mContentAreaImageData != null && !StretchesViewer.equalSize(base, this.mContentAreaImageData)) {
            this.mContentAreaImageData = new ImageData(base.width, base.height, 1, PADDING_PALLET);
        } else {
            GraphicsUtilities.clearImageData(this.mContentAreaImageData);
        }
        this.mHorizontal.setImage(this.mNinePatchedImage);
        this.mVertical.setImage(this.mNinePatchedImage);
        this.mBoth.setImage(this.mNinePatchedImage);
        this.mContentAreaImage = this.buildContentAreaPreview();
        this.setScale(this.mScale);
    }

    private Image buildContentAreaPreview() {
        if (this.mContentAreaImage != null) {
            this.mContentAreaImage.dispose();
        }
        Rectangle rect = this.mNinePatchedImage.getContentArea();
        int yLen = rect.y + rect.height;
        int y = rect.y;
        while (y < yLen) {
            int xLen = rect.x + rect.width;
            int x = rect.x;
            while (x < xLen) {
                this.mContentAreaImageData.setPixel(x, y, 204);
                this.mContentAreaImageData.setAlpha(x, y, 100);
                ++x;
            }
            ++y;
        }
        return new Image((Device)AdtPlugin.getDisplay(), this.mContentAreaImageData);
    }

    public void setScale(int scale) {
        this.mScale = scale;
        int imageWidth = this.mNinePatchedImage.getWidth();
        int imageHeight = this.mNinePatchedImage.getHeight();
        this.mHorizontal.setSize(imageWidth * scale, imageHeight);
        this.mVertical.setSize(imageWidth, imageHeight * scale);
        this.mBoth.setSize(imageWidth * scale, imageHeight * scale);
        this.redraw();
    }

    public void dispose() {
        this.mBackgroundLayer.dispose();
        super.dispose();
    }

    private class StretchView
    extends Canvas
    implements PaintListener {
        private final Point mSize;
        private final Rectangle mPadding;
        private NinePatchedImage.Projection[][] mProjection;

        public StretchView(Composite parent, int style) {
            super(parent, style);
            this.mSize = new Point(0, 0);
            this.mPadding = new Rectangle(0, 0, 0, 0);
            this.mProjection = null;
            this.addPaintListener(this);
        }

        private void setImage(NinePatchedImage image) {
            this.setSize(image.getWidth(), image.getHeight());
        }

        public void setSize(int width, int heigh) {
            this.mSize.x = width;
            this.mSize.y = heigh;
            this.mProjection = StretchesViewer.this.mNinePatchedImage.getProjections(this.mSize.x, this.mSize.y, this.mProjection);
        }

        private synchronized void calcPaddings(int width, int height) {
            Point canvasSize = this.getSize();
            this.mPadding.x = (canvasSize.x - width) / 2;
            this.mPadding.y = (canvasSize.y - height) / 2;
            this.mPadding.width = width;
            this.mPadding.height = height;
        }

        public void paintControl(PaintEvent pe) {
            if (StretchesViewer.this.mNinePatchedImage == null || this.mProjection == null) {
                return;
            }
            Point size = this.getSize();
            float ratio = 1.0f;
            float wRatio = (float)size.x / (float)this.mSize.x;
            ratio = Math.min(wRatio, ratio);
            float hRatio = (float)size.y / (float)this.mSize.y;
            ratio = Math.min(hRatio, ratio);
            int width = Math.round((float)this.mSize.x * ratio);
            int height = Math.round((float)this.mSize.y * ratio);
            this.calcPaddings(width, height);
            Rectangle dest = new Rectangle(0, 0, 0, 0);
            GC gc = pe.gc;
            int backgroundLayerWidth = ((StretchesViewer)StretchesViewer.this).mBackgroundLayer.getImageData().width;
            int backgroundLayerHeight = ((StretchesViewer)StretchesViewer.this).mBackgroundLayer.getImageData().height;
            int yCount = size.y / backgroundLayerHeight + (size.y % backgroundLayerHeight > 0 ? 1 : 0);
            int xCount = size.x / backgroundLayerWidth + (size.x % backgroundLayerWidth > 0 ? 1 : 0);
            int y = 0;
            while (y < yCount) {
                int x = 0;
                while (x < xCount) {
                    gc.drawImage(StretchesViewer.this.mBackgroundLayer, x * backgroundLayerWidth, y * backgroundLayerHeight);
                    ++x;
                }
                ++y;
            }
            gc.setAlpha(136);
            gc.drawRectangle(0, 0, size.x, size.y);
            gc.setAlpha(255);
            int yLen = this.mProjection.length;
            int xLen = this.mProjection[0].length;
            int yPos = 0;
            while (yPos < yLen) {
                int xPos = 0;
                while (xPos < xLen) {
                    NinePatchedImage.Projection p = this.mProjection[yPos][xPos];
                    dest.x = (int)Math.ceil((float)p.dest.x * ratio);
                    dest.y = (int)Math.ceil((float)p.dest.y * ratio);
                    dest.width = (int)Math.ceil((float)p.dest.width * ratio);
                    dest.height = (int)Math.ceil((float)p.dest.height * ratio);
                    gc.drawImage(StretchesViewer.this.mNinePatchedImage.getImage(), p.src.x, p.src.y, p.src.width, p.src.height, this.mPadding.x + dest.x, this.mPadding.y + dest.y, dest.width, dest.height);
                    if (StretchesViewer.this.mIsContentAreaShown) {
                        gc.drawImage(StretchesViewer.this.mContentAreaImage, p.src.x, p.src.y, p.src.width, p.src.height, this.mPadding.x + dest.x, this.mPadding.y + dest.y, dest.width, dest.height);
                    }
                    ++xPos;
                }
                ++yPos;
            }
        }
    }
}

