/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.export;

import com.android.SdkConstants;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.export.ExportEditor;
import com.android.ide.eclipse.adt.internal.editors.ui.SectionHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

abstract class AbstractPropertiesFieldsPart
extends SectionHelper.ManifestSectionPart {
    private final HashMap<String, Control> mNameToField = new HashMap();
    private ExportEditor mEditor;
    private boolean mInternalTextUpdate = false;

    public AbstractPropertiesFieldsPart(Composite body, FormToolkit toolkit, ExportEditor editor) {
        super(body, toolkit, 66, true);
        this.mEditor = editor;
    }

    protected HashMap<String, Control> getNameToField() {
        return this.mNameToField;
    }

    protected ExportEditor getEditor() {
        return this.mEditor;
    }

    protected void setInternalTextUpdate(boolean internalTextUpdate) {
        this.mInternalTextUpdate = internalTextUpdate;
    }

    protected boolean isInternalTextUpdate() {
        return this.mInternalTextUpdate;
    }

    protected void addModifyListenerToFields() {
        ModifyListener markDirtyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!AbstractPropertiesFieldsPart.this.mInternalTextUpdate) {
                    AbstractPropertiesFieldsPart.this.markDirty();
                }
            }
        };
        for (Control field : this.mNameToField.values()) {
            this.setFieldModifyListener(field, markDirtyListener);
        }
    }

    protected void setFieldModifyListener(Control field, ModifyListener markDirtyListener) {
        if (field instanceof Text) {
            ((Text)field).addModifyListener(markDirtyListener);
        }
    }

    public void commit(boolean onSave) {
        if (this.isDirty()) {
            this.mEditor.wrapRewriteSession(new Runnable(){

                @Override
                public void run() {
                    AbstractPropertiesFieldsPart.this.saveFieldsToModel();
                }
            });
        }
        super.commit(onSave);
    }

    private void saveFieldsToModel() {
        HashSet<String> allKeywords = new HashSet<String>(this.mNameToField.keySet());
        IDocument doc = this.mEditor.getDocument();
        int numLines = doc.getNumberOfLines();
        String delim = null;
        try {
            delim = numLines > 0 ? doc.getLineDelimiter(0) : null;
        }
        catch (BadLocationException badLocationException) {}
        if (delim == null || delim.length() == 0) {
            delim = SdkConstants.CURRENT_PLATFORM == 2 ? "\r\n" : "\n";
        }
        int i = 0;
        while (i < numLines) {
            block17: {
                try {
                    String key;
                    Control field;
                    int pos;
                    IRegion info = doc.getLineInformation(i);
                    String line = doc.get(info.getOffset(), info.getLength());
                    line = line.trim();
                    if (line.startsWith("#") || (pos = line.indexOf(61)) <= 0 || pos >= line.length() - 1 || (field = this.mNameToField.get(key = line.substring(0, pos).trim())) == null) break block17;
                    line = String.valueOf(key) + "=" + this.getFieldText(field);
                    try {
                        this.mInternalTextUpdate = true;
                        doc.replace(info.getOffset(), info.getLength(), line);
                        allKeywords.remove(key);
                    }
                    finally {
                        this.mInternalTextUpdate = false;
                    }
                }
                catch (BadLocationException e) {
                    AdtPlugin.log(e, "Failed to replace in export.properties", new Object[0]);
                }
            }
            ++i;
        }
        for (String key : allKeywords) {
            Control field = this.mNameToField.get(key);
            if (field == null) continue;
            String line = String.valueOf(key) + "=" + this.getFieldText(field);
            try {
                try {
                    IRegion info;
                    this.mInternalTextUpdate = true;
                    numLines = doc.getNumberOfLines();
                    IRegion iRegion = info = numLines > 0 ? doc.getLineInformation(numLines - 1) : null;
                    if (info != null && info.getLength() == 0) {
                        doc.replace(info.getOffset(), info.getLength(), line);
                    } else {
                        String eofDelim;
                        if (numLines > 0 && ((eofDelim = doc.getLineDelimiter(numLines - 1)) == null || eofDelim.length() == 0)) {
                            line = String.valueOf(delim) + line;
                        }
                        int len = doc.getLength();
                        doc.replace(len, 0, line);
                    }
                    allKeywords.remove(key);
                }
                catch (BadLocationException e) {
                    AdtPlugin.log(e, "Failed to append to export.properties: %s", line);
                    this.mInternalTextUpdate = false;
                    continue;
                }
            }
            catch (Throwable throwable) {
                this.mInternalTextUpdate = false;
                throw throwable;
            }
            this.mInternalTextUpdate = false;
        }
    }

    protected String getFieldText(Control field) {
        if (field instanceof Text) {
            return ((Text)field).getText();
        }
        return "";
    }

    public void onModelInit(ExportEditor editor) {
        HashSet<String> allKeywords = new HashSet<String>(this.mNameToField.keySet());
        IDocument doc = editor.getDocument();
        int numLines = doc.getNumberOfLines();
        int i = 0;
        while (i < numLines) {
            block10: {
                try {
                    String key;
                    Control field;
                    int pos;
                    IRegion info = doc.getLineInformation(i);
                    String line = doc.get(info.getOffset(), info.getLength());
                    line = line.trim();
                    if (line.startsWith("#") || (pos = line.indexOf(61)) <= 0 || pos >= line.length() - 1 || (field = this.mNameToField.get(key = line.substring(0, pos).trim())) == null) break block10;
                    String value = line.substring(pos + 1).trim();
                    try {
                        this.mInternalTextUpdate = true;
                        this.setFieldText(field, value);
                        allKeywords.remove(key);
                    }
                    finally {
                        this.mInternalTextUpdate = false;
                    }
                }
                catch (BadLocationException e) {
                    AdtPlugin.log(e, "Failed to set field to export.properties value", new Object[0]);
                }
            }
            ++i;
        }
        Iterator<String> iterator = allKeywords.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            Control field = this.mNameToField.get(key);
            if (field == null) continue;
            try {
                this.mInternalTextUpdate = true;
                this.setFieldText(field, "");
                iterator.remove();
            }
            finally {
                this.mInternalTextUpdate = false;
            }
        }
    }

    protected void setFieldText(Control field, String value) {
        if (field instanceof Text) {
            ((Text)field).setText(value);
        }
    }

    public void onModelChanged(ExportEditor editor, DocumentEvent event) {
        if (!this.mInternalTextUpdate) {
            this.onModelInit(editor);
        }
    }
}

