/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.formatting;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.xml.XmlFormatPreferences;
import com.android.ide.common.xml.XmlFormatStyle;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.ide.eclipse.adt.internal.editors.formatting.EclipseXmlFormatPreferences;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.DomUtilities;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.utils.SdkUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EclipseXmlPrettyPrinter
extends XmlPrettyPrinter {
    public EclipseXmlPrettyPrinter(XmlFormatPreferences prefs, XmlFormatStyle style, String lineSeparator) {
        super(prefs, style, lineSeparator == null ? EclipseXmlPrettyPrinter.getDefaultLineSeparator() : lineSeparator);
    }

    @NonNull
    public static String prettyPrint(@NonNull String xml, @NonNull XmlFormatPreferences prefs, @NonNull XmlFormatStyle style, @Nullable String lineSeparator) {
        org.w3c.dom.Document document = DomUtilities.parseStructuredDocument(xml);
        if (document != null) {
            EclipseXmlPrettyPrinter printer = new EclipseXmlPrettyPrinter(prefs, style, lineSeparator);
            if (xml.endsWith("\n")) {
                printer.setEndWithNewline(true);
            }
            StringBuilder sb = new StringBuilder(3 * xml.length() / 2);
            printer.prettyPrint(-1, document, null, null, sb, false);
            return sb.toString();
        }
        return xml;
    }

    @NonNull
    public static String prettyPrint(@NonNull Node node, boolean endWithNewline) {
        return EclipseXmlPrettyPrinter.prettyPrint(node, EclipseXmlFormatPreferences.create(), XmlFormatStyle.get((Node)node), null, endWithNewline);
    }

    private static String getDefaultLineSeparator() {
        Document blank = new Document();
        String lineSeparator = TextUtilities.getDefaultLineDelimiter((IDocument)blank);
        if (lineSeparator == null) {
            lineSeparator = SdkUtils.getLineSeparator();
        }
        return lineSeparator;
    }

    @NonNull
    public static String prettyPrint(@NonNull Node node, @NonNull XmlFormatPreferences prefs, @NonNull XmlFormatStyle style, @Nullable String lineSeparator, boolean endWithNewline) {
        EclipseXmlPrettyPrinter printer = new EclipseXmlPrettyPrinter(prefs, style, lineSeparator);
        printer.setEndWithNewline(endWithNewline);
        StringBuilder sb = new StringBuilder(1000);
        printer.prettyPrint(-1, node, null, null, sb, false);
        String xml = sb.toString();
        if (node.getNodeType() == 9 && !xml.startsWith("<?")) {
            xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" + xml;
        }
        return xml;
    }

    @Nullable
    protected String getSource(@NonNull Node node) {
        if (node instanceof IDOMNode) {
            IDOMNode textImpl = (IDOMNode)node;
            return textImpl.getSource();
        }
        return super.getSource(node);
    }

    protected boolean isEmptyTag(Element element) {
        IDOMElement elementImpl;
        return element instanceof IDOMElement && (elementImpl = (IDOMElement)element).isEmptyTag();
    }

    public static XmlFormatStyle get(ResourceType resourceType) {
        switch (resourceType) {
            case ARRAY: 
            case ATTR: 
            case BOOL: 
            case COLOR: 
            case DECLARE_STYLEABLE: 
            case DIMEN: 
            case FRACTION: 
            case ID: 
            case INTEGER: 
            case PLURALS: 
            case STRING: 
            case STYLE: 
            case STYLEABLE: {
                return XmlFormatStyle.RESOURCE;
            }
            case LAYOUT: {
                return XmlFormatStyle.LAYOUT;
            }
        }
        return XmlFormatStyle.FILE;
    }

    public static XmlFormatStyle getForFolderType(ResourceFolderType folderType) {
        switch (folderType) {
            case LAYOUT: {
                return XmlFormatStyle.LAYOUT;
            }
            case COLOR: 
            case VALUES: {
                return XmlFormatStyle.RESOURCE;
            }
        }
        return XmlFormatStyle.FILE;
    }

    public static XmlFormatStyle getForFile(IPath path) {
        if ("AndroidManifest.xml".equals(path.lastSegment())) {
            return XmlFormatStyle.MANIFEST;
        }
        if (path.segmentCount() > 2) {
            String parentName = path.segment(path.segmentCount() - 2);
            ResourceFolderType folderType = ResourceFolderType.getFolderType((String)parentName);
            return EclipseXmlPrettyPrinter.getForFolderType(folderType);
        }
        return XmlFormatStyle.FILE;
    }
}

