/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.configuration;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.configuration.LanguageQualifier;
import com.android.ide.common.resources.configuration.RegionQualifier;
import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.DesignerPlugin;

public class FlagManager {
    private static final FlagManager sInstance = new FlagManager();
    private Map<String, Image> mImageMap = Maps.newHashMap();

    @NonNull
    public static FlagManager get() {
        return sInstance;
    }

    private FlagManager() {
    }

    public static Image getEmptyIcon() {
        return DesignerPlugin.getImage((String)"nls/flags/flag_empty.png");
    }

    public static Image getGlobeIcon() {
        return IconFactory.getInstance().getIcon("globe");
    }

    @Nullable
    public Image getFlag(@Nullable String language, @Nullable String region) {
        assert (region != null || language != null);
        if (region == null || region.isEmpty()) {
            Image flag;
            assert (language != null);
            Locale locale = Locale.getDefault();
            if (language.equals(locale.getLanguage()) && (flag = this.getFlag(locale.getCountry())) != null) {
                return flag;
            }
            region = language.equals("ca") ? "catalonia" : (language.equals("gd") ? "scotland" : (language.equals("cy") ? "wales" : LocaleManager.getLanguageRegion((String)language)));
        }
        if (region == null || region.isEmpty()) {
            return null;
        }
        return this.getIcon(region);
    }

    public Image getFlag(LanguageQualifier language, RegionQualifier region) {
        String regionCode;
        String languageCode = language != null ? language.getValue() : null;
        String string = regionCode = region != null ? region.getValue() : null;
        if ("__".equals(languageCode)) {
            languageCode = null;
        }
        if ("__".equals(regionCode)) {
            regionCode = null;
        }
        return this.getFlag(languageCode, regionCode);
    }

    @Nullable
    public Image getFlagForFolderName(@NonNull String folder) {
        RegionQualifier region = null;
        LanguageQualifier language = null;
        for (String qualifier : Splitter.on((char)'-').split((CharSequence)folder)) {
            if (qualifier.length() == 3) {
                region = RegionQualifier.getQualifier((String)qualifier);
                if (region == null) continue;
                break;
            }
            if (qualifier.length() != 2 || language != null) continue;
            language = LanguageQualifier.getQualifier((String)qualifier);
        }
        if (region != null || language != null) {
            return FlagManager.get().getFlag(language, region);
        }
        return null;
    }

    @Nullable
    public Image getFlag(@NonNull String region) {
        assert (region.length() == 2 && Character.isUpperCase(region.charAt(0)) && Character.isUpperCase(region.charAt(1))) : region;
        return this.getIcon(region);
    }

    private Image getIcon(@NonNull String base) {
        Image flagImage = this.mImageMap.get(base);
        if (flagImage == null) {
            if (this.mImageMap.containsKey(base)) {
                return null;
            }
            String flagFileName = String.valueOf(base.toLowerCase(Locale.US)) + ".png";
            flagImage = DesignerPlugin.getImage((String)("nls/flags/" + flagFileName));
            this.mImageMap.put(base, flagImage);
        }
        return flagImage;
    }
}

