/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.descriptors;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.platform.AttributeInfo;
import com.android.ide.common.resources.platform.AttrsXmlParser;
import com.android.ide.common.resources.platform.ViewClassInfo;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DescriptorsUtils;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.descriptors.LayoutDescriptors;
import com.android.ide.eclipse.adt.internal.editors.layout.descriptors.ViewElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.manifest.ManifestInfo;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectResources;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceManager;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.ide.eclipse.adt.internal.sdk.ProjectState;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.google.common.collect.Maps;
import com.google.common.collect.ObjectArrays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.graphics.Image;

public final class CustomViewDescriptorService {
    private static CustomViewDescriptorService sThis = new CustomViewDescriptorService();
    private HashMap<IProject, HashMap<String, ViewElementDescriptor>> mCustomDescriptorMap = new HashMap();
    private ICustomViewDescriptorListener mListener;
    private Map<ResourceFile, AttrsXmlParser> mParserCache;
    private static long sLastCheck;

    public static CustomViewDescriptorService getInstance() {
        return sThis;
    }

    public void setListener(ICustomViewDescriptorListener listener) {
        this.mListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewElementDescriptor getDescriptor(IProject project, String fqcn) {
        HashMap<IProject, HashMap<String, ViewElementDescriptor>> hashMap = this.mCustomDescriptorMap;
        synchronized (hashMap) {
            block12: {
                ViewElementDescriptor descriptor;
                HashMap<String, ViewElementDescriptor> map = this.mCustomDescriptorMap.get(project);
                if (map != null && (descriptor = map.get(fqcn)) != null) {
                    return descriptor;
                }
                try {
                    ITypeHierarchy hierarchy;
                    ViewElementDescriptor parentDescriptor;
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    String javaClassName = fqcn.replaceAll("\\$", "\\.");
                    IType type = javaProject.findType(javaClassName);
                    if (type == null || !type.exists() || (parentDescriptor = this.createViewDescriptor((hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor())).getSuperclass(type), project, hierarchy)) == null) break block12;
                    ArrayList<AttributeDescriptor> attrList = new ArrayList<AttributeDescriptor>();
                    ArrayList<AttributeDescriptor> paramList = new ArrayList<AttributeDescriptor>();
                    Map<ResourceFile, Long> files = this.findCustomDescriptors(project, type, attrList, paramList);
                    AttributeDescriptor[] attributes = CustomViewDescriptorService.getAttributeDescriptor(type, parentDescriptor);
                    if (!attrList.isEmpty()) {
                        attributes = CustomViewDescriptorService.join(attrList, attributes);
                    }
                    AttributeDescriptor[] layoutAttributes = CustomViewDescriptorService.getLayoutAttributeDescriptors(type, parentDescriptor);
                    if (!paramList.isEmpty()) {
                        layoutAttributes = CustomViewDescriptorService.join(paramList, layoutAttributes);
                    }
                    String name = DescriptorsUtils.getBasename(fqcn);
                    CustomViewDescriptor descriptor2 = new CustomViewDescriptor(name, fqcn, attributes, layoutAttributes, parentDescriptor.getChildren(), project, files);
                    descriptor2.setSuperClass(parentDescriptor);
                    HashMap<IProject, HashMap<String, ViewElementDescriptor>> hashMap2 = this.mCustomDescriptorMap;
                    synchronized (hashMap2) {
                        map = this.mCustomDescriptorMap.get(project);
                        if (map == null) {
                            map = new HashMap();
                            this.mCustomDescriptorMap.put(project, map);
                        }
                        map.put(fqcn, descriptor2);
                    }
                    return descriptor2;
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        return null;
    }

    private static AttributeDescriptor[] join(@NonNull List<AttributeDescriptor> attributeList, @NonNull AttributeDescriptor[] attributes) {
        if (!attributeList.isEmpty()) {
            return (AttributeDescriptor[])ObjectArrays.concat((Object[])attributeList.toArray(new AttributeDescriptor[attributeList.size()]), (Object[])attributes, AttributeDescriptor.class);
        }
        return attributes;
    }

    private AttrsXmlParser getParser(ResourceFile file) {
        AttrsXmlParser parser;
        if (this.mParserCache == null) {
            this.mParserCache = new HashMap<ResourceFile, AttrsXmlParser>();
        }
        if ((parser = this.mParserCache.get(file)) == null) {
            parser = new AttrsXmlParser(file.getFile().getOsLocation(), AdtPlugin.getDefault(), 20);
            parser.preload();
            this.mParserCache.put(file, parser);
        }
        return parser;
    }

    private Map<ResourceFile, Long> findCustomDescriptors(IProject project, IType type, List<AttributeDescriptor> customAttributes, List<AttributeDescriptor> customLayoutAttributes) {
        String className;
        Set<ResourceFile> resourceFiles;
        IProject library = CustomViewDescriptorService.getProjectDeclaringType(type);
        if (library == null) {
            library = project;
        }
        if ((resourceFiles = CustomViewDescriptorService.findAttrsFiles(library, className = type.getElementName())) != null && resourceFiles.size() > 0) {
            String appUri = CustomViewDescriptorService.getAppResUri(project);
            HashMap timestamps = Maps.newHashMapWithExpectedSize((int)resourceFiles.size());
            for (ResourceFile file : resourceFiles) {
                AttrsXmlParser attrsXmlParser = this.getParser(file);
                String fqcn = type.getFullyQualifiedName();
                ViewClassInfo classInfo = new ViewClassInfo(true, fqcn, className);
                attrsXmlParser.loadViewAttributes(classInfo);
                CustomViewDescriptorService.appendAttributes(customAttributes, classInfo.getAttributes(), appUri);
                ViewClassInfo.LayoutParamsInfo layoutInfo = new ViewClassInfo.LayoutParamsInfo(classInfo, "Layout", null);
                attrsXmlParser.loadLayoutParamsAttributes(layoutInfo);
                CustomViewDescriptorService.appendAttributes(customLayoutAttributes, layoutInfo.getAttributes(), appUri);
                timestamps.put(file, file.getFile().getModificationStamp());
            }
            return timestamps;
        }
        return null;
    }

    @Nullable
    private static Set<ResourceFile> findAttrsFiles(IProject library, String className) {
        HashSet resourceFiles = null;
        ResourceManager manager = ResourceManager.getInstance();
        ProjectResources resources = manager.getProjectResources(library);
        if (resources != null) {
            Collection items = resources.getResourceItemsOfType(ResourceType.DECLARE_STYLEABLE);
            for (ResourceItem item : items) {
                String viewName = item.getName();
                if (!viewName.equals(className) && (!viewName.startsWith(className) || !viewName.equals(String.valueOf(className) + "_Layout"))) continue;
                if (resourceFiles == null) {
                    resourceFiles = new HashSet();
                }
                resourceFiles.addAll(item.getSourceFileList());
            }
        }
        return resourceFiles;
    }

    @Nullable
    private static IProject getProjectDeclaringType(IType type) {
        IClassFile classFile = type.getClassFile();
        if (classFile != null) {
            IPath path = classFile.getPath();
            IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
            IResource resource = path.isAbsolute() ? AdtUtils.fileToResource(path.toFile()) : workspace.findMember(path);
            if (resource != null && resource.getProject() != null) {
                return resource.getProject();
            }
        }
        return null;
    }

    private static String getAppResUri(IProject project) {
        String appResource;
        ProjectState projectState = Sdk.getProjectState(project);
        if (projectState != null && projectState.isLibrary()) {
            appResource = "http://schemas.android.com/apk/res-auto";
        } else {
            ManifestInfo manifestInfo = ManifestInfo.get(project);
            appResource = "http://schemas.android.com/apk/res/" + manifestInfo.getPackage();
        }
        return appResource;
    }

    private static void appendAttributes(List<AttributeDescriptor> attributes, AttributeInfo[] attributeInfos, String appResource) {
        AttributeInfo[] attributeInfoArray = attributeInfos;
        int n = attributeInfos.length;
        int n2 = 0;
        while (n2 < n) {
            String nsUri;
            AttributeInfo info = attributeInfoArray[n2];
            if (info.getName().startsWith("android:")) {
                info.setName(info.getName().substring("android:".length()));
                nsUri = "http://schemas.android.com/apk/res/android";
            } else {
                nsUri = appResource;
            }
            DescriptorsUtils.appendAttribute(attributes, null, nsUri, info, false, null);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ViewElementDescriptor createViewDescriptor(IType type, IProject project, ITypeHierarchy typeHierarchy) {
        ViewElementDescriptor parentDescriptor;
        AndroidTargetData data;
        IAndroidTarget target;
        List<ViewElementDescriptor> builtInList = null;
        if (type == null) {
            return null;
        }
        String fqcn = type.getFullyQualifiedName();
        Sdk currentSdk = Sdk.getCurrent();
        if (currentSdk != null && (target = currentSdk.getTarget(project)) != null && (data = currentSdk.getTargetData(target)) != null) {
            LayoutDescriptors descriptors = data.getLayoutDescriptors();
            ViewElementDescriptor d = descriptors.findDescriptorByClass(fqcn);
            if (d != null) {
                return d;
            }
            builtInList = descriptors.getViewDescriptors();
        }
        if (typeHierarchy == null) {
            return null;
        }
        IType parentType = typeHierarchy.getSuperclass(type);
        if (parentType != null && (parentDescriptor = this.createViewDescriptor(parentType, project, typeHierarchy)) != null) {
            String name = DescriptorsUtils.getBasename(fqcn);
            boolean isViewGroup = fqcn.equals("android.view.ViewGroup");
            boolean hasChildren = isViewGroup || parentDescriptor.hasChildren();
            ElementDescriptor[] children = null;
            if (hasChildren && builtInList != null) {
                children = builtInList.toArray(new ViewElementDescriptor[builtInList.size()]);
            }
            CustomViewDescriptor descriptor = new CustomViewDescriptor(name, fqcn, CustomViewDescriptorService.getAttributeDescriptor(type, parentDescriptor), CustomViewDescriptorService.getLayoutAttributeDescriptors(type, parentDescriptor), children, project, null);
            descriptor.setSuperClass(parentDescriptor);
            HashMap<IProject, HashMap<String, ViewElementDescriptor>> hashMap = this.mCustomDescriptorMap;
            synchronized (hashMap) {
                HashMap<String, ViewElementDescriptor> map = this.mCustomDescriptorMap.get(project);
                if (map == null) {
                    map = new HashMap();
                    this.mCustomDescriptorMap.put(project, map);
                }
                map.put(fqcn, descriptor);
            }
            return descriptor;
        }
        return null;
    }

    private static AttributeDescriptor[] getAttributeDescriptor(IType type, ViewElementDescriptor parentDescriptor) {
        return parentDescriptor.getAttributes();
    }

    private static AttributeDescriptor[] getLayoutAttributeDescriptors(IType type, ViewElementDescriptor parentDescriptor) {
        return parentDescriptor.getLayoutAttributes();
    }

    private class CustomViewDescriptor
    extends ViewElementDescriptor {
        private Map<ResourceFile, Long> mTimeStamps;
        private IProject mProject;

        public CustomViewDescriptor(String name, String fqcn, AttributeDescriptor[] attributes, AttributeDescriptor[] layoutAttributes, ElementDescriptor[] children, IProject project, Map<ResourceFile, Long> timestamps) {
            super(fqcn, name, fqcn, fqcn, null, attributes, layoutAttributes, children, false);
            this.mTimeStamps = timestamps;
            this.mProject = project;
        }

        @Override
        public Image getGenericIcon() {
            IconFactory iconFactory = IconFactory.getInstance();
            int index = this.mXmlName.lastIndexOf(46);
            if (index != -1) {
                return iconFactory.getIcon(this.mXmlName.substring(index + 1), "customView");
            }
            return iconFactory.getIcon("customView");
        }

        @Override
        public boolean syncAttributes() {
            if (this.mTimeStamps != null) {
                long now = System.currentTimeMillis();
                if (now - sLastCheck < 1000L) {
                    return true;
                }
                sLastCheck = now;
                for (Map.Entry<ResourceFile, Long> entry : this.mTimeStamps.entrySet()) {
                    ResourceFile file = entry.getKey();
                    Long timestamp = entry.getValue();
                    boolean recompute = false;
                    if (file.getFile().getModificationStamp() > timestamp) {
                        recompute = true;
                        CustomViewDescriptorService.this.mParserCache.remove(file);
                    }
                    if (!recompute) continue;
                    IJavaProject javaProject = JavaCore.create((IProject)this.mProject);
                    String fqcn = this.getFullClassName();
                    IType type = null;
                    try {
                        type = javaProject.findType(fqcn);
                    }
                    catch (CoreException e) {
                        AdtPlugin.log(e, null, new Object[0]);
                    }
                    if (type == null || !type.exists()) {
                        return true;
                    }
                    ArrayList attrList = new ArrayList();
                    ArrayList paramList = new ArrayList();
                    this.mTimeStamps = CustomViewDescriptorService.this.findCustomDescriptors(this.mProject, type, attrList, paramList);
                    ViewElementDescriptor parentDescriptor = this.getSuperClassDesc();
                    AttributeDescriptor[] attributes = CustomViewDescriptorService.getAttributeDescriptor(type, parentDescriptor);
                    if (!attrList.isEmpty()) {
                        attributes = CustomViewDescriptorService.join(attrList, attributes);
                    }
                    attributes = attrList.toArray(new AttributeDescriptor[attrList.size()]);
                    this.setAttributes(attributes);
                    return false;
                }
            }
            return true;
        }
    }

    public static interface ICustomViewDescriptorListener {
        public void updatedClassInfo(IProject var1, String var2, ViewElementDescriptor var3);
    }
}

