/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gle2;

import com.android.annotations.Nullable;
import com.android.ide.common.api.Rect;
import java.util.ArrayList;
import java.util.List;

class BinPacker {
    private static final boolean DEBUG = false;
    private final List<Rect> mSpace = new ArrayList<Rect>();
    private final int mMinHeight;
    private final int mMinWidth;
    private List<Rect> mAllocated;
    private static int sLayoutId;
    private static int sRectId;

    BinPacker(int minWidth, int minHeight) {
        this.mMinWidth = minWidth;
        this.mMinHeight = minHeight;
    }

    void addSpace(Rect rect) {
        if (rect.w >= this.mMinWidth && rect.h >= this.mMinHeight) {
            this.mSpace.add(rect);
        }
    }

    @Nullable
    Rect occupy(int width, int height) {
        int index = this.findBest(width, height);
        if (index == -1) {
            return null;
        }
        return this.split(index, width, height);
    }

    private int findBest(int width, int height) {
        if (this.mSpace.isEmpty()) {
            return -1;
        }
        int bestIndex = -1;
        boolean multipleAtSameY = false;
        int minY = Integer.MAX_VALUE;
        int i = 0;
        int n = this.mSpace.size();
        while (i < n) {
            Rect rect = this.mSpace.get(i);
            if (rect.y <= minY && rect.w >= width && rect.h >= height) {
                if (rect.y < minY) {
                    minY = rect.y;
                    multipleAtSameY = false;
                    bestIndex = i;
                } else if (minY == rect.y) {
                    multipleAtSameY = true;
                }
            }
            ++i;
        }
        if (!multipleAtSameY) {
            return bestIndex;
        }
        bestIndex = -1;
        int bestShortDistance = Integer.MAX_VALUE;
        int bestLongDistance = Integer.MAX_VALUE;
        int i2 = 0;
        int n2 = this.mSpace.size();
        while (i2 < n2) {
            Rect rect = this.mSpace.get(i2);
            if (rect.y == minY && rect.w >= width && rect.h >= height) {
                int distance;
                if (width < height) {
                    distance = rect.w - width;
                    if (distance < bestShortDistance || distance == bestShortDistance && rect.h - height < bestLongDistance) {
                        bestShortDistance = distance;
                        bestLongDistance = rect.h - height;
                        bestIndex = i2;
                    }
                } else {
                    distance = rect.w - width;
                    if (distance < bestShortDistance || distance == bestShortDistance && rect.h - height < bestLongDistance) {
                        bestShortDistance = distance;
                        bestLongDistance = rect.h - height;
                        bestIndex = i2;
                    }
                }
            }
            ++i2;
        }
        return bestIndex;
    }

    private void removeRect(int index) {
        assert (!this.mSpace.isEmpty());
        int lastIndex = this.mSpace.size() - 1;
        if (index != lastIndex) {
            Rect temp = this.mSpace.get(index);
            this.mSpace.set(index, this.mSpace.get(lastIndex));
            this.mSpace.set(lastIndex, temp);
        }
        this.mSpace.remove(lastIndex);
    }

    private Rect split(int index, int width, int height) {
        Rect rect = this.mSpace.get(index);
        assert (rect.w >= width && rect.h >= height) : rect;
        Rect r = new Rect(rect);
        r.w = width;
        r.h = height;
        int i = 0;
        while (i < this.mSpace.size()) {
            Rect other = this.mSpace.get(i);
            if (other.intersects(r)) {
                this.removeRect(i);
                --i;
            }
            ++i;
        }
        int remainingHeight = rect.h - height;
        int remainingWidth = rect.w - width;
        if (remainingHeight >= this.mMinHeight) {
            this.mSpace.add(new Rect(rect.x, rect.y + height, width, remainingHeight));
        }
        if (remainingWidth >= this.mMinWidth) {
            this.mSpace.add(new Rect(rect.x + width, rect.y, remainingWidth, rect.h));
        }
        if (remainingHeight >= this.mMinHeight) {
            this.mSpace.add(new Rect(rect.x, rect.y + height, rect.w, remainingHeight));
        }
        if (remainingWidth >= this.mMinWidth) {
            this.mSpace.add(new Rect(rect.x + width, rect.y, remainingWidth, height));
        }
        int i2 = 0;
        while (i2 < this.mSpace.size() - 1) {
            int j = i2 + 1;
            while (j < this.mSpace.size()) {
                Rect iRect = this.mSpace.get(i2);
                Rect jRect = this.mSpace.get(j);
                if (jRect.contains(iRect)) {
                    this.removeRect(i2);
                    --i2;
                    break;
                }
                if (iRect.contains(jRect)) {
                    this.removeRect(j);
                    --j;
                }
                ++j;
            }
            ++i2;
        }
        return r;
    }

    private void dumpImage() {
    }
}

