/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gle2;

import com.android.ide.common.api.IDragElement;
import com.android.ide.common.api.INode;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DescriptorsUtils;
import com.android.ide.eclipse.adt.internal.editors.layout.LayoutEditorDelegate;
import com.android.ide.eclipse.adt.internal.editors.layout.descriptors.ViewElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.CanvasViewInfo;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.GraphicalEditorPart;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.LayoutCanvas;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SelectionItem;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SelectionManager;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SimpleElement;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SimpleXmlTransfer;
import com.android.ide.eclipse.adt.internal.editors.layout.gre.NodeProxy;
import com.android.ide.eclipse.adt.internal.editors.layout.gre.RulesEngine;
import com.android.ide.eclipse.adt.internal.editors.layout.uimodel.UiViewElementNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiDocumentNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Composite;

public class ClipboardSupport {
    private static final boolean DEBUG = false;
    private Clipboard mClipboard;
    private LayoutCanvas mCanvas;

    public ClipboardSupport(LayoutCanvas canvas, Composite parent) {
        this.mCanvas = canvas;
        this.mClipboard = new Clipboard(parent.getDisplay());
    }

    public void dispose() {
        if (this.mClipboard != null) {
            this.mClipboard.dispose();
            this.mClipboard = null;
        }
    }

    public void copySelectionToClipboard(List<SelectionItem> selection) {
        SelectionManager.sanitize(selection);
        String message = null;
        GraphicalEditorPart graphicalEditor = this.mCanvas.getEditorDelegate().getGraphicalEditor();
        StyledText errorLabel = graphicalEditor.getErrorLabel();
        if (errorLabel.getSelectionCount() > 0) {
            message = errorLabel.getSelectionText();
        }
        if (selection.isEmpty()) {
            if (message != null) {
                this.mClipboard.setContents(new Object[]{message}, new Transfer[]{TextTransfer.getInstance()});
            }
            return;
        }
        Object[] data = new Object[]{SelectionItem.getAsElements(selection), message != null ? message : SelectionItem.getAsText(this.mCanvas, selection)};
        Transfer[] types = new Transfer[]{SimpleXmlTransfer.getInstance(), TextTransfer.getInstance()};
        this.mClipboard.setContents(data, types);
    }

    public void cutSelectionToClipboard(List<SelectionItem> selection) {
        this.copySelectionToClipboard(selection);
        this.deleteSelection(this.mCanvas.getCutLabel(), selection);
    }

    public void deleteSelection(String verb, final List<SelectionItem> selection) {
        int pos;
        SelectionManager.sanitize(selection);
        if (selection.isEmpty()) {
            return;
        }
        String title = null;
        for (SelectionItem cs : selection) {
            CanvasViewInfo vi = cs.getViewInfo();
            if (vi == null || vi.getParent() == null) continue;
            CanvasViewInfo parent = vi.getParent();
            assert (parent != null);
            if (title == null) {
                title = parent.getName();
                continue;
            }
            if (title.equals(parent.getName())) continue;
            title = null;
            break;
        }
        if (title != null && (pos = title.lastIndexOf(46)) > 0 && pos < title.length() - 1) {
            title = title.substring(pos + 1);
        }
        boolean multiple = this.mCanvas.getSelectionManager().hasMultiSelection();
        title = title == null ? String.format(multiple ? "%1$s elements" : "%1$s element", verb) : String.format(multiple ? "%1$s elements from %2$s" : "%1$s element from %2$s", verb, title);
        this.mCanvas.getEditorDelegate().getEditor().wrapUndoEditXmlModel(title, new Runnable(){

            @Override
            public void run() {
                ArrayList<INode> children;
                INode parent;
                HashMap<NodeProxy, ArrayList<INode>> clusters = new HashMap<NodeProxy, ArrayList<INode>>();
                for (SelectionItem cs : selection) {
                    NodeProxy node = cs.getNode();
                    if (node == null || (parent = node.getParent()) == null) continue;
                    children = (ArrayList<INode>)clusters.get(parent);
                    if (children == null) {
                        children = new ArrayList<INode>();
                        clusters.put((NodeProxy)parent, children);
                    }
                    children.add(node);
                }
                RulesEngine rulesEngine = ClipboardSupport.this.mCanvas.getRulesEngine();
                for (Map.Entry entry : clusters.entrySet()) {
                    parent = (NodeProxy)entry.getKey();
                    children = (List)entry.getValue();
                    if (!($assertionsDisabled || children != null && children.size() > 0)) {
                        throw new AssertionError();
                    }
                    rulesEngine.callOnRemovingChildren((NodeProxy)parent, children);
                    parent.applyPendingChanges();
                }
                for (SelectionItem cs : selection) {
                    UiViewElementNode ui;
                    CanvasViewInfo vi = cs.getViewInfo();
                    if (vi == null || vi.isRoot() || (ui = vi.getUiViewNode()) == null) continue;
                    ui.deleteXmlNode();
                }
            }
        });
    }

    public void pasteSelection(List<SelectionItem> selection) {
        CanvasViewInfo target;
        SimpleXmlTransfer sxt = SimpleXmlTransfer.getInstance();
        final SimpleElement[] pasted = (SimpleElement[])this.mClipboard.getContents((Transfer)sxt);
        if (pasted == null || pasted.length == 0) {
            return;
        }
        CanvasViewInfo lastRoot = this.mCanvas.getViewHierarchy().getRoot();
        if (lastRoot == null) {
            this.pasteInEmptyDocument(pasted[0]);
            return;
        }
        SelectionManager.sanitize(selection);
        if (selection.size() > 0) {
            SelectionItem cs = selection.get(0);
            target = cs.getViewInfo();
        } else {
            target = lastRoot;
        }
        final NodeProxy targetNode = this.mCanvas.getNodeFactory().create(target);
        this.mCanvas.getEditorDelegate().getEditor().wrapUndoEditXmlModel("Paste", new Runnable(){

            @Override
            public void run() {
                RulesEngine engine = ClipboardSupport.this.mCanvas.getRulesEngine();
                NodeProxy node = engine.callOnPaste(targetNode, target.getViewObject(), pasted);
                node.applyPendingChanges();
            }
        });
    }

    private void pasteInEmptyDocument(final IDragElement pastedElement) {
        String rootFqcn = pastedElement.getFqcn();
        final LayoutEditorDelegate delegate = this.mCanvas.getEditorDelegate();
        final UiDocumentNode uiDoc = delegate.getUiRootNode();
        if (uiDoc == null || uiDoc.getUiChildren().size() > 0) {
            this.debugPrintf("Failed to paste document root for %1$s: document is not empty", rootFqcn);
            return;
        }
        final ViewElementDescriptor viewDesc = delegate.getFqcnViewDescriptor(rootFqcn);
        if (viewDesc == null) {
            this.debugPrintf("Failed to paste document root, unknown FQCN %1$s", rootFqcn);
            return;
        }
        String title = rootFqcn;
        int pos = title.lastIndexOf(46);
        if (pos > 0 && pos < title.length() - 1) {
            title = title.substring(pos + 1);
        }
        title = String.format("Paste root %1$s in document", title);
        delegate.getEditor().wrapUndoEditXmlModel(title, new Runnable(){

            @Override
            public void run() {
                UiElementNode uiNew = uiDoc.appendNewUiChild(viewDesc);
                uiNew.setAttributeValue("android", "http://www.w3.org/2000/xmlns/", "http://schemas.android.com/apk/res/android", true);
                IDragElement.IDragAttribute[] iDragAttributeArray = pastedElement.getAttributes();
                int n = iDragAttributeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IDragElement.IDragAttribute attr = iDragAttributeArray[n2];
                    uiNew.setAttributeValue(attr.getName(), attr.getUri(), attr.getValue(), true);
                    ++n2;
                }
                DescriptorsUtils.setDefaultLayoutAttributes(uiNew, false);
                uiNew.createXmlNode();
                iDragAttributeArray = pastedElement.getInnerElements();
                n = iDragAttributeArray.length;
                n2 = 0;
                while (n2 < n) {
                    IDragElement.IDragAttribute childElement = iDragAttributeArray[n2];
                    this.addChild(uiNew, (IDragElement)childElement);
                    ++n2;
                }
            }

            private void addChild(UiElementNode uiParent, IDragElement childElement) {
                String childFqcn = childElement.getFqcn();
                ViewElementDescriptor childDesc = delegate.getFqcnViewDescriptor(childFqcn);
                if (childDesc == null) {
                    ClipboardSupport.this.debugPrintf("Failed to paste element, unknown FQCN %1$s", new Object[]{childFqcn});
                    return;
                }
                UiElementNode uiChild = uiParent.appendNewUiChild(childDesc);
                IDragElement.IDragAttribute[] iDragAttributeArray = childElement.getAttributes();
                int n = iDragAttributeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IDragElement.IDragAttribute attr = iDragAttributeArray[n2];
                    uiChild.setAttributeValue(attr.getName(), attr.getUri(), attr.getValue(), true);
                    ++n2;
                }
                DescriptorsUtils.setDefaultLayoutAttributes(uiChild, false);
                uiChild.createXmlNode();
                iDragAttributeArray = childElement.getInnerElements();
                n = iDragAttributeArray.length;
                n2 = 0;
                while (n2 < n) {
                    IDragElement.IDragAttribute grandChildElement = iDragAttributeArray[n2];
                    this.addChild(uiChild, (IDragElement)grandChildElement);
                    ++n2;
                }
            }
        });
    }

    public boolean hasSxtOnClipboard() {
        SimpleXmlTransfer sxt = SimpleXmlTransfer.getInstance();
        TransferData[] transferDataArray = this.mClipboard.getAvailableTypes();
        int n = transferDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData td = transferDataArray[n2];
            if (sxt.isSupportedType(td)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void debugPrintf(String message, Object ... params) {
    }
}

