/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gle2;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.ImageOverlay;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.LayoutCanvas;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

class ExportScreenshotAction
extends Action {
    private final LayoutCanvas mCanvas;

    ExportScreenshotAction(LayoutCanvas canvas) {
        super("Export Screenshot...");
        this.mCanvas = canvas;
    }

    public void run() {
        Shell shell = AdtPlugin.getShell();
        ImageOverlay imageOverlay = this.mCanvas.getImageOverlay();
        BufferedImage image = imageOverlay.getAwtImage();
        if (image != null) {
            FileDialog dialog = new FileDialog(shell, 8192);
            dialog.setFilterExtensions(new String[]{"*.png"});
            String path = dialog.open();
            if (path != null) {
                MessageDialog d;
                int result;
                File file;
                if (!path.endsWith(".png")) {
                    path = String.valueOf(path) + ".png";
                }
                if ((file = new File(path)).exists() && (result = (d = new MessageDialog(null, "File Already Exists", null, String.format("%1$s already exists.\nWould you like to replace it?", path), 3, new String[]{"Yes", "No"}, 0)).open()) != 0) {
                    return;
                }
                try {
                    ImageIO.write((RenderedImage)image, "PNG", file);
                }
                catch (IOException e) {
                    AdtPlugin.log(e, null, new Object[0]);
                }
            }
        } else {
            MessageDialog.openError((Shell)shell, (String)"Error", (String)"Image not available");
        }
    }
}

