/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gle2;

import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.editors.layout.LayoutEditorDelegate;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.CanvasTransform;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.CanvasViewInfo;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.LayoutCanvas;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.Overlay;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.ViewHierarchy;
import com.android.ide.eclipse.adt.internal.preferences.AdtPrefs;
import java.util.ArrayList;
import lombok.ast.libs.org.parboiled.google.collect.Lists;
import org.eclipse.core.resources.IMarker;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.w3c.dom.Node;

public class LintOverlay
extends Overlay {
    static final int ICON_SIZE = 8;
    private static final int ALPHA = 192;
    private final LayoutCanvas mCanvas;
    private Image mWarningImage;
    private Image mErrorImage;

    public LintOverlay(LayoutCanvas canvas) {
        this.mCanvas = canvas;
    }

    @Override
    public boolean isHiding() {
        return super.isHiding() || !AdtPrefs.getPrefs().isLintOnSave();
    }

    @Override
    public void paint(GC gc) {
        LayoutEditorDelegate editor = this.mCanvas.getEditorDelegate();
        ArrayList nodes = editor.getLintNodes();
        if (nodes != null && !nodes.isEmpty()) {
            nodes = Lists.newArrayList(nodes);
            ViewHierarchy hierarchy = this.mCanvas.getViewHierarchy();
            Image icon = this.getWarningIcon();
            ImageData imageData = icon.getImageData();
            int iconWidth = imageData.width;
            int iconHeight = imageData.height;
            CanvasTransform mHScale = this.mCanvas.getHorizontalTransform();
            CanvasTransform mVScale = this.mCanvas.getVerticalTransform();
            int maxX = mHScale.translate(0) + mHScale.getScaledImgSize();
            int maxY = mVScale.translate(0) + mVScale.getScaledImgSize();
            int oldAlpha = gc.getAlpha();
            try {
                gc.setAlpha(192);
                for (Node node : nodes) {
                    CanvasViewInfo vi = hierarchy.findViewInfoFor(node);
                    if (vi == null) continue;
                    Rectangle bounds = vi.getAbsRect();
                    int x = mHScale.translate(bounds.x);
                    int y = mVScale.translate(bounds.y);
                    int w = mHScale.scale(bounds.width);
                    int h = mVScale.scale(bounds.height);
                    if (w < iconWidth || h < iconHeight || (x += w - iconWidth) > maxX || (y += h - iconHeight) > maxY) continue;
                    boolean isError = false;
                    IMarker marker = editor.getIssueForNode(vi.getUiViewNode());
                    if (marker != null) {
                        int severity = marker.getAttribute("severity", 0);
                        isError = severity == 2;
                    }
                    icon = isError ? this.getErrorIcon() : this.getWarningIcon();
                    gc.drawImage(icon, x, y);
                }
            }
            finally {
                gc.setAlpha(oldAlpha);
            }
        }
    }

    private Image getWarningIcon() {
        if (this.mWarningImage == null) {
            this.mWarningImage = IconFactory.getInstance().getIcon("warning-badge");
        }
        return this.mWarningImage;
    }

    private Image getErrorIcon() {
        if (this.mErrorImage == null) {
            this.mErrorImage = IconFactory.getInstance().getIcon("error-badge");
        }
        return this.mErrorImage;
    }
}

