/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gle2;

import com.android.ide.eclipse.adt.internal.editors.layout.gle2.CanvasViewInfo;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.ControlPoint;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.Gesture;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.LayoutCanvas;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.LayoutPoint;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.Overlay;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SelectionItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class MarqueeGesture
extends Gesture {
    private MarqueeOverlay mOverlay;
    private LayoutCanvas mCanvas;
    private Collection<CanvasViewInfo> mInitialSelection;

    public MarqueeGesture(LayoutCanvas canvas, boolean toggle) {
        this.mCanvas = canvas;
        if (toggle) {
            List<SelectionItem> selection = canvas.getSelectionManager().getSelections();
            this.mInitialSelection = new ArrayList<CanvasViewInfo>(selection.size());
            for (SelectionItem item : selection) {
                this.mInitialSelection.add(item.getViewInfo());
            }
        } else {
            this.mInitialSelection = Collections.emptySet();
        }
    }

    @Override
    public void update(ControlPoint pos) {
        if (this.mOverlay == null) {
            return;
        }
        int x = Math.min(pos.x, this.mStart.x);
        int y = Math.min(pos.y, this.mStart.y);
        int w = Math.abs(pos.x - this.mStart.x);
        int h = Math.abs(pos.y - this.mStart.y);
        this.mOverlay.updateSize(x, y, w, h);
        LayoutPoint topLeft = ControlPoint.create(this.mCanvas, x, y).toLayout();
        LayoutPoint bottomRight = ControlPoint.create(this.mCanvas, x + w, y + h).toLayout();
        this.mCanvas.getSelectionManager().selectWithin(topLeft, bottomRight, this.mInitialSelection);
    }

    @Override
    public List<Overlay> createOverlays() {
        this.mOverlay = new MarqueeOverlay();
        return Collections.singletonList(this.mOverlay);
    }

    private static class MarqueeOverlay
    extends Overlay {
        private Color mStroke;
        private Color mFill;
        private Rectangle mRectangle = new Rectangle(0, 0, 0, 0);
        private int mFillAlpha;
        private int mStrokeAlpha;

        public void updateSize(int x, int y, int w, int h) {
            this.mRectangle.x = x;
            this.mRectangle.y = y;
            this.mRectangle.width = w;
            this.mRectangle.height = h;
        }

        @Override
        public void create(Device device) {
            this.mStroke = new Color(device, 255, 255, 255);
            this.mFill = new Color(device, 128, 128, 128);
            this.mFillAlpha = 64;
            this.mStrokeAlpha = 255;
        }

        @Override
        public void dispose() {
            this.mStroke.dispose();
            this.mFill.dispose();
        }

        @Override
        public void paint(GC gc) {
            if (this.mRectangle.width > 0 && this.mRectangle.height > 0) {
                gc.setLineStyle(1);
                gc.setLineWidth(1);
                gc.setForeground(this.mStroke);
                gc.setBackground(this.mFill);
                gc.setAlpha(this.mStrokeAlpha);
                gc.drawRectangle(this.mRectangle);
                gc.setAlpha(this.mFillAlpha);
                gc.fillRectangle(this.mRectangle);
            }
        }
    }
}

