/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gle2;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.api.Rect;
import com.android.ide.common.rendering.api.Capability;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.DeviceConfigHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LanguageQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.Configuration;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.ConfigurationChooser;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.ConfigurationDescription;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.Locale;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.NestedConfiguration;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.VaryingConfiguration;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.BinPacker;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.CanvasTransform;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.ControlPoint;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.GraphicalEditorPart;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.IncludeFinder;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.LayoutCanvas;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.RenderPreview;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.RenderPreviewList;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.RenderPreviewMode;
import com.android.ide.eclipse.adt.internal.preferences.AdtPrefs;
import com.android.resources.Density;
import com.android.resources.ScreenSize;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class RenderPreviewManager {
    private static double sScale = 1.0;
    private static final int RENDER_DELAY = 150;
    private static final int PREVIEW_VGAP = 18;
    private static final int PREVIEW_HGAP = 12;
    private static final int MAX_WIDTH = 200;
    private static final int MAX_HEIGHT = 200;
    private static final int ZOOM_ICON_WIDTH = 16;
    private static final int ZOOM_ICON_HEIGHT = 16;
    @Nullable
    private List<RenderPreview> mPreviews;
    @Nullable
    private RenderPreviewList mManualList;
    @NonNull
    private final LayoutCanvas mCanvas;
    @NonNull
    private final CanvasTransform mVScale;
    @NonNull
    private final CanvasTransform mHScale;
    private int mPrevCanvasWidth;
    private int mPrevCanvasHeight;
    private int mPrevImageWidth;
    private int mPrevImageHeight;
    @NonNull
    private RenderPreviewMode mMode = RenderPreviewMode.NONE;
    @Nullable
    private RenderPreview mActivePreview;
    @Nullable
    private ScrollBarListener mListener;
    private int mLayoutHeight;
    private static int mRevision;
    private static int sRevision;
    private boolean mNeedLayout;
    private boolean mNeedRender;
    private boolean mNeedZoom;
    private SwapAnimation mAnimation;
    private int mPendingRenderCount;

    public RenderPreviewManager(@NonNull LayoutCanvas canvas) {
        this.mCanvas = canvas;
        this.mHScale = canvas.getHorizontalTransform();
        this.mVScale = canvas.getVerticalTransform();
    }

    public static void bumpRevision() {
        ++sRevision;
    }

    @NonNull
    ConfigurationChooser getChooser() {
        GraphicalEditorPart editor = this.mCanvas.getEditorDelegate().getGraphicalEditor();
        return editor.getConfigurationChooser();
    }

    @NonNull
    public LayoutCanvas getCanvas() {
        return this.mCanvas;
    }

    public void zoomIn() {
        if (Math.abs((sScale *= 1.1111111111111112) - 1.0) < 1.0E-4) {
            sScale = 1.0;
        }
        this.updatedZoom();
    }

    public void zoomOut() {
        if (Math.abs((sScale *= 0.9) - 1.0) < 1.0E-4) {
            sScale = 1.0;
        }
        this.updatedZoom();
    }

    public void zoomReset() {
        sScale = 1.0;
        this.updatedZoom();
        this.mNeedLayout = true;
        this.mNeedZoom = true;
        this.mCanvas.redraw();
    }

    private void updatedZoom() {
        if (this.hasPreviews()) {
            RenderPreview preview2;
            for (RenderPreview preview2 : this.mPreviews) {
                preview2.disposeThumbnail();
            }
            preview2 = this.mCanvas.getPreview();
            if (preview2 != null) {
                preview2.disposeThumbnail();
            }
        }
        this.mNeedRender = true;
        this.mNeedLayout = true;
        this.mCanvas.redraw();
    }

    static int getMaxWidth() {
        return (int)(sScale * 200.0);
    }

    static int getMaxHeight() {
        return (int)(sScale * 200.0);
    }

    static double getScale() {
        return sScale;
    }

    public boolean hasManualPreviews() {
        assert (this.mMode == RenderPreviewMode.CUSTOM);
        return this.mManualList != null && !this.mManualList.isEmpty();
    }

    public void deleteManualPreviews() {
        this.disposePreviews();
        this.selectMode(RenderPreviewMode.NONE);
        this.mCanvas.setFitScale(true, true);
        if (this.mManualList != null) {
            this.mManualList.delete();
        }
    }

    public void disposePreviews() {
        if (this.mPreviews != null) {
            List<RenderPreview> old = this.mPreviews;
            this.mPreviews = null;
            for (RenderPreview preview : old) {
                preview.dispose();
            }
        }
    }

    public void deletePreview(RenderPreview preview) {
        this.mPreviews.remove(preview);
        preview.dispose();
        this.layout(true);
        this.mCanvas.redraw();
        if (this.mManualList != null) {
            this.mManualList.remove(preview);
            this.saveList();
        }
    }

    public int computePreviewWidth() {
        int maxPreviewWidth = 0;
        if (this.hasPreviews()) {
            for (RenderPreview preview : this.mPreviews) {
                maxPreviewWidth = Math.max(maxPreviewWidth, preview.getWidth());
            }
            if (maxPreviewWidth > 0) {
                maxPreviewWidth += 24;
                maxPreviewWidth += 10;
            }
            return maxPreviewWidth;
        }
        return 0;
    }

    void layout(boolean refresh) {
        this.mNeedLayout = false;
        if (this.mPreviews == null || this.mPreviews.isEmpty()) {
            return;
        }
        int scaledImageWidth = this.mHScale.getScaledImgSize();
        int scaledImageHeight = this.mVScale.getScaledImgSize();
        Rectangle clientArea = this.mCanvas.getClientArea();
        if (!refresh && scaledImageWidth == this.mPrevImageWidth && scaledImageHeight == this.mPrevImageHeight && clientArea.width == this.mPrevCanvasWidth && clientArea.height == this.mPrevCanvasHeight) {
            return;
        }
        this.mPrevImageWidth = scaledImageWidth;
        this.mPrevImageHeight = scaledImageHeight;
        this.mPrevCanvasWidth = clientArea.width;
        this.mPrevCanvasHeight = clientArea.height;
        if (this.mListener == null) {
            this.mListener = new ScrollBarListener();
            this.mCanvas.getVerticalBar().addSelectionListener((SelectionListener)this.mListener);
        }
        this.beginRenderScheduling();
        this.mLayoutHeight = 0;
        if (this.previewsHaveIdenticalSize() || this.fixedOrder()) {
            this.rowLayout();
        } else if (this.previewsFit()) {
            this.layoutFullFit();
        } else {
            this.rowLayout();
        }
        this.mCanvas.updateScrollBars();
    }

    private void rowLayout() {
        List<RenderPreview> aspectOrder;
        int scaledImageWidth = this.mHScale.getScaledImgSize();
        int scaledImageHeight = this.mVScale.getScaledImgSize();
        Rectangle clientArea = this.mCanvas.getClientArea();
        int availableWidth = clientArea.x + clientArea.width - this.getX();
        int availableHeight = clientArea.y + clientArea.height - this.getY();
        int maxVisibleY = clientArea.y + clientArea.height;
        int bottomBorder = scaledImageHeight;
        int rightHandSide = scaledImageWidth + 12;
        int nextY = 0;
        int x = rightHandSide;
        int y = 0;
        boolean wrapped = false;
        int vgap = 18;
        for (RenderPreview preview : this.mPreviews) {
            if (!preview.isForked()) continue;
            vgap *= 2;
            break;
        }
        if (!this.fixedOrder()) {
            aspectOrder = new ArrayList<RenderPreview>(this.mPreviews);
            Collections.sort(aspectOrder, RenderPreview.INCREASING_ASPECT_RATIO);
        } else {
            aspectOrder = this.mPreviews;
        }
        for (RenderPreview preview : aspectOrder) {
            if (x > 0 && x + preview.getWidth() > availableWidth) {
                x = rightHandSide;
                int prevY = y;
                y = nextY;
                if ((prevY <= bottomBorder || y <= bottomBorder) && Math.max(nextY, y + preview.getHeight()) > bottomBorder && bottomBorder < availableHeight - 40 && preview.getScale() < 1.2) {
                    if (bottomBorder - y > y + preview.getHeight() - bottomBorder) {
                        rightHandSide = 0;
                        wrapped = true;
                    } else if (!wrapped) {
                        y = nextY = Math.max(nextY, bottomBorder + vgap);
                        rightHandSide = 0;
                        x = 0;
                        wrapped = true;
                    }
                }
            }
            if (x > 0 && y <= bottomBorder && Math.max(nextY, y + preview.getHeight()) > bottomBorder && clientArea.height - bottomBorder >= preview.getHeight() && preview.getScale() < 1.2) {
                if (bottomBorder - y > y + preview.getHeight() - bottomBorder) {
                    rightHandSide = 0;
                    wrapped = true;
                } else {
                    y = nextY = Math.max(nextY, bottomBorder + vgap);
                    rightHandSide = 0;
                    x = 0;
                    wrapped = true;
                }
            }
            preview.setPosition(x, y);
            if (y > maxVisibleY && maxVisibleY > 0) {
                preview.setVisible(false);
            } else if (!preview.isVisible()) {
                preview.setVisible(true);
            }
            x += preview.getWidth();
            x += 12;
            nextY = Math.max(nextY, y + preview.getHeight() + vgap);
        }
        this.mLayoutHeight = nextY;
    }

    private boolean fixedOrder() {
        return this.mMode == RenderPreviewMode.SCREENS;
    }

    private boolean previewsHaveIdenticalSize() {
        if (!this.hasPreviews()) {
            return true;
        }
        Iterator<RenderPreview> iterator = this.mPreviews.iterator();
        RenderPreview first = iterator.next();
        int width = first.getWidth();
        int height = first.getHeight();
        while (iterator.hasNext()) {
            RenderPreview preview = iterator.next();
            if (width == preview.getWidth() && height == preview.getHeight()) continue;
            return false;
        }
        return true;
    }

    private boolean previewsFit() {
        int scaledImageWidth = this.mHScale.getScaledImgSize();
        int scaledImageHeight = this.mVScale.getScaledImgSize();
        Rectangle clientArea = this.mCanvas.getClientArea();
        int availableWidth = clientArea.x + clientArea.width - this.getX();
        int availableHeight = clientArea.y + clientArea.height - this.getY();
        int bottomBorder = scaledImageHeight;
        int rightHandSide = scaledImageWidth + 12;
        long availableArea = rightHandSide * bottomBorder + availableWidth * Math.max(0, availableHeight - bottomBorder);
        long requiredArea = 0L;
        for (RenderPreview preview : this.mPreviews) {
            requiredArea += (long)preview.getArea();
        }
        return (double)requiredArea * sScale < (double)availableArea;
    }

    private void layoutFullFit() {
        int scaledImageWidth = this.mHScale.getScaledImgSize();
        int scaledImageHeight = this.mVScale.getScaledImgSize();
        Rectangle clientArea = this.mCanvas.getClientArea();
        int availableWidth = clientArea.x + clientArea.width - this.getX();
        int availableHeight = clientArea.y + clientArea.height - this.getY();
        int maxVisibleY = clientArea.y + clientArea.height;
        int bottomBorder = scaledImageHeight;
        int rightHandSide = scaledImageWidth + 12;
        int minWidth = Integer.MAX_VALUE;
        int minHeight = Integer.MAX_VALUE;
        for (RenderPreview preview : this.mPreviews) {
            minWidth = Math.min(minWidth, preview.getWidth());
            minHeight = Math.min(minHeight, preview.getHeight());
        }
        BinPacker packer = new BinPacker(minWidth, minHeight);
        packer.addSpace(new Rect(rightHandSide, 0, availableWidth - rightHandSide + 12, availableHeight + 18));
        if (maxVisibleY > bottomBorder) {
            packer.addSpace(new Rect(0, bottomBorder + 18, availableWidth + 12, maxVisibleY - bottomBorder + 18));
        }
        ArrayList<RenderPreview> aspectOrder = new ArrayList<RenderPreview>(this.mPreviews);
        Collections.sort(aspectOrder, RenderPreview.INCREASING_ASPECT_RATIO);
        for (RenderPreview preview : aspectOrder) {
            Rect position;
            int previewWidth = preview.getWidth();
            int previewHeight = preview.getHeight();
            previewHeight += 18;
            if (preview.isForked()) {
                previewHeight += 18;
            }
            if ((position = packer.occupy(previewWidth += 12, previewHeight)) != null) {
                preview.setPosition(position.x, position.y);
                preview.setVisible(true);
                continue;
            }
            this.rowLayout();
            return;
        }
        this.mLayoutHeight = availableHeight;
    }

    void paint(GC gc) {
        if (this.hasPreviews()) {
            int x;
            RenderPreview preview2;
            this.layout(this.mNeedLayout);
            if (this.mNeedRender) {
                this.renderPreviews();
            }
            if (this.mNeedZoom) {
                boolean allowZoomIn = true;
                this.mCanvas.setFitScale(false, allowZoomIn);
                this.mNeedZoom = false;
            }
            int rootX = this.getX();
            int rootY = this.getY();
            for (RenderPreview preview2 : this.mPreviews) {
                if (!preview2.isVisible()) continue;
                int x2 = rootX + preview2.getX();
                int y = rootY + preview2.getY();
                preview2.paint(gc, x2, y);
            }
            preview2 = this.mCanvas.getPreview();
            if (preview2 != null) {
                String displayName = null;
                Configuration configuration = preview2.getConfiguration();
                if (configuration instanceof VaryingConfiguration) {
                    VaryingConfiguration cfg = (VaryingConfiguration)configuration;
                    int flags = cfg.getAlternateFlags() | cfg.getOverrideFlags();
                    displayName = NestedConfiguration.computeDisplayName(flags, this.getChooser().getConfiguration());
                } else if (configuration instanceof NestedConfiguration) {
                    int flags = ((NestedConfiguration)configuration).getOverrideFlags();
                    displayName = NestedConfiguration.computeDisplayName(flags, this.getChooser().getConfiguration());
                } else {
                    displayName = configuration.getDisplayName();
                }
                if (displayName != null) {
                    CanvasTransform hi = this.mHScale;
                    CanvasTransform vi = this.mVScale;
                    int destX = hi.translate(0);
                    int destY = vi.translate(0);
                    int destWidth = hi.getScaledImgSize();
                    int destHeight = vi.getScaledImgSize();
                    int x3 = destX + destWidth / 2 - preview2.getWidth() / 2;
                    int y = destY + destHeight;
                    preview2.paintTitle(gc, x3, y, false, displayName);
                }
            }
            if ((x = this.getZoomX()) > 0) {
                int y = this.getZoomY();
                int oldAlpha = gc.getAlpha();
                gc.setBackground(gc.getDevice().getSystemColor(15));
                gc.setAlpha(128);
                int padding = 3;
                int arc = 5;
                gc.fillRoundRectangle(x - padding, y - padding, 16 + 2 * padding, 64 + 2 * padding, arc, arc);
                gc.setAlpha(255);
                IconFactory iconFactory = IconFactory.getInstance();
                Image zoomOut = iconFactory.getIcon("zoomminus");
                Image zoomIn = iconFactory.getIcon("zoomplus");
                Image zoom100 = iconFactory.getIcon("zoom100");
                Image close = iconFactory.getIcon("close");
                gc.drawImage(zoomIn, x, y);
                gc.drawImage(zoomOut, x, y += 16);
                gc.drawImage(zoom100, x, y += 16);
                gc.drawImage(close, x, y += 16);
                y += 16;
                gc.setAlpha(oldAlpha);
            }
        } else if (this.mMode == RenderPreviewMode.CUSTOM) {
            int rootX = this.getX();
            rootX += this.mHScale.getScaledImgSize();
            int rootY = this.getY();
            gc.setFont(this.mCanvas.getFont());
            gc.setForeground(this.mCanvas.getDisplay().getSystemColor(2));
            gc.drawText("Add previews with \"Add as Thumbnail\"\nin the configuration menu", rootX += 24, rootY += 20, true);
        }
        if (this.mAnimation != null) {
            this.mAnimation.tick(gc);
        }
    }

    private void addPreview(@NonNull RenderPreview preview) {
        if (this.mPreviews == null) {
            this.mPreviews = Lists.newArrayList();
        }
        this.mPreviews.add(preview);
    }

    public void addAsThumbnail() {
        InputDialog d;
        ConfigurationChooser chooser = this.getChooser();
        String name = chooser.getConfiguration().getDisplayName();
        if (name == null || name.isEmpty()) {
            name = this.getUniqueName();
        }
        if ((d = new InputDialog(AdtPlugin.getShell(), "Add as Thumbnail Preview", "Name of thumbnail:", name, null)).open() == 0) {
            this.selectMode(RenderPreviewMode.CUSTOM);
            String newName = d.getValue();
            Configuration configuration = Configuration.copy(chooser.getConfiguration());
            configuration.setDisplayName(newName);
            RenderPreview preview = RenderPreview.create(this, configuration);
            this.addPreview(preview);
            this.layout(true);
            this.beginRenderScheduling();
            this.scheduleRender(preview);
            this.mCanvas.setFitScale(true, false);
            if (this.mManualList == null) {
                this.loadList();
            }
            if (this.mManualList != null) {
                this.mManualList.add(preview);
                this.saveList();
            }
        }
    }

    private String getUniqueName() {
        if (this.mPreviews == null || this.mPreviews.isEmpty()) {
            return "Config1";
        }
        HashSet<String> names = new HashSet<String>(this.mPreviews.size());
        for (RenderPreview preview : this.mPreviews) {
            names.add(preview.getDisplayName());
        }
        int index = 2;
        String name;
        while (names.contains(name = String.format("Config%1$d", index))) {
            ++index;
        }
        return name;
    }

    public void addDefaultPreviews() {
        ConfigurationChooser chooser = this.getChooser();
        Configuration parent = chooser.getConfiguration();
        if (parent instanceof NestedConfiguration) {
            parent = ((NestedConfiguration)parent).getParent();
        }
        if (this.mCanvas.getImageOverlay().getImage() != null) {
            this.createLocaleVariation(chooser, parent);
            this.createScreenVariations(parent);
            this.createStateVariation(chooser, parent);
            this.createRenderTargetVariation(chooser, parent);
        }
        this.addIncludedInPreviews();
        RenderPreview preview = RenderPreview.create(this, parent);
        this.mCanvas.setPreview(preview);
        this.sortPreviewsByOrientation();
    }

    private void createRenderTargetVariation(ConfigurationChooser chooser, Configuration parent) {
    }

    private void createStateVariation(ConfigurationChooser chooser, Configuration parent) {
        State currentState = parent.getDeviceState();
        State nextState = parent.getNextDeviceState(currentState);
        if (nextState != currentState) {
            VaryingConfiguration configuration = VaryingConfiguration.create(chooser, parent);
            configuration.setAlternateDeviceState(true);
            configuration.syncFolderConfig();
            this.addPreview(RenderPreview.create(this, configuration));
        }
    }

    private void createLocaleVariation(ConfigurationChooser chooser, Configuration parent) {
        LanguageQualifier currentLanguage = parent.getLocale().language;
        for (Locale locale : chooser.getLocaleList()) {
            LanguageQualifier language = locale.language;
            if (language.equals((Object)currentLanguage)) continue;
            VaryingConfiguration configuration = VaryingConfiguration.create(chooser, parent);
            configuration.setAlternateLocale(true);
            configuration.syncFolderConfig();
            this.addPreview(RenderPreview.create(this, configuration));
            break;
        }
    }

    private void createScreenVariations(Configuration parent) {
        ConfigurationChooser chooser = this.getChooser();
        VaryingConfiguration configuration = VaryingConfiguration.create(chooser, parent);
        configuration.setVariation(0);
        configuration.setAlternateDevice(true);
        configuration.syncFolderConfig();
        this.addPreview(RenderPreview.create(this, configuration));
        configuration = VaryingConfiguration.create(chooser, parent);
        configuration.setVariation(1);
        configuration.setAlternateDevice(true);
        configuration.syncFolderConfig();
        this.addPreview(RenderPreview.create(this, configuration));
    }

    @NonNull
    public RenderPreviewMode getMode() {
        return this.mMode;
    }

    public boolean recomputePreviews(boolean force) {
        RenderPreviewMode newMode = AdtPrefs.getPrefs().getRenderPreviewMode();
        if (!(newMode != this.mMode || force || mRevision != sRevision && this.mMode != RenderPreviewMode.NONE && this.mMode != RenderPreviewMode.CUSTOM)) {
            return false;
        }
        RenderPreviewMode oldMode = this.mMode;
        this.mMode = newMode;
        mRevision = sRevision;
        sScale = 1.0;
        this.disposePreviews();
        switch (this.mMode) {
            case DEFAULT: {
                this.addDefaultPreviews();
                break;
            }
            case INCLUDES: {
                this.addIncludedInPreviews();
                break;
            }
            case LOCALES: {
                this.addLocalePreviews();
                break;
            }
            case SCREENS: {
                this.addScreenSizePreviews();
                break;
            }
            case VARIATIONS: {
                this.addVariationPreviews();
                break;
            }
            case CUSTOM: {
                this.addManualPreviews();
                break;
            }
            case NONE: {
                this.mCanvas.setFitScale(false, true);
                break;
            }
            default: {
                assert (false) : this.mMode;
                break;
            }
        }
        this.mNeedRender = true;
        this.mNeedLayout = true;
        this.mCanvas.redraw();
        if (oldMode != this.mMode && (oldMode == RenderPreviewMode.NONE || this.mMode == RenderPreviewMode.NONE)) {
            this.mCanvas.getHorizontalTransform().refresh();
            this.mCanvas.getVerticalTransform().refresh();
        }
        return true;
    }

    public void selectMode(@NonNull RenderPreviewMode mode) {
        if (mode != this.mMode) {
            AdtPrefs.getPrefs().setPreviewMode(mode);
            this.recomputePreviews(false);
        }
    }

    public void addLocalePreviews() {
        ConfigurationChooser chooser = this.getChooser();
        List<Locale> locales = chooser.getLocaleList();
        Configuration parent = chooser.getConfiguration();
        for (Locale locale : locales) {
            if (!locale.hasLanguage() && !locale.hasRegion()) continue;
            NestedConfiguration configuration = NestedConfiguration.create(chooser, parent);
            configuration.setOverrideLocale(true);
            configuration.setLocale(locale, false);
            String displayName = ConfigurationChooser.getLocaleLabel(chooser, locale, false);
            assert (displayName != null);
            configuration.setDisplayName(displayName);
            this.addPreview(RenderPreview.create(this, configuration));
        }
        Configuration configuration = parent;
        Locale locale = configuration.getLocale();
        String label = ConfigurationChooser.getLocaleLabel(chooser, locale, false);
        if (label == null) {
            label = "default";
        }
        configuration.setDisplayName(label);
        RenderPreview preview = RenderPreview.create(this, parent);
        if (preview != null) {
            this.mCanvas.setPreview(preview);
        }
    }

    public void addScreenSizePreviews() {
        ConfigurationChooser chooser = this.getChooser();
        List<Device> devices = chooser.getDeviceList();
        Configuration configuration = chooser.getConfiguration();
        boolean canScaleNinePatch = configuration.supports(Capability.FIXED_SCALABLE_NINE_PATCH);
        ArrayList<Device> sorted = new ArrayList<Device>(devices);
        HashSet<ScreenSize> seenSizes = new HashSet<ScreenSize>();
        State currentState = configuration.getDeviceState();
        String currentStateName = currentState != null ? currentState.getName() : "";
        int i = 0;
        int n = sorted.size();
        while (i < n) {
            FolderConfiguration c;
            Device device = (Device)sorted.get(i);
            boolean interesting = false;
            State state = device.getState(currentStateName);
            if (state == null) {
                state = (State)device.getAllStates().get(0);
            }
            if (device.getName().startsWith("Nexus ") || device.getName().endsWith(" Nexus")) {
                interesting = true;
            }
            if ((c = DeviceConfigHelper.getFolderConfig((State)state)) != null) {
                DensityQualifier density;
                ScreenSize size;
                ScreenSizeQualifier sizeQualifier = c.getScreenSizeQualifier();
                if (sizeQualifier != null && !seenSizes.contains(size = sizeQualifier.getValue())) {
                    seenSizes.add(size);
                    interesting = true;
                }
                if ((density = c.getDensityQualifier()) != null) {
                    Density d = density.getValue();
                    if (d == Density.LOW) {
                        interesting = false;
                    }
                    if (!canScaleNinePatch && d == Density.TV) {
                        interesting = false;
                    }
                }
            }
            if (interesting) {
                NestedConfiguration screenConfig = NestedConfiguration.create(chooser, configuration);
                screenConfig.setOverrideDevice(true);
                screenConfig.setDevice(device, true);
                screenConfig.syncFolderConfig();
                screenConfig.setDisplayName(ConfigurationChooser.getDeviceLabel(device, true));
                this.addPreview(RenderPreview.create(this, screenConfig));
            }
            ++i;
        }
        this.sortPreviewsByScreenSize();
    }

    public void addIncludedInPreviews() {
        ConfigurationChooser chooser = this.getChooser();
        IProject project = chooser.getProject();
        if (project == null) {
            return;
        }
        IncludeFinder finder = IncludeFinder.get(project);
        List<IncludeFinder.Reference> includedBy = finder.getIncludedBy((IResource)chooser.getEditedFile());
        if (includedBy == null || includedBy.isEmpty()) {
            return;
        }
        for (IncludeFinder.Reference reference : includedBy) {
            String title = reference.getDisplayName();
            Configuration config = Configuration.create(chooser.getConfiguration(), reference.getFile());
            RenderPreview preview = RenderPreview.create(this, config);
            preview.setDisplayName(title);
            preview.setIncludedWithin(reference);
            this.addPreview(preview);
        }
        this.sortPreviewsByOrientation();
    }

    public void addVariationPreviews() {
        ConfigurationChooser chooser = this.getChooser();
        IFile file = chooser.getEditedFile();
        List<IFile> variations = AdtUtils.getResourceVariations(file, false);
        Collections.sort(variations, new Comparator<IFile>(){

            @Override
            public int compare(IFile file1, IFile file2) {
                return file1.getParent().getName().compareTo(file2.getParent().getName());
            }
        });
        Configuration currentConfig = chooser.getConfiguration();
        for (IFile variation : variations) {
            String title = variation.getParent().getName();
            Configuration config = Configuration.create(chooser.getConfiguration(), variation);
            config.setTheme(currentConfig.getTheme());
            config.setActivity(currentConfig.getActivity());
            RenderPreview preview = RenderPreview.create(this, config);
            preview.setDisplayName(title);
            preview.setAlternateInput(variation);
            this.addPreview(preview);
        }
        this.sortPreviewsByOrientation();
    }

    public void addManualPreviews() {
        if (this.mManualList == null) {
            this.loadList();
        } else {
            this.mPreviews = this.mManualList.createPreviews(this.mCanvas);
        }
    }

    private void loadList() {
        IProject project = this.getChooser().getProject();
        if (project == null) {
            return;
        }
        if (this.mManualList == null) {
            this.mManualList = RenderPreviewList.get(project);
        }
        try {
            this.mManualList.load(this.getChooser().getDeviceList());
            this.mPreviews = this.mManualList.createPreviews(this.mCanvas);
        }
        catch (IOException e) {
            AdtPlugin.log(e, null, new Object[0]);
        }
    }

    private void saveList() {
        if (this.mManualList != null) {
            try {
                this.mManualList.save();
            }
            catch (IOException e) {
                AdtPlugin.log(e, null, new Object[0]);
            }
        }
    }

    void rename(ConfigurationDescription description, String newName) {
        IProject project = this.getChooser().getProject();
        if (project == null) {
            return;
        }
        if (this.mManualList == null) {
            this.mManualList = RenderPreviewList.get(project);
        }
        description.displayName = newName;
        this.saveList();
    }

    public void configurationChanged(int flags) {
        if (this.hasPreviews()) {
            RenderPreview preview2;
            this.beginRenderScheduling();
            for (RenderPreview preview2 : this.mPreviews) {
                if (!(preview2.getScale() > 1.2)) continue;
                preview2.configurationChanged(flags);
            }
            for (RenderPreview preview2 : this.mPreviews) {
                if (!(preview2.getScale() <= 1.2)) continue;
                preview2.configurationChanged(flags);
            }
            preview2 = this.mCanvas.getPreview();
            if (preview2 != null) {
                preview2.configurationChanged(flags);
                preview2.dispose();
            }
            this.mNeedLayout = true;
            this.mCanvas.redraw();
        }
    }

    public void renderPreviews() {
        if (this.hasPreviews()) {
            this.beginRenderScheduling();
            ArrayList<RenderPreview> visualOrder = new ArrayList<RenderPreview>(this.mPreviews);
            Collections.sort(visualOrder, RenderPreview.VISUAL_ORDER);
            for (RenderPreview preview : visualOrder) {
                if (!(preview.getScale() > 1.2) || !preview.isVisible()) continue;
                this.scheduleRender(preview);
            }
            for (RenderPreview preview : visualOrder) {
                if (!(preview.getScale() <= 1.2) || !preview.isVisible()) continue;
                this.scheduleRender(preview);
            }
        }
        this.mNeedRender = false;
    }

    public void beginRenderScheduling() {
        this.mPendingRenderCount = 0;
    }

    public void scheduleRender(@NonNull RenderPreview preview) {
        ++this.mPendingRenderCount;
        preview.render(this.mPendingRenderCount * 150);
    }

    public void switchTo(@NonNull RenderPreview preview) {
        RenderPreview newPreview;
        IFile input = preview.getAlternateInput();
        if (input != null) {
            IWorkbenchPartSite site = this.mCanvas.getEditorDelegate().getEditor().getSite();
            try {
                Configuration configuration = preview.getConfiguration();
                boolean setSize = false;
                if (configuration instanceof NestedConfiguration) {
                    ConfigurationChooser chooser;
                    IFile editedFile;
                    NestedConfiguration nestedConfig = (NestedConfiguration)configuration;
                    setSize = nestedConfig.isOverridingDevice();
                    if (configuration instanceof VaryingConfiguration) {
                        VaryingConfiguration c = (VaryingConfiguration)configuration;
                        setSize |= c.isAlternatingDevice();
                    }
                    if (setSize && (editedFile = (chooser = this.getChooser()).getEditedFile()) != null) {
                        chooser.syncToVariations(6, editedFile, configuration, false, false);
                    }
                }
                IDE.openEditor((IWorkbenchPage)site.getWorkbenchWindow().getActivePage(), (IFile)input, (String)"com.android.ide.eclipse.editors.CommonXmlEditor");
            }
            catch (PartInitException e) {
                AdtPlugin.log(e, null, new Object[0]);
            }
            return;
        }
        GraphicalEditorPart editor = this.mCanvas.getEditorDelegate().getGraphicalEditor();
        ConfigurationChooser chooser = editor.getConfigurationChooser();
        Configuration originalConfiguration = chooser.getConfiguration();
        Configuration previewConfiguration = preview.getConfiguration();
        Configuration newConfiguration = previewConfiguration;
        if (newConfiguration instanceof NestedConfiguration) {
            newConfiguration = Configuration.copy(previewConfiguration);
            for (RenderPreview p : this.mPreviews) {
                Configuration configuration = p.getConfiguration();
                if (!(configuration instanceof NestedConfiguration)) continue;
                NestedConfiguration nested = (NestedConfiguration)configuration;
                nested.setParent(newConfiguration);
            }
        }
        if ((newPreview = this.mCanvas.getPreview()) == null) {
            newPreview = RenderPreview.create(this, originalConfiguration);
        }
        if (previewConfiguration instanceof VaryingConfiguration) {
            VaryingConfiguration varying = VaryingConfiguration.create((VaryingConfiguration)previewConfiguration, newConfiguration);
            varying.updateDisplayName();
            originalConfiguration = varying;
            newPreview.setConfiguration(originalConfiguration);
        } else if (previewConfiguration instanceof NestedConfiguration) {
            NestedConfiguration nested = NestedConfiguration.create((NestedConfiguration)previewConfiguration, originalConfiguration, newConfiguration);
            nested.setDisplayName(nested.computeDisplayName());
            originalConfiguration = nested;
            newPreview.setConfiguration(originalConfiguration);
        }
        int i = 0;
        int n = this.mPreviews.size();
        while (i < n) {
            if (preview == this.mPreviews.get(i)) {
                this.mPreviews.set(i, newPreview);
                break;
            }
            ++i;
        }
        this.mCanvas.setPreview(preview);
        preview.setVisible(false);
        chooser.setConfiguration(newConfiguration);
        editor.changed(65535);
        this.mCanvas.getVerticalBar().setSelection(this.mCanvas.getVerticalBar().getMinimum());
        this.mNeedZoom = true;
        this.mNeedLayout = true;
        this.mCanvas.redraw();
        this.mAnimation = new SwapAnimation(preview, newPreview);
    }

    RenderPreview getPreview(ControlPoint mousePos) {
        if (this.hasPreviews()) {
            int rootX = this.getX();
            if (mousePos.x < rootX) {
                return null;
            }
            int rootY = this.getY();
            for (RenderPreview preview : this.mPreviews) {
                int x = rootX + preview.getX();
                int y = rootY + preview.getY();
                if (mousePos.x < x || mousePos.x > x + preview.getWidth() || mousePos.y < y || mousePos.y > y + preview.getHeight()) continue;
                return preview;
            }
        }
        return null;
    }

    private int getX() {
        return this.mHScale.translate(0);
    }

    private int getY() {
        return this.mVScale.translate(0);
    }

    private int getZoomX() {
        Rectangle clientArea = this.mCanvas.getClientArea();
        int x = clientArea.x + clientArea.width - 16;
        if (x < this.mHScale.getScaledImgSize() + 12) {
            return -1;
        }
        return x - 6;
    }

    private int getZoomY() {
        Rectangle clientArea = this.mCanvas.getClientArea();
        return clientArea.y + 5;
    }

    public int getHeight() {
        return this.mLayoutHeight;
    }

    public void moved(ControlPoint mousePos) {
        RenderPreview hovered = this.getPreview(mousePos);
        if (hovered != this.mActivePreview) {
            if (this.mActivePreview != null) {
                this.mActivePreview.setActive(false);
            }
            this.mActivePreview = hovered;
            if (this.mActivePreview != null) {
                this.mActivePreview.setActive(true);
            }
            this.mCanvas.redraw();
        }
    }

    public void enter(ControlPoint mousePos) {
        this.moved(mousePos);
    }

    public void exit(ControlPoint mousePos) {
        if (this.mActivePreview != null) {
            this.mActivePreview.setActive(false);
        }
        this.mActivePreview = null;
        this.mCanvas.redraw();
    }

    public boolean click(ControlPoint mousePos) {
        boolean handled;
        int y;
        int x = this.getZoomX();
        if (x > 0 && mousePos.x >= x && mousePos.x <= x + 16 && mousePos.y >= (y = this.getZoomY()) && mousePos.y <= y + 64) {
            if (mousePos.y < y + 16) {
                this.zoomIn();
            } else if (mousePos.y < y + 32) {
                this.zoomOut();
            } else if (mousePos.y < y + 48) {
                this.zoomReset();
            } else {
                this.selectMode(RenderPreviewMode.NONE);
            }
            return true;
        }
        RenderPreview preview = this.getPreview(mousePos);
        if (preview != null && (handled = preview.click(mousePos.x - this.getX() - preview.getX(), mousePos.y - this.getY() - preview.getY()))) {
            this.moved(mousePos);
            return true;
        }
        return false;
    }

    public boolean hasPreviews() {
        return this.mPreviews != null && !this.mPreviews.isEmpty();
    }

    private void sortPreviewsByScreenSize() {
        if (this.mPreviews != null) {
            Collections.sort(this.mPreviews, new Comparator<RenderPreview>(){

                @Override
                public int compare(RenderPreview preview1, RenderPreview preview2) {
                    State state2;
                    State state1;
                    Configuration config1 = preview1.getConfiguration();
                    Configuration config2 = preview2.getConfiguration();
                    Device device1 = config1.getDevice();
                    Device device2 = config1.getDevice();
                    if (device1 != null && device2 != null) {
                        Screen screen1 = device1.getDefaultHardware().getScreen();
                        Screen screen2 = device2.getDefaultHardware().getScreen();
                        if (screen1 != null && screen2 != null) {
                            double delta = screen1.getDiagonalLength() - screen2.getDiagonalLength();
                            if (delta != 0.0) {
                                return (int)Math.signum(delta);
                            }
                            if (screen1.getPixelDensity() != screen2.getPixelDensity()) {
                                return screen1.getPixelDensity().compareTo((Enum)screen2.getPixelDensity());
                            }
                        }
                    }
                    if ((state1 = config1.getDeviceState()) != (state2 = config2.getDeviceState()) && state1 != null && state2 != null) {
                        return state1.getName().compareTo(state2.getName());
                    }
                    return preview1.getDisplayName().compareTo(preview2.getDisplayName());
                }
            });
        }
    }

    private void sortPreviewsByOrientation() {
        if (this.mPreviews != null) {
            Collections.sort(this.mPreviews, new Comparator<RenderPreview>(){

                @Override
                public int compare(RenderPreview preview1, RenderPreview preview2) {
                    State state2;
                    Configuration config1 = preview1.getConfiguration();
                    Configuration config2 = preview2.getConfiguration();
                    State state1 = config1.getDeviceState();
                    if (state1 != (state2 = config2.getDeviceState()) && state1 != null && state2 != null) {
                        return state1.getName().compareTo(state2.getName());
                    }
                    return preview1.getDisplayName().compareTo(preview2.getDisplayName());
                }
            });
        }
    }

    public void updateChooserConfig(@NonNull Configuration oldConfiguration, @NonNull Configuration newConfiguration) {
        if (this.hasPreviews()) {
            for (RenderPreview preview : this.mPreviews) {
                NestedConfiguration nestedConfig;
                Configuration configuration = preview.getConfiguration();
                if (!(configuration instanceof NestedConfiguration) || (nestedConfig = (NestedConfiguration)configuration).getParent() != oldConfiguration) continue;
                nestedConfig.setParent(newConfiguration);
            }
        }
    }

    private class ScrollBarListener
    implements SelectionListener {
        private ScrollBarListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (RenderPreviewManager.this.mPreviews == null) {
                return;
            }
            ScrollBar bar = RenderPreviewManager.this.mCanvas.getVerticalBar();
            int selection = bar.getSelection();
            int thumb = bar.getThumb();
            int maxY = selection + thumb;
            RenderPreviewManager.this.beginRenderScheduling();
            for (RenderPreview preview : RenderPreviewManager.this.mPreviews) {
                if (preview.isVisible() || preview.getY() > maxY) continue;
                preview.setVisible(true);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class SwapAnimation
    implements Runnable {
        private long begin = System.currentTimeMillis();
        private long end = this.begin + 400L;
        private static final long DURATION = 400L;
        private Rect initialRect1;
        private Rect targetRect1;
        private Rect initialRect2;
        private Rect targetRect2;
        private RenderPreview preview;

        SwapAnimation(RenderPreview preview1, RenderPreview preview2) {
            this.initialRect1 = new Rect(preview1.getX(), preview1.getY(), preview1.getWidth(), preview1.getHeight());
            CanvasTransform hi = RenderPreviewManager.this.mCanvas.getHorizontalTransform();
            CanvasTransform vi = RenderPreviewManager.this.mCanvas.getVerticalTransform();
            this.initialRect2 = new Rect(hi.translate(0), vi.translate(0), hi.getScaledImgSize(), vi.getScaledImgSize());
            this.preview = preview2;
        }

        void tick(GC gc) {
            long now = System.currentTimeMillis();
            if (now > this.end || RenderPreviewManager.this.mCanvas.isDisposed()) {
                RenderPreviewManager.this.mAnimation = null;
                return;
            }
            CanvasTransform hi = RenderPreviewManager.this.mCanvas.getHorizontalTransform();
            CanvasTransform vi = RenderPreviewManager.this.mCanvas.getVerticalTransform();
            if (this.targetRect1 == null) {
                this.targetRect1 = new Rect(hi.translate(0), vi.translate(0), hi.getScaledImgSize(), vi.getScaledImgSize());
            }
            double portion = (double)(now - this.begin) / 400.0;
            Rect rect1 = new Rect((int)(portion * (double)(this.targetRect1.x - this.initialRect1.x) + (double)this.initialRect1.x), (int)(portion * (double)(this.targetRect1.y - this.initialRect1.y) + (double)this.initialRect1.y), (int)(portion * (double)(this.targetRect1.w - this.initialRect1.w) + (double)this.initialRect1.w), (int)(portion * (double)(this.targetRect1.h - this.initialRect1.h) + (double)this.initialRect1.h));
            if (this.targetRect2 == null) {
                this.targetRect2 = new Rect(this.preview.getX(), this.preview.getY(), this.preview.getWidth(), this.preview.getHeight());
            }
            portion = (double)(now - this.begin) / 400.0;
            Rect rect2 = new Rect((int)(portion * (double)(this.targetRect2.x - this.initialRect2.x) + (double)this.initialRect2.x), (int)(portion * (double)(this.targetRect2.y - this.initialRect2.y) + (double)this.initialRect2.y), (int)(portion * (double)(this.targetRect2.w - this.initialRect2.w) + (double)this.initialRect2.w), (int)(portion * (double)(this.targetRect2.h - this.initialRect2.h) + (double)this.initialRect2.h));
            gc.setForeground(gc.getDevice().getSystemColor(15));
            gc.drawRectangle(rect1.x, rect1.y, rect1.w, rect1.h);
            gc.drawRectangle(rect2.x, rect2.y, rect2.w, rect2.h);
            RenderPreviewManager.this.mCanvas.getDisplay().timerExec(5, (Runnable)this);
        }

        @Override
        public void run() {
            RenderPreviewManager.this.mCanvas.redraw();
        }
    }
}

