/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gle2;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.api.ResizePolicy;
import com.android.ide.eclipse.adt.internal.editors.layout.LayoutEditorDelegate;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.CanvasViewInfo;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.LayoutCanvas;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SelectionHandles;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SimpleElement;
import com.android.ide.eclipse.adt.internal.editors.layout.gre.NodeProxy;
import com.android.ide.eclipse.adt.internal.editors.layout.gre.ViewMetadataRepository;
import com.android.ide.eclipse.adt.internal.editors.layout.uimodel.UiViewElementNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Rectangle;
import org.w3c.dom.Node;

class SelectionItem {
    private LayoutCanvas mCanvas;
    private final CanvasViewInfo mCanvasViewInfo;
    private final Rectangle mRect;
    private final NodeProxy mNodeProxy;
    private ResizePolicy mResizePolicy;
    private SelectionHandles mHandles;

    public SelectionItem(LayoutCanvas canvas, CanvasViewInfo canvasViewInfo) {
        assert (canvasViewInfo != null);
        this.mCanvas = canvas;
        this.mCanvasViewInfo = canvasViewInfo;
        if (canvasViewInfo == null) {
            this.mRect = null;
            this.mNodeProxy = null;
        } else {
            Rectangle r = canvasViewInfo.getSelectionRect();
            this.mRect = new Rectangle(r.x, r.y, r.width, r.height);
            this.mNodeProxy = this.mCanvas.getNodeFactory().create(canvasViewInfo);
        }
    }

    public boolean isRoot() {
        return this.mCanvasViewInfo.isRoot();
    }

    public boolean isHidden() {
        return this.mCanvasViewInfo.isHidden();
    }

    @NonNull
    public CanvasViewInfo getViewInfo() {
        return this.mCanvasViewInfo;
    }

    @Nullable
    public UiViewElementNode getUiNode() {
        return this.mCanvasViewInfo.getUiViewNode();
    }

    public Rectangle getRect() {
        return this.mRect;
    }

    @Nullable
    NodeProxy getNode() {
        return this.mNodeProxy;
    }

    @NonNull
    LayoutCanvas getCanvas() {
        return this.mCanvas;
    }

    @NonNull
    static String getAsText(LayoutCanvas canvas, List<SelectionItem> selection) {
        StringBuilder sb = new StringBuilder();
        LayoutEditorDelegate layoutEditorDelegate = canvas.getEditorDelegate();
        for (SelectionItem cs : selection) {
            CanvasViewInfo vi = cs.getViewInfo();
            UiViewElementNode key = vi.getUiViewNode();
            Node node = key.getXmlNode();
            String t = layoutEditorDelegate.getEditor().getXmlText(node);
            if (t == null) continue;
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(t);
        }
        return sb.toString();
    }

    @NonNull
    static SimpleElement[] getAsElements(@NonNull List<SelectionItem> items) {
        return SelectionItem.getAsElements(items, null);
    }

    @NonNull
    static SimpleElement[] getAsElements(@NonNull List<SelectionItem> items, @Nullable SelectionItem primary) {
        ArrayList<SimpleElement> elements = new ArrayList<SimpleElement>();
        if (primary != null) {
            CanvasViewInfo vi = primary.getViewInfo();
            SimpleElement e = vi.toSimpleElement();
            e.setSelectionItem(primary);
            elements.add(e);
        }
        for (SelectionItem cs : items) {
            if (cs == primary) continue;
            CanvasViewInfo vi = cs.getViewInfo();
            SimpleElement e = vi.toSimpleElement();
            e.setSelectionItem(cs);
            elements.add(e);
        }
        return elements.toArray(new SimpleElement[elements.size()]);
    }

    public boolean isLayout() {
        UiViewElementNode node = this.mCanvasViewInfo.getUiViewNode();
        if (node != null) {
            return node.getDescriptor().hasChildren();
        }
        return false;
    }

    @NonNull
    public SelectionHandles getSelectionHandles() {
        if (this.mHandles == null) {
            this.mHandles = new SelectionHandles(this);
        }
        return this.mHandles;
    }

    @NonNull
    public ResizePolicy getResizePolicy() {
        if (this.mResizePolicy == null && this.mNodeProxy != null) {
            this.mResizePolicy = ViewMetadataRepository.get().getResizePolicy(this.mNodeProxy.getFqcn());
        }
        return this.mResizePolicy;
    }
}

