/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gre;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.layout.gre.RulesEngine;
import com.android.ide.eclipse.adt.internal.sdk.ProjectState;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.utils.Pair;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

public class RuleLoader {
    private static final QualifiedName RULE_LOADER = new QualifiedName("com.android.ide.eclipse.adt", "ruleloader");
    private final IProject mProject;
    private ClassLoader mUserClassLoader;
    private List<Pair<File, Long>> mUserJarTimeStamps;
    private long mLastCheckTimeStamp;
    private boolean mUserClassLoaderInited;

    public static RuleLoader get(IProject project) {
        RuleLoader loader = null;
        try {
            loader = (RuleLoader)project.getSessionProperty(RULE_LOADER);
        }
        catch (CoreException coreException) {}
        if (loader == null) {
            loader = new RuleLoader(project);
            try {
                project.setSessionProperty(RULE_LOADER, (Object)loader);
            }
            catch (CoreException e) {
                AdtPlugin.log(e, "Can't store RuleLoader", new Object[0]);
            }
        }
        return loader;
    }

    private RuleLoader(IProject project) {
        this.mProject = project;
    }

    private ClassLoader computeUserClassLoader(IProject project) {
        ProjectState state = Sdk.getProjectState(project);
        ProjectProperties projectProperties = state.getProperties();
        projectProperties.reload();
        String path = projectProperties.getProperty("layoutrules.jars");
        if (path != null && path.length() > 0) {
            String[] pathElements;
            this.mUserJarTimeStamps = new ArrayList<Pair<File, Long>>();
            this.mLastCheckTimeStamp = System.currentTimeMillis();
            ArrayList<URL> urls = new ArrayList<URL>();
            String[] stringArray = pathElements = path.split(File.pathSeparator);
            int n = pathElements.length;
            int n2 = 0;
            while (n2 < n) {
                String pathElement = stringArray[n2];
                File pathFile = new File(pathElement = pathElement.trim());
                if (!pathFile.isAbsolute()) {
                    pathFile = new File(project.getLocation().toFile(), pathElement);
                }
                if (pathFile.isFile() || pathFile.isDirectory()) {
                    try {
                        URL url = pathFile.toURI().toURL();
                        urls.add(url);
                        this.mUserJarTimeStamps.add((Pair<File, Long>)Pair.of((Object)pathFile, (Object)pathFile.lastModified()));
                    }
                    catch (MalformedURLException e) {
                        AdtPlugin.log(2, "Invalid URL: %1$s", e.toString());
                    }
                }
                ++n2;
            }
            if (urls.size() > 0) {
                return new URLClassLoader(urls.toArray(new URL[urls.size()]), RulesEngine.class.getClassLoader());
            }
        }
        return null;
    }

    public ClassLoader getClassLoader() {
        long time;
        if (this.mUserClassLoader == null) {
            if (!this.mUserClassLoaderInited) {
                this.mUserClassLoaderInited = true;
                this.mUserClassLoader = this.computeUserClassLoader(this.mProject);
            }
        } else if (this.mUserJarTimeStamps != null && (time = System.currentTimeMillis()) - this.mLastCheckTimeStamp > 3000L) {
            this.mLastCheckTimeStamp = time;
            for (Pair<File, Long> pair : this.mUserJarTimeStamps) {
                File file = (File)pair.getFirst();
                Long prevModified = (Long)pair.getSecond();
                long modified = file.lastModified();
                if (prevModified == modified) continue;
                this.mUserClassLoaderInited = true;
                this.mUserJarTimeStamps = null;
                this.mUserClassLoader = this.computeUserClassLoader(this.mProject);
            }
        }
        return this.mUserClassLoader;
    }
}

