/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.properties;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.CanvasViewInfo;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.GraphicalEditorPart;
import com.android.ide.eclipse.adt.internal.editors.layout.properties.PropertyFactory;
import com.android.ide.eclipse.adt.internal.editors.layout.uimodel.UiViewElementNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.IUiUpdateListener;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.wb.internal.core.editor.structure.IPage;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.table.IPropertyExceptionHandler;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;

public class PropertySheetPage
extends Page
implements IPropertySheetPage,
IUiUpdateListener,
IPage {
    private PropertyTable mPropertyTable;
    private final GraphicalEditorPart mEditor;
    private Property mActiveProperty;
    private Action mDefaultValueAction;
    private Action mShowAdvancedPropertiesAction;
    private Action mSortAlphaAction;
    private Action mCollapseAll;
    private Action mExpandAll;
    private List<CanvasViewInfo> mSelection;
    private static final String EXPAND_DISABLED_ICON = "expandall-disabled";
    private static final String EXPAND_ICON = "expandall";
    private static final String DEFAULT_ICON = "properties_default";
    private static final String ADVANCED_ICON = "filter_advanced_properties";
    private static final String ALPHA_ICON = "sort_alpha";
    private static final int ACTION_DEFAULT_VALUE = 1;
    private static final int ACTION_SHOW_ADVANCED = 2;
    private static final int ACTION_COLLAPSE = 3;
    private static final int ACTION_EXPAND = 4;
    private static final int ACTION_SORT_ALPHA = 5;

    public PropertySheetPage(GraphicalEditorPart editor) {
        this.mEditor = editor;
    }

    private PropertyFactory getPropertyFactory() {
        return this.mEditor.getPropertyFactory();
    }

    public void createControl(Composite parent) {
        assert (parent != null);
        this.mPropertyTable = new PropertyTable(parent, 0);
        this.mPropertyTable.setExceptionHandler(new IPropertyExceptionHandler(){

            public void handle(Throwable e) {
                AdtPlugin.log(e, null, new Object[0]);
            }
        });
        this.mPropertyTable.setDefaultCollapsedNames(Arrays.asList("Deprecated", "Layout Parameters", "Layout Parameters|Margins"));
        this.createActions();
        this.setPropertyTableContextMenu();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof TreeSelection && this.mPropertyTable != null && !this.mPropertyTable.isDisposed()) {
            int selectionCount;
            TreeSelection treeSelection = (TreeSelection)selection;
            if (this.mSelection != null) {
                if (this.mSelection.isEmpty()) {
                    if (treeSelection.isEmpty()) {
                        return;
                    }
                } else {
                    selectionCount = treeSelection.size();
                    if (selectionCount == this.mSelection.size()) {
                        boolean same = true;
                        Iterator iterator = treeSelection.iterator();
                        int i = 0;
                        int n = selectionCount;
                        while (i < n && iterator.hasNext()) {
                            Object next = iterator.next();
                            if (next instanceof CanvasViewInfo) {
                                CanvasViewInfo info = (CanvasViewInfo)next;
                                if (info != this.mSelection.get(i)) {
                                    same = false;
                                    break;
                                }
                            } else {
                                same = false;
                                break;
                            }
                            ++i;
                        }
                        if (same) {
                            return;
                        }
                    }
                }
            }
            this.stopTrackingSelection();
            if (treeSelection.isEmpty()) {
                this.mSelection = Collections.emptyList();
            } else {
                selectionCount = treeSelection.size();
                ArrayList<CanvasViewInfo> newSelection = new ArrayList<CanvasViewInfo>(selectionCount);
                for (Object next : treeSelection) {
                    if (!(next instanceof CanvasViewInfo)) continue;
                    CanvasViewInfo info = (CanvasViewInfo)next;
                    newSelection.add(info);
                }
                this.mSelection = newSelection;
            }
            this.startTrackingSelection();
            this.refreshProperties();
        }
    }

    public void dispose() {
        this.stopTrackingSelection();
        super.dispose();
    }

    private void startTrackingSelection() {
        if (this.mSelection != null && !this.mSelection.isEmpty()) {
            for (CanvasViewInfo item : this.mSelection) {
                UiViewElementNode node = item.getUiViewNode();
                if (node == null) continue;
                node.addUpdateListener(this);
            }
        }
    }

    private void stopTrackingSelection() {
        if (this.mSelection != null && !this.mSelection.isEmpty()) {
            for (CanvasViewInfo item : this.mSelection) {
                UiViewElementNode node = item.getUiViewNode();
                if (node == null) continue;
                node.removeUpdateListener(this);
            }
        }
        this.mSelection = null;
    }

    @Override
    public void uiElementNodeUpdated(UiElementNode node, IUiUpdateListener.UiUpdateState state) {
        this.refreshProperties();
    }

    public Control getControl() {
        return this.mPropertyTable;
    }

    public void setFocus() {
        this.mPropertyTable.setFocus();
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        toolBarManager.add((IAction)this.mShowAdvancedPropertiesAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.mSortAlphaAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.mDefaultValueAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.mExpandAll);
        toolBarManager.add((IAction)this.mCollapseAll);
        toolBarManager.add((IContributionItem)new Separator());
    }

    private void createActions() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        IconFactory iconFactory = IconFactory.getInstance();
        this.mExpandAll = new PropertySheetAction(1, "Expand All", 4, iconFactory.getImageDescriptor(EXPAND_ICON), iconFactory.getImageDescriptor(EXPAND_DISABLED_ICON));
        this.mCollapseAll = new PropertySheetAction(1, "Collapse All", 3, sharedImages.getImageDescriptor("IMG_ELCL_COLLAPSEALL"), sharedImages.getImageDescriptor("IMG_ELCL_COLLAPSEALL_DISABLED"));
        this.mShowAdvancedPropertiesAction = new PropertySheetAction(2, "Show Advanced Properties", 2, iconFactory.getImageDescriptor(ADVANCED_ICON), null);
        this.mSortAlphaAction = new PropertySheetAction(2, "Sort Alphabetically", 5, iconFactory.getImageDescriptor(ALPHA_ICON), null);
        this.mDefaultValueAction = new PropertySheetAction(1, "Restore Default Value", 1, iconFactory.getImageDescriptor(DEFAULT_ICON), null);
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                PropertySheetPage.this.mActiveProperty = (Property)selection.getFirstElement();
                PropertySheetPage.this.updateDefaultValueAction();
            }
        };
        this.mPropertyTable.addSelectionChangedListener(listener);
    }

    private void updateDefaultValueAction() {
        if (this.mActiveProperty != null) {
            try {
                this.mDefaultValueAction.setEnabled(this.mActiveProperty.isModified());
            }
            catch (Exception e) {
                AdtPlugin.log(e, null, new Object[0]);
            }
        } else {
            this.mDefaultValueAction.setEnabled(false);
        }
    }

    private void setPropertyTableContextMenu() {
        final MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                MenuItem[] menuItemArray = manager.getMenu().getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    item.dispose();
                    ++n2;
                }
                this.fillContextMenu();
            }

            private void fillContextMenu() {
                manager.add((IAction)PropertySheetPage.this.mDefaultValueAction);
                manager.add((IAction)PropertySheetPage.this.mSortAlphaAction);
                manager.add((IAction)PropertySheetPage.this.mShowAdvancedPropertiesAction);
            }
        });
        this.mPropertyTable.setMenu(manager.createContextMenu((Control)this.mPropertyTable));
    }

    private void refreshProperties() {
        PropertyFactory factory = this.getPropertyFactory();
        this.mPropertyTable.setInput(factory.getProperties(this.mSelection));
        this.updateDefaultValueAction();
    }

    public void setToolBar(IToolBarManager toolBarManager) {
        this.makeContributions(null, toolBarManager, null);
        toolBarManager.update(false);
    }

    private class PropertySheetAction
    extends Action {
        private final int mAction;

        private PropertySheetAction(int style, String label, int action, ImageDescriptor imageDesc, ImageDescriptor disabledImageDesc) {
            super(label, style);
            this.mAction = action;
            this.setImageDescriptor(imageDesc);
            if (disabledImageDesc != null) {
                this.setDisabledImageDescriptor(disabledImageDesc);
            }
            this.setToolTipText(label);
        }

        public void run() {
            switch (this.mAction) {
                case 3: {
                    PropertySheetPage.this.mPropertyTable.collapseAll();
                    break;
                }
                case 4: {
                    PropertySheetPage.this.mPropertyTable.expandAll();
                    break;
                }
                case 2: {
                    boolean show = PropertySheetPage.this.mShowAdvancedPropertiesAction.isChecked();
                    PropertySheetPage.this.mPropertyTable.setShowAdvancedProperties(show);
                    break;
                }
                case 5: {
                    boolean isAlphabetical = PropertySheetPage.this.mSortAlphaAction.isChecked();
                    PropertySheetPage.this.getPropertyFactory().setSortingMode(isAlphabetical ? PropertyFactory.SortingMode.ALPHABETICAL : PropertyFactory.DEFAULT_MODE);
                    PropertySheetPage.this.refreshProperties();
                    break;
                }
                case 1: {
                    try {
                        PropertySheetPage.this.mActiveProperty.setValue(Property.UNKNOWN_VALUE);
                    }
                    catch (Exception exception) {}
                    break;
                }
                default: {
                    assert (false) : this.mAction;
                    break;
                }
            }
        }
    }
}

