/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.properties;

import com.android.annotations.NonNull;
import com.android.ide.eclipse.adt.internal.editors.layout.properties.XmlProperty;
import com.google.common.base.Objects;
import java.util.Arrays;
import org.eclipse.wb.internal.core.model.property.Property;

class XmlPropertyComposite
extends XmlProperty {
    private static final Object NO_VALUE = new Object();
    private final XmlProperty[] mProperties;

    public XmlPropertyComposite(XmlProperty primary, XmlProperty[] properties) {
        super(primary.getEditor(), primary.getFactory(), primary.getNode(), primary.getDescriptor());
        this.mProperties = properties;
    }

    @Override
    @NonNull
    public String getTitle() {
        return this.mProperties[0].getTitle();
    }

    public int hashCode() {
        return this.mProperties.length;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof XmlPropertyComposite) {
            XmlPropertyComposite property = (XmlPropertyComposite)((Object)obj);
            return Arrays.equals((Object[])this.mProperties, (Object[])property.mProperties);
        }
        return false;
    }

    @Override
    public boolean isModified() throws Exception {
        XmlProperty[] xmlPropertyArray = this.mProperties;
        int n = this.mProperties.length;
        int n2 = 0;
        while (n2 < n) {
            XmlProperty property = xmlPropertyArray[n2];
            if (property.isModified()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Object getValue() throws Exception {
        Object value = NO_VALUE;
        XmlProperty[] xmlPropertyArray = this.mProperties;
        int n = this.mProperties.length;
        int n2 = 0;
        while (n2 < n) {
            XmlProperty property = xmlPropertyArray[n2];
            Object propertyValue = property.getValue();
            if (value == NO_VALUE) {
                value = propertyValue;
            } else if (!Objects.equal((Object)value, (Object)propertyValue)) {
                return UNKNOWN_VALUE;
            }
            ++n2;
        }
        return value;
    }

    @Override
    public void setValue(Object value) throws Exception {
        XmlProperty[] xmlPropertyArray = this.mProperties;
        int n = this.mProperties.length;
        int n2 = 0;
        while (n2 < n) {
            XmlProperty property = xmlPropertyArray[n2];
            property.setValue(value);
            ++n2;
        }
    }

    @NonNull
    public static XmlPropertyComposite create(Property ... properties) {
        XmlProperty[] xmlProperties = new XmlProperty[properties.length];
        int i = 0;
        while (i < properties.length) {
            Property property = properties[i];
            xmlProperties[i] = (XmlProperty)property;
            ++i;
        }
        XmlPropertyComposite composite = new XmlPropertyComposite(xmlProperties[0], xmlProperties);
        composite.setCategory(xmlProperties[0].getCategory());
        return composite;
    }
}

