/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.manifest.pages;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.IPageImageProvider;
import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.manifest.ManifestEditor;
import com.android.ide.eclipse.adt.internal.editors.manifest.descriptors.AndroidManifestDescriptors;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.UiTreeBlock;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public final class PermissionPage
extends FormPage
implements IPageImageProvider {
    public static final String PAGE_ID = "permission_page";
    ManifestEditor mEditor;
    private UiTreeBlock mTreeBlock;

    public PermissionPage(ManifestEditor editor) {
        super((FormEditor)editor, PAGE_ID, "Permissions");
        this.mEditor = editor;
    }

    @Override
    public Image getPageImage() {
        return IconFactory.getInstance().getIcon(this.getTitle(), 4, 82);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        form.setText("Android Manifest Permissions");
        form.setImage(AdtPlugin.getAndroidLogo());
        UiElementNode manifest = this.mEditor.getUiRootNode();
        AndroidManifestDescriptors manifestDescriptor = this.mEditor.getManifestDescriptors();
        ElementDescriptor[] descriptorFilters = null;
        if (manifestDescriptor != null) {
            descriptorFilters = new ElementDescriptor[]{manifestDescriptor.getPermissionElement(), manifestDescriptor.getUsesPermissionElement(), manifestDescriptor.getPermissionGroupElement(), manifestDescriptor.getPermissionTreeElement()};
        }
        this.mTreeBlock = new UiTreeBlock(this.mEditor, manifest, true, descriptorFilters, "Permissions", "List of permissions defined and used by the manifest");
        this.mTreeBlock.createContent(managedForm);
    }

    public void refreshUiNode() {
        if (this.mTreeBlock != null) {
            UiElementNode manifest = this.mEditor.getUiRootNode();
            AndroidManifestDescriptors manifestDescriptor = this.mEditor.getManifestDescriptors();
            this.mTreeBlock.changeRootAndDescriptors(manifest, new ElementDescriptor[]{manifestDescriptor.getPermissionElement(), manifestDescriptor.getUsesPermissionElement(), manifestDescriptor.getPermissionGroupElement(), manifestDescriptor.getPermissionTreeElement()}, true);
        }
    }
}

