/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.otherxml.descriptors;

import com.android.ide.common.resources.platform.AttributeInfo;
import com.android.ide.common.resources.platform.DeclareStyleableInfo;
import com.android.ide.common.resources.platform.ViewClassInfo;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DescriptorsUtils;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DocumentDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.IDescriptorProvider;
import com.android.ide.eclipse.adt.internal.editors.descriptors.SeparatorAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.XmlnsAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.descriptors.ViewElementDescriptor;
import java.util.ArrayList;
import java.util.Map;

public final class OtherXmlDescriptors
implements IDescriptorProvider {
    public static final String PREF_KEY_ATTR = "key";
    private DocumentDescriptor mDescriptor = new DocumentDescriptor("xml_doc", null);
    private DocumentDescriptor mSearchDescriptor = new DocumentDescriptor("xml_doc", null);
    private DocumentDescriptor mPrefDescriptor = new DocumentDescriptor("xml_doc", null);
    private DocumentDescriptor mAppWidgetDescriptor = new DocumentDescriptor("xml_doc", null);

    @Override
    public DocumentDescriptor getDescriptor() {
        return this.mDescriptor;
    }

    @Override
    public ElementDescriptor[] getRootElementDescriptors() {
        return this.mDescriptor.getChildren();
    }

    public DocumentDescriptor getSearchableDescriptor() {
        return this.mSearchDescriptor;
    }

    public DocumentDescriptor getPreferencesDescriptor() {
        return this.mPrefDescriptor;
    }

    public DocumentDescriptor getAppWidgetDescriptor() {
        return this.mAppWidgetDescriptor;
    }

    public IDescriptorProvider getSearchableProvider() {
        return new IDescriptorProvider(){

            @Override
            public ElementDescriptor getDescriptor() {
                return OtherXmlDescriptors.this.mSearchDescriptor;
            }

            @Override
            public ElementDescriptor[] getRootElementDescriptors() {
                return OtherXmlDescriptors.this.mSearchDescriptor.getChildren();
            }
        };
    }

    public IDescriptorProvider getPreferencesProvider() {
        return new IDescriptorProvider(){

            @Override
            public ElementDescriptor getDescriptor() {
                return OtherXmlDescriptors.this.mPrefDescriptor;
            }

            @Override
            public ElementDescriptor[] getRootElementDescriptors() {
                return OtherXmlDescriptors.this.mPrefDescriptor.getChildren();
            }
        };
    }

    public IDescriptorProvider getAppWidgetProvider() {
        return new IDescriptorProvider(){

            @Override
            public ElementDescriptor getDescriptor() {
                return OtherXmlDescriptors.this.mAppWidgetDescriptor;
            }

            @Override
            public ElementDescriptor[] getRootElementDescriptors() {
                return OtherXmlDescriptors.this.mAppWidgetDescriptor.getChildren();
            }
        };
    }

    public synchronized void updateDescriptors(Map<String, DeclareStyleableInfo> searchableStyleMap, Map<String, DeclareStyleableInfo> appWidgetStyleMap, ViewClassInfo[] prefs, ViewClassInfo[] prefGroups) {
        XmlnsAttributeDescriptor xmlns = new XmlnsAttributeDescriptor("android", "http://schemas.android.com/apk/res/android");
        ElementDescriptor searchable = this.createSearchable(searchableStyleMap, xmlns);
        ElementDescriptor appWidget = this.createAppWidgetProviderInfo(appWidgetStyleMap, xmlns);
        ElementDescriptor preferences = this.createPreference(prefs, prefGroups, xmlns);
        ArrayList<ElementDescriptor> list = new ArrayList<ElementDescriptor>();
        if (searchable != null) {
            list.add(searchable);
            this.mSearchDescriptor.setChildren(new ElementDescriptor[]{searchable});
        }
        if (appWidget != null) {
            list.add(appWidget);
            this.mAppWidgetDescriptor.setChildren(new ElementDescriptor[]{appWidget});
        }
        if (preferences != null) {
            list.add(preferences);
            this.mPrefDescriptor.setChildren(new ElementDescriptor[]{preferences});
        }
        if (list.size() > 0) {
            this.mDescriptor.setChildren(list.toArray(new ElementDescriptor[list.size()]));
        }
    }

    private ElementDescriptor createSearchable(Map<String, DeclareStyleableInfo> searchableStyleMap, XmlnsAttributeDescriptor xmlns) {
        ElementDescriptor action_key = this.createElement(searchableStyleMap, "SearchableActionKey", "actionkey", "Action Key", null, null, null, false);
        ElementDescriptor searchable = this.createElement(searchableStyleMap, "Searchable", "searchable", "Searchable", null, xmlns, new ElementDescriptor[]{action_key}, false);
        return searchable;
    }

    private ElementDescriptor createAppWidgetProviderInfo(Map<String, DeclareStyleableInfo> appWidgetStyleMap, XmlnsAttributeDescriptor xmlns) {
        if (appWidgetStyleMap == null) {
            return null;
        }
        ElementDescriptor appWidget = this.createElement(appWidgetStyleMap, "AppWidgetProviderInfo", "appwidget-provider", "AppWidget Provider", null, xmlns, null, false);
        return appWidget;
    }

    private ElementDescriptor createElement(Map<String, DeclareStyleableInfo> styleMap, String styleName, String xmlName, String uiName, String sdkUrl, AttributeDescriptor extraAttribute, ElementDescriptor[] childrenElements, boolean mandatory) {
        ElementDescriptor element = new ElementDescriptor(xmlName, uiName, null, sdkUrl, null, childrenElements, mandatory);
        return this.updateElement(element, styleMap, styleName, extraAttribute);
    }

    private ElementDescriptor updateElement(ElementDescriptor element, Map<String, DeclareStyleableInfo> styleMap, String styleName, AttributeDescriptor extraAttribute) {
        DeclareStyleableInfo style;
        ArrayList<AttributeDescriptor> descs = new ArrayList<AttributeDescriptor>();
        DeclareStyleableInfo declareStyleableInfo = style = styleMap != null ? styleMap.get(styleName) : null;
        if (style != null) {
            DescriptorsUtils.appendAttributes(descs, null, "http://schemas.android.com/apk/res/android", style.getAttributes(), null, null);
            element.setTooltip(style.getJavaDoc());
        }
        if (extraAttribute != null) {
            descs.add(extraAttribute);
        }
        element.setAttributes(descs.toArray(new AttributeDescriptor[descs.size()]));
        return element;
    }

    private ElementDescriptor createPreference(ViewClassInfo[] prefs, ViewClassInfo[] prefGroups, XmlnsAttributeDescriptor xmlns) {
        ArrayList<ElementDescriptor> newPrefs = new ArrayList<ElementDescriptor>();
        if (prefs != null) {
            ViewClassInfo[] viewClassInfoArray = prefs;
            int n = prefs.length;
            int n2 = 0;
            while (n2 < n) {
                ViewClassInfo info = viewClassInfoArray[n2];
                ElementDescriptor desc = this.convertPref(info);
                newPrefs.add(desc);
                ++n2;
            }
        }
        ElementDescriptor topPreferences = null;
        ArrayList<ElementDescriptor> newGroups = new ArrayList<ElementDescriptor>();
        if (prefGroups != null) {
            ViewClassInfo[] viewClassInfoArray = prefGroups;
            int desc = prefGroups.length;
            int n = 0;
            while (n < desc) {
                ViewClassInfo info = viewClassInfoArray[n];
                ElementDescriptor desc2 = this.convertPref(info);
                newGroups.add(desc2);
                if (info.getFullClassName() == "android.preference.PreferenceScreen") {
                    topPreferences = desc2;
                }
                ++n;
            }
        }
        ArrayList<ElementDescriptor> everything = new ArrayList<ElementDescriptor>();
        everything.addAll(newGroups);
        everything.addAll(newPrefs);
        ElementDescriptor[] newArray = everything.toArray(new ElementDescriptor[everything.size()]);
        for (ElementDescriptor layoutDesc : newGroups) {
            layoutDesc.setChildren(newArray);
        }
        if (topPreferences != null) {
            AttributeDescriptor[] attrs = topPreferences.getAttributes();
            AttributeDescriptor[] newAttrs = new AttributeDescriptor[attrs.length + 1];
            System.arraycopy(attrs, 0, newAttrs, 0, attrs.length);
            newAttrs[attrs.length] = xmlns;
            return new ElementDescriptor(topPreferences.getXmlName(), topPreferences.getUiName(), topPreferences.getTooltip(), topPreferences.getSdkUrl(), newAttrs, topPreferences.getChildren(), false);
        }
        return null;
    }

    private ElementDescriptor convertPref(ViewClassInfo info) {
        String xml_name = info.getShortClassName();
        String tooltip = info.getJavaDoc();
        ArrayList<AttributeDescriptor> attributes = new ArrayList<AttributeDescriptor>();
        DescriptorsUtils.appendAttributes(attributes, null, "http://schemas.android.com/apk/res/android", info.getAttributes(), null, null);
        ViewClassInfo link = info.getSuperClass();
        while (link != null) {
            AttributeInfo[] attrList = link.getAttributes();
            if (attrList.length > 0) {
                attributes.add(new SeparatorAttributeDescriptor(String.format("Attributes from %1$s", link.getShortClassName())));
                DescriptorsUtils.appendAttributes(attributes, null, "http://schemas.android.com/apk/res/android", attrList, null, null);
            }
            link = link.getSuperClass();
        }
        return new ViewElementDescriptor(xml_name, xml_name, info.getFullClassName(), tooltip, null, attributes.toArray(new AttributeDescriptor[attributes.size()]), null, null, false);
    }
}

