/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.ui.tree;

import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

class UiModelTreeContentProvider
implements ITreeContentProvider {
    private ElementDescriptor[] mDescriptorFilters;
    private final UiElementNode mUiRootNode;

    public UiModelTreeContentProvider(UiElementNode uiRootNode, ElementDescriptor[] descriptorFilters) {
        this.mUiRootNode = uiRootNode;
        this.mDescriptorFilters = descriptorFilters;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof UiElementNode) {
            UiElementNode node = (UiElementNode)parentElement;
            return node.getUiChildren().toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof UiElementNode) {
            UiElementNode node = (UiElementNode)element;
            return node.getUiParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof UiElementNode) {
            UiElementNode node = (UiElementNode)element;
            return node.getUiChildren().size() > 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<UiElementNode> roots = new ArrayList<UiElementNode>();
        if (this.mUiRootNode != null) {
            for (UiElementNode ui_node : this.mUiRootNode.getUiChildren()) {
                if (this.mDescriptorFilters == null || this.mDescriptorFilters.length == 0) {
                    roots.add(ui_node);
                    continue;
                }
                ElementDescriptor[] elementDescriptorArray = this.mDescriptorFilters;
                int n = this.mDescriptorFilters.length;
                int n2 = 0;
                while (n2 < n) {
                    ElementDescriptor filter = elementDescriptorArray[n2];
                    if (ui_node.getDescriptor() == filter) {
                        roots.add(ui_node);
                    }
                    ++n2;
                }
            }
        }
        return roots.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

