/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.ui.tree;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.AndroidXmlEditor;
import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.ui.SectionHelper;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.CopyCutAction;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.ICommitXml;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.PasteAction;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.UiActions;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.UiElementDetail;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.UiModelTreeContentProvider;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.UiModelTreeLabelProvider;
import com.android.ide.eclipse.adt.internal.editors.uimodel.IUiUpdateListener;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiDocumentNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public final class UiTreeBlock
extends MasterDetailsBlock
implements ICommitXml {
    private static final int TREE_HEIGHT_HINT = 50;
    AndroidXmlEditor mEditor;
    private UiElementNode mUiRootNode;
    private ElementDescriptor[] mDescriptorFilters;
    private String mTitle;
    private String mDescription;
    private SectionHelper.ManifestSectionPart mMasterPart;
    private TreeViewer mTreeViewer;
    private Button mAddButton;
    private Button mRemoveButton;
    private Button mUpButton;
    private Button mDownButton;
    private IManagedForm mManagedForm;
    private DetailsPart mDetailsPart;
    private Clipboard mClipboard;
    private IUiUpdateListener mUiRefreshListener;
    private IUiUpdateListener mUiEnableListener;
    private UiTreeActions mUiTreeActions;
    private final boolean mAutoCreateRoot;

    public UiTreeBlock(AndroidXmlEditor editor, UiElementNode uiRootNode, boolean autoCreateRoot, ElementDescriptor[] descriptorFilters, String title, String description) {
        this.mEditor = editor;
        this.mUiRootNode = uiRootNode;
        this.mAutoCreateRoot = autoCreateRoot;
        this.mDescriptorFilters = descriptorFilters;
        this.mTitle = title;
        this.mDescription = description;
    }

    AndroidXmlEditor getEditor() {
        return this.mEditor;
    }

    Clipboard getClipboard() {
        return this.mClipboard;
    }

    SectionHelper.ManifestSectionPart getMasterPart() {
        return this.mMasterPart;
    }

    public UiElementNode getRootNode() {
        return this.mUiRootNode;
    }

    protected void createMasterPart(IManagedForm managedForm, Composite parent) {
        FormToolkit toolkit = managedForm.getToolkit();
        this.mManagedForm = managedForm;
        this.mMasterPart = new SectionHelper.ManifestSectionPart(parent, toolkit);
        Section section = this.mMasterPart.getSection();
        section.setText(this.mTitle);
        section.setDescription(this.mDescription);
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(1808));
        Composite grid = SectionHelper.createGridLayout((Composite)section, toolkit, 2);
        Tree tree = this.createTreeViewer(toolkit, grid, managedForm);
        this.createButtons(toolkit, grid);
        this.createTreeContextMenu(tree);
        this.createSectionActions(section, toolkit);
    }

    private void createSectionActions(Section section, FormToolkit toolkit) {
        ToolBarManager manager = new ToolBarManager(0x800000);
        manager.removeAll();
        ToolBar toolbar = manager.createControl((Composite)section);
        section.setTextClient((Control)toolbar);
        ElementDescriptor[] descs = this.mDescriptorFilters;
        if (descs == null && this.mUiRootNode != null) {
            descs = this.mUiRootNode.getDescriptor().getChildren();
        }
        if (descs != null && descs.length > 1) {
            ElementDescriptor[] elementDescriptorArray = descs;
            int n = descs.length;
            int n2 = 0;
            while (n2 < n) {
                ElementDescriptor desc = elementDescriptorArray[n2];
                manager.add((IAction)new DescriptorFilterAction(desc));
                ++n2;
            }
        }
        manager.add((IAction)new TreeSortAction());
        manager.update(true);
    }

    private Tree createTreeViewer(FormToolkit toolkit, Composite grid, final IManagedForm managedForm) {
        Tree tree = toolkit.createTree(grid, 2);
        GridData gd = new GridData(1808);
        gd.widthHint = 50;
        gd.heightHint = 50;
        tree.setLayoutData((Object)gd);
        this.mTreeViewer = new TreeViewer(tree);
        this.mTreeViewer.setContentProvider((IContentProvider)new UiModelTreeContentProvider(this.mUiRootNode, this.mDescriptorFilters));
        this.mTreeViewer.setLabelProvider((IBaseLabelProvider)new UiModelTreeLabelProvider());
        this.mTreeViewer.setInput((Object)"unused");
        this.mTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                managedForm.fireSelectionChanged((IFormPart)UiTreeBlock.this.mMasterPart, event.getSelection());
                UiTreeBlock.this.adjustTreeButtons(event.getSelection());
            }
        });
        this.mUiRefreshListener = new IUiUpdateListener(){

            @Override
            public void uiElementNodeUpdated(UiElementNode ui_node, IUiUpdateListener.UiUpdateState state) {
                UiTreeBlock.this.mTreeViewer.refresh();
            }
        };
        this.mUiEnableListener = new IUiUpdateListener(){

            @Override
            public void uiElementNodeUpdated(UiElementNode ui_node, IUiUpdateListener.UiUpdateState state) {
                Section section;
                boolean exists;
                boolean bl = exists = UiTreeBlock.this.mAutoCreateRoot || ui_node.getXmlNode() != null;
                if (UiTreeBlock.this.mMasterPart != null && (section = UiTreeBlock.this.mMasterPart.getSection()).getEnabled() != exists) {
                    section.setEnabled(exists);
                    Control[] controlArray = section.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control c = controlArray[n2];
                        c.setEnabled(exists);
                        ++n2;
                    }
                }
            }
        };
        final Sdk.TargetChangeListener targetListener = new Sdk.TargetChangeListener(){

            @Override
            public IProject getProject() {
                if (UiTreeBlock.this.mEditor != null) {
                    return UiTreeBlock.this.mEditor.getProject();
                }
                return null;
            }

            @Override
            public void reload() {
                if (UiTreeBlock.this.mDetailsPart != null) {
                    int limit = UiTreeBlock.this.mDetailsPart.getPageLimit();
                    UiTreeBlock.this.mDetailsPart.setPageLimit(0);
                    UiTreeBlock.this.mDetailsPart.setPageLimit(limit);
                }
                UiTreeBlock.this.mTreeViewer.refresh();
            }
        };
        this.changeRootAndDescriptors(this.mUiRootNode, this.mDescriptorFilters, false);
        AdtPlugin.getDefault().addTargetListener(targetListener);
        tree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (UiTreeBlock.this.mUiRootNode != null) {
                    UiElementNode node;
                    UiElementNode uiElementNode = node = UiTreeBlock.this.mUiRootNode.getUiParent() != null ? UiTreeBlock.this.mUiRootNode.getUiParent() : UiTreeBlock.this.mUiRootNode;
                    if (node != null) {
                        node.removeUpdateListener(UiTreeBlock.this.mUiRefreshListener);
                    }
                    UiTreeBlock.this.mUiRootNode.removeUpdateListener(UiTreeBlock.this.mUiEnableListener);
                }
                AdtPlugin.getDefault().removeTargetListener(targetListener);
                if (UiTreeBlock.this.mClipboard != null) {
                    UiTreeBlock.this.mClipboard.dispose();
                    UiTreeBlock.this.mClipboard = null;
                }
            }
        });
        this.mClipboard = new Clipboard(tree.getDisplay());
        return tree;
    }

    public void changeRootAndDescriptors(UiElementNode uiRootNode, ElementDescriptor[] descriptorFilters, boolean forceRefresh) {
        UiElementNode node;
        if (this.mUiRootNode != null) {
            node = this.mUiRootNode.getUiParent() != null ? this.mUiRootNode.getUiParent() : this.mUiRootNode;
            node.removeUpdateListener(this.mUiRefreshListener);
            this.mUiRootNode.removeUpdateListener(this.mUiEnableListener);
        }
        this.mUiRootNode = uiRootNode;
        this.mDescriptorFilters = descriptorFilters;
        this.mTreeViewer.setContentProvider((IContentProvider)new UiModelTreeContentProvider(this.mUiRootNode, this.mDescriptorFilters));
        if (this.mUiRootNode != null) {
            UiElementNode uiElementNode = node = this.mUiRootNode.getUiParent() != null ? this.mUiRootNode.getUiParent() : this.mUiRootNode;
            if (node != null) {
                node.addUpdateListener(this.mUiRefreshListener);
            }
            this.mUiRootNode.addUpdateListener(this.mUiEnableListener);
            this.mUiEnableListener.uiElementNodeUpdated(this.mUiRootNode, null);
        }
        if (forceRefresh) {
            this.mTreeViewer.refresh();
        }
        this.createSectionActions(this.mMasterPart.getSection(), this.mManagedForm.getToolkit());
    }

    private void createButtons(FormToolkit toolkit, Composite grid) {
        this.mUiTreeActions = new UiTreeActions();
        Composite button_grid = SectionHelper.createGridLayout(grid, toolkit, 1);
        button_grid.setLayoutData((Object)new GridData(2));
        this.mAddButton = toolkit.createButton(button_grid, "Add...", 8);
        SectionHelper.addControlTooltip((Control)this.mAddButton, "Adds a new element.");
        this.mAddButton.setLayoutData((Object)new GridData(770));
        this.mAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                UiTreeBlock.this.doTreeAdd();
            }
        });
        this.mRemoveButton = toolkit.createButton(button_grid, "Remove...", 8);
        SectionHelper.addControlTooltip((Control)this.mRemoveButton, "Removes an existing selected element.");
        this.mRemoveButton.setLayoutData((Object)new GridData(768));
        this.mRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                UiTreeBlock.this.doTreeRemove();
            }
        });
        this.mUpButton = toolkit.createButton(button_grid, "Up", 8);
        SectionHelper.addControlTooltip((Control)this.mRemoveButton, "Moves the selected element up.");
        this.mUpButton.setLayoutData((Object)new GridData(768));
        this.mUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                UiTreeBlock.this.doTreeUp();
            }
        });
        this.mDownButton = toolkit.createButton(button_grid, "Down", 8);
        SectionHelper.addControlTooltip((Control)this.mRemoveButton, "Moves the selected element down.");
        this.mDownButton.setLayoutData((Object)new GridData(768));
        this.mDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                UiTreeBlock.this.doTreeDown();
            }
        });
        this.adjustTreeButtons((ISelection)TreeSelection.EMPTY);
    }

    private void createTreeContextMenu(Tree tree) {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ISelection selection = UiTreeBlock.this.mTreeViewer.getSelection();
                if (!selection.isEmpty() && selection instanceof ITreeSelection) {
                    ArrayList selected = UiTreeBlock.this.filterSelection((ITreeSelection)selection);
                    UiTreeBlock.this.doCreateMenuAction(manager, selected);
                    return;
                }
                UiTreeBlock.this.doCreateMenuAction(manager, null);
            }
        });
        Menu contextMenu = menuManager.createContextMenu((Control)tree);
        tree.setMenu(contextMenu);
    }

    private void doCreateMenuAction(IMenuManager manager, ArrayList<UiElementNode> selected) {
        if (selected != null) {
            boolean hasXml = false;
            for (UiElementNode uiNode : selected) {
                if (uiNode.getXmlNode() == null) continue;
                hasXml = true;
                break;
            }
            if (hasXml) {
                UiElementNode ui_root;
                manager.add((IAction)new CopyCutAction(this.getEditor(), this.getClipboard(), null, selected, true));
                manager.add((IAction)new CopyCutAction(this.getEditor(), this.getClipboard(), null, selected, false));
                if (selected.size() <= 1 && ((ui_root = selected.get(0).getUiRoot()).getDescriptor().hasChildren() || !(ui_root.getUiParent() instanceof UiDocumentNode))) {
                    manager.add((IAction)new PasteAction(this.getEditor(), this.getClipboard(), selected.get(0)));
                }
                manager.add((IContributionItem)new Separator());
            }
        }
        IconFactory factory = IconFactory.getInstance();
        if (selected == null || selected.size() <= 1) {
            manager.add((IAction)new Action("Add...", factory.getImageDescriptor("add")){

                public void run() {
                    super.run();
                    UiTreeBlock.this.doTreeAdd();
                }
            });
        }
        if (selected != null) {
            manager.add((IAction)new Action("Remove", factory.getImageDescriptor("delete")){

                public void run() {
                    super.run();
                    UiTreeBlock.this.doTreeRemove();
                }
            });
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new Action("Up", factory.getImageDescriptor("up")){

                public void run() {
                    super.run();
                    UiTreeBlock.this.doTreeUp();
                }
            });
            manager.add((IAction)new Action("Down", factory.getImageDescriptor("down")){

                public void run() {
                    super.run();
                    UiTreeBlock.this.doTreeDown();
                }
            });
        }
    }

    private void adjustTreeButtons(ISelection selection) {
        this.mRemoveButton.setEnabled(!selection.isEmpty() && selection instanceof ITreeSelection);
        this.mUpButton.setEnabled(this.canDoTreeUp(selection));
        this.mDownButton.setEnabled(this.canDoTreeDown(selection));
    }

    private ArrayList<UiElementNode> filterSelection(ITreeSelection selection) {
        ArrayList<UiElementNode> selected = new ArrayList<UiElementNode>();
        for (Object selectedObj : selection) {
            if (!(selectedObj instanceof UiElementNode)) continue;
            selected.add((UiElementNode)selectedObj);
        }
        return selected.size() > 0 ? selected : null;
    }

    private void doTreeAdd() {
        ITreeSelection tree_selection;
        Object first;
        UiElementNode ui_node = this.mUiRootNode;
        ISelection selection = this.mTreeViewer.getSelection();
        if (!selection.isEmpty() && selection instanceof ITreeSelection && (first = (tree_selection = (ITreeSelection)selection).getFirstElement()) != null && first instanceof UiElementNode) {
            ui_node = (UiElementNode)first;
        }
        this.mUiTreeActions.doAdd(ui_node, this.mDescriptorFilters, this.mTreeViewer.getControl().getShell(), (ILabelProvider)this.mTreeViewer.getLabelProvider());
    }

    protected void doTreeRemove() {
        ISelection selection = this.mTreeViewer.getSelection();
        if (!selection.isEmpty() && selection instanceof ITreeSelection) {
            ArrayList<UiElementNode> selected = this.filterSelection((ITreeSelection)selection);
            this.mUiTreeActions.doRemove(selected, this.mTreeViewer.getControl().getShell());
        }
    }

    protected void doTreeUp() {
        ISelection selection = this.mTreeViewer.getSelection();
        if (!selection.isEmpty() && selection instanceof ITreeSelection) {
            ArrayList<UiElementNode> selected = this.filterSelection((ITreeSelection)selection);
            this.mUiTreeActions.doUp(selected, this.mDescriptorFilters);
        }
    }

    protected boolean canDoTreeUp(ISelection selection) {
        if (!selection.isEmpty() && selection instanceof ITreeSelection) {
            ArrayList<UiElementNode> selected = this.filterSelection((ITreeSelection)selection);
            return this.mUiTreeActions.canDoUp(selected, this.mDescriptorFilters);
        }
        return false;
    }

    protected void doTreeDown() {
        ISelection selection = this.mTreeViewer.getSelection();
        if (!selection.isEmpty() && selection instanceof ITreeSelection) {
            ArrayList<UiElementNode> selected = this.filterSelection((ITreeSelection)selection);
            this.mUiTreeActions.doDown(selected, this.mDescriptorFilters);
        }
    }

    protected boolean canDoTreeDown(ISelection selection) {
        if (!selection.isEmpty() && selection instanceof ITreeSelection) {
            ArrayList<UiElementNode> selected = this.filterSelection((ITreeSelection)selection);
            return this.mUiTreeActions.canDoDown(selected, this.mDescriptorFilters);
        }
        return false;
    }

    void commitManagedForm() {
        if (this.mManagedForm != null) {
            this.mManagedForm.commit(false);
        }
    }

    @Override
    public void commitPendingXmlChanges() {
        this.commitManagedForm();
    }

    protected void createToolBarActions(IManagedForm managedForm) {
    }

    protected void registerPages(DetailsPart inDetailsPart) {
        this.mDetailsPart = inDetailsPart;
        inDetailsPart.setPageLimit(5);
        final UiTreeBlock tree = this;
        inDetailsPart.setPageProvider(new IDetailsPageProvider(){

            public IDetailsPage getPage(Object key) {
                if (key instanceof UiElementNode) {
                    return new UiElementDetail(tree);
                }
                return null;
            }

            public Object getPageKey(Object object) {
                return object;
            }
        });
    }

    private class DescriptorFilterAction
    extends Action {
        private final ElementDescriptor mDescriptor;
        private ViewerFilter mFilter;

        public DescriptorFilterAction(ElementDescriptor descriptor) {
            super(String.format("Displays only %1$s elements.", descriptor.getUiName()), 2);
            this.mDescriptor = descriptor;
            this.setImageDescriptor(descriptor.getImageDescriptor());
        }

        public void run() {
            super.run();
            if (this.isChecked()) {
                if (this.mFilter == null) {
                    this.mFilter = new DescriptorFilter(this);
                }
                UiTreeBlock.this.mTreeViewer.addFilter(this.mFilter);
                ViewerFilter[] viewerFilterArray = UiTreeBlock.this.mTreeViewer.getFilters();
                int n = viewerFilterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ViewerFilter filter = viewerFilterArray[n2];
                    if (filter instanceof DescriptorFilter && filter != this.mFilter) {
                        DescriptorFilterAction action = ((DescriptorFilter)filter).getAction();
                        action.setChecked(false);
                        UiTreeBlock.this.mTreeViewer.removeFilter(filter);
                    }
                    ++n2;
                }
            } else if (this.mFilter != null) {
                UiTreeBlock.this.mTreeViewer.removeFilter(this.mFilter);
            }
        }

        private class DescriptorFilter
        extends ViewerFilter {
            private final DescriptorFilterAction mAction;

            public DescriptorFilter(DescriptorFilterAction action) {
                this.mAction = action;
            }

            public DescriptorFilterAction getAction() {
                return this.mAction;
            }

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                while (element instanceof UiElementNode) {
                    UiElementNode uiNode = (UiElementNode)element;
                    if (uiNode.getDescriptor() == DescriptorFilterAction.this.mDescriptor) {
                        return true;
                    }
                    element = uiNode.getUiParent();
                }
                return false;
            }
        }
    }

    private class TreeSortAction
    extends Action {
        private ViewerComparator mComparator;

        public TreeSortAction() {
            super("Sorts elements alphabetically.", 2);
            this.setImageDescriptor(IconFactory.getInstance().getImageDescriptor("az_sort"));
            if (UiTreeBlock.this.mTreeViewer != null) {
                boolean is_sorted = UiTreeBlock.this.mTreeViewer.getComparator() != null;
                this.setChecked(is_sorted);
            }
        }

        public void run() {
            if (UiTreeBlock.this.mTreeViewer == null) {
                this.notifyResult(false);
                return;
            }
            ViewerComparator comp = UiTreeBlock.this.mTreeViewer.getComparator();
            if (comp != null) {
                this.mComparator = comp;
                UiTreeBlock.this.mTreeViewer.setComparator(null);
            } else {
                if (this.mComparator == null) {
                    this.mComparator = new ViewerComparator();
                }
                UiTreeBlock.this.mTreeViewer.setComparator(this.mComparator);
            }
            this.notifyResult(true);
        }
    }

    private class UiTreeActions
    extends UiActions {
        private UiTreeActions() {
        }

        @Override
        protected UiElementNode getRootNode() {
            return UiTreeBlock.this.mUiRootNode;
        }

        @Override
        protected void selectUiNode(UiElementNode uiNodeToSelect) {
            if (uiNodeToSelect != null) {
                LinkedList<UiElementNode> segments = new LinkedList<UiElementNode>();
                UiElementNode ui_node = uiNodeToSelect;
                while (ui_node != UiTreeBlock.this.mUiRootNode) {
                    segments.add(0, ui_node);
                    ui_node = ui_node.getUiParent();
                }
                if (segments.size() > 0) {
                    UiTreeBlock.this.mTreeViewer.setSelection((ISelection)new TreeSelection(new TreePath(segments.toArray())));
                } else {
                    UiTreeBlock.this.mTreeViewer.setSelection(null);
                }
            }
        }

        @Override
        public void commitPendingXmlChanges() {
            UiTreeBlock.this.commitManagedForm();
        }
    }
}

