/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.uimodel;

import com.android.ide.eclipse.adt.internal.editors.descriptors.TextValueDescriptor;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiTextAttributeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class UiTextValueNode
extends UiTextAttributeNode {
    public UiTextValueNode(TextValueDescriptor attributeDescriptor, UiElementNode uiParent) {
        super(attributeDescriptor, uiParent);
    }

    @Override
    public void updateValue(Node xml_attribute_node) {
        Node xml_node;
        this.setCurrentValue("");
        UiElementNode parent = this.getUiParent();
        if (parent != null && (xml_node = parent.getXmlNode()) != null) {
            Node xml_child = xml_node.getFirstChild();
            while (xml_child != null) {
                if (xml_child.getNodeType() == 3) {
                    this.setCurrentValue(xml_child.getNodeValue());
                    break;
                }
                xml_child = xml_child.getNextSibling();
            }
        }
        if (this.isValid() && !this.getTextWidgetValue().equals(this.getCurrentValue())) {
            try {
                this.setInInternalTextModification(true);
                this.setTextWidgetValue(this.getCurrentValue());
                this.setDirty(false);
            }
            finally {
                this.setInInternalTextModification(false);
            }
        }
    }

    @Override
    public void commit() {
        Node element;
        UiElementNode parent = this.getUiParent();
        if (parent != null && this.isValid() && this.isDirty() && (element = parent.prepareCommit()) != null) {
            Document doc;
            String value = this.getTextWidgetValue();
            boolean updated = false;
            Node xml_child = element.getFirstChild();
            while (xml_child != null) {
                if (xml_child.getNodeType() == 3) {
                    xml_child.setNodeValue(value);
                    updated = true;
                    break;
                }
                xml_child = xml_child.getNextSibling();
            }
            if (!updated && (doc = element.getOwnerDocument()) != null) {
                Text text = doc.createTextNode(value);
                element.appendChild(text);
            }
            this.setCurrentValue(value);
        }
        this.setDirty(false);
    }
}

