/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.launch.junit;

import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ide.common.xml.ManifestData;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.launch.AndroidLaunch;
import com.android.ide.eclipse.adt.internal.launch.AndroidLaunchConfiguration;
import com.android.ide.eclipse.adt.internal.launch.AndroidLaunchController;
import com.android.ide.eclipse.adt.internal.launch.LaunchConfigDelegate;
import com.android.ide.eclipse.adt.internal.launch.LaunchMessages;
import com.android.ide.eclipse.adt.internal.launch.junit.AndroidJUnitLaunchAction;
import com.android.ide.eclipse.adt.internal.launch.junit.InstrumentationRunnerValidator;
import com.android.ide.eclipse.adt.internal.launch.junit.runtime.AndroidJUnitLaunchInfo;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.swt.widgets.Display;

public class AndroidJUnitLaunchConfigDelegate
extends LaunchConfigDelegate {
    static final String ATTR_INSTR_NAME = "com.android.ide.eclipse.adt.instrumentation";
    static final String ATTR_TEST_SIZE = "com.android.ide.eclipse.adt.testSize";
    private static final String EMPTY_STRING = "";

    @Override
    protected void doLaunch(ILaunchConfiguration configuration, final String mode, final IProgressMonitor monitor, final IProject project, final AndroidLaunch androidLaunch, final AndroidLaunchConfiguration config, final AndroidLaunchController controller, final IFile applicationPackage, final ManifestData manifestData) {
        String runner = this.getRunner(project, configuration, manifestData);
        if (runner == null) {
            AdtPlugin.displayError(LaunchMessages.LaunchDialogTitle, String.format(LaunchMessages.AndroidJUnitDelegate_NoRunnerMsg_s, project.getName()));
            androidLaunch.stopLaunch();
            return;
        }
        final String targetAppPackage = this.getTargetPackage(manifestData, runner);
        if (targetAppPackage == null) {
            AdtPlugin.displayError(LaunchMessages.LaunchDialogTitle, String.format(LaunchMessages.AndroidJUnitDelegate_NoTargetMsg_3s, project.getName(), runner, "AndroidManifest.xml"));
            androidLaunch.stopLaunch();
            return;
        }
        final String testAppPackage = manifestData.getPackage();
        AndroidJUnitLaunchInfo junitLaunchInfo = new AndroidJUnitLaunchInfo(project, testAppPackage, runner);
        junitLaunchInfo.setTestClass(this.getTestClass(configuration));
        junitLaunchInfo.setTestPackage(this.getTestPackage(configuration));
        junitLaunchInfo.setTestMethod(this.getTestMethod(configuration));
        junitLaunchInfo.setLaunch((ILaunch)androidLaunch);
        junitLaunchInfo.setTestSize(this.getTestSize(configuration));
        final AndroidJUnitLaunchAction junitLaunch = new AndroidJUnitLaunchAction(junitLaunchInfo);
        if (Display.getCurrent() != null) {
            Job job = new Job("Junit Launch"){

                protected IStatus run(IProgressMonitor m) {
                    controller.launch(project, mode, applicationPackage, testAppPackage, targetAppPackage, manifestData.getDebuggable(), manifestData.getMinSdkVersionString(), junitLaunch, config, androidLaunch, monitor);
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(10);
            job.schedule();
        } else {
            controller.launch(project, mode, applicationPackage, testAppPackage, targetAppPackage, manifestData.getDebuggable(), manifestData.getMinSdkVersionString(), junitLaunch, config, androidLaunch, monitor);
        }
    }

    private String getTargetPackage(ManifestData manifestParser, String runner) {
        ManifestData.Instrumentation[] instrumentationArray = manifestParser.getInstrumentations();
        int n = instrumentationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestData.Instrumentation instr = instrumentationArray[n2];
            if (instr.getName().equals(runner)) {
                return instr.getTargetPackage();
            }
            ++n2;
        }
        return null;
    }

    private String getTestPackage(ILaunchConfiguration configuration) {
        IJavaElement element;
        String containerHandle = this.getStringLaunchAttribute("org.eclipse.jdt.junit.CONTAINER", configuration);
        if (containerHandle != null && containerHandle.length() > 0 && (element = JavaCore.create((String)containerHandle)).getElementType() == 4) {
            return element.getElementName();
        }
        return null;
    }

    private String getTestClass(ILaunchConfiguration configuration) {
        return this.getStringLaunchAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, configuration);
    }

    private String getTestMethod(ILaunchConfiguration configuration) {
        return this.getStringLaunchAttribute("org.eclipse.jdt.junit.TESTNAME", configuration);
    }

    private IRemoteAndroidTestRunner.TestSize getTestSize(ILaunchConfiguration configuration) {
        String testSizeAnnotation = this.getStringLaunchAttribute(ATTR_TEST_SIZE, configuration);
        if ("@SmallTest".equals(testSizeAnnotation)) {
            return IRemoteAndroidTestRunner.TestSize.SMALL;
        }
        if ("@MediumTest".equals(testSizeAnnotation)) {
            return IRemoteAndroidTestRunner.TestSize.MEDIUM;
        }
        if ("@LargeTest".equals(testSizeAnnotation)) {
            return IRemoteAndroidTestRunner.TestSize.LARGE;
        }
        return null;
    }

    private String getRunner(IProject project, ILaunchConfiguration configuration, ManifestData manifestData) {
        try {
            String runner = this.getRunnerFromConfig(configuration);
            if (runner != null) {
                return runner;
            }
            InstrumentationRunnerValidator instrFinder = new InstrumentationRunnerValidator(BaseProjectHelper.getJavaProject(project), manifestData);
            runner = instrFinder.getValidInstrumentationTestRunner();
            if (runner != null) {
                AdtPlugin.printErrorToConsole(project, new Object[]{String.format(LaunchMessages.AndroidJUnitDelegate_NoRunnerConfigMsg_s, runner)});
                return runner;
            }
            AdtPlugin.printErrorToConsole(project, new Object[]{String.format(LaunchMessages.AndroidJUnitDelegate_NoRunnerConsoleMsg_4s, project.getName(), "android.test.InstrumentationTestRunner", "android.test.runner", "AndroidManifest.xml")});
            return null;
        }
        catch (CoreException e) {
            AdtPlugin.log(e, "Error when retrieving instrumentation info", new Object[0]);
            return null;
        }
    }

    private String getRunnerFromConfig(ILaunchConfiguration configuration) {
        return this.getStringLaunchAttribute(ATTR_INSTR_NAME, configuration);
    }

    private String getStringLaunchAttribute(String attributeName, ILaunchConfiguration configuration) {
        String attrValue;
        block3: {
            try {
                attrValue = configuration.getAttribute(attributeName, EMPTY_STRING);
                if (attrValue.length() >= 1) break block3;
                return null;
            }
            catch (CoreException e) {
                AdtPlugin.log(e, String.format("Error when retrieving launch info %1$s", attributeName), new Object[0]);
                return null;
            }
        }
        return attrValue;
    }

    static void setJUnitDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.jdt.junit.TEST_KIND", "org.eclipse.jdt.junit.loader.junit3");
    }
}

