/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.lint;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.editors.AndroidXmlEditor;
import com.android.ide.eclipse.adt.internal.lint.AddSuppressAnnotation;
import com.android.ide.eclipse.adt.internal.lint.AddSuppressAttribute;
import com.android.ide.eclipse.adt.internal.lint.EclipseLintClient;
import com.android.ide.eclipse.adt.internal.lint.LintFix;
import com.android.ide.eclipse.adt.internal.preferences.AdtPrefs;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.DefaultConfiguration;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.SdkUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class LintFixGenerator
implements IMarkerResolutionGenerator2,
IQuickAssistProcessor {
    public boolean hasResolutions(IMarker marker) {
        try {
            assert (marker.getType().equals("com.android.ide.eclipse.adt.lintProblem"));
        }
        catch (CoreException coreException) {}
        return true;
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        String id = marker.getAttribute("checkid", "");
        IResource resource = marker.getResource();
        ArrayList<IMarkerResolution> resolutions = new ArrayList<IMarkerResolution>();
        if (resource.getName().endsWith(".java")) {
            AddSuppressAnnotation.createFixes(marker, id, resolutions);
        }
        resolutions.add((IMarkerResolution)new MoreInfoProposal(id, marker.getAttribute("message", null)));
        resolutions.add((IMarkerResolution)new SuppressProposal(resource, id, false));
        resolutions.add((IMarkerResolution)new SuppressProposal((IResource)resource.getProject(), id, true));
        resolutions.add((IMarkerResolution)new SuppressProposal(resource, id, true));
        resolutions.add((IMarkerResolution)new ClearMarkersProposal(resource, true));
        if (resolutions.size() > 0) {
            return resolutions.toArray(new IMarkerResolution[resolutions.size()]);
        }
        return null;
    }

    public String getErrorMessage() {
        return "Disable Lint Error";
    }

    public boolean canFix(Annotation annotation) {
        return true;
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return true;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        ISourceViewer sourceViewer = invocationContext.getSourceViewer();
        AndroidXmlEditor editor = AndroidXmlEditor.fromTextViewer((ITextViewer)sourceViewer);
        if (editor != null) {
            IFile file = editor.getInputFile();
            if (file == null) {
                return null;
            }
            IDocument document = sourceViewer.getDocument();
            List<IMarker> markers = AdtUtils.findMarkersOnLine("com.android.ide.eclipse.adt.lintProblem", (IResource)file, document, invocationContext.getOffset());
            ArrayList<Object> proposals = new ArrayList<Object>();
            if (markers.size() > 0) {
                for (IMarker marker : markers) {
                    String id = marker.getAttribute("checkid", "");
                    List<LintFix> fixes = LintFix.getFixes(id, marker);
                    if (fixes != null) {
                        for (LintFix fix : fixes) {
                            proposals.add(fix);
                        }
                    }
                    String message = marker.getAttribute("message", null);
                    proposals.add(new MoreInfoProposal(id, message));
                    proposals.addAll(AddSuppressAttribute.createFixes(editor, marker, id));
                    proposals.add(new SuppressProposal((IResource)file, id, false));
                    proposals.add(new SuppressProposal((IResource)file.getProject(), id, true));
                    proposals.add(new SuppressProposal((IResource)file, id, true));
                    proposals.add(new ClearMarkersProposal((IResource)file, true));
                }
            }
            if (proposals.size() > 0) {
                return proposals.toArray(new ICompletionProposal[proposals.size()]);
            }
        }
        return null;
    }

    public static void suppressDetector(String id, boolean updateMarkers, IResource resource, boolean thisFileOnly) {
        IssueRegistry registry = EclipseLintClient.getRegistry();
        Issue issue = registry.getIssue(id);
        if (issue != null) {
            EclipseLintClient mClient = new EclipseLintClient(registry, Collections.singletonList(resource), null, false);
            Project project = null;
            IProject eclipseProject = resource.getProject();
            if (eclipseProject != null) {
                File dir = AdtUtils.getAbsolutePath((IResource)eclipseProject).toFile();
                project = mClient.getProject(dir, dir);
            }
            Configuration configuration = mClient.getConfigurationFor(project);
            if (thisFileOnly && configuration instanceof DefaultConfiguration) {
                File file = AdtUtils.getAbsolutePath(resource).toFile();
                ((DefaultConfiguration)configuration).ignore(issue, file);
            } else {
                configuration.setSeverity(issue, Severity.IGNORE);
            }
        }
        if (updateMarkers) {
            EclipseLintClient.removeMarkers(resource, id);
        }
    }

    public static void addSuppressAnnotation(IMarker marker) {
        String id = EclipseLintClient.getId(marker);
        if (id != null) {
            IResource resource = marker.getResource();
            if (!(resource instanceof IFile)) {
                return;
            }
            IFile file = (IFile)resource;
            boolean isJava = file.getName().endsWith(".java");
            boolean isXml = SdkUtils.endsWith((CharSequence)file.getName(), (CharSequence)".xml");
            if (!isJava && !isXml) {
                return;
            }
            try {
                IEditorInput input;
                IEditorPart activeEditor = AdtUtils.getActiveEditor();
                IEditorPart part = null;
                if (activeEditor != null && (input = activeEditor.getEditorInput()) instanceof FileEditorInput && ((FileEditorInput)input).getFile().equals((Object)file)) {
                    part = activeEditor;
                }
                if (part == null) {
                    Region region = null;
                    int start = marker.getAttribute("charStart", -1);
                    int end = marker.getAttribute("charEnd", -1);
                    if (start != -1 && end != -1) {
                        region = new Region(start, end - start);
                    }
                    part = AdtPlugin.openFile(file, region, true);
                }
                if (isJava) {
                    ArrayList<IMarkerResolution> resolutions = new ArrayList<IMarkerResolution>();
                    AddSuppressAnnotation.createFixes(marker, id, resolutions);
                    if (resolutions.size() > 0) {
                        ((IMarkerResolution)resolutions.get(0)).run(marker);
                    }
                } else {
                    AndroidXmlEditor editor;
                    List<AddSuppressAttribute> fixes;
                    assert (isXml);
                    if (part instanceof AndroidXmlEditor && (fixes = AddSuppressAttribute.createFixes(editor = (AndroidXmlEditor)part, marker, id)).size() > 0) {
                        IStructuredDocument document = editor.getStructuredDocument();
                        fixes.get(0).apply((IDocument)document);
                    }
                }
            }
            catch (PartInitException pie) {
                AdtPlugin.log(pie, null, new Object[0]);
            }
        }
    }

    private static class ClearMarkersProposal
    implements ICompletionProposal,
    IMarkerResolution2 {
        private final boolean mGlobal;
        private final IResource mResource;

        public ClearMarkersProposal(IResource resource, boolean global) {
            this.mResource = resource;
            this.mGlobal = global;
        }

        private void perform() {
            IResource resource = this.mGlobal ? this.mResource.getProject() : this.mResource;
            EclipseLintClient.clearMarkers(resource);
        }

        public String getDisplayString() {
            return this.mGlobal ? "Clear All Lint Markers" : "Clear Markers in This File Only";
        }

        public String getLabel() {
            return this.getDisplayString();
        }

        public void run(IMarker marker) {
            this.perform();
        }

        public String getDescription() {
            return this.getAdditionalProposalInfo();
        }

        public void apply(IDocument document) {
            this.perform();
        }

        public Point getSelection(IDocument document) {
            return null;
        }

        public String getAdditionalProposalInfo() {
            StringBuilder sb = new StringBuilder(200);
            if (this.mGlobal) {
                sb.append("Clears all lint warning markers from the project.");
            } else {
                sb.append("Clears all lint warnings from this file.");
            }
            sb.append("<br><br>");
            sb.append("This temporarily hides the problem, but does not suppress it. Running Lint again can bring the error back.");
            if (AdtPrefs.getPrefs().isLintOnSave()) {
                sb.append(' ');
                sb.append("This will happen the next time the file is saved since lint-on-save is enabled. You can turn this off in the \"Lint Error Checking\" preference page.");
            }
            return sb.toString();
        }

        public Image getImage() {
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            return sharedImages.getImage("IMG_ELCL_REMOVE");
        }

        public IContextInformation getContextInformation() {
            return null;
        }
    }

    private static class MoreInfoProposal
    implements ICompletionProposal,
    IMarkerResolution2 {
        private final String mId;
        private final String mMessage;

        public MoreInfoProposal(String id, String message) {
            this.mId = id;
            this.mMessage = message;
        }

        private void perform() {
            Issue issue = EclipseLintClient.getRegistry().getIssue(this.mId);
            assert (issue != null) : this.mId;
            StringBuilder sb = new StringBuilder(300);
            sb.append(this.mMessage);
            sb.append('\n').append('\n');
            sb.append("Issue Explanation:");
            sb.append('\n');
            String explanation = issue.getExplanation(Issue.OutputFormat.TEXT);
            if (explanation != null && !explanation.isEmpty()) {
                sb.append('\n');
                sb.append(explanation);
            } else {
                sb.append(issue.getDescription(Issue.OutputFormat.TEXT));
            }
            if (issue.getMoreInfo() != null) {
                sb.append('\n').append('\n');
                sb.append("More Information: ");
                sb.append(issue.getMoreInfo());
            }
            MessageDialog.openInformation((Shell)AdtPlugin.getShell(), (String)"More Info", (String)sb.toString());
        }

        public String getDisplayString() {
            return String.format("Explain Issue (%1$s)", this.mId);
        }

        public String getLabel() {
            return this.getDisplayString();
        }

        public void run(IMarker marker) {
            this.perform();
        }

        public String getDescription() {
            return this.getAdditionalProposalInfo();
        }

        public void apply(IDocument document) {
            this.perform();
        }

        public Point getSelection(IDocument document) {
            return null;
        }

        public String getAdditionalProposalInfo() {
            return "Provides more information about this issue.<br><br>" + EclipseLintClient.getRegistry().getIssue(this.mId).getExplanation(Issue.OutputFormat.HTML);
        }

        public Image getImage() {
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            return sharedImages.getImage("IMG_OBJS_INFO_TSK");
        }

        public IContextInformation getContextInformation() {
            return null;
        }
    }

    private static class SuppressProposal
    implements ICompletionProposal,
    IMarkerResolution2 {
        private final String mId;
        private final boolean mGlobal;
        private final IResource mResource;

        private SuppressProposal(IResource resource, String check, boolean global) {
            this.mResource = resource;
            this.mId = check;
            this.mGlobal = global;
        }

        private void perform() {
            LintFixGenerator.suppressDetector(this.mId, true, this.mResource, !this.mGlobal);
        }

        public String getDisplayString() {
            if (this.mResource instanceof IProject) {
                return "Disable Check in This Project";
            }
            if (this.mGlobal) {
                return "Disable Check";
            }
            return "Disable Check in This File Only";
        }

        public String getLabel() {
            return this.getDisplayString();
        }

        public void run(IMarker marker) {
            this.perform();
        }

        public String getDescription() {
            return this.getAdditionalProposalInfo();
        }

        public void apply(IDocument document) {
            this.perform();
        }

        public Point getSelection(IDocument document) {
            return null;
        }

        public String getAdditionalProposalInfo() {
            StringBuilder sb = new StringBuilder(200);
            if (this.mResource instanceof IProject) {
                sb.append("Suppresses this type of lint warning in the current project only.");
            } else if (this.mGlobal) {
                sb.append("Suppresses this type of lint warning in all files.");
            } else {
                sb.append("Suppresses this type of lint warning in the current file only.");
            }
            sb.append("<br><br>");
            sb.append("You can re-enable checks from the \"Android > Lint Error Checking\" preference page.");
            return sb.toString();
        }

        public Image getImage() {
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            return sharedImages.getImage("IMG_OBJS_WARN_TSK");
        }

        public IContextInformation getContextInformation() {
            return null;
        }
    }
}

