/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.lint;

import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.editors.AndroidXmlEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DescriptorsUtils;
import com.android.ide.eclipse.adt.internal.lint.SetPropertyFix;
import com.android.tools.lint.checks.AccessibilityDetector;
import com.android.tools.lint.checks.InefficientWeightDetector;
import com.android.tools.lint.checks.ManifestOrderDetector;
import com.android.tools.lint.checks.MissingIdDetector;
import com.android.tools.lint.checks.SecurityDetector;
import com.android.tools.lint.checks.TextFieldDetector;
import com.android.tools.lint.checks.TranslationDetector;
import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Element;

final class SetAttributeFix
extends SetPropertyFix {
    private SetAttributeFix(String id, IMarker marker) {
        super(id, marker);
    }

    @Override
    protected String getAttribute() {
        if (this.mId.equals(AccessibilityDetector.ISSUE.getId())) {
            return "contentDescription";
        }
        if (this.mId.equals(InefficientWeightDetector.BASELINE_WEIGHTS.getId())) {
            return "baselineAligned";
        }
        if (this.mId.equals(SecurityDetector.EXPORTED_SERVICE.getId())) {
            return "permission";
        }
        if (this.mId.equals(TextFieldDetector.ISSUE.getId())) {
            return "inputType";
        }
        if (this.mId.equals(TranslationDetector.MISSING.getId())) {
            return "translatable";
        }
        if (this.mId.equals(ManifestOrderDetector.ALLOW_BACKUP.getId())) {
            return "allowBackup";
        }
        if (this.mId.equals(MissingIdDetector.ISSUE.getId())) {
            return "id";
        }
        assert (false) : this.mId;
        return "";
    }

    @Override
    protected boolean isAndroidAttribute() {
        return !this.mId.equals(TranslationDetector.MISSING.getId());
    }

    @Override
    public String getDisplayString() {
        if (this.mId.equals(AccessibilityDetector.ISSUE.getId())) {
            return "Add content description attribute";
        }
        if (this.mId.equals(InefficientWeightDetector.BASELINE_WEIGHTS.getId())) {
            return "Set baseline attribute";
        }
        if (this.mId.equals(TextFieldDetector.ISSUE.getId())) {
            return "Set input type";
        }
        if (this.mId.equals(SecurityDetector.EXPORTED_SERVICE.getId())) {
            return "Add permission attribute";
        }
        if (this.mId.equals(TranslationDetector.MISSING.getId())) {
            return "Mark this as a non-translatable resource";
        }
        if (this.mId.equals(ManifestOrderDetector.ALLOW_BACKUP.getId())) {
            return "Set the allowBackup attribute to true or false";
        }
        if (this.mId.equals(MissingIdDetector.ISSUE.getId())) {
            return "Set the ID attribute";
        }
        assert (false) : this.mId;
        return "";
    }

    @Override
    public String getAdditionalProposalInfo() {
        String help = super.getAdditionalProposalInfo();
        if (this.mId.equals(TranslationDetector.MISSING.getId())) {
            help = "<b>Adds translatable=\"false\" to this &lt;string&gt;.</b><br><br>" + help;
        }
        return help;
    }

    @Override
    protected boolean invokeCodeCompletion() {
        return this.mId.equals(SecurityDetector.EXPORTED_SERVICE.getId()) || this.mId.equals(TextFieldDetector.ISSUE.getId()) || this.mId.equals(ManifestOrderDetector.ALLOW_BACKUP.getId());
    }

    @Override
    public boolean selectValue() {
        if (this.mId.equals(TranslationDetector.MISSING.getId())) {
            return false;
        }
        return super.selectValue();
    }

    @Override
    protected String getProposal(Element element) {
        if (this.mId.equals(InefficientWeightDetector.BASELINE_WEIGHTS.getId())) {
            return "false";
        }
        if (this.mId.equals(TranslationDetector.MISSING.getId())) {
            return "false";
        }
        if (this.mId.equals(TextFieldDetector.ISSUE.getId())) {
            return element.getAttributeNS("http://schemas.android.com/apk/res/android", "inputType");
        }
        if (this.mId.equals(MissingIdDetector.ISSUE.getId())) {
            IEditorPart editor = AdtUtils.getActiveEditor();
            if (editor instanceof AndroidXmlEditor) {
                AndroidXmlEditor xmlEditor = (AndroidXmlEditor)editor;
                return DescriptorsUtils.getFreeWidgetId(xmlEditor.getUiRootNode(), "fragment");
            }
            return "@+id/";
        }
        return super.getProposal(element);
    }
}

